/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.model.datatransfer.operation;

import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.datatransfer.XmlTransferUtils;
import oracle.bali.xml.model.datatransfer.operation.AbstractNodeTargetingOperation;
import oracle.bali.xml.model.task.FixedNameTransactionTask;
import oracle.bali.xml.share.TransactionToken;
import oracle.javatools.datatransfer.FetchMode;
import oracle.javatools.datatransfer.TransferDataInfo;
import org.w3c.dom.Node;

class SurroundOperation
extends AbstractNodeTargetingOperation {
    SurroundOperation() {
    }

    @Override
    public String getDisplayName(AbstractModel model, TransferDataInfo info) {
        String infoDesc;
        String string = infoDesc = info == null ? null : (String)info.getMetadata(TransferDataInfo.METADATA_MEDIUM_DESCRIPTION);
        if (infoDesc == null) {
            return model.getTranslatedString("DragSurround");
        }
        return model.getTranslatedString("DragSurround_Data", infoDesc);
    }

    @Override
    public float getSuitabilityRank() {
        return 0.45f;
    }

    @Override
    public int getSupportedActions() {
        return 0;
    }

    @Override
    protected DataFlavor getRequiredDataFlavor() {
        return XmlTransferUtils.FLAVOR_XMLKEY;
    }

    @Override
    protected boolean applyImpl(AbstractModel model, final Node node, TransferDataInfo data, final TransactionToken token) throws IOException, XmlCommitException {
        final XmlKey key = (XmlKey)data.getData(FetchMode.STANDARD, false);
        if (key != null) {
            return new FixedNameTransactionTask(this.getDisplayName(model, data)){

                @Override
                protected void performTask(AbstractModel model) throws XmlCommitException {
                    model.getContext().setTransactionToken(token);
                    Node target = node;
                    if (model instanceof XmlView) {
                        target = ((XmlView)model).viewToModel(target);
                    }
                    boolean ok = false;
                    if (target != null) {
                        XmlModel baseModel = model.getBaseModel();
                        baseModel.getSelection().set(target);
                        Node ret = baseModel.surroundSelection(key);
                        boolean bl = ok = ret != null;
                    }
                    if (!ok) {
                        this.cancelTask();
                    }
                }
            }.run(model);
        }
        return false;
    }

    @Override
    protected List getApplicableNodesForDataImpl(AbstractModel model, List possibleNodes, TransferDataInfo data) {
        for (Node node : possibleNodes) {
            if (!model.getXmlMetadataResolver().isSurroundable(new Node[]{node}, null)) continue;
            return Collections.singletonList(node);
        }
        return Collections.EMPTY_LIST;
    }
}

