/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.connections.ConnectionFactory;
import oracle.dbtools.connections.ConnectionReferenceable;
import oracle.dbtools.connections.NameExistsException;
import oracle.dbtools.connections.Storage;
import oracle.dbtools.connections.StorageException;
import oracle.dbtools.connections.db.DatabaseProvider;
import oracle.dbtools.connections.db.DatabaseProviderStorageFactory;
import oracle.ide.Ide;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.usages.UsageData;
import oracle.ide.usages.UsagesTracker;
import oracle.ideri.util.Product;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.event.DBObjectProviderListener;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.ConnectionsEvent;
import oracle.jdeveloper.db.ConnectionsListener;
import oracle.jdeveloper.db.DatabaseConnectionsListener;
import oracle.jdeveloper.db.DisconnectListener;
import oracle.jdevimpl.db.StoreContext;
import oracle.jdevimpl.db.adapter.CAConnectionCreator;
import oracle.jdevimpl.db.adapter.CAConnectionCreatorFactory;
import oracle.jdevimpl.db.adapter.StorageWrapper;
import oracle.jdevimpl.db.resource.ConnBundle;

public class DatabaseConnections {
    private static DatabaseConnections s_instance;
    private static Logger s_logger;
    private final Map<String, Collection<Connection>> m_extraConns = new HashMap<String, Collection<Connection>>();
    private final Collection<DatabaseConnectionsListener> m_lists = new CopyOnWriteArraySet<DatabaseConnectionsListener>();
    private StorageWrapper m_storage;
    private final DatabaseFactory.ConnectionCreator m_connCreator;
    private final String m_storeName;
    private DBObjectProviderListener m_proListBridge;
    private boolean m_privateStore;

    protected DatabaseConnections(String string, StorageWrapper storageWrapper, DatabaseFactory.ConnectionCreator connectionCreator) {
        this.m_storeName = string;
        this.m_storage = storageWrapper;
        this.m_connCreator = connectionCreator;
        if (this.m_connCreator == null) {
            throw new NullPointerException("ConnectionCreator cannot be null");
        }
        CAConnectionCreatorFactory.cacheCreator(string, this.m_connCreator);
    }

    private synchronized StorageWrapper getWrapper() {
        if (this.isCentralStore() && this.m_storage == null) {
            this.m_storage = StorageWrapper.getDefaultWrapper();
        }
        if (this.m_storage == null) {
            throw new IllegalStateException(ConnBundle.get("DB_CONN_NO_CONTEXT"));
        }
        return this.m_storage;
    }

    private synchronized void checkListenerInit() {
        if (this.m_proListBridge == null) {
            this.m_proListBridge = new ProviderListenerBridge();
            DBObjectProviderFactory.registerProviderListener((String)"db", (DBObjectProviderListener)this.m_proListBridge);
        }
    }

    protected synchronized void closeStore() {
        this.closeOpenConnections();
        if (this.m_connCreator != null && !this.isCentralStore()) {
            CAConnectionCreatorFactory.uncacheCreator(this.m_storeName, this.m_connCreator);
        }
    }

    protected void closeOpenConnections() {
        for (String string : this.listOpenConnections()) {
            try {
                this.disconnect(string, true);
            }
            catch (ConnectionException connectionException) {
                DatabaseConnections.getLogger().log(Level.WARNING, connectionException.getMessage());
            }
        }
    }

    public void addListener(ConnectionsListener connectionsListener) {
        if (connectionsListener != null) {
            this.addListener(DatabaseConnectionsListener.adapt(connectionsListener));
        }
    }

    public boolean removeListener(ConnectionsListener connectionsListener) {
        return connectionsListener == null ? false : this.removeListener(DatabaseConnectionsListener.adapt(connectionsListener));
    }

    protected Collection<DatabaseConnectionsListener> getListeners() {
        return Collections.unmodifiableCollection(this.m_lists);
    }

    public void addDisconnectListener(DisconnectListener disconnectListener) {
        if (disconnectListener != null) {
            this.addListener(DatabaseConnectionsListener.adapt(disconnectListener));
        }
    }

    public boolean removeDisconnectListener(DisconnectListener disconnectListener) {
        return disconnectListener == null ? false : this.removeListener(DatabaseConnectionsListener.adapt(disconnectListener));
    }

    public void addListener(DatabaseConnectionsListener databaseConnectionsListener) {
        if (databaseConnectionsListener != null) {
            this.checkListenerInit();
            this.m_lists.add(databaseConnectionsListener);
        }
    }

    public boolean removeListener(DatabaseConnectionsListener databaseConnectionsListener) {
        return this.m_lists.remove(databaseConnectionsListener);
    }

    @Deprecated
    protected Collection<? extends DisconnectListener> getDisconnectListeners() {
        return this.getListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionAdded(ConnectionsEvent connectionsEvent) {
        for (ConnectionsListener connectionsListener : this.getListeners()) {
            long l = System.currentTimeMillis();
            try {
                connectionsListener.connectionAdded(connectionsEvent);
            }
            catch (Exception exception) {
                try {
                    DatabaseConnections.getLogger().log(Level.WARNING, "DatabaseConnectionsListener failed", exception);
                }
                catch (Throwable throwable) {
                    this.logTiming(" listener {0} took for add connection", l, connectionsListener.getClass().getName());
                    throw throwable;
                }
                this.logTiming(" listener {0} took for add connection", l, connectionsListener.getClass().getName());
                continue;
            }
            this.logTiming(" listener {0} took for add connection", l, connectionsListener.getClass().getName());
        }
        this.logConnectionUsage(connectionsEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionRemoved(ConnectionsEvent connectionsEvent) {
        for (ConnectionsListener connectionsListener : this.getListeners()) {
            long l = System.currentTimeMillis();
            try {
                connectionsListener.connectionRemoved(connectionsEvent);
            }
            catch (Exception exception) {
                try {
                    DatabaseConnections.getLogger().log(Level.WARNING, "DatabaseConnectionsListener failed", exception);
                }
                catch (Throwable throwable) {
                    this.logTiming(" listener {0} took for remove connection", l, connectionsListener.getClass().getName());
                    throw throwable;
                }
                this.logTiming(" listener {0} took for remove connection", l, connectionsListener.getClass().getName());
                continue;
            }
            this.logTiming(" listener {0} took for remove connection", l, connectionsListener.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionUpdated(ConnectionsEvent connectionsEvent) {
        for (ConnectionsListener connectionsListener : this.getListeners()) {
            long l = System.currentTimeMillis();
            try {
                connectionsListener.connectionUpdated(connectionsEvent);
            }
            catch (Exception exception) {
                try {
                    DatabaseConnections.getLogger().log(Level.WARNING, "DatabaseConnectionsListener failed", exception);
                }
                catch (Throwable throwable) {
                    this.logTiming(" listener {0} took for update connection", l, connectionsListener.getClass().getName());
                    throw throwable;
                }
                this.logTiming(" listener {0} took for update connection", l, connectionsListener.getClass().getName());
                continue;
            }
            this.logTiming(" listener {0} took for update connection", l, connectionsListener.getClass().getName());
        }
        this.logConnectionUsage(connectionsEvent);
    }

    private void logConnectionUsage(ConnectionsEvent connectionsEvent) {
        String string;
        ConnectionReferenceable connectionReferenceable;
        if (Ide.isRunning() && !this.m_privateStore && (connectionReferenceable = connectionsEvent.getReferenceable()) instanceof DatabaseProvider && ModelUtil.hasLength((String)(string = ((DatabaseProvider)connectionReferenceable).getProperty("subtype")))) {
            UsagesTracker usagesTracker = UsagesTracker.getUsagesTracker();
            UsageData usageData = usagesTracker.createUsageData();
            usageData.setEventId("CREATE_CONNECTION");
            usageData.setEventSource("DB");
            usageData.setProperty("db-type", string);
            usagesTracker.report(usageData);
        }
    }

    private String getMessage(Throwable throwable) {
        Throwable throwable2;
        String string = throwable.getLocalizedMessage();
        if ((!ModelUtil.hasLength((String)string) || string.equals("null")) && (throwable2 = throwable.getCause()) != null && throwable2 != throwable) {
            string = this.getMessage(throwable2);
        }
        return string;
    }

    public final Collection<String> listConnections() {
        long l = System.currentTimeMillis();
        Collection<String> collection = this.listConnectionsImpl();
        this.logReturningConnections(collection, l);
        return collection;
    }

    private void logReturningConnections(Collection<String> collection, long l) {
        this.logTiming("Returned {0} connections.", l, collection.size());
    }

    private Collection<String> listConnectionsImpl() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Storage<DatabaseProvider> storage = this.getWrapper().getDatabaseStorage();
        long l = System.currentTimeMillis();
        for (String string : storage.listConnections()) {
            arrayList.add(string);
        }
        this.logTiming("Listing connections from CA", l, new Object[0]);
        return arrayList;
    }

    public final Collection<String> listConnections(boolean bl) {
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "oraJDBC";
        } else {
            stringArray = null;
        }
        return this.listConnections(stringArray);
    }

    public Collection<String> listConnections(String[] stringArray) {
        Collection<String> collection;
        long l = System.currentTimeMillis();
        if (stringArray != null) {
            Arrays.sort(stringArray);
        }
        if ((collection = this.listConnectionsImpl()).size() > 0 && stringArray != null) {
            for (String string : new ArrayList<String>(collection)) {
                try {
                    Properties properties = this.getProperties(string);
                    String string2 = properties.getProperty("subtype");
                    if (string2 != null && Arrays.binarySearch(stringArray, string2) >= 0) continue;
                    collection.remove(string);
                }
                catch (ConnectionException connectionException) {
                    DatabaseConnections.getLogger().log(Level.WARNING, connectionException.getMessage(), connectionException);
                    collection.remove(string);
                }
            }
        }
        this.logReturningConnections(collection, l);
        return collection;
    }

    public final Collection<String> listConnections(Properties properties) {
        long l = System.currentTimeMillis();
        Collection<String> collection = this.listConnectionsImpl();
        if (properties == null || properties.size() == 0) {
            return collection;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : collection) {
            boolean bl = false;
            try {
                Properties properties2 = this.getProperties(string);
                bl = true;
                for (Object object : properties.keySet()) {
                    String string2 = properties.getProperty((String)object);
                    String string3 = properties2.getProperty((String)object);
                    if (!ModelUtil.areDifferent((Object)string3, (Object)string2)) continue;
                    bl = false;
                    break;
                }
            }
            catch (ConnectionException connectionException) {
                // empty catch block
            }
            if (!bl) continue;
            arrayList.add(string);
        }
        this.logReturningConnections(arrayList, l);
        return arrayList;
    }

    public Collection<String> listOpenConnections() {
        Collection<String> collection = this.m_connCreator == null ? Collections.emptyList() : this.m_connCreator.listDatabases();
        return collection;
    }

    public final Connection getConnection(String string) throws ConnectionException {
        try {
            Database database = this.getDatabase(string);
            if (database == null) {
                throw new ConnectionException(ConnBundle.format("DB_CONN_MISSING", string));
            }
            return database.getConnection();
        }
        catch (DBException dBException) {
            Throwable throwable = dBException.getCause() == null ? dBException : dBException.getCause();
            throw new ConnectionException(ConnBundle.format("DB_CONN_CONN_ERR", string, this.getMessage(throwable)), throwable);
        }
    }

    public final Connection getUniqueConnection(String string) throws ConnectionException {
        DatabaseProvider databaseProvider = this.getReferenceable(string);
        if (databaseProvider != null) {
            try {
                Connection connection = databaseProvider.getConnection();
                Collection<Connection> collection = this.m_extraConns.get(string);
                if (collection == null) {
                    collection = new ArrayList<Connection>();
                    this.m_extraConns.put(string, collection);
                }
                collection.add(connection);
                return connection;
            }
            catch (SQLException sQLException) {
                throw new ConnectionException(ConnBundle.format("DB_CONN_CONN_ERR", string, this.getMessage(sQLException)), sQLException);
            }
        }
        throw new ConnectionException(ConnBundle.format("DB_CONN_MISSING", string));
    }

    public final Connection getConnection(Properties properties) throws ConnectionException {
        Connection connection = null;
        DatabaseProvider databaseProvider = this.newDatabaseProvider(null, properties);
        try {
            connection = databaseProvider.getConnection();
            ConnectionsEvent connectionsEvent = new ConnectionsEvent(null, (ConnectionReferenceable)databaseProvider);
            this.fireConnectionConnected(connectionsEvent, DatabaseConnectionsListener.ConnectionType.UNIQUE);
        }
        catch (SQLException sQLException) {
            throw new ConnectionException(ConnBundle.format("DB_CONN_CONN2_ERR", this.getMessage(sQLException)), sQLException);
        }
        return connection;
    }

    private void fireConnectionConnected(ConnectionsEvent connectionsEvent, DatabaseConnectionsListener.ConnectionType connectionType) {
        for (DatabaseConnectionsListener databaseConnectionsListener : this.getListeners()) {
            try {
                databaseConnectionsListener.connectionConnected(connectionsEvent, connectionType);
            }
            catch (Exception exception) {
                DatabaseConnections.getLogger().log(Level.SEVERE, databaseConnectionsListener.getClass().getName(), exception);
            }
        }
    }

    public final Database getDatabase(String string) throws DBException {
        return this.getDatabase(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Database getDatabase(String string, boolean bl) throws DBException {
        String string2;
        try {
            if (this.getReferenceable(string) == null) {
                return null;
            }
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
        Database database = null;
        boolean bl2 = false;
        if (this.m_connCreator != null) {
            bl2 = true;
            if (bl) {
                string2 = this.m_connCreator;
                synchronized (string2) {
                    database = this.m_connCreator.findDatabase(string);
                    if (database == null && bl) {
                        database = DatabaseFactory.createDatabase((String)string, (DatabaseFactory.ConnectionCreator)this.m_connCreator);
                    }
                }
            } else {
                database = this.m_connCreator.findDatabase(string);
            }
        }
        if (!bl2 && (database = (Database)DBObjectProviderFactory.findProvider((String)"db", (Object)(string2 = DatabaseFactory.encodeIdentifier((String)this.m_storeName, (String)string)))) == null && bl) {
            database = (Database)DBObjectProviderFactory.findOrCreateProvider((String)"db", (Object)string2);
        }
        return database;
    }

    public DatabaseProvider getReferenceable(String string) throws ConnectionException {
        DatabaseProvider databaseProvider = null;
        if (string != null) {
            Storage<DatabaseProvider> storage = this.getWrapper().getDatabaseStorage();
            try {
                long l = System.currentTimeMillis();
                databaseProvider = (DatabaseProvider)storage.getConnection(string, (ConnectionFactory)new DatabaseProviderStorageFactory());
                this.logTiming("... lookup of Referenceable from CA", l, new Object[0]);
            }
            catch (StorageException storageException) {
                throw new ConnectionException(ConnBundle.format("DB_CONN_REF_ERR", string, this.getMessage(storageException)), storageException);
            }
        }
        return databaseProvider;
    }

    public final Properties getProperties(String string) throws ConnectionException {
        Properties properties = null;
        DatabaseProvider databaseProvider = this.getReferenceable(string);
        if (databaseProvider != null) {
            properties = databaseProvider.getProperties();
        }
        return properties;
    }

    private DatabaseProvider newDatabaseProvider(String string, Properties properties) {
        DatabaseProvider.Builder builder = DatabaseProvider.builder((String)string);
        StorageWrapper storageWrapper = this.getWrapper();
        builder.worker(storageWrapper.getReferenceWorker());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object object = entry.getKey();
            if (!(object instanceof String)) continue;
            Object object2 = entry.getValue();
            if (object2 instanceof char[]) {
                builder.credential((String)object, (char[])object2);
                continue;
            }
            if (object2 == null) continue;
            builder.property((String)object, String.valueOf(object2));
        }
        return builder.build();
    }

    public void addConnection(String string, Properties properties) throws ConnectionException {
        long l = System.currentTimeMillis();
        DatabaseProvider databaseProvider = this.newDatabaseProvider(string, properties);
        try {
            PerformanceLogger performanceLogger = PerformanceLogger.get();
            performanceLogger.startTiming("DatabaseConnections.addConnection");
            this.getWrapper().getDatabaseStorage().addConnection(string, (ConnectionReferenceable)databaseProvider);
            performanceLogger.stopTiming("DatabaseConnections.addConnection", "bind of new connection to Storage", 500);
            this.fireConnectionAdded(new ConnectionsEvent(string, (ConnectionReferenceable)databaseProvider));
        }
        catch (NameExistsException nameExistsException) {
            throw new ConnectionException(ConnBundle.format("DB_CONN_EXISTS", string));
        }
        catch (StorageException storageException) {
            throw new ConnectionException(ConnBundle.format("DB_CONN_CREATE_ERR", string, this.getMessage(storageException)), storageException);
        }
        this.logTiming("Total time for addConnection", l, new Object[0]);
    }

    public boolean removeConnection(String string) throws ConnectionException {
        long l = System.currentTimeMillis();
        DatabaseProvider databaseProvider = this.getReferenceable(string);
        if (databaseProvider == null) {
            return false;
        }
        try {
            if (!this.disconnect(string, false)) {
                return false;
            }
            long l2 = System.currentTimeMillis();
            this.getWrapper().getDatabaseStorage().removeConnection(string);
            this.logTiming("... unbind from storage", l2, new Object[0]);
            this.closeDatabase(string, true, databaseProvider, true);
            this.logTiming("Total time for removeConnection", l, new Object[0]);
            return true;
        }
        catch (StorageException storageException) {
            throw new ConnectionException(ConnBundle.format("DB_CONN_REMOVE_ERR", string, this.getMessage(storageException)), storageException);
        }
    }

    private void closeDatabase(String string, boolean bl, DatabaseProvider databaseProvider, boolean bl2) {
        Database database;
        if (this.m_connCreator != null && (database = this.m_connCreator.findDatabase(string)) != null) {
            database.close();
            if (bl) {
                this.m_connCreator.uncacheDatabase(string);
            }
        }
        if (databaseProvider != null) {
            databaseProvider.disconnect();
        }
        if (bl2) {
            this.fireConnectionRemoved(new ConnectionsEvent(string, (ConnectionReferenceable)databaseProvider));
        }
    }

    public boolean updateConnection(String string, String string2, Properties properties) throws ConnectionException {
        return this.updateConnection(string, string2, properties, false);
    }

    public boolean updateConnection(String string, String string2, Properties properties, boolean bl) throws ConnectionException {
        boolean bl2;
        boolean bl3;
        DatabaseProvider databaseProvider;
        long l = System.currentTimeMillis();
        DatabaseProvider databaseProvider2 = this.getReferenceable(string);
        if (databaseProvider2 == null) {
            throw new ConnectionException(ConnBundle.format("DB_CONN_MISSING", string));
        }
        if (properties == null) {
            databaseProvider = databaseProvider2;
            bl3 = false;
        } else {
            databaseProvider = this.newDatabaseProvider(string2 == null ? string : string2, properties);
            bl3 = !databaseProvider.equals((Object)databaseProvider2);
        }
        boolean bl4 = bl2 = !string.equals(string2);
        if (bl3 || bl2) {
            Storage<DatabaseProvider> storage = this.getWrapper().getDatabaseStorage();
            try {
                if (bl3) {
                    if (!bl && !this.disconnect(string, false)) {
                        return false;
                    }
                } else {
                    this.renameDatabase(string, string2);
                }
                if (string2 != null && string2.length() > 0 && bl2) {
                    if (!bl3) {
                        storage.renameConnection(string, string2);
                    } else {
                        long l2 = System.currentTimeMillis();
                        storage.updateConnection(string, string2, (ConnectionReferenceable)databaseProvider);
                        this.logTiming("... rebind (bind/unbind) to storage", l2, new Object[0]);
                    }
                    String string3 = string2;
                    this.fireConnectionUpdated(new ConnectionsEvent(string, string3, (ConnectionReferenceable)databaseProvider));
                } else {
                    long l3 = System.currentTimeMillis();
                    storage.updateConnection(string, (ConnectionReferenceable)databaseProvider);
                    String string4 = string;
                    this.logTiming("... rebind to storage", l3, new Object[0]);
                }
            }
            catch (StorageException storageException) {
                throw new ConnectionException(ConnBundle.format("DB_CONN_UPDATE_ERR", string, this.getMessage(storageException)), storageException);
            }
            if (!bl && bl3) {
                this.closeDatabase(string, true, databaseProvider2, false);
            }
        }
        this.logTiming("Total time for updateConnection", l, new Object[0]);
        return true;
    }

    private void renameDatabase(String string, String string2) {
        if (this.m_connCreator != null) {
            this.m_connCreator.renameDatabase(string, string2);
        }
    }

    public final void testConnection(Properties properties) throws ConnectionException {
        this.testConnection(properties, null);
    }

    public final void testConnection(Properties properties, DatabaseConnectionTester databaseConnectionTester) throws ConnectionException {
        DatabaseProvider databaseProvider = this.newDatabaseProvider(null, properties);
        Connection connection = null;
        try {
            connection = databaseProvider.getConnection();
            if (databaseConnectionTester != null) {
                databaseConnectionTester.testConnection(connection);
            }
        }
        catch (Throwable throwable) {
            throw new ConnectionException(ConnBundle.format("DB_CONN_TEST_ERR", this.getMessage(throwable)), throwable);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public final void disconnect(String string) throws ConnectionException {
        this.disconnect(string, false);
    }

    public final boolean disconnect(String string, boolean bl) throws ConnectionException {
        DatabaseProvider databaseProvider = this.getReferenceable(string);
        return this.doDisconnect(string, databaseProvider, bl);
    }

    private boolean doDisconnect(String string, DatabaseProvider databaseProvider, boolean bl) throws ConnectionException {
        ConnectionsEvent connectionsEvent = new ConnectionsEvent(string, (ConnectionReferenceable)databaseProvider);
        for (DisconnectListener iterator : this.getListeners()) {
            try {
                if (iterator.canDisconnect(connectionsEvent)) continue;
                if (bl) {
                    DatabaseConnections.getLogger().log(Level.FINE, ConnBundle.format("DB_CONN_DISCONNECT_NOT_BLOCKED", string, iterator.getClass().getName()));
                    continue;
                }
                DatabaseConnections.getLogger().log(Level.FINE, ConnBundle.format("DB_CONN_DISCONNECT_BLOCKED", string, iterator.getClass().getName()));
                return false;
            }
            catch (Exception exception) {
                DatabaseConnections.getLogger().log(Level.SEVERE, ConnBundle.format("DB_CONN_DISCONNECT_LIST_ERR", iterator.getClass().getSimpleName()));
            }
        }
        this.closeDatabase(string, false, databaseProvider, false);
        Collection<Connection> collection = this.m_extraConns.get(string);
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Connection connection = (Connection)iterator.next();
                try {
                    iterator.remove();
                    DatabaseConnections.getLogger().log(Level.FINE, ConnBundle.format("DB_CONN_DISCONNECT_ADDITIONAL", string));
                    connection.close();
                }
                catch (SQLException sQLException) {
                    DatabaseConnections.getLogger().log(Level.FINE, ConnBundle.format("DB_CONN_DISCONNECT_ERR", string), sQLException);
                }
            }
        }
        for (DisconnectListener disconnectListener : this.getDisconnectListeners()) {
            try {
                disconnectListener.connectionDisconnected(connectionsEvent);
            }
            catch (Exception exception) {
                DatabaseConnections.getLogger().log(Level.WARNING, ConnBundle.format("DB_CONN_DISCONNECT_LIST_ERR", disconnectListener.getClass().getSimpleName()));
            }
        }
        return true;
    }

    public String getStoreName() {
        return this.m_storeName;
    }

    public boolean isCentralStore() {
        return "IdeConnections".equals(this.m_storeName);
    }

    private void logTiming(String string, long l, Object ... objectArray) {
        long l2 = System.currentTimeMillis() - l;
        Logger logger = DatabaseConnections.getLogger();
        Level level = Level.FINEST;
        if (l2 > 50L && logger.isLoggable(level)) {
            if (objectArray != null) {
                string = MessageFormat.format(string, objectArray);
            }
            logger.log(level, "Timing: " + l2 + "ms " + string);
        }
    }

    private static Logger getLogger() {
        if (s_logger == null) {
            s_logger = DBLog.getLogger(DatabaseConnections.class);
        }
        return s_logger;
    }

    public static DatabaseConnections getInstance() {
        if (s_instance == null && (Product.isJDeveloper() || Product.isRaptor() || StoreContext.getContext().isCentralStoreAvailable())) {
            DatabaseFactory.ConnectionCreator connectionCreator = CAConnectionCreatorFactory.findCreator("IdeConnections");
            if (connectionCreator == null) {
                connectionCreator = new CAConnectionCreator();
            }
            s_instance = new DatabaseConnections("IdeConnections", null, connectionCreator);
        }
        return s_instance;
    }

    public static DatabaseConnections getPrivateInstance(URL uRL) {
        return DatabaseConnections.getPrivateInstanceImpl(uRL, true);
    }

    public static DatabaseConnections getPrivateInstance(URL uRL, String string) {
        DatabaseConnections databaseConnections = string == null ? DatabaseConnections.getPrivateInstanceImpl(uRL, false) : DatabaseConnections.getPrivateInstanceImpl(uRL, StorageWrapper.createWrapper(uRL, string));
        return databaseConnections;
    }

    private static DatabaseConnections getPrivateInstanceImpl(URL uRL, boolean bl) {
        DatabaseConnections databaseConnections = DatabaseConnections.getPrivateInstanceImpl(uRL, bl ? StorageWrapper.createSystemWrapper(uRL) : StorageWrapper.createWrapper(uRL, null));
        return databaseConnections;
    }

    private static DatabaseConnections getPrivateInstanceImpl(URL uRL, StorageWrapper storageWrapper) {
        String string = URLFileSystem.getPath((URL)uRL);
        DatabaseFactory.ConnectionCreator connectionCreator = CAConnectionCreatorFactory.findCreator(string);
        if (connectionCreator == null) {
            connectionCreator = new CAConnectionCreator(string, storageWrapper);
        }
        DatabaseConnections databaseConnections = new DatabaseConnections(string, storageWrapper, connectionCreator);
        databaseConnections.m_privateStore = true;
        return databaseConnections;
    }

    @Deprecated
    public static void useStandaloneConnectionStore() {
    }

    public static abstract class DatabaseConnectionTester {
        public abstract void testConnection(Connection var1) throws ConnectionException;
    }

    private class ProviderListenerBridge
    extends DBObjectProviderListener {
        private ProviderListenerBridge() {
        }

        public void providerOpened(DBObjectProvider dBObjectProvider) {
            this.fireEvent(dBObjectProvider, DatabaseConnectionsListener.ConnectionType.CONNECT);
        }

        public void providerReloaded(DBObjectProvider dBObjectProvider) {
            this.fireEvent(dBObjectProvider, DatabaseConnectionsListener.ConnectionType.RECONNECT);
        }

        private void fireEvent(DBObjectProvider dBObjectProvider, DatabaseConnectionsListener.ConnectionType connectionType) {
            String string;
            if (dBObjectProvider instanceof Database && ModelUtil.areEqual((Object)(string = ((Database)dBObjectProvider).getConnectionStore()), (Object)DatabaseConnections.this.m_storeName)) {
                DatabaseConnections.this.fireConnectionConnected(new ConnectionsEvent((Database)dBObjectProvider), connectionType);
            }
        }
    }
}

