/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.database;

import java.text.MessageFormat;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.database.DBDefAttribute;

public class NumberAttribute
extends DBDefAttribute<Integer> {
    private Integer maxValue;
    private String units;
    private Integer minValue;
    private boolean rangeConstraint;

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String string) {
        this.units = string;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public boolean isRangeConstraint() {
        return this.rangeConstraint;
    }

    public NumberAttribute(String string, String string2, DBDefAttribute.DBDefAttributeType dBDefAttributeType, Integer n, Integer n2, Integer n3, boolean bl, String string3) {
        super(string, string2, dBDefAttributeType, bl);
        this.maxValue = n2;
        this.minValue = n3;
        this.rangeConstraint = true;
        this.units = string3;
        this.value = n;
        this.defaultValue = this.value;
    }

    public NumberAttribute(String string, String string2, DBDefAttribute.DBDefAttributeType dBDefAttributeType, Integer n, Integer n2, boolean bl, String string3) {
        super(string, string2, dBDefAttributeType, bl);
        this.minValue = n2;
        this.rangeConstraint = false;
        this.units = string3;
        this.value = n;
        this.defaultValue = this.value;
    }

    public NumberAttribute(NumberAttribute numberAttribute) {
        super(numberAttribute);
        this.minValue = numberAttribute.getMinValue();
        this.maxValue = numberAttribute.getMaxValue();
        this.rangeConstraint = numberAttribute.isRangeConstraint();
        this.defaultValue = numberAttribute.getDefaultValue();
        this.value = numberAttribute.getValue();
    }

    @Override
    public Integer getValue() {
        return (Integer)this.value;
    }

    @Override
    public void setValue(Integer n) {
        this.value = n;
    }

    @Override
    public boolean isValid() {
        if (this.rangeConstraint) {
            return (Integer)this.value >= this.minValue && (Integer)this.value <= this.maxValue;
        }
        return (Integer)this.value >= this.minValue;
    }

    @Override
    public void setValueFromString(String string) {
        try {
            this.value = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public String getValueAsString() {
        return Integer.toString((Integer)this.value);
    }

    @Override
    public String getErrorMessage() {
        if (this.rangeConstraint) {
            return MessageFormat.format(Messages.getString("TimesTenGrid.attributeRangeError"), this.attributeName, this.minValue, this.maxValue);
        }
        return MessageFormat.format(Messages.getString("TimesTenGrid.attributeRangeLowerBoundaryError"), this.attributeName, this.minValue);
    }

    @Override
    public String getDBDefValue() {
        return Integer.toString((Integer)this.value);
    }
}

