/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.loginspector;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.grid.loginspector.InstanceLogWrapper;
import oracle.dbtools.raptor.timesten.grid.loginspector.TTLogEntry;
import oracle.dbtools.raptor.timesten.grid.loginspector.TTLogEntryViewer;
import oracle.dbtools.raptor.timesten.grid.object.InstanceObject;

public class InstanceLogTablePanel
extends JPanel
implements ChangeListener {
    private JTable msgsTable;
    private static final Logger logger = Logger.getLogger(InstanceLogTablePanel.class.getName());
    private InstanceDiagTableModel model;
    private InstanceLogWrapper instanceLogObject;
    private InstanceObject instanceObj;
    public static final long MAX_INITIAL_LINES_TO_SHOW = Long.getLong("oracle.dbtools.raptor.timesten.grid.loginspector.logInitialLinesToShow", 500L);
    public static final long MAX_LINES_NEXT_LOAD = Long.getLong("oracle.dbtools.raptor.timesten.grid.loginspector.logNextLinesToLoad", 500L);
    private JViewport viewport;
    private List<TTLogEntry> messagesList;
    private JScrollBar verticalBar;
    private int nextMatchIdx;
    private TTLogEntryViewer entryViewer;
    private JScrollPane scrollPane2;
    private static final int DATE_COL_WIDTH = 150;
    private static final int SEVERITY_COL_WIDTH = 50;
    private static final int PROGNAME_COL_WIDTH = 80;
    private static final int PID_COL_WIDTH = 50;
    private JLabel instanceLabel;
    private JLabel searchLabel;
    private List<TABLE_COLUMN> columnsToShow;

    public InstanceLogTablePanel(InstanceObject instanceObject, Set<TABLE_COLUMN> set) {
        this.instanceObj = instanceObject;
        this.instanceLogObject = instanceObject.getLog();
        this.messagesList = instanceObject.getLog().getLogMessages();
        this.init(set);
    }

    public void fireTableDataChanged() {
        if (this.messagesList == null) {
            this.messagesList = this.instanceLogObject.getLogMessages();
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.model.fireTableDataChanged();
            this.entryViewer.clearEntry();
        } else {
            SwingUtilities.invokeLater(() -> {
                this.model.fireTableDataChanged();
                this.entryViewer.clearEntry();
            });
        }
    }

    public void setColumnsToShow(Set<TABLE_COLUMN> set) {
        TABLE_COLUMN tABLE_COLUMN;
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        TABLE_COLUMN tABLE_COLUMN2 = TABLE_COLUMN.MESSAGE;
        this.columnsToShow.clear();
        if (set.contains((Object)TABLE_COLUMN.DATE)) {
            tABLE_COLUMN = TABLE_COLUMN.DATE;
            tABLE_COLUMN.setColumnIdx(n++);
            this.columnsToShow.add(tABLE_COLUMN);
        }
        if (set.contains((Object)TABLE_COLUMN.SEVERITY)) {
            tABLE_COLUMN = TABLE_COLUMN.SEVERITY;
            n2 = n;
            tABLE_COLUMN.setColumnIdx(n++);
            this.columnsToShow.add(tABLE_COLUMN);
        }
        if (set.contains((Object)TABLE_COLUMN.PROGRAM)) {
            tABLE_COLUMN = TABLE_COLUMN.PROGRAM;
            n3 = n;
            tABLE_COLUMN.setColumnIdx(n++);
            this.columnsToShow.add(tABLE_COLUMN);
        }
        if (set.contains((Object)TABLE_COLUMN.PID)) {
            tABLE_COLUMN = TABLE_COLUMN.PID;
            n4 = n;
            tABLE_COLUMN.setColumnIdx(n++);
            this.columnsToShow.add(tABLE_COLUMN);
        }
        if (set.contains((Object)TABLE_COLUMN.MESSAGE)) {
            tABLE_COLUMN2.setColumnIdx(n++);
            this.columnsToShow.add(tABLE_COLUMN2);
        }
        this.model.fireTableStructureChanged();
        this.msgsTable.getColumnModel().getColumn(0).setWidth(150);
        this.msgsTable.getColumnModel().getColumn(0).setMaxWidth(150);
        this.msgsTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        if (n2 > 0) {
            this.msgsTable.getColumnModel().getColumn(n2).setWidth(50);
            this.msgsTable.getColumnModel().getColumn(n2).setMaxWidth(50);
            this.msgsTable.getColumnModel().getColumn(n2).setPreferredWidth(50);
        }
        if (n3 > 0) {
            this.msgsTable.getColumnModel().getColumn(n3).setWidth(80);
            this.msgsTable.getColumnModel().getColumn(n3).setMaxWidth(80);
            this.msgsTable.getColumnModel().getColumn(n3).setPreferredWidth(80);
        }
        if (n4 > 0) {
            this.msgsTable.getColumnModel().getColumn(n4).setWidth(50);
            this.msgsTable.getColumnModel().getColumn(n4).setMaxWidth(50);
            this.msgsTable.getColumnModel().getColumn(n4).setPreferredWidth(50);
        }
    }

    public void setResultsLabelMsg(String string) {
        Runnable runnable = () -> this.searchLabel.setText(string);
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void findTextSelectNext(final String string) {
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                InstanceLogTablePanel.this.setResultsLabelMsg(Messages.getString("TimesTenGrid.searching"));
                int n = InstanceLogTablePanel.this.msgsTable.getSelectedRow();
                InstanceLogTablePanel.this.nextMatchIdx = InstanceLogTablePanel.this.instanceLogObject.getNextEntryIndexContaining(string, n);
                if (InstanceLogTablePanel.this.nextMatchIdx >= 0) {
                    this.selectTableRow(InstanceLogTablePanel.this.nextMatchIdx);
                } else {
                    int n2 = InstanceLogTablePanel.this.instanceLogObject.getLogMessages().size();
                    while (InstanceLogTablePanel.this.instanceLogObject.readPreviousMessages(5L * MAX_LINES_NEXT_LOAD)) {
                        InstanceLogTablePanel.this.nextMatchIdx = InstanceLogTablePanel.this.instanceLogObject.getNextEntryIndexContaining(string, n2);
                        if (InstanceLogTablePanel.this.nextMatchIdx >= 0) {
                            this.selectTableRow(InstanceLogTablePanel.this.nextMatchIdx);
                            return null;
                        }
                        n2 = InstanceLogTablePanel.this.instanceLogObject.getLogMessages().size();
                    }
                    if (n != -1) {
                        InstanceLogTablePanel.this.nextMatchIdx = InstanceLogTablePanel.this.instanceLogObject.getNextEntryIndexContaining(string, 0, n);
                    }
                    if (InstanceLogTablePanel.this.nextMatchIdx >= 0) {
                        this.selectTableRow(InstanceLogTablePanel.this.nextMatchIdx);
                    } else {
                        InstanceLogTablePanel.this.setResultsLabelMsg(Messages.getString("TimesTenGrid.NoMatches"));
                    }
                }
                return null;
            }

            private void selectTableRow(int n) {
                if (SwingUtilities.isEventDispatchThread()) {
                    InstanceLogTablePanel.this.msgsTable.clearSelection();
                    InstanceLogTablePanel.this.msgsTable.addRowSelectionInterval(n, n);
                    InstanceLogTablePanel.this.msgsTable.scrollRectToVisible(new Rectangle(InstanceLogTablePanel.this.msgsTable.getCellRect(n, 0, true)));
                    InstanceLogTablePanel.this.setResultsLabelMsg("");
                } else {
                    SwingUtilities.invokeLater(() -> {
                        InstanceLogTablePanel.this.msgsTable.clearSelection();
                        InstanceLogTablePanel.this.msgsTable.addRowSelectionInterval(n, n);
                        InstanceLogTablePanel.this.msgsTable.scrollRectToVisible(new Rectangle(InstanceLogTablePanel.this.msgsTable.getCellRect(n, 0, true)));
                        InstanceLogTablePanel.this.setResultsLabelMsg("");
                    });
                }
            }
        };
        swingWorker.execute();
    }

    private void init(Set<TABLE_COLUMN> set) {
        this.setLayout(new GridBagLayout());
        this.columnsToShow = new ArrayList<TABLE_COLUMN>();
        this.model = new InstanceDiagTableModel();
        this.entryViewer = new TTLogEntryViewer(null);
        this.instanceLabel = new JLabel();
        this.searchLabel = new JLabel("");
        this.msgsTable = new JTable(this.model){
            private static final long serialVersionUID = 1L;

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                String string = "";
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                try {
                    string = InstanceLogTablePanel.this.msgsTable.getValueAt(n, n2).toString();
                }
                catch (RuntimeException runtimeException) {
                    logger.severe(runtimeException.getMessage());
                }
                return string;
            }
        };
        this.msgsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (InstanceLogTablePanel.this.msgsTable.getSelectedRow() < 0) {
                    return;
                }
                InstanceLogTablePanel.this.entryViewer.setEntry(InstanceLogTablePanel.this.messagesList.get(InstanceLogTablePanel.this.msgsTable.getSelectedRow()));
            }
        });
        this.msgsTable.setCellSelectionEnabled(false);
        this.msgsTable.setRowSelectionAllowed(true);
        this.msgsTable.setSelectionMode(2);
        this.setColumnsToShow(set);
        JScrollPane jScrollPane = new JScrollPane(this.msgsTable);
        this.viewport = jScrollPane.getViewport();
        this.viewport.addChangeListener(this);
        this.verticalBar = jScrollPane.getVerticalScrollBar();
        this.scrollPane2 = new JScrollPane(this.entryViewer);
        this.instanceLabel.setText(this.instanceObj.getFullName());
        this.instanceLabel.setForeground(new Color(0, 0, 185));
        this.searchLabel.setForeground(new Color(0, 0, 185));
        this.add((Component)this.instanceLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.searchLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 22, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 21, 1, new Insets(10, 10, 10, 0), 0, 0));
    }

    public JScrollPane getEntryViewer() {
        return this.scrollPane2;
    }

    public JScrollBar getVerticalScroll() {
        return this.verticalBar;
    }

    public void setInstance(InstanceLogWrapper instanceLogWrapper) {
        this.instanceLogObject = instanceLogWrapper;
    }

    public InstanceLogWrapper getInstanceLog() {
        return this.instanceLogObject;
    }

    public InstanceObject getInstance() {
        return this.instanceObj;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Rectangle rectangle = this.viewport.getViewRect();
        int n = this.msgsTable.rowAtPoint(new Point(0, rectangle.y + rectangle.height - 1));
        if (n == -1) {
            return;
        }
        if (n == this.model.getRowCount() - 1) {
            this.instanceLogObject.readPreviousMessagesOnNewThread(MAX_LINES_NEXT_LOAD, () -> {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.model.fireTableDataChanged();
                    this.msgsTable.setRowSelectionInterval(n, n);
                } else {
                    SwingUtilities.invokeLater(() -> {
                        this.model.fireTableDataChanged();
                        this.msgsTable.setRowSelectionInterval(n, n);
                    });
                }
            });
        }
    }

    public static enum TABLE_COLUMN {
        DATE(Messages.getString("TimesTenGrid.LogDate")),
        SEVERITY(Messages.getString("TimesTenGrid.LogSeverity")),
        PROGRAM(Messages.getString("TimesTenGrid.LogProg")),
        PID(Messages.getString("TimesTenGrid.LogPID")),
        MESSAGE(Messages.getString("TimesTenGrid.LogMsg"));

        private String headerTile;
        private int columnIdx;

        private TABLE_COLUMN(String string2) {
            this.headerTile = string2;
        }

        public String getHeaderTitle() {
            return this.headerTile;
        }

        public void setColumnIdx(int n) {
            this.columnIdx = n;
        }

        public int getColumnIdx() {
            return this.columnIdx;
        }

        public String getLogEntryValue(TTLogEntry tTLogEntry) {
            switch (this) {
                case DATE: {
                    return tTLogEntry.getStringTimeStamp();
                }
                case SEVERITY: {
                    return tTLogEntry.getLevel().toString();
                }
                case PROGRAM: {
                    return tTLogEntry.getShortProgramName();
                }
                case PID: {
                    return String.valueOf(tTLogEntry.getPID());
                }
                case MESSAGE: {
                    return tTLogEntry.getMessage();
                }
            }
            return null;
        }
    }

    private final class InstanceDiagTableModel
    extends AbstractTableModel {
        private InstanceDiagTableModel() {
        }

        @Override
        public int getRowCount() {
            return InstanceLogTablePanel.this.messagesList.size();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public int getColumnCount() {
            return InstanceLogTablePanel.this.columnsToShow.size();
        }

        @Override
        public String getColumnName(int n) {
            return InstanceLogTablePanel.this.columnsToShow.get(n).getHeaderTitle();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return InstanceLogTablePanel.this.columnsToShow.get(n2).getLogEntryValue(InstanceLogTablePanel.this.messagesList.get(n));
        }
    }
}

