/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.grid.utils;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.celleditor.RaptorTableEditorJPanel;
import oracle.dbtools.raptor.controls.celleditor.RaptorTableEditorTextField;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditor;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditorFactory;
import oracle.dbtools.raptor.controls.celleditor.popups.PopupCellEditorHandler;
import oracle.dbtools.raptor.navigator.net.editor.BreakoutEditorListener;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;

public class LongTextCellEditor
extends DefaultCellEditor
implements PopupCellEditorHandler {
    int columnDataType = 12;
    String columnDataTypeName = "VARCHAR";
    PopupCellEditor popupEditor = null;
    JTable _table;
    Object editorValue;

    public LongTextCellEditor(JTable jTable) {
        super((JTextField)new RaptorTableEditorTextField(jTable));
        this._table = jTable;
        ((RaptorTableEditorTextField)this.getComponent()).getCaret().setBlinkRate(500);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        if (this.popupEditor == null) {
            this.popupEditor = PopupCellEditorFactory.getPopupCellEditorForDriver((String)"oracle.jdbc.OracleDriver", (int)this.columnDataType, (String)this.columnDataTypeName);
            this.popupEditor.setEditable(true);
        }
        RaptorTableEditorTextField raptorTableEditorTextField = (RaptorTableEditorTextField)this.getComponent();
        raptorTableEditorTextField.setText((String)this._table.getModel().getValueAt(n, n2));
        this.setEditorValue(raptorTableEditorTextField.getText());
        return new RaptorTableEditorJPanel((PopupCellEditorHandler)this, (JTextField)raptorTableEditorTextField, true, this.popupEditor);
    }

    private void setEditorValue(Object object) {
        ((RaptorTableEditorTextField)this.getComponent()).setText((String)object);
    }

    public void handlePopupEdit(PopupCellEditor popupCellEditor) {
        JComponent jComponent = popupCellEditor.getComponent();
        if (jComponent == null) {
            return;
        }
        this.setEditorValue(this.getCellEditorValue());
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jComponent, (Component)popupCellEditor.getDefaultComponent(), (String)Messages.getString("TimesTenGrid.editValue"));
        jEWTDialog.setResizable(true);
        jEWTDialog.setOKButtonEnabled(popupCellEditor.isEditable());
        popupCellEditor.setValue(this.getCellEditorValue());
        popupCellEditor.setPopupDialog(jEWTDialog);
        popupCellEditor.setBreakoutEditorListener(new BreakoutEditorListener(){

            public void save(Object object) {
                if (this.savable()) {
                    LongTextCellEditor.this.setEditorValue(object);
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            LongTextCellEditor.this.stopCellEditing();
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            }

            public boolean savable() {
                int n = LongTextCellEditor.this.getCellEditorListeners().length;
                return n > 0;
            }
        });
        if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
            this.setEditorValue(popupCellEditor.getValue());
            this.stopCellEditing();
        } else if (!popupCellEditor.editorBrokeout()) {
            this.cancelCellEditing();
        }
        popupCellEditor.dismissPopupEditor();
        if (this._table != null) {
            this._table.requestFocusInWindow();
        }
    }
}

