/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.panels;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.text.NumberTextField;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.ttdbobjects.TTPrimaryKeyIndexType;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.panels.table.TableInfoPanel;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Table;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.dialogs.MessageDialog;

public class TTCreateTableHeader
extends TableInfoPanel
implements ChangeListener {
    private JRadioButton rangeIndex;
    private JRadioButton hashIndex;
    private NumberTextField pages;
    private TTPrimaryKeyIndexType indexType;
    private JPanel setupPanel;
    private DBEditorConfig _config;

    public TTCreateTableHeader(DBEditorConfig dBEditorConfig, DBUILayoutHelper dBUILayoutHelper) {
        this._config = dBEditorConfig;
        this.addTimesTenTableComponents(dBUILayoutHelper);
    }

    protected void layoutComponents(DBUILayoutHelper dBUILayoutHelper) {
        super.layoutComponents(dBUILayoutHelper);
    }

    private void addTimesTenTableComponents(DBUILayoutHelper dBUILayoutHelper) {
        Table table = (Table)this._config.getUpdatedObject();
        this.indexType = (TTPrimaryKeyIndexType)((Object)table.getProperty("TTPrimaryKeyIndexType"));
        this.rangeIndex = new JRadioButton(Messages.getString("TimestenTable.range"));
        this.hashIndex = new JRadioButton(Messages.getString("TimestenTable.hash"));
        this.pages = new NumberTextField(15);
        this.setupPanel = new JPanel();
        DBUILayoutHelper dBUILayoutHelper2 = new DBUILayoutHelper((JPanel)((Object)this));
        this.setupPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TimestenTable.indexConfiguration")));
        this.pages.setEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rangeIndex);
        buttonGroup.add(this.hashIndex);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.rangeIndex);
        jPanel.add(this.hashIndex);
        dBUILayoutHelper2.add((Component)new JLabel(Messages.getString("TimestenTable.indexType")));
        dBUILayoutHelper2.add((Component)jPanel);
        dBUILayoutHelper2.nextRow();
        dBUILayoutHelper2.add((Component)new JLabel(Messages.getString("TimestenTable.pageSize")));
        dBUILayoutHelper2.add((Component)this.pages);
        dBUILayoutHelper2.layout();
        dBUILayoutHelper.add((Component)((Object)this), 2, 1, true, false);
        if (this.indexType.getIndexType().equals((Object)TTPrimaryKeyIndexType.TTPrimaryKeyType.RANGE)) {
            this.rangeIndex.setSelected(true);
            this.pages.setEnabled(false);
            this.enableControl(false);
        } else {
            this.hashIndex.setSelected(true);
            this.pages.setText(Integer.toString(this.indexType.getPagesSize()));
        }
        this.rangeIndex.addChangeListener(this);
        this.hashIndex.addChangeListener(this);
        table.addObjectListener(new DBObjectListener(){

            public void objectUpdated(DBObjectChange dBObjectChange) {
                List list = dBObjectChange.getOwnedObjectsAdded();
                for (DBObject dBObject : list) {
                    if (!(dBObject instanceof PKConstraint)) continue;
                    TTCreateTableHeader.this.enableControl(true);
                }
                list = dBObjectChange.getOwnedObjectsRemoved();
                for (DBObject dBObject : list) {
                    if (!(dBObject instanceof PKConstraint)) continue;
                    TTCreateTableHeader.this.enableControl(false);
                }
            }
        });
        this.pages.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (TTCreateTableHeader.this.pages.isEnabled()) {
                    if (TTCreateTableHeader.this.pages.getText().isEmpty()) {
                        MessageDialog.error((Component)((Object)TTCreateTableHeader.this), (Object)Messages.getString("TimestenTable.pageError"), (String)Messages.getString("TimesTen.common.error"), null);
                        TTCreateTableHeader.this.pages.setText("");
                        TTCreateTableHeader.this.pages.requestFocus();
                    } else {
                        int n = Integer.parseInt(TTCreateTableHeader.this.pages.getText());
                        if (n > 0) {
                            TTCreateTableHeader.this.indexType.setPagesSize(n);
                        } else {
                            MessageDialog.error((Component)((Object)TTCreateTableHeader.this), (Object)Messages.getString("TimestenTable.pageError"), (String)Messages.getString("TimesTen.common.error"), null);
                            TTCreateTableHeader.this.pages.setText("");
                            TTCreateTableHeader.this.pages.requestFocus();
                        }
                    }
                }
            }
        });
        if (this._config.getOriginalObject() == null) {
            this.enableControl(false);
        } else if (this.hasPK()) {
            this.enableControl(true);
        }
    }

    private boolean hasPK() {
        for (Constraint constraint : ((Table)this._config.getUpdatedObject()).getConstraints()) {
            if (!(constraint instanceof PKConstraint)) continue;
            return true;
        }
        return false;
    }

    private void enableControl(boolean bl) {
        for (Component component : this.setupPanel.getComponents()) {
            component.setEnabled(bl);
        }
        this.setEnabled(bl);
        this.hashIndex.setEnabled(bl);
        this.rangeIndex.setEnabled(bl);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JRadioButton jRadioButton = (JRadioButton)changeEvent.getSource();
        if (jRadioButton.isSelected()) {
            if (jRadioButton == this.rangeIndex) {
                this.indexType.setIndexType(TTPrimaryKeyIndexType.TTPrimaryKeyType.RANGE);
                this.indexType.setPagesSize(0);
                this.pages.setText("");
                this.pages.setEnabled(false);
            } else {
                this.indexType.setIndexType(TTPrimaryKeyIndexType.TTPrimaryKeyType.HASH);
                this.pages.setEnabled(true);
            }
        }
    }
}

