/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.olapi.Debug;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataXMLTags;
import oracle.olapi.metadata.MetadataObjectHolder;
import oracle.olapi.metadata.MetadataXMLReader;
import oracle.olapi.metadata.MetadataXMLReaderRenameState;
import oracle.olapi.metadata.MetadataXMLReaderState;
import oracle.olapi.xml.TagHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

final class MetadataXMLReaderRenameObjectsState
extends MetadataXMLReaderState {
    private MetadataXMLReaderState m_OuterState = null;
    private HashMap<MetadataObjectHolder, String> m_RenamedHolders = new HashMap();
    private List<BaseMetadataObject> m_RenamedObjects = new ArrayList<BaseMetadataObject>();
    private List<BaseMetadataObject> m_UpgradedObjects = new ArrayList<BaseMetadataObject>();
    private Set<BaseMetadataObject> m_RenamedOrUpgradedObjectOwners = new HashSet<BaseMetadataObject>();

    @Override
    void setOuterState(MetadataXMLReaderState metadataXMLReaderState) {
        this.m_OuterState = metadataXMLReaderState;
    }

    @Override
    MetadataXMLReaderState getOuterState() {
        return this.m_OuterState;
    }

    void addRenamedHolder(MetadataObjectHolder metadataObjectHolder, String string) {
        Debug._assert(metadataObjectHolder.getMetadataObject() == null);
        this.m_RenamedHolders.put(metadataObjectHolder, string);
    }

    void addRenamedObject(BaseMetadataObject baseMetadataObject) {
        this.m_RenamedObjects.add(baseMetadataObject);
        this.m_RenamedOrUpgradedObjectOwners.add(baseMetadataObject.getTopLevelObject());
    }

    void addUpgradedObject(BaseMetadataObject baseMetadataObject) {
        this.m_UpgradedObjects.add(baseMetadataObject);
        this.m_RenamedOrUpgradedObjectOwners.add(baseMetadataObject.getTopLevelObject());
    }

    @Override
    protected void enter(String string, Attributes attributes, TagHandler tagHandler) throws SAXException {
        MetadataXMLReader metadataXMLReader = (MetadataXMLReader)tagHandler;
        this.m_RenamedObjects.clear();
        this.m_UpgradedObjects.clear();
    }

    @Override
    protected MetadataXMLReaderState exit(TagHandler tagHandler) throws SAXException {
        MetadataXMLReader metadataXMLReader = (MetadataXMLReader)tagHandler;
        for (BaseMetadataObject object : this.m_RenamedObjects) {
            object.updateName();
        }
        for (BaseMetadataObject baseMetadataObject : this.m_UpgradedObjects) {
            if (!baseMetadataObject.hasProperty(BaseMetadataXMLTags.NAMESPACE)) continue;
            baseMetadataObject.internalSetStringProperty(BaseMetadataXMLTags.NAMESPACE, "", 3, true);
        }
        for (BaseMetadataObject baseMetadataObject : this.m_RenamedOrUpgradedObjectOwners) {
            baseMetadataObject.updateIDsOfSelfAndChildren();
        }
        for (Map.Entry entry : this.m_RenamedHolders.entrySet()) {
            metadataXMLReader.getMetadataProvider().renameObjectHolder((MetadataObjectHolder)entry.getKey(), (String)entry.getValue());
        }
        this.setPropertyTag(null);
        MetadataXMLReaderState metadataXMLReaderState = this.getOuterState();
        this.setOuterState(null);
        return metadataXMLReaderState;
    }

    @Override
    protected MetadataXMLReaderState transition(String string, Attributes attributes, TagHandler tagHandler) throws SAXException {
        MetadataXMLReader metadataXMLReader = (MetadataXMLReader)tagHandler;
        String string2 = metadataXMLReader.getXMLFormat().getVersion();
        if (BaseMetadataXMLTags.RENAME_TAG.matches(string, string2)) {
            MetadataXMLReaderRenameState metadataXMLReaderRenameState = metadataXMLReader.getRenameState();
            metadataXMLReaderRenameState.setOuterState(this);
            metadataXMLReaderRenameState.setPropertyTag(BaseMetadataXMLTags.RENAME_OBJECTS_TAG);
            return metadataXMLReaderRenameState;
        }
        return null;
    }
}

