/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBSQLException;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractBuildableObject
extends AbstractDBObject {
    public AbstractBuildableObject() {
    }

    protected AbstractBuildableObject(String string, DBObjectID dBObjectID) {
        super(string, dBObjectID);
    }

    @Override
    AbstractDBObject.PropertySupport createPropertySupport() {
        return new BuildablePropertySupport();
    }

    @Override
    BuildablePropertySupport getPropertySupport() {
        return (BuildablePropertySupport)super.getPropertySupport();
    }

    final boolean isBuilt(String string) {
        BuildablePropertySupport buildablePropertySupport = this.getPropertySupport();
        return string != null && (buildablePropertySupport.isBuilt(string) || buildablePropertySupport.getBuilder(string) == null);
    }

    protected boolean needsInitialization() {
        return this.getPropertySupport().needsInitialization();
    }

    protected void checkInit(String string) {
        this.getPropertySupport().checkBuilt(string);
    }

    protected void checkInit() {
        this.checkInit(null);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.getPropertySupport().getLazyMapWrapper();
    }

    @Override
    public void setID(DBObjectID dBObjectID) {
        DBObjectBuilder dBObjectBuilder;
        DBObject dBObject;
        super.setID(dBObjectID);
        BuildablePropertySupport buildablePropertySupport = this.getPropertySupport();
        DBObjectBuilder dBObjectBuilder2 = buildablePropertySupport.m_builder;
        if (dBObjectID instanceof TemporaryObjectID && dBObjectBuilder2 instanceof TemporaryCopyBuilder && (dBObject = ((TemporaryObjectID)dBObjectID).getOriginalObject()) instanceof AbstractBuildableObject && ((TemporaryCopyBuilder)dBObjectBuilder2).m_original != dBObject && (dBObjectBuilder = ((AbstractBuildableObject)dBObject).getPropertySupport().m_builder) instanceof AbstractDBObjectBuilder) {
            buildablePropertySupport.initCopyBuilder((AbstractBuildableObject)dBObject, (AbstractDBObjectBuilder)dBObjectBuilder, new TemporaryObjectID.TemporaryIDPolicy());
        }
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> collection, String ... stringArray) {
        Collection<String> collection2 = this.getChildPropertiesForTypes(stringArray);
        if (collection2 == null) {
            this.checkInit();
        } else {
            for (String string : collection2) {
                this.checkInit(string);
            }
        }
        super.getOwnedObjectsImpl(collection, stringArray);
    }

    private Collection<String> getChildPropertiesForTypes(String[] stringArray) {
        ArrayList<String> arrayList = null;
        if (stringArray != null) {
            for (Map.Entry<String, PropertyInfo> entry : PropertyHelper.getPropertyInfos(this.getClass(), null, null).entrySet()) {
                String string = entry.getKey();
                PropertyInfo propertyInfo = entry.getValue();
                Class<?> clazz = DBUtil.decodeArrayClass(propertyInfo.getPropertyClass());
                if (!DBObject.class.isAssignableFrom(clazz)) continue;
                String string2 = Metadata.getType(clazz);
                for (String string3 : stringArray) {
                    if (!ModelUtil.areEqual((Object)string3, (Object)string2)) continue;
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add(string);
                }
            }
        }
        return arrayList;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> collection) {
        this.checkInit();
        super.getReferenceIDsImpl(collection);
    }

    @Override
    protected void copyToImpl(AbstractDBObject abstractDBObject, DBObject dBObject, IDPolicy iDPolicy) {
        BuildablePropertySupport buildablePropertySupport = this.getPropertySupport();
        if (!(buildablePropertySupport.supportsCopyBuilder(iDPolicy) || iDPolicy instanceof IDPolicy.SameIDPolicy || iDPolicy instanceof TemporaryObjectID.CopyBackPolicy)) {
            buildablePropertySupport.checkBuilt(null);
            ((AbstractBuildableObject)abstractDBObject).getPropertySupport().markAsBuilt();
        }
        super.copyToImpl(abstractDBObject, dBObject, iDPolicy);
    }

    DBObject createStaticCopy() {
        return this.copyTo(null, new StaticCopyPolicy());
    }

    @Override
    boolean fireListeners(DBObjectChange dBObjectChange) {
        return !this.getPropertySupport().isBuilding();
    }

    @Override
    final void processChange(DBObjectChange dBObjectChange) {
        BuildablePropertySupport buildablePropertySupport = this.getPropertySupport();
        if (!buildablePropertySupport.isBuilding()) {
            this.processPropertyChange(dBObjectChange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processPropertyChange(DBObjectChange dBObjectChange) {
        boolean bl = false;
        BuildablePropertySupport buildablePropertySupport = this.getPropertySupport();
        DerivedPropertyBuilder derivedPropertyBuilder = buildablePropertySupport.getDerivedPropertyBuilder();
        if (derivedPropertyBuilder != null && !buildablePropertySupport.m_clearingDerivedProperties) {
            bl = derivedPropertyBuilder.isClearDerivedPropertiesRequired(this, dBObjectChange, buildablePropertySupport.m_currentlyBuiltProps);
        }
        if (bl) {
            buildablePropertySupport.m_clearingDerivedProperties = true;
            try {
                buildablePropertySupport.clearDerivedProperties(dBObjectChange);
            }
            finally {
                buildablePropertySupport.m_clearingDerivedProperties = false;
            }
        }
    }

    private class LazyPropertiesMap
    extends AbstractMap<String, Object> {
        private LazyPropertiesMap() {
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            AbstractBuildableObject.this.checkInit();
            return AbstractBuildableObject.super.getProperties().entrySet();
        }

        @Override
        public Object put(String string, Object object) {
            AbstractBuildableObject.this.setProperty(string, object);
            return true;
        }

        @Override
        public Object get(Object object) {
            Object var2_2 = null;
            if (object instanceof String) {
                BuildablePropertySupport buildablePropertySupport = AbstractBuildableObject.this.getPropertySupport();
                buildablePropertySupport.checkBuilt((String)object);
                var2_2 = buildablePropertySupport.get((String)object);
            }
            return var2_2;
        }

        @Override
        public Object remove(Object object) {
            Object object2 = null;
            if (object instanceof String) {
                object2 = this.get(object);
                this.put((String)object, (Object)null);
            }
            return object2;
        }

        @Override
        public boolean containsKey(Object object) {
            return this.get(object) != null;
        }
    }

    class TemporaryCopyBuilder
    extends AbstractDBObjectBuilder {
        private final AbstractBuildableObject m_original;
        private final TemporaryObjectID.TemporaryIDPolicy m_idPolicy;
        private final AbstractDBObjectBuilder m_delegate;

        TemporaryCopyBuilder(AbstractBuildableObject abstractBuildableObject2, AbstractDBObjectBuilder abstractDBObjectBuilder, TemporaryObjectID.TemporaryIDPolicy temporaryIDPolicy) {
            super(abstractDBObjectBuilder.getProvider(), abstractBuildableObject2.getType());
            this.m_original = abstractBuildableObject2;
            this.m_idPolicy = temporaryIDPolicy;
            this.m_delegate = abstractDBObjectBuilder;
            this.copyTimestamp(AbstractBuildableObject.this);
        }

        @Override
        public AbstractBuildableObject createObject(String string, Schema schema, DBObjectID dBObjectID) {
            throw new UnsupportedOperationException("TemporaryCopyBuilder doesn't support create");
        }

        @Override
        public boolean isBuildableProperty(String string) {
            return !s_specialProps.contains(string);
        }

        protected void fillInObject(AbstractBuildableObject abstractBuildableObject) throws DBException {
            this.m_original.checkInit();
            BuildablePropertySupport buildablePropertySupport = this.m_original.getPropertySupport();
            BuildablePropertySupport buildablePropertySupport2 = abstractBuildableObject.getPropertySupport();
            TreeSet<String> treeSet = new TreeSet<String>(buildablePropertySupport2.m_currentlyBuiltProps);
            for (String string : buildablePropertySupport2.m_clearedDerivedProps) {
                if (treeSet.contains(string) || buildablePropertySupport2.m_derivedPropertyBuilder == null || !buildablePropertySupport2.m_derivedPropertyBuilder.isBuildableProperty(string)) continue;
                treeSet.add(string);
            }
            buildablePropertySupport.copyTo(buildablePropertySupport2, this.m_idPolicy, treeSet);
            abstractBuildableObject.replaceReferenceIDsDirectly(this.m_idPolicy.getIDMap());
        }

        protected boolean fillInObjectComponentImpl(AbstractBuildableObject abstractBuildableObject, String string) throws DBException {
            BuildablePropertySupport buildablePropertySupport = this.m_original.getPropertySupport();
            BuildablePropertySupport buildablePropertySupport2 = abstractBuildableObject.getPropertySupport();
            buildablePropertySupport.checkBuiltEx(string);
            Object v = AbstractBuildableObject.this.copyObject(buildablePropertySupport.get(string), abstractBuildableObject, this.m_idPolicy);
            buildablePropertySupport2.put(string, v);
            abstractBuildableObject.replaceReferenceIDsDirectly(this.m_idPolicy.getIDMap());
            return true;
        }

        @Override
        protected boolean canBuildComponents() {
            return true;
        }

        protected void registerObject(AbstractBuildableObject abstractBuildableObject) throws DBException {
            this.copyTimestamp(abstractBuildableObject);
        }

        private void copyTimestamp(AbstractBuildableObject abstractBuildableObject) {
            Object v = this.m_original.getPropertySupport().get("Timestamp");
            if (v != null) {
                abstractBuildableObject.setProperty("Timestamp", v);
            }
        }

        @Override
        String[] getPropertyDependencies(String string) {
            return this.m_delegate.getPropertyDependencies(string);
        }

        @Override
        protected String[] getBuiltProperties(String string) {
            return new String[]{string};
        }

        @Override
        public boolean cancelCurrentBuild(AbstractBuildableObject abstractBuildableObject) {
            boolean bl = super.cancelCurrentBuild(abstractBuildableObject);
            if (bl) {
                this.m_delegate.cancelCurrentBuild(this.m_original);
            }
            return bl;
        }
    }

    private static enum BuiltStatus {
        UNBUILT,
        PARTIAL,
        BUILT;

    }

    private class StaticCopyPolicy
    extends IDPolicy.SameIDPolicy {
        private StaticCopyPolicy() {
        }
    }

    final class BuildablePropertySupport
    extends AbstractDBObject.PropertySupport {
        private final Holder<Map<String, Object>> m_lazyWrapper;
        private DBObjectBuilder m_builder;
        private DerivedPropertyBuilder m_derivedPropertyBuilder;
        private final Set<String> m_building;
        private boolean m_buildingImpl;
        private boolean m_buildingAll;
        private Thread m_buildingThread;
        private final Set<String> m_currentlyBuiltProps;
        private boolean m_clearingDerivedProperties;
        private final Set<String> m_clearedDerivedProps;
        private volatile BuiltStatus m_status;

        BuildablePropertySupport() {
            super(AbstractBuildableObject.this);
            this.m_lazyWrapper = new Holder();
            this.m_building = new TreeSet<String>();
            this.m_currentlyBuiltProps = new CopyOnWriteArraySet<String>();
            this.m_clearedDerivedProps = new CopyOnWriteArraySet<String>();
            this.m_status = BuiltStatus.BUILT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Object> getLazyMapWrapper() {
            Holder<Map<String, Object>> holder = this.m_lazyWrapper;
            synchronized (holder) {
                Map map = (Map)this.m_lazyWrapper.get();
                if (map == null) {
                    map = new LazyPropertiesMap();
                    this.m_lazyWrapper.set((Object)map);
                }
                return map;
            }
        }

        void setBuilder(DBObjectBuilder dBObjectBuilder) {
            if (dBObjectBuilder == null) {
                throw new IllegalArgumentException("builder cannot be null");
            }
            this.m_builder = dBObjectBuilder;
            this.m_currentlyBuiltProps.clear();
            this.m_clearedDerivedProps.clear();
            this.m_status = BuiltStatus.UNBUILT;
            this.replaceObjectPropertyExecutor(dBObjectBuilder);
        }

        private void replaceObjectPropertyExecutor(DBObjectBuilder dBObjectBuilder) {
            Executor executor;
            if (dBObjectBuilder instanceof AbstractDBObjectBuilder && (executor = ((AbstractDBObjectBuilder)dBObjectBuilder).getPropertyExecutor(AbstractBuildableObject.this)) != null) {
                AbstractBuildableObject.this.replacePropertyExecutor(executor);
            }
        }

        void setDerivedPropertyBuilder(DerivedPropertyBuilder derivedPropertyBuilder) {
            this.m_derivedPropertyBuilder = derivedPropertyBuilder;
            if (this.m_builder == null) {
                this.replaceObjectPropertyExecutor(derivedPropertyBuilder);
            }
        }

        DerivedPropertyBuilder getDerivedPropertyBuilder() {
            return this.m_derivedPropertyBuilder;
        }

        void markAsBuilt() {
            if (this.m_status != BuiltStatus.BUILT) {
                this.m_status = BuiltStatus.BUILT;
            }
        }

        boolean needsInitialization() {
            return this.m_status != BuiltStatus.BUILT;
        }

        void setBuildingAll() {
            this.m_buildingAll = true;
        }

        boolean isBuilding() {
            return this.m_buildingImpl || this.m_buildingAll || !this.m_building.isEmpty();
        }

        void startBuilding(String ... stringArray) {
            if (stringArray != null) {
                for (String string : stringArray) {
                    if (this.m_building.contains(string)) {
                        AbstractDBObject.getPropertyLogger().severe("already building " + string);
                    }
                    this.m_building.add(string);
                }
            }
        }

        void finishBuilding(String ... stringArray) {
            if (stringArray != null) {
                for (String string : stringArray) {
                    this.m_building.remove(string);
                }
            }
        }

        void setBuilt(String ... stringArray) {
            if (stringArray != null) {
                for (String string : stringArray) {
                    this.m_currentlyBuiltProps.add(string);
                    this.m_clearedDerivedProps.remove(string);
                }
            }
        }

        void setUnbuilt(String ... stringArray) {
            if (stringArray != null) {
                for (String string : stringArray) {
                    this.m_currentlyBuiltProps.remove(string);
                }
            }
        }

        boolean isBuilt(String string) {
            boolean bl = false;
            if (string == null || this.m_derivedPropertyBuilder == null || !this.m_derivedPropertyBuilder.isBuildableProperty(string)) {
                boolean bl2 = bl = this.m_status == BuiltStatus.BUILT;
            }
            if (!bl) {
                if (string == null) {
                    bl = false;
                } else if (this.m_currentlyBuiltProps.contains(string)) {
                    bl = true;
                }
            }
            return bl;
        }

        void checkBuilt(String string) {
            DBObjectBuilder dBObjectBuilder = this.getBuilder(string);
            if (dBObjectBuilder != null) {
                try {
                    this.checkBuiltEx(string, dBObjectBuilder);
                }
                catch (DBSQLException dBSQLException) {
                    AbstractDBObject.getPropertyLogger().log(Level.SEVERE, "Error : \"" + dBSQLException.getMessage() + "\" building {0}, executing sql:\n {1}", new Object[]{AbstractBuildableObject.this.getName(), dBSQLException.getSQL()});
                }
                catch (CancelledException cancelledException) {
                    this.logBuildCancelled(string);
                }
                catch (DBException dBException) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.logBuildCancelled(string);
                    }
                    String string2 = (String)this.get("name");
                    String string3 = ModelUtil.hasLength((String)string) ? APIBundle.format("BUILD_OBJ_COMP_ERROR", dBException.getMessage(), string, AbstractBuildableObject.this.getType(), string2) : APIBundle.format("BUILD_OBJ_ERROR", dBException.getMessage(), AbstractBuildableObject.this.getType(), string2);
                    AbstractDBObject.getPropertyLogger().log(Level.FINE, string3, dBException);
                    AbstractDBObject.getPropertyLogger().severe(string3);
                }
            }
        }

        private void logBuildCancelled(String string) {
            String string2 = (String)this.get("name");
            String string3 = ModelUtil.hasLength((String)string) ? APIBundle.format("BUILD_OBJ_COMP_CANCELLED", string, AbstractBuildableObject.this.getType(), string2) : APIBundle.format("BUILD_OBJ_CANCELLED", AbstractBuildableObject.this.getType(), string2);
            AbstractDBObject.getPropertyLogger().log(Level.WARNING, string3);
        }

        void checkBuiltEx(String string) throws DBException {
            DBObjectBuilder dBObjectBuilder = this.getBuilder(string);
            if (dBObjectBuilder != null) {
                this.checkBuiltEx(string, dBObjectBuilder);
            }
        }

        private void checkBuiltEx(String string, DBObjectBuilder dBObjectBuilder) throws DBException {
            if (dBObjectBuilder == null || this.isBuilt(string)) {
                return;
            }
            if (this.m_buildingAll || string != null && this.m_building.contains(string)) {
                if (this.m_buildingThread == null) {
                    return;
                }
                Thread thread = Thread.currentThread();
                if (thread == this.m_buildingThread || StatementWrapper.isExecutionProxyThread(this.m_buildingThread, thread)) {
                    return;
                }
                AbstractDBObject.getPropertyLogger().log(Level.FINEST, "Querying " + string + " while it is being built");
            }
            if (!(string == null || dBObjectBuilder instanceof AbstractDBObjectBuilder && ((AbstractDBObjectBuilder)dBObjectBuilder).canBuildComponents() || this.m_derivedPropertyBuilder == null || !this.m_derivedPropertyBuilder.isBuildableProperty(string))) {
                this.buildImpl(dBObjectBuilder, null);
                if (!this.isBuilt(string)) {
                    this.buildImpl(this.m_derivedPropertyBuilder, string);
                }
            } else {
                this.buildImpl(dBObjectBuilder, string);
            }
        }

        void ensureDerivedPropertiesBuilt() throws DBException {
            if (this.m_derivedPropertyBuilder != null && !this.m_buildingAll) {
                this.buildImpl(this.m_derivedPropertyBuilder, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void buildImpl(final DBObjectBuilder dBObjectBuilder, final String string) throws DBException {
            final Holder holder = new Holder();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        BuildablePropertySupport.this.buildImplWhileLocked(dBObjectBuilder, string);
                    }
                    catch (DBException dBException) {
                        holder.set((Object)dBException);
                    }
                }
            };
            CancelledException.checkInterrupt();
            this.m_buildingImpl = true;
            try {
                AbstractBuildableObject.this.invokeCompoundChange(runnable, false);
            }
            finally {
                this.m_buildingImpl = false;
            }
            DBException dBException = (DBException)holder.get();
            if (dBException != null) {
                throw dBException;
            }
        }

        private void buildImplWhileLocked(DBObjectBuilder dBObjectBuilder, String string) throws DBException {
            long l;
            block14: {
                if (string != null && dBObjectBuilder != this.m_derivedPropertyBuilder && this.isBuilt(string)) {
                    return;
                }
                l = System.currentTimeMillis();
                boolean bl = false;
                try {
                    this.m_buildingThread = Thread.currentThread();
                    if (string == null) {
                        this.m_buildingAll = true;
                        dBObjectBuilder.buildObject(AbstractBuildableObject.this);
                        if (dBObjectBuilder == this.m_builder) {
                            this.m_status = BuiltStatus.BUILT;
                        }
                    } else {
                        dBObjectBuilder.buildObjectComponent(AbstractBuildableObject.this, string);
                        if (dBObjectBuilder == this.m_builder && this.m_status == BuiltStatus.UNBUILT) {
                            this.m_status = BuiltStatus.PARTIAL;
                        }
                    }
                    this.m_buildingThread = null;
                    this.m_buildingAll = false;
                    if (string == null || bl) break block14;
                    this.m_currentlyBuiltProps.add(string);
                }
                catch (DBException dBException) {
                    try {
                        if (dBException instanceof CancelledException || dBObjectBuilder instanceof AbstractDBObjectBuilder && !((AbstractDBObjectBuilder)dBObjectBuilder).isBuiltOnFailure(AbstractBuildableObject.this, new String[]{string}, dBException)) {
                            bl = true;
                            if (string != null) {
                                this.m_currentlyBuiltProps.remove(string);
                            }
                        }
                        throw dBException;
                    }
                    catch (Throwable throwable) {
                        this.m_buildingThread = null;
                        this.m_buildingAll = false;
                        if (string != null && !bl) {
                            this.m_currentlyBuiltProps.add(string);
                        }
                        if ((l = System.currentTimeMillis() - l) > 20L) {
                            AbstractDBObject.getPropertyLogger().log(Level.FINEST, "Building {0} of {1} took {2}ms", new Object[]{string == null ? "all" : string, AbstractBuildableObject.this.getName(), Long.toString(l)});
                        }
                        throw throwable;
                    }
                }
            }
            if ((l = System.currentTimeMillis() - l) > 20L) {
                AbstractDBObject.getPropertyLogger().log(Level.FINEST, "Building {0} of {1} took {2}ms", new Object[]{string == null ? "all" : string, AbstractBuildableObject.this.getName(), Long.toString(l)});
            }
        }

        DBObjectBuilder getBuilder(String string) {
            DBObjectBuilder dBObjectBuilder = this.m_builder;
            if (string != null) {
                boolean bl;
                boolean bl2 = this.m_derivedPropertyBuilder != null && this.m_derivedPropertyBuilder.isBuildableProperty(string);
                boolean bl3 = bl = this.m_builder instanceof AbstractDBObjectBuilder && ((AbstractDBObjectBuilder)this.m_builder).isBuildableProperty(string);
                if (bl2 && (!bl || this.m_clearedDerivedProps.contains(string))) {
                    dBObjectBuilder = this.m_derivedPropertyBuilder;
                } else if (!bl) {
                    dBObjectBuilder = null;
                }
            }
            return dBObjectBuilder;
        }

        @Override
        public void copyTo(AbstractDBObject.PropertySupport propertySupport, IDPolicy iDPolicy) {
            super.copyTo(propertySupport, iDPolicy);
            BuildablePropertySupport buildablePropertySupport = (BuildablePropertySupport)propertySupport;
            DerivedPropertyBuilder derivedPropertyBuilder = buildablePropertySupport.m_derivedPropertyBuilder;
            buildablePropertySupport.m_derivedPropertyBuilder = null;
            boolean bl = false;
            if (iDPolicy instanceof StaticCopyPolicy) {
                bl = true;
                buildablePropertySupport.markAsBuilt();
            } else if (iDPolicy instanceof IDPolicy.SameIDPolicy) {
                bl = true;
                if (this.m_status != BuiltStatus.BUILT) {
                    if (this.m_builder instanceof TemporaryCopyBuilder) {
                        buildablePropertySupport.initCopyBuilder(((TemporaryCopyBuilder)this.m_builder).m_original, ((TemporaryCopyBuilder)this.m_builder).m_delegate, new TemporaryObjectID.TemporaryIDPolicy());
                    } else {
                        buildablePropertySupport.m_builder = this.m_builder;
                    }
                    this.copyPropertyStateTo(buildablePropertySupport);
                }
            } else if (this.supportsCopyBuilder(iDPolicy)) {
                bl = true;
                if (this.m_status != BuiltStatus.BUILT) {
                    buildablePropertySupport.initCopyBuilder(AbstractBuildableObject.this, (AbstractDBObjectBuilder)this.m_builder, (TemporaryObjectID.TemporaryIDPolicy)iDPolicy);
                    this.copyPropertyStateTo(buildablePropertySupport);
                }
            } else if (iDPolicy instanceof TemporaryObjectID.TemporaryIDPolicy || iDPolicy instanceof TemporaryObjectID.CopyBackPolicy) {
                bl = true;
            }
            if (bl) {
                if (this.m_derivedPropertyBuilder != null) {
                    AbstractDBObjectProvider abstractDBObjectProvider = this.m_derivedPropertyBuilder.getProvider();
                    buildablePropertySupport.m_derivedPropertyBuilder = abstractDBObjectProvider.getDescriptor().getDerivedPropertyBuilder(AbstractBuildableObject.this.getClass(), abstractDBObjectProvider);
                    this.copyDerivedPropertyStateTo(buildablePropertySupport);
                } else if (derivedPropertyBuilder != null) {
                    buildablePropertySupport.m_derivedPropertyBuilder = derivedPropertyBuilder;
                    this.copyDerivedPropertyStateTo(buildablePropertySupport);
                }
            }
        }

        private void copyPropertyStateTo(BuildablePropertySupport buildablePropertySupport) {
            buildablePropertySupport.m_status = this.m_status;
            buildablePropertySupport.m_currentlyBuiltProps.addAll(this.m_currentlyBuiltProps);
            buildablePropertySupport.m_currentlyBuiltProps.retainAll(this.m_currentlyBuiltProps);
        }

        private void copyDerivedPropertyStateTo(BuildablePropertySupport buildablePropertySupport) {
            buildablePropertySupport.m_clearedDerivedProps.addAll(this.m_clearedDerivedProps);
            buildablePropertySupport.m_clearedDerivedProps.retainAll(this.m_clearedDerivedProps);
            if (this.m_status == BuiltStatus.BUILT) {
                buildablePropertySupport.m_currentlyBuiltProps.removeAll(this.m_clearedDerivedProps);
                Collection<String> collection = buildablePropertySupport.m_derivedPropertyBuilder.listBuildableProperties();
                for (String string : collection) {
                    if ("Timestamp".equals(string)) continue;
                    if (this.m_currentlyBuiltProps.contains(string)) {
                        buildablePropertySupport.m_currentlyBuiltProps.add(string);
                        continue;
                    }
                    buildablePropertySupport.m_currentlyBuiltProps.remove(string);
                }
            }
        }

        private void initCopyBuilder(AbstractBuildableObject abstractBuildableObject, AbstractDBObjectBuilder abstractDBObjectBuilder, TemporaryObjectID.TemporaryIDPolicy temporaryIDPolicy) {
            this.setBuilder(new TemporaryCopyBuilder(abstractBuildableObject, abstractDBObjectBuilder, temporaryIDPolicy));
        }

        private boolean supportsCopyBuilder(IDPolicy iDPolicy) {
            return iDPolicy instanceof TemporaryObjectID.TemporaryIDPolicy && this.m_builder instanceof AbstractDBObjectBuilder && ((AbstractDBObjectBuilder)this.m_builder).canBuildComponents();
        }

        @Override
        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof BuildablePropertySupport) {
                this.syncBuildState((BuildablePropertySupport)object);
                bl = super.equals(object) && this.equalsImpl((BuildablePropertySupport)object);
            }
            return bl;
        }

        private boolean equalsImpl(BuildablePropertySupport buildablePropertySupport) {
            boolean bl = ModelUtil.areEqual((Object)((Object)this.m_status), (Object)((Object)buildablePropertySupport.m_status));
            if (bl && this.m_status != BuiltStatus.BUILT) {
                bl = this.m_currentlyBuiltProps.equals(buildablePropertySupport.m_currentlyBuiltProps);
            }
            return bl;
        }

        private boolean isTempCopyOf(BuildablePropertySupport buildablePropertySupport) {
            boolean bl = false;
            if (this.m_builder instanceof TemporaryCopyBuilder) {
                bl = ((TemporaryCopyBuilder)this.m_builder).m_original == buildablePropertySupport.getParentForChildren();
            }
            return bl;
        }

        private void syncBuildState(BuildablePropertySupport buildablePropertySupport) {
            boolean bl = this.isTempCopyOf(buildablePropertySupport);
            boolean bl2 = buildablePropertySupport.isTempCopyOf(this);
            if (bl || bl2) {
                if (!this.needsInitialization()) {
                    buildablePropertySupport.checkBuilt(null);
                } else if (!buildablePropertySupport.needsInitialization()) {
                    this.checkBuilt(null);
                } else {
                    BuildablePropertySupport buildablePropertySupport2;
                    BuildablePropertySupport buildablePropertySupport3;
                    if (bl) {
                        buildablePropertySupport3 = buildablePropertySupport;
                        buildablePropertySupport2 = this;
                    } else {
                        buildablePropertySupport3 = this;
                        buildablePropertySupport2 = buildablePropertySupport;
                    }
                    TreeSet<String> treeSet = new TreeSet<String>(buildablePropertySupport2.m_currentlyBuiltProps);
                    for (String object2 : treeSet) {
                        buildablePropertySupport3.checkBuilt(object2);
                    }
                    TreeSet<String> treeSet2 = new TreeSet<String>(buildablePropertySupport3.m_currentlyBuiltProps);
                    treeSet2.removeAll(treeSet);
                    Iterator iterator = treeSet2.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        buildablePropertySupport2.checkBuilt(string);
                    }
                }
            } else {
                this.checkBuilt(null);
                buildablePropertySupport.checkBuilt(null);
            }
        }

        @Override
        public Object put(String string, Object object) {
            Object object2 = super.put(string, object);
            if (!this.m_building.contains(string)) {
                this.setBuilt(string);
            }
            return object2;
        }

        private void clearDerivedProperties(DBObjectChange dBObjectChange) {
            Collection<String> collection;
            if (this.m_derivedPropertyBuilder != null && (collection = this.m_derivedPropertyBuilder.clearDerivedProperties(AbstractBuildableObject.this, dBObjectChange)) != null && !collection.isEmpty()) {
                this.m_currentlyBuiltProps.removeAll(collection);
                this.m_clearedDerivedProps.addAll(collection);
            }
        }
    }
}

