/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.DBObject;

public class DBException
extends Exception {
    private DBException m_next;
    private DBObject m_object;
    private DBObject[] m_relatedObjects;

    public DBException(DBObject dBObject, String string) {
        super(string);
        this.m_object = dBObject;
    }

    public DBException(DBObject dBObject, String string, Throwable throwable) {
        super(string, throwable);
        this.m_object = dBObject;
    }

    public DBException(DBObject dBObject, Throwable throwable) {
        super(throwable);
        this.m_object = dBObject;
    }

    public DBException(Throwable throwable) {
        super(throwable);
    }

    protected DBException() {
    }

    public DBObject getObject() {
        return this.m_object;
    }

    public DBObject[] getRelatedObjects() {
        return this.m_relatedObjects;
    }

    public void setRelatedObjects(DBObject ... dBObjectArray) {
        this.m_relatedObjects = dBObjectArray;
    }

    public DBException getNextException() {
        return this.m_next;
    }

    public synchronized void setNextException(DBException dBException) {
        if (dBException == this) {
            throw new IllegalStateException("Attempt to add this as nextException");
        }
        DBException dBException2 = this;
        while (dBException2.m_next != null) {
            dBException2 = dBException2.m_next;
        }
        dBException2.m_next = dBException;
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    public String getAllMessages() {
        String string;
        if (this.m_next == null) {
            string = this.getMessage();
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (DBException dBException = this; dBException != null; dBException = dBException.getNextException()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(dBException.getMessage());
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    public static <T extends DBException> T append(T t, T t2) {
        T t3;
        if (t != null) {
            t3 = t;
            if (t2 != null) {
                t3.setNextException(t2);
            }
        } else {
            t3 = t2;
        }
        return t3;
    }
}

