/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.math.BigInteger;
import oracle.javatools.db.AbstractChildBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AutoExtendProperties;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ora.OracleTableProperties;
import oracle.javatools.db.property.NumberProperty;
import oracle.javatools.db.property.PropertyKey;

public class OracleTablespaceProperties
extends AbstractChildBuildableObject {
    public static final String TYPE = "OracleTablespaceProperties";
    @PropertyKey(value=OracleTablespaceProperties.class, childOf={Tablespace.class}, provider=DBObjectProvider.class)
    public static final String KEY = "OracleTablespaceProperties";
    private boolean editing;

    public OracleTablespaceProperties() {
        this(false);
    }

    public OracleTablespaceProperties(boolean bl) {
        this.editing = bl;
        this.setForceLogging(false);
        this.setAutoAllocate(false);
    }

    @Override
    protected void copyToImpl(AbstractDBObject abstractDBObject, DBObject dBObject, IDPolicy iDPolicy) {
        super.copyToImpl(abstractDBObject, dBObject, iDPolicy);
        if (abstractDBObject.getID() != null) {
            ((OracleTablespaceProperties)abstractDBObject).editing = this.editing;
        }
    }

    public boolean isEditing() {
        return this.editing;
    }

    @Override
    public String getType() {
        return "OracleTablespaceProperties";
    }

    public void setMinExtent(Integer n) {
        this.setProperty("minExtent", n);
    }

    public Integer getMinExtent() {
        return (Integer)this.getProperty("minExtent");
    }

    public void setBlockSize(Integer n) {
        this.setProperty("blockSize", n);
    }

    public Integer getBlockSize() {
        return (Integer)this.getProperty("blockSize");
    }

    public void setDefaultTableCompression(OracleTableProperties.OracleTableCompression oracleTableCompression) {
        this.setProperty("defaultTableCompression", (Object)oracleTableCompression);
    }

    public OracleTableProperties.OracleTableCompression getDefaultTableCompression() {
        return (OracleTableProperties.OracleTableCompression)((Object)this.getProperty("defaultTableCompression"));
    }

    public void setOnlineStatus(OnlineStatus onlineStatus) {
        this.setProperty("onlineStatus", (Object)onlineStatus);
    }

    public OnlineStatus getOnlineStatus() {
        return (OnlineStatus)((Object)this.getProperty("onlineStatus"));
    }

    public void setSegmentManagement(SegmentManagement segmentManagement) {
        this.setProperty("segmentManagement", (Object)segmentManagement);
    }

    public SegmentManagement getSegmentManagement() {
        return (SegmentManagement)((Object)this.getProperty("segmentManagement"));
    }

    public void setLogging(LoggingType loggingType) {
        this.setProperty("logging", (Object)loggingType);
    }

    public LoggingType getLogging() {
        return (LoggingType)((Object)this.getProperty("logging"));
    }

    public void setForceLogging(boolean bl) {
        this.setProperty("forceLogging", bl);
    }

    public boolean isForceLogging() {
        return (Boolean)this.getProperty("forceLogging", false);
    }

    public void setRetention(RetentionType retentionType) {
        this.setProperty("retention", (Object)retentionType);
    }

    public RetentionType getRetention() {
        return (RetentionType)((Object)this.getProperty("retention"));
    }

    public void setTablespaceGroup(String string) {
        this.setProperty("tablespaceGroup", string);
    }

    public String getTablespaceGroup() {
        return (String)this.getProperty("tablespaceGroup");
    }

    public void setExtentManagementType(ExtentManagementType extentManagementType) {
        this.setProperty("extentManagementType", (Object)extentManagementType);
    }

    public ExtentManagementType getExtentManagementType() {
        return (ExtentManagementType)((Object)this.getProperty("extentManagementType"));
    }

    public void setAutoAllocate(boolean bl) {
        this.setProperty("autoAllocate", bl);
    }

    public boolean isAutoAllocate() {
        return (Boolean)this.getProperty("autoAllocate", false);
    }

    public void setUniformSize(BigInteger bigInteger) {
        this.setProperty("uniformSize", bigInteger);
    }

    @NumberProperty(physicalSize=true)
    public BigInteger getUniformSize() {
        return (BigInteger)this.getProperty("uniformSize");
    }

    public void setAutoExtendProperties(AutoExtendProperties autoExtendProperties) {
        this.setProperty("autoExtendProperties", autoExtendProperties);
    }

    public AutoExtendProperties getAutoExtendProperties() {
        return (AutoExtendProperties)this.getProperty("autoExtendProperties");
    }

    public void setShardedTablespace(boolean bl) {
        this.setProperty("shardedTablespace", bl);
    }

    public boolean getShardedTablespace() {
        return (Boolean)this.getProperty("shardedTablespace", false);
    }

    public void setShardDDLEnabled(boolean bl) {
        this.setProperty("shardDDLEnabled", bl);
    }

    public boolean getShardDDLEnabled() {
        return (Boolean)this.getProperty("shardDDLEnabled", false);
    }

    public static enum ExtentManagementType {
        LOCAL,
        DICTIONARY;

    }

    public static enum RetentionType {
        GUARANTEE,
        NOGUARANTEE;

    }

    public static enum LoggingType {
        LOGGING,
        NOLOGGING,
        FILESYSTEM_LIKE_LOGGING;

    }

    public static enum SegmentManagement {
        AUTO,
        MANUAL;

    }

    public static enum OnlineStatus {
        ONLINE,
        OFFLINE,
        OFFLINE_NORMAL,
        OFFLINE_TEMPORARY,
        OFFLINE_IMMEDIATE;

    }

    @Deprecated
    public static enum DefaultTableCompression {
        NOCOMPRESS,
        COMPRESS,
        COMPRESS_FOR_ALL_OPERATIONS,
        COMPRESS_FOR_DIRECT_LOAD_OPERATIONS,
        COMPRESS_FOR_OLTP,
        COMPRESS_FOR_ARCHIVE_LOW,
        COMPRESS_FOR_ARCHIVE_HIGH,
        COMPRESS_FOR_QUERY_LOW,
        COMPRESS_FOR_QUERY_HIGH;

    }
}

