/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBLog;
import oracle.javatools.db.property.Internal;
import oracle.javatools.db.resource.APIBundle;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractAliasFragment
extends AbstractSQLFragment
implements AliasFragment {
    protected AbstractAliasFragment() {
    }

    protected AbstractAliasFragment(SQLFragment sQLFragment, String string) {
        this.setExpression(sQLFragment);
        this.setAlias(string);
    }

    @Override
    public String getAlias() {
        return (String)this.getProperty("alias");
    }

    @Override
    public void setAlias(String string) {
        if (this.canHaveAlias()) {
            this.setProperty("alias", string);
            this.setName(null);
        } else if (ModelUtil.hasLength((String)string)) {
            DBLog.getLogger(this).warning(APIBundle.format("SQL_NO_ALIAS", this.getExpression().getSQLText()));
        }
    }

    public boolean canHaveAlias() {
        return true;
    }

    @Override
    public SQLFragment getExpression() {
        return (SQLFragment)this.getProperty("expression");
    }

    @Override
    public void setExpression(SQLFragment sQLFragment) {
        this.setProperty("expression", sQLFragment);
        if (this.canHaveAlias()) {
            this.setName(null);
        } else {
            this.setAlias(null);
        }
    }

    @Override
    public String getSQLText() {
        SQLFragment sQLFragment = this.getExpression();
        String string = this.getAlias();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTextOrNull(sQLFragment));
        if (ModelUtil.hasLength((String)string)) {
            if (this.useAsBeforeAlias()) {
                stringBuilder.append(" AS");
            }
            stringBuilder.append(" ").append(string);
        }
        return stringBuilder.toString();
    }

    protected boolean useAsBeforeAlias() {
        return false;
    }

    @Override
    public String getUsableAlias() {
        String string = this.getAlias();
        if (string == null && !(this.getExpression() instanceof JoinObject) && !this.canUseAsAlias(string = this.getName())) {
            string = null;
        }
        return string;
    }

    @Override
    @Internal
    public String getName() {
        String string = super.getName();
        if (string == null) {
            String string2 = this.getAlias();
            if (ModelUtil.hasLength((String)string2)) {
                string = string2;
            } else {
                SQLFragment sQLFragment = this.getExpression();
                if (sQLFragment != null) {
                    string = sQLFragment.getSQLText();
                }
            }
        }
        return string;
    }

    protected boolean canUseAsAlias(String string) {
        return string.indexOf(" ") <= -1;
    }

    @Override
    public String toString() {
        Object object;
        SQLFragment sQLFragment = this.getExpression();
        String string = this.getAlias();
        Object object2 = object = sQLFragment == null ? null : sQLFragment.toString();
        if (ModelUtil.hasLength((String)string)) {
            object = string + " (" + (String)object + ")";
        }
        return object;
    }
}

