/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Arrays;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class DataMiningFunction
extends Operation {
    public DataMiningFunction() {
        this(null, null, false, null, null);
    }

    @Deprecated
    public DataMiningFunction(String string, SQLFragment sQLFragment, boolean bl, SQLFragment[] sQLFragmentArray, SQLFragment[] sQLFragmentArray2) {
        super(sQLFragmentArray2);
        this.setFunctionFormat(true);
        this.setFunction(string);
        this.setModel(sQLFragment);
        this.setCostModel(bl);
        this.setDmSpecificArgs(sQLFragmentArray);
    }

    public DataMiningFunction(String string, SQLFragment sQLFragment, SQLFragment[] sQLFragmentArray, SQLFragment[] sQLFragmentArray2, SQLFragment[] sQLFragmentArray3) {
        super(sQLFragmentArray3);
        this.setFunctionFormat(true);
        this.setFunction(string);
        this.setModel(sQLFragment);
        if (sQLFragmentArray != null) {
            if (sQLFragmentArray.length == 1) {
                SQLFragment sQLFragment2 = sQLFragmentArray[0];
                this.setCostModel(true);
                if ("AUTO".equalsIgnoreCase(sQLFragment2.getSQLText())) {
                    this.setCostModelAuto(true);
                }
            } else {
                this.setDmCostValues(sQLFragmentArray);
            }
        }
        this.setDmSpecificArgs(sQLFragmentArray2);
    }

    public String getFunction() {
        return (String)this.getProperty("function");
    }

    public void setFunction(String string) {
        this.setProperty("function", string);
    }

    public boolean getCostModel() {
        return (Boolean)this.getProperty("costModel", false);
    }

    public void setCostModel(boolean bl) {
        this.setProperty("costModel", bl);
    }

    public boolean getCostModelAuto() {
        return (Boolean)this.getProperty("costModelAuto", false);
    }

    public void setCostModelAuto(boolean bl) {
        this.setProperty("costModelAuto", bl);
    }

    public SQLFragment getModel() {
        return (SQLFragment)this.getProperty("model");
    }

    public void setModel(SQLFragment sQLFragment) {
        this.setProperty("model", sQLFragment);
    }

    @Deprecated
    @Transient
    public DataMiningArguments getDataMiningArguments() {
        return new DataMiningArguments(this.getDmSpecificArgs());
    }

    @Deprecated
    public void setDataMiningArguments(DataMiningArguments dataMiningArguments) {
        this.setDmSpecificArgs(dataMiningArguments == null ? null : dataMiningArguments.getArguments());
    }

    @Override
    protected String getOperatorText() {
        return this.getFunction();
    }

    private boolean isSymbolFunction(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isLetterOrDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public SQLFragment[] getDmCostValues() {
        return this.getChildSupport("dmCostValues").getChildArray(SQLFragment.class);
    }

    public void setDmCostValues(SQLFragment[] sQLFragmentArray) {
        this.getChildSupport("dmCostValues").setChildArray(sQLFragmentArray);
    }

    public SQLFragment[] getDmSpecificArgs() {
        return this.getChildSupport("dmSpecificArgs").getChildArray(SQLFragment.class);
    }

    public void setDmSpecificArgs(SQLFragment[] sQLFragmentArray) {
        this.getChildSupport("dmSpecificArgs").setChildArray(sQLFragmentArray);
    }

    @Override
    public String getSQLText() {
        String string = this.getSeparator();
        StringBuilder stringBuilder = new StringBuilder(this.getOperatorText() + "( ");
        SQLFragment sQLFragment = this.getModel();
        stringBuilder.append(this.getTextOrNull(sQLFragment));
        String string2 = this.argsToString(this.getChildSupport("dmSpecificArgs").getChildList(false), false, this.getSeparator(), 0);
        if (ModelUtil.hasLength((String)string2)) {
            stringBuilder.append(string + " ").append(string2);
        }
        if (this.getCostModel()) {
            stringBuilder.append(" COST MODEL ");
            if (this.getCostModelAuto()) {
                stringBuilder.append("AUTO ");
            }
        } else {
            SQLFragment[] sQLFragmentArray = this.getDmCostValues();
            if (sQLFragmentArray != null && sQLFragmentArray.length > 0) {
                String string3 = sQLFragmentArray[0].getSQLText();
                stringBuilder.append(" COST ").append(string3);
                stringBuilder.append(" VALUES ( ");
                for (int i = 1; i < sQLFragmentArray.length; ++i) {
                    if (i > 1) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(sQLFragmentArray[i].getSQLText());
                }
                stringBuilder.append(" ) ");
            }
        }
        stringBuilder.append(" USING ");
        stringBuilder.append(this.argsToString(Arrays.asList(this.getArguments()), false, string, 0));
        stringBuilder.append(" )");
        return stringBuilder.toString();
    }

    @Deprecated
    public static class DataMiningArguments
    extends AbstractSQLFragment {
        public DataMiningArguments() {
        }

        public DataMiningArguments(SQLFragment[] sQLFragmentArray) {
            this.setArguments(sQLFragmentArray);
        }

        public SQLFragment[] getArguments() {
            return this.getChildSupport("arguments").getChildArray(SQLFragment.class);
        }

        public void setArguments(SQLFragment[] sQLFragmentArray) {
            this.getChildSupport("arguments").setChildArray(sQLFragmentArray);
        }

        private DataMiningFunction getDMFunction() {
            return (DataMiningFunction)this.getParent();
        }

        @Override
        public String getSQLText() {
            DataMiningFunction dataMiningFunction = this.getDMFunction();
            if (dataMiningFunction != null) {
                return dataMiningFunction.argsToString(this.getChildSupport("arguments").getChildList(false), false, dataMiningFunction.getSeparator(), 0);
            }
            return null;
        }
    }

    public static class DataMiningCostValues
    extends AbstractSQLFragment {
        public DataMiningCostValues() {
        }

        public DataMiningCostValues(SQLFragment[] sQLFragmentArray) {
            this.setArguments(sQLFragmentArray);
        }

        public SQLFragment[] getArguments() {
            return this.getChildSupport("arguments").getChildArray(SQLFragment.class);
        }

        public void setArguments(SQLFragment[] sQLFragmentArray) {
            this.getChildSupport("arguments").setChildArray(sQLFragmentArray);
        }

        @Override
        public String getSQLText() {
            return "( " + this.argsToString(this.getChildSupport("arguments").getChildList(false), false, ",", 0) + " )";
        }
    }
}

