/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Schema;
import oracle.javatools.db.property.DerivedPropertyBuilder;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;

public abstract class SQLQueryBuilderFactory {
    public final SQLQueryBuilder createSQLQueryBuilder(DBObjectProvider dBObjectProvider) {
        return this.createBuilderImpl(dBObjectProvider, SQLQueryBuilderFactory.checkDefaultSchema(dBObjectProvider, null));
    }

    public final SQLQueryBuilder createSQLQueryBuilder(DBObjectProvider dBObjectProvider, Schema schema) {
        schema = SQLQueryBuilderFactory.checkDefaultSchema(dBObjectProvider, schema);
        return this.createBuilderImpl(dBObjectProvider, schema);
    }

    protected abstract SQLQueryBuilder createBuilderImpl(DBObjectProvider var1, Schema var2);

    public static SQLQueryBuilder createBuilder(DBObjectProvider dBObjectProvider) {
        return SQLQueryBuilderFactory.createBuilder(dBObjectProvider, null);
    }

    public static SQLQueryBuilder createBuilder(DBObjectProvider dBObjectProvider, Schema schema) {
        DatabaseDescriptor databaseDescriptor = dBObjectProvider.getDescriptor();
        SQLQueryBuilderFactory sQLQueryBuilderFactory = databaseDescriptor.getSQLQueryBuilderFactory();
        if (sQLQueryBuilderFactory != null) {
            return sQLQueryBuilderFactory.createSQLQueryBuilder(dBObjectProvider, schema);
        }
        return null;
    }

    private static Schema checkDefaultSchema(DBObjectProvider dBObjectProvider, DBObject dBObject) {
        Schema schema = null;
        schema = dBObject instanceof Schema ? (Schema)dBObject : DBUtil.getSchema(dBObject);
        if (schema == null && dBObjectProvider != null) {
            try {
                schema = dBObjectProvider.getDefaultSchema();
            }
            catch (DBException dBException) {
                DBLog.getLogger(SQLQueryBuilderFactory.class).warning("Cannot get default schema for sql query building: " + dBException.getMessage());
            }
        }
        return schema;
    }

    public static SQLQueryBuilder findOrCreateBuilder(SQLQuery sQLQuery, DBObjectProvider dBObjectProvider) {
        return SQLQueryBuilderFactory.findOrCreateBuilder(sQLQuery, dBObjectProvider, SQLQueryBuilderFactory.checkDefaultSchema(dBObjectProvider, sQLQuery));
    }

    public static SQLQueryBuilder findOrCreateBuilder(SQLQuery sQLQuery, DBObjectProvider dBObjectProvider, Schema schema) {
        SQLQueryBuilder sQLQueryBuilder = null;
        DerivedPropertyBuilder derivedPropertyBuilder = dBObjectProvider.getObjectFactory().ensureDerivedPropertyBuilder(sQLQuery, false);
        if (derivedPropertyBuilder instanceof SQLQueryBuilder) {
            sQLQueryBuilder = (SQLQueryBuilder)((Object)derivedPropertyBuilder);
            if (derivedPropertyBuilder instanceof AbstractSQLQueryBuilder) {
                ((AbstractSQLQueryBuilder)derivedPropertyBuilder).setSQLQuery(sQLQuery);
                if (schema != null) {
                    ((AbstractSQLQueryBuilder)derivedPropertyBuilder).setDefaultSchema(schema);
                }
            }
        } else if (derivedPropertyBuilder != null) {
            throw new IllegalStateException("Derived property builder for a query should be a SQLQueryBuilder.");
        }
        return sQLQueryBuilder;
    }

    public static SQLQueryBuilder createBuilder(DBObjectProvider dBObjectProvider, Schema schema, String string) throws SQLQueryException {
        SQLQueryBuilder sQLQueryBuilder = SQLQueryBuilderFactory.createBuilder(dBObjectProvider, schema);
        sQLQueryBuilder.buildQuery(string);
        return sQLQueryBuilder;
    }
}

