/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.cloud.ui.backendDelegation;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.migration.cloud.CloudMigrationsResources;
import oracle.dbtools.migration.cloud.ui.backendDelegation.BackendDelegatorRaptorTask;
import oracle.dbtools.migration.cloud.ui.log.LogManager;
import oracle.dbtools.migration.cloud.ui.model.CloudMigrationModel;
import oracle.dbtools.migration.cloud.ui.preferences.CloudMigrationOptions;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.ide.Ide;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.DeployableTextNode;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;

public class BackendDelegator {
    private static final boolean DEBUG = true;
    private static final String REDACTED_STRING = "********";
    private Logger backendDelegatorLogger = Logger.getLogger(BackendDelegator.class.getName());
    private CloudMigrationModel uiModel = null;
    private HashMap<String, Object> preferenceHashmap = null;

    public BackendDelegator(CloudMigrationModel cloudMigrationModel) {
        this.uiModel = cloudMigrationModel;
        if (this.uiModel == null) {
            this.uiModel = CloudMigrationModel.getInstance();
        }
    }

    public String getRedShiftDatabase() {
        return this.uiModel.getString("REDSHIFT_DATABASE_KEY");
    }

    public String getRedShiftDatabaseDisplayName() {
        return this.uiModel.getString("REDSHIFT_DATABASE_DISPLAY_NAME_KEY");
    }

    public String getTargetDatabase() {
        return this.uiModel.getString("DWCS_DATABASE_KEY");
    }

    public String getTargetDatabaseDisplayName() {
        return this.uiModel.getString("DWCS_DATABASE_DISPLAY_NAME_KEY");
    }

    public String getMigrationType() {
        return this.uiModel.getString("REDSHIFT_MIGRATION_TYPE_KEY");
    }

    public String getAWSAccessKey() {
        return this.uiModel.getString("REDSHIFT_AWS_ACCESS_TYPE_KEY");
    }

    public String getAWSSecureAccess() {
        return this.uiModel.getString("REDSHIFT_AWS_SECRET_ACCESS_TYPE_KEY");
    }

    public String getS3Bucket() {
        return this.uiModel.getString("REDSHIFT_S3_BUCKET_KEY");
    }

    private String getScriptsInDirectory() {
        return this.uiModel.getString("SCRIPT_DOWNLOAD_DIRECTORY_KEY");
    }

    private Boolean getMigrationNow() {
        return this.uiModel.getBoolean("REDSHIFT_MIGRATION_DO_NOW_KEY");
    }

    private Boolean isDropMigrationRepository() {
        return this.uiModel.getBoolean("DWCS_DROP_MIGRATION_REPOSITORY_KEY");
    }

    private String getMigrationRepositoryPassword() {
        if (this.uiModel.getBoolean("DWCS_SHOW_MIGRATION_REPOSITORY_REDACTED_PASSWORD_KEY").booleanValue()) {
            return REDACTED_STRING;
        }
        return this.uiModel.getString("MIGRATION_REPOSITORY_PASSWORD_KEY");
    }

    public String[] getAvailableSchemas() {
        String[] stringArray = this.uiModel.getAvailableSchemas();
        return stringArray;
    }

    public String[] getSelectedSchemas() {
        String[] stringArray = this.uiModel.getSelectedSchemas();
        return stringArray;
    }

    public String[] getPreviouslyDeployedSchemas() {
        String[] stringArray = this.uiModel.getPreviouslyDeployedSchemas();
        return stringArray;
    }

    public String[] getNewDeployableSchemas() {
        String[] stringArray = this.uiModel.getNewDeployableSchemas();
        return stringArray;
    }

    public void startBackendThread2() {
        this.backendDelegatorLogger.info("startBackendThread2 ...  ");
        this.traceFlow("startBackendThread2 ...#2");
        this.createPreferenceHashmap();
        BackendDelegatorRaptorTask backendDelegatorRaptorTask = new BackendDelegatorRaptorTask("RedshiftMigrationTask", this.getRedShiftDatabase(), this.getTargetDatabase(), this.getAWSAccessKey(), this.getAWSSecureAccess(), this.getS3Bucket(), this.getSelectedSchemas(), this.getAvailableSchemas(), this.getMigrationType(), this.getMigrationNow(), this.getScriptsInDirectory(), this.preferenceHashmap, this.getRedShiftDatabaseDisplayName(), this.getTargetDatabaseDisplayName(), this.isDropMigrationRepository(), this.getMigrationRepositoryPassword(), this.getPreviouslyDeployedSchemas(), this.getNewDeployableSchemas());
        backendDelegatorRaptorTask.getDescriptor().addListener((IRaptorTaskListener)new BackendDelegatorTaskAdaptor());
        this.backendDelegatorLogger.info("startBackendThread2 ...#2");
        this.traceFlow("startBackendThread2 ...#2");
        RaptorTaskManager.getInstance().addTask((RaptorTask)backendDelegatorRaptorTask);
    }

    private void traceFlow(String string) {
        this.backendDelegatorLogger.info("[DEBUG]:" + string);
    }

    protected static void openTextNodeForURL(URL uRL) throws Exception {
        final DeployableTextNode deployableTextNode = (DeployableTextNode)NodeFactory.findOrCreate(DeployableTextNode.class, (URL)uRL);
        if (deployableTextNode != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            EditorUtil.openDefaultEditorInFrame((Node)deployableTextNode);
                        }
                    });
                }
            });
        }
    }

    public void createPreferenceHashmap() {
        this.preferenceHashmap = new HashMap();
        CloudMigrationOptions cloudMigrationOptions = CloudMigrationOptions.getInstance();
        Object object = cloudMigrationOptions.getValue("ARS.OVERWRITE");
        if (object instanceof Boolean) {
            object = new Boolean((Boolean)object);
        } else if (object instanceof String) {
            object = Boolean.valueOf((String)object);
        }
        this.preferenceHashmap.put("ARS.OVERWRITE", object);
        Object object2 = cloudMigrationOptions.getValue("CPD.REJLIM");
        if (object2 instanceof String) {
            object2 = Integer.valueOf((String)object2);
        }
        this.preferenceHashmap.put("CPD.REJLIM", object2);
        this.preferenceHashmap.put("REDSHIFT_MIGRATION_DIR", cloudMigrationOptions.getValue("REDSHIFT_MIGRATION_DIR"));
        Object object3 = cloudMigrationOptions.getValue("MAX_NUMBER_THREADS");
        if (object3 instanceof String) {
            object3 = Integer.valueOf((String)object3);
        }
        this.preferenceHashmap.put("MAX_NUMBER_THREADS", object3);
        Object object4 = cloudMigrationOptions.getValue("USE_DBMS_SCHEDULER");
        if (object4 instanceof Boolean) {
            object4 = new Boolean((Boolean)object4);
        } else if (object4 instanceof String) {
            object4 = Boolean.valueOf((String)object4);
        }
        this.preferenceHashmap.put("USE_DBMS_SCHEDULER", object4);
        String string = CloudMigrationOptions.getDateToDeployType();
        this.preferenceHashmap.put("DATE_TO_DEPLOY_TYPE", string);
        String string2 = CloudMigrationOptions.getDateToDeployTimeZone();
        this.preferenceHashmap.put("DATE_TO_DEPLOY_TIME_ZONE", string2);
        long l = CloudMigrationOptions.getDateToDeploy();
        this.preferenceHashmap.put("DATE_TO_DEPLOY", l);
        String string3 = CloudMigrationOptions.getFormattedDateToDeploy();
        this.preferenceHashmap.put("FORMATTED_DATE_TO_DEPLOY", string3);
    }

    protected String nls(String string) {
        return CloudMigrationsResources.get(string);
    }

    public String nls(String string, Object ... objectArray) {
        return CloudMigrationsResources.format(string, objectArray);
    }

    class BackendDelegatorTaskAdaptor
    extends RaptorTaskAdapter {
        private static final boolean DEBUG = true;
        private LogManager logManager;

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            super.taskFailed(raptorTaskEvent);
            BackendDelegator.this.backendDelegatorLogger.info("taskFailed");
            BackendDelegator.this.traceFlow("TaskFailed");
            String string = raptorTaskEvent.getTaskDescriptor().getStatus().value();
            BackendDelegator.this.traceFlow("TaskFailed.Status=" + string);
            final String string2 = raptorTaskEvent.getThrowable().getMessage();
            raptorTaskEvent.getThrowable().printStackTrace();
            BackendDelegator.this.traceFlow("[taskFailed].eventMessage=" + string2);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, string2);
            this.logManager = LogManager.getInstance();
            LogManager.nextLineNumber();
            this.logManager.printLineNumber();
            this.logManager.logStringWithComments(BackendDelegator.this.nls("TASK_FAILED"), string2);
            try {
                this.logManager.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (string2.startsWith("ORA-01920")) {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)(BackendDelegator.this.nls("REDSHIFT_MIGRATION_FAILED") + " " + BackendDelegatorTaskAdaptor.this.overwriteErrorORAO01920()), (String)BackendDelegator.this.nls("REDSHIFT_MIGRATION_STATUS_TITLE"), null);
                        } else {
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)(BackendDelegator.this.nls("REDSHIFT_MIGRATION_FAILED") + " " + string2), (String)BackendDelegator.this.nls("REDSHIFT_MIGRATION_STATUS_TITLE"), null);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }
            });
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            super.taskCancelled(raptorTaskEvent);
            BackendDelegator.this.traceFlow("taskCancelled");
            this.logManager = LogManager.getInstance();
            try {
                this.logManager.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, iOException.getStackTrace()[0].toString(), iOException);
            }
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            super.taskFinished(raptorTaskEvent);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        BackendDelegator.this.traceFlow("taskFinished");
                        BackendDelegatorTaskAdaptor.this.logManager = LogManager.getInstance();
                        Path path = BackendDelegatorTaskAdaptor.this.logManager.getLogFilePath();
                        String string = path.toString();
                        BackendDelegator.this.traceFlow("logFile=" + string);
                        BackendDelegator.openTextNodeForURL(path.toUri().toURL());
                        BackendDelegatorTaskAdaptor.this.logManager.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }
            });
        }

        private String overwriteErrorORAO01920() {
            String[] stringArray = BackendDelegator.this.getSelectedSchemas();
            Object object = "";
            for (int i = 0; i < stringArray.length - 1; ++i) {
                object = (String)object + stringArray[i] + ", ";
            }
            object = (String)object + stringArray[stringArray.length - 1];
            return BackendDelegator.this.nls("ERROR_SCHEMA_ALREADY_EXISTS", object);
        }
    }
}

