/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.AttributeTypeAndValue;
import oracle.security.crypto.cert.AttributeTypeAndValueList;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.cmp.CertTemplate;
import oracle.security.crypto.cmp.attribute.PKIArchiveOptionRegControl;
import oracle.security.crypto.cmp.attribute.RegistrationControl;
import oracle.security.crypto.util.OIDManager;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableInputException;
import oracle.security.crypto.util.Utils;

public class CertRequest
implements ASN1Object {
    private BigInteger certReqID;
    private CertTemplate certTemp;
    private AttributeTypeAndValueList controls;
    private transient ASN1Object contents;

    public CertRequest(CertTemplate certTemp, BigInteger certReqID) {
        this.certTemp = certTemp;
        this.certReqID = certReqID;
    }

    public CertRequest(InputStream is) throws IOException {
        this.input(is);
    }

    public BigInteger getCertReqID() {
        return this.certReqID;
    }

    public CertTemplate getCertTemplate() {
        return this.certTemp;
    }

    public void addRegControl(RegistrationControl rc) {
        if (this.controls == null) {
            this.controls = new AttributeTypeAndValueList();
        }
        this.controls.addAttribute((AttributeTypeAndValue)rc);
        this.update();
    }

    public void addRegControl(ASN1ObjectID type, ASN1Object value) {
        RegistrationControl ctrl = null;
        if (type.equals((Object)CMP.id_regCtrl_pkiArchiveOptions)) {
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)type);
            s.addElement(value);
            try {
                ctrl = PKIArchiveOptionRegControl.inputArchiveOption(Utils.toStream((Streamable)s));
            }
            catch (IOException ex) {
                throw new StreamableInputException(ex.toString());
            }
        }
        Class c = OIDManager.getOIDManager().getMapping(type, "registrationControl");
        if (c != null) {
            try {
                ctrl = (RegistrationControl)((Object)c.newInstance());
                ctrl.setValue(value);
            }
            catch (IllegalAccessException ex) {
                ctrl = null;
            }
            catch (InstantiationException ex) {
                ctrl = null;
            }
            catch (ClassCastException ex) {
                ctrl = null;
            }
        }
        if (ctrl == null) {
            ctrl = new RegistrationControl(type, value);
        }
        this.addRegControl(ctrl);
    }

    public AttributeTypeAndValueList getRegControls() {
        return this.controls;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("{ certReqId = " + this.certReqID);
        s.append(", certTemplate = " + this.certTemp);
        if (this.controls != null) {
            s.append(", controls = " + this.controls);
        }
        s.append(" }");
        return s.toString();
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        this.certReqID = ASN1Integer.inputValue((InputStream)sis);
        this.certTemp = new CertTemplate((InputStream)sis);
        if (sis.hasMoreData()) {
            this.controls = new AttributeTypeAndValueList();
            ASN1SequenceInputStream sisControls = new ASN1SequenceInputStream((InputStream)sis);
            while (sisControls.hasMoreData()) {
                this.controls.addAttribute((AttributeTypeAndValue)RegistrationControl.inputInstance((InputStream)sisControls));
            }
            sisControls.terminate();
        } else {
            this.controls = null;
        }
        sis.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            ASN1Sequence seq = new ASN1Sequence();
            seq.addElement((ASN1Object)new ASN1Integer(this.certReqID));
            seq.addElement((ASN1Object)this.certTemp);
            if (this.controls != null && this.controls.size() > 0) {
                seq.addElement((ASN1Object)this.controls);
            }
            this.contents = seq;
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
    }
}

