/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1String;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class PKIStatusInfo
implements ASN1Object {
    private Status status;
    private Vector statusText;
    private boolean[] failInfo;
    private int failCount;
    private ASN1Object contents;

    public PKIStatusInfo() {
    }

    public PKIStatusInfo(Status status) {
        this.status = status;
    }

    public PKIStatusInfo(Status status, String text) {
        this.status = status;
        this.addStatusText(text);
    }

    public PKIStatusInfo(Status status, Failure failure) {
        this.status = status;
        this.addFailure(failure);
    }

    public PKIStatusInfo(Status status, String text, Failure failure) {
        this.status = status;
        this.addStatusText(text);
        this.addFailure(failure);
    }

    public PKIStatusInfo(InputStream is) throws IOException {
        this.input(is);
    }

    public Status getStatus() {
        return this.status;
    }

    public void addStatusText(String text) {
        if (this.statusText == null) {
            this.statusText = new Vector();
        }
        this.statusText.addElement(text);
        this.update();
    }

    public String getStatusText() {
        return this.statusText != null ? (String)this.statusText.elementAt(0) : null;
    }

    public Vector getStatusTexts() {
        return this.statusText;
    }

    public void addFailure(Failure failure) {
        if (this.failInfo == null || this.failInfo.length < Failure.LIST.length) {
            boolean[] newFailInfo = new boolean[Failure.LIST.length];
            if (this.failInfo != null) {
                System.arraycopy(this.failInfo, 0, newFailInfo, 0, this.failInfo.length);
            }
            this.failInfo = newFailInfo;
        }
        this.failInfo[failure.getValue()] = true;
        ++this.failCount;
        this.update();
    }

    public void addFailures(Failure[] failures) {
        if (this.failInfo == null || this.failInfo.length < Failure.LIST.length) {
            boolean[] newFailInfo = new boolean[Failure.LIST.length];
            if (this.failInfo != null) {
                System.arraycopy(this.failInfo, 0, newFailInfo, 0, this.failInfo.length);
            }
            this.failInfo = newFailInfo;
        }
        for (int i = 0; i < failures.length; ++i) {
            this.failInfo[failures[i].getValue()] = true;
        }
        this.failCount += failures.length;
        this.update();
    }

    public boolean hasFailure(Failure failure) {
        int i = failure.getValue();
        return this.failInfo != null && i < this.failInfo.length ? this.failInfo[i] : false;
    }

    public Failure[] getFailures() {
        if (this.failInfo == null || this.failCount == 0) {
            return null;
        }
        Failure[] failures = new Failure[this.failCount];
        int n = 0;
        for (int i = 0; i < this.failInfo.length; ++i) {
            if (!this.failInfo[i]) continue;
            failures[n++] = Failure.LIST[i];
        }
        return failures;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("{ status = " + this.status);
        if (this.statusText != null) {
            s.append(", statusText = " + Utils.toString((Vector)this.statusText));
        }
        if (this.failInfo != null && this.failCount > 0) {
            s.append(", failInfo = { ");
            Failure[] f = this.getFailures();
            for (int i = 0; i < f.length; ++i) {
                if (f[i] != null) {
                    s.append(f[i].toString());
                }
                if (i == f.length - 1) continue;
                s.append(", ");
            }
            s.append(" }");
        }
        s.append(" }");
        return s.toString();
    }

    public boolean equals(Object o) {
        int i;
        if (o == null || !(o instanceof PKIStatusInfo)) {
            return false;
        }
        PKIStatusInfo s = (PKIStatusInfo)o;
        if (this.status != s.status) {
            return false;
        }
        if (this.statusText == null && s.statusText != null) {
            return false;
        }
        if (this.statusText != null && !this.statusText.equals(s.statusText)) {
            return false;
        }
        if (this.failInfo == s.failInfo) {
            return true;
        }
        if (this.failInfo == null || s.failInfo == null) {
            return false;
        }
        int size = Math.min(this.failInfo.length, s.failInfo.length);
        for (i = 0; i < size; ++i) {
            if (this.failInfo[i] == s.failInfo[i]) continue;
            return false;
        }
        if (this.failInfo.length > s.failInfo.length) {
            for (i = s.failInfo.length; i < this.failInfo.length; ++i) {
                if (!this.failInfo[i]) continue;
                return false;
            }
        } else {
            for (i = this.failInfo.length; i < s.failInfo.length; ++i) {
                if (!s.failInfo[i]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void input(InputStream is) throws IOException {
        this.update();
        this.contents = new ASN1Sequence(is);
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(Utils.toStream((Streamable)this.contents));
        int s = ASN1Integer.inputValue((InputStream)sis).intValue();
        try {
            this.status = Status.LIST[s];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new ASN1FormatException("Unknown CMP status code: " + s);
        }
        if (sis.hasMoreData() && sis.getCurrentTag() == 16) {
            ASN1SequenceInputStream tis = new ASN1SequenceInputStream((InputStream)sis);
            if (this.statusText == null) {
                this.statusText = new Vector();
            } else {
                this.statusText.removeAllElements();
            }
            while (tis.hasMoreData()) {
                this.statusText.addElement(ASN1String.inputValue((InputStream)tis));
            }
            tis.terminate();
        } else {
            this.statusText = null;
        }
        if (sis.hasMoreData() && sis.getCurrentTag() == 3) {
            int i;
            ASN1BitString b = new ASN1BitString((InputStream)sis);
            this.failInfo = new boolean[b.bitLength()];
            try {
                for (i = 0; i < this.failInfo.length; ++i) {
                    this.failInfo[i] = b.testBit(i);
                    if (!this.failInfo[i]) continue;
                    ++this.failCount;
                }
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new ASN1FormatException("Unknown CMP failure code: " + i);
            }
        } else {
            this.failInfo = null;
            this.failCount = 0;
        }
        sis.terminate();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1().output(os);
    }

    public int length() {
        return this.toASN1().length();
    }

    private ASN1Object toASN1() {
        if (this.contents == null) {
            int i;
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)new ASN1Integer((long)this.status.getValue()));
            if (this.statusText != null) {
                ASN1Sequence t = new ASN1Sequence();
                int n = this.statusText.size();
                for (i = 0; i < n; ++i) {
                    t.addElement((ASN1Object)new ASN1String((String)this.statusText.elementAt(i), 12));
                }
                s.addElement((ASN1Object)t);
            }
            if (this.failInfo != null && this.failCount > 0) {
                ASN1BitString b = new ASN1BitString(this.failInfo.length);
                for (i = 0; i < this.failInfo.length; ++i) {
                    if (!this.failInfo[i]) continue;
                    b.setBit(i);
                }
                s.addElement((ASN1Object)b);
            }
            this.contents = s;
        }
        return this.contents;
    }

    private void update() {
        this.contents = null;
    }

    public static class Failure {
        public static final Failure BAD_ALG = new Failure(0);
        public static final Failure BAD_MESSAGE_CHECK = new Failure(1);
        public static final Failure BAD_REQUEST = new Failure(2);
        public static final Failure BAD_TIME = new Failure(3);
        public static final Failure BAD_CERT_ID = new Failure(4);
        public static final Failure BAD_DATA_FORMAT = new Failure(5);
        public static final Failure WRONG_AUTHORITY = new Failure(6);
        public static final Failure INCORRECT_DATA = new Failure(7);
        public static final Failure MISSING_TIME_STAMP = new Failure(8);
        public static final Failure BAD_POP = new Failure(9);
        public static final Failure CERT_REVOKED = new Failure(10);
        public static final Failure CERT_CONFIRMED = new Failure(11);
        public static final Failure WRONG_INTEGRITY = new Failure(12);
        public static final Failure BAD_RECIPIENT_NONCE = new Failure(13);
        public static final Failure TIME_NOT_AVAILABLE = new Failure(14);
        public static final Failure UNACCEPTED_POLICY = new Failure(15);
        public static final Failure UNACCEPTED_EXTENSION = new Failure(16);
        public static final Failure ADD_INFO_NOT_AVAILABLE = new Failure(17);
        public static final Failure BAD_SENDER_NONCE = new Failure(18);
        public static final Failure BAD_CERT_TEMPLATE = new Failure(19);
        public static final Failure SIGNER_NOT_TRUSTED = new Failure(20);
        public static final Failure TRANSACTION_ID_IN_USE = new Failure(21);
        public static final Failure UNSUPPORTED_VERSION = new Failure(22);
        public static final Failure NOT_AUTHORIZED = new Failure(23);
        public static final Failure SYSTEM_UNAVAILABLE = new Failure(24);
        public static final Failure SYSTEM_FAILURE = new Failure(25);
        public static final Failure DUPLICATE_CERT_REQ = new Failure(26);
        private static final Failure[] LIST = new Failure[]{BAD_ALG, BAD_MESSAGE_CHECK, BAD_REQUEST, BAD_TIME, BAD_CERT_ID, BAD_DATA_FORMAT, WRONG_AUTHORITY, INCORRECT_DATA, MISSING_TIME_STAMP, BAD_POP, CERT_REVOKED, CERT_CONFIRMED, WRONG_INTEGRITY, BAD_RECIPIENT_NONCE, TIME_NOT_AVAILABLE, UNACCEPTED_POLICY, UNACCEPTED_EXTENSION, ADD_INFO_NOT_AVAILABLE, BAD_SENDER_NONCE, BAD_CERT_TEMPLATE, SIGNER_NOT_TRUSTED, TRANSACTION_ID_IN_USE, UNSUPPORTED_VERSION, NOT_AUTHORIZED, SYSTEM_UNAVAILABLE, SYSTEM_FAILURE, DUPLICATE_CERT_REQ};
        private int value;

        private Failure(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this.value) {
                case 0: {
                    return "badAlg";
                }
                case 1: {
                    return "badMessageCheck";
                }
                case 2: {
                    return "badRequest";
                }
                case 3: {
                    return "badTime";
                }
                case 4: {
                    return "badCertId";
                }
                case 5: {
                    return "badDataFormat";
                }
                case 6: {
                    return "wrongAuthority";
                }
                case 7: {
                    return "incorrectData";
                }
                case 8: {
                    return "missingTimeStamp";
                }
                case 9: {
                    return "badPOP";
                }
                case 10: {
                    return "certRevoked";
                }
                case 11: {
                    return "certConfirmed";
                }
                case 12: {
                    return "wrongIntegrity";
                }
                case 13: {
                    return "badRecipientNonce";
                }
                case 14: {
                    return "timeNotAvailable";
                }
                case 15: {
                    return "unacceptedPolicy";
                }
                case 16: {
                    return "unacceptedExtension";
                }
                case 17: {
                    return "addInfoNotAvailable";
                }
                case 18: {
                    return "badSenderNonce";
                }
                case 19: {
                    return "badCertTemplate";
                }
                case 20: {
                    return "signerNotTrusted";
                }
                case 21: {
                    return "transactionIdInUse";
                }
                case 22: {
                    return "unsupportedVersion";
                }
                case 23: {
                    return "notAuthorized";
                }
                case 24: {
                    return "systemUnavail";
                }
                case 25: {
                    return "systemFailure";
                }
                case 26: {
                    return "duplicateCertReq";
                }
            }
            return "code " + this.value;
        }
    }

    public static class Status {
        public static final Status GRANTED = new Status(0);
        public static final Status GRANTED_WITH_MODS = new Status(1);
        public static final Status REJECTION = new Status(2);
        public static final Status WAITING = new Status(3);
        public static final Status REVOCATION_WARNING = new Status(4);
        public static final Status REVOCATION_NOTIFICATION = new Status(5);
        public static final Status KEY_UPDATE_WARNING = new Status(6);
        static final Status[] LIST = new Status[]{GRANTED, GRANTED_WITH_MODS, REJECTION, WAITING, REVOCATION_WARNING, REVOCATION_NOTIFICATION, KEY_UPDATE_WARNING};
        private int value;

        private Status(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this.value) {
                case 0: {
                    return "accepted";
                }
                case 1: {
                    return "grantedWithMods";
                }
                case 2: {
                    return "rejection";
                }
                case 3: {
                    return "waiting";
                }
                case 4: {
                    return "revocationWarning";
                }
                case 5: {
                    return "revocationNotification";
                }
                case 6: {
                    return "keyUpdateWarning";
                }
            }
            return "code " + this.value;
        }
    }
}

