/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cmp.attribute;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.AttributeTypeAndValue;
import oracle.security.crypto.cmp.CMP;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.OIDManager;

public class InfoTypeAndValue
extends AttributeTypeAndValue {
    private static final CMP.OIDRegistrar oidReg = new CMP.OIDRegistrar();
    private ASN1ObjectID type;
    private ASN1Object value;
    protected boolean encoded = false;
    protected boolean decoded = true;
    private ASN1Sequence contents;

    public InfoTypeAndValue() {
    }

    public InfoTypeAndValue(ASN1ObjectID type, ASN1Object value) {
        this.type = type;
        this.value = value;
        this.encoded = true;
        this.decoded = false;
    }

    public InfoTypeAndValue(ASN1ObjectID type) {
        this(type, null);
    }

    public InfoTypeAndValue(InputStream is) throws IOException {
        this.input(is);
    }

    public static InfoTypeAndValue inputInstance(InputStream is) throws IOException {
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        ASN1ObjectID type = new ASN1ObjectID((InputStream)sis);
        ASN1Object value = null;
        if (sis.hasMoreData()) {
            value = ASN1Utils.inputASN1Object((InputStream)sis);
        }
        sis.terminate();
        Class cl = OIDManager.getOIDManager().getMapping(type, "infoTypeAndValue");
        if (cl == null) {
            return new InfoTypeAndValue(type, value);
        }
        InfoTypeAndValue info = null;
        try {
            info = (InfoTypeAndValue)((Object)cl.newInstance());
            info.setValue(value);
        }
        catch (IllegalAccessException ex) {
            throw new IOException(ex.toString());
        }
        catch (InstantiationException ex) {
            throw new IOException(ex.toString());
        }
        catch (ClassCastException ex) {
            throw new IOException(ex.toString());
        }
        return info;
    }

    public ASN1ObjectID getType() {
        return this.type;
    }

    public ASN1Object getValue() {
        this.encodeValue();
        return this.value;
    }

    public void setValue(ASN1Object value) {
        this.value = value;
        this.encoded = true;
        this.decoded = false;
        this.update();
    }

    protected void encodeValue() {
        this.encoded = true;
    }

    protected void decodeValue() {
        this.decoded = true;
    }

    public String toString() {
        return "{ type = " + this.type + ", value = " + this.value + " }";
    }

    public void input(InputStream is) throws IOException {
        Class c;
        ASN1SequenceInputStream sis = new ASN1SequenceInputStream(is);
        this.type = new ASN1ObjectID((InputStream)sis);
        this.value = sis.hasMoreData() ? ASN1Utils.inputASN1Object((InputStream)sis) : null;
        sis.terminate();
        this.update();
        this.encoded = true;
        this.decoded = false;
        this.decodeValue();
        if (!((Object)((Object)this)).getClass().equals(InfoTypeAndValue.class) && (c = OIDManager.getOIDManager().getMapping(this.type, "infoTypeAndValue")) != null && !c.isAssignableFrom(((Object)((Object)this)).getClass())) {
            throw new InvalidInputException("InfoType " + this.type + " invalid for instance of " + ((Object)((Object)this)).getClass().getName());
        }
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private void update() {
        this.contents = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            this.encodeValue();
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)this.type);
            if (this.value != null) {
                s.addElement(this.value);
            }
            this.contents = s;
        }
        return this.contents;
    }
}

