/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.generator;

import java.sql.Connection;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.ext.ora.statement.AbstractOracleStatement;
import liquibase.ext.ora.statement.CreateInternalSxmlStatement;
import liquibase.ext.ora.statement.DropInternalSxmlStatement;
import liquibase.ext.ora.statement.LogOracleActionStatement;
import liquibase.ext.ora.statement.LogOracleSyncStatement;
import liquibase.ext.ora.statement.RunApexScriptStatement;
import liquibase.ext.ora.statement.RunInternalScriptStatement;
import liquibase.ext.ora.statement.RunOracleScriptStatement;
import liquibase.ext.ora.statement.RunOrdsScriptStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.structure.DatabaseObject;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.util.Service;

public class MetadataSqlGenerator {
    public static Sql[] getCreateSqlPlSql(AbstractOracleStatement statement, Database database) throws Exception {
        String outSql = null;
        StringBuilder sql = new StringBuilder();
        try {
            if (!("GRANT".equals(statement.getObjectType()) || "JOB".equals(statement.getObjectType()) || "COMMENT".equals(statement.getObjectType()) || statement.getSource().toUpperCase().substring(0, 15).contains("CREATE") || statement.getSource().toUpperCase().substring(0, 15).contains("ALTER"))) {
                sql.append("CREATE ");
                if (statement.getReplaceIfExists() != null && statement.getReplaceIfExists().booleanValue()) {
                    sql.append("OR REPLACE ");
                }
            }
            sql.append(statement.getSource());
            outSql = sql.toString();
            outSql = outSql.replace("%USER_NAME%", Scope.getCurrentScope().getDatabase().getDefaultSchemaName());
            outSql = outSql.replaceAll("END;/", "END;");
            outSql = outSql.replaceAll("\nALTER", "\n/ \nALTER");
            outSql = MetadataSqlGenerator.metadata_cleanup(statement, outSql, LbUtils.getContext());
            outSql = LbUtils.processSchema(outSql, statement.getOwnerName());
            while (outSql.trim().endsWith(";")) {
                outSql = outSql.substring(0, outSql.length() - 1);
            }
            if (SchemaGenerator.ddlChangeTypes.containsKey(statement.getObjectType()) && !outSql.trim().endsWith("/")) {
                outSql = outSql.concat(";");
            }
            if (outSql != null && !"".equals(outSql.trim())) {
                return new Sql[]{new UnparsedSql(LbUtils.processSchema(outSql, statement.getOwnerName()), new DatabaseObject[0])};
            }
            return new Sql[]{new UnparsedSql("-- object is the same nothing to do", new DatabaseObject[0])};
        }
        catch (Exception e) {
            LbUtils.log(e);
            throw e;
        }
    }

    public static Sql[] getCreateSqlSxml(AbstractOracleStatement stmt, Database database) throws Exception {
        String sql = null;
        try {
            Connection conn = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
            String oName = stmt.getObjectName();
            String oType = stmt.getObjectType();
            String destXml = stmt.getSource();
            String origSchema = stmt.getOwnerName();
            String source = stmt.getSource();
            if (!origSchema.equals("")) {
                source = source.replaceAll("%USER_NAME%", database.getDefaultSchemaName());
                stmt.setSource(source);
                destXml = destXml.replaceAll("%USER_NAME%", database.getDefaultSchemaName());
            }
            if (!"VIEW".equalsIgnoreCase(oType) && QueryUtils.doesObjectExist(conn, oName, oType, database.getDefaultSchemaName())) {
                String sourceXml = DbmsMetaUtils.getObjectFromDb(conn, stmt.getObjectType(), stmt.getObjectName());
                sql = DbmsMetaUtils.getAlterDdl(conn, sourceXml, destXml, stmt.getObjectType());
            } else {
                sql = DbmsMetaUtils.getDdlFromSxml(conn, destXml, stmt.getObjectType());
                sql = MetadataSqlGenerator.metadata_cleanup(stmt, sql, LbUtils.getContext());
            }
            if (sql == null || "".equals(sql)) {
                sql = "-- object is the same nothing to do";
            }
            if (!(stmt instanceof CreateInternalSxmlStatement || stmt instanceof DropInternalSxmlStatement || stmt instanceof LogOracleActionStatement || stmt instanceof LogOracleSyncStatement || stmt instanceof RunInternalScriptStatement)) {
                sql = LbUtils.processSchema(sql, stmt.getOwnerName());
            }
            return new Sql[]{new UnparsedSql(LiquibaseStringUtils.trimEndofSql(sql), new DatabaseObject[0])};
        }
        catch (Exception e) {
            LbUtils.log(e);
            return null;
        }
    }

    private static String getDrop(AbstractOracleStatement statement, Database database) {
        StringBuilder sql = new StringBuilder();
        sql.append("DROP ");
        if (SchemaGenerator.typeNameTransform.containsKey(statement.getObjectType())) {
            sql.append(SchemaGenerator.typeNameTransform.get(statement.getObjectType()) + " ");
        } else {
            sql.append(statement.getObjectType() + " ");
        }
        if (LbUtils.outputSchema()) {
            String schema = statement.getOwnerName();
            if (LbUtils.getParameter("default-schema-name") != null) {
                schema = LbUtils.getParameter("default-schema-name");
            }
            sql.append("\"" + schema + "\".");
        }
        sql.append("\"" + statement.getObjectName() + "\"");
        if ("TABLE".equals(statement.getObjectType())) {
            sql.append(" CASCADE CONSTRAINTS");
        }
        return sql.toString();
    }

    public static Sql[] getDropSqlPlSql(AbstractOracleStatement statement, Database database) throws Exception {
        String outSql = null;
        String oName = null;
        Connection conn = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
        StringBuilder sql = new StringBuilder();
        String action = null;
        if (statement instanceof RunOracleScriptStatement || statement instanceof RunApexScriptStatement || statement instanceof RunOrdsScriptStatement) {
            return null;
        }
        try {
            if (statement.getObjectName() != null && !"%OBJECT_NAME%".equals(statement.getObjectName())) {
                oName = Service.handleMixedCase((String)statement.getObjectName());
            }
            try {
                action = QueryUtils.getXmlFromActionsLog(conn, statement, database);
            }
            catch (Exception e) {
                LbUtils.log(e);
            }
            if (action == null || "".equals(action)) {
                if ("JOB".equals(statement.getObjectType())) {
                    String subType = QueryUtils.getSchedulerObjectType(oName, database);
                    if (subType != null) {
                        sql.append("BEGIN DBMS_SCHEDULER.drop_" + subType.toLowerCase() + " (" + subType.toLowerCase() + "_name => '" + oName + "' ,FORCE=>TRUE); end;");
                    }
                } else if ("COMMENT".equals(statement.getObjectType())) {
                    sql.append(LiquibaseStringUtils.trimEndofSql(statement.getSource().replaceAll("'.*'", "''")));
                } else if ("REFCONSTRAINT".equalsIgnoreCase(statement.getObjectType())) {
                    String dropsql = statement.getSource();
                    dropsql = dropsql.replaceAll("ADD", "DROP");
                    int loc = dropsql.indexOf("FOREIGN KEY");
                    sql.append(dropsql.substring(0, loc - 1));
                } else if ("GRANT".equalsIgnoreCase(statement.getObjectType())) {
                    String dropsql = statement.getSource();
                    dropsql = dropsql.replaceAll("GRANT", "REVOKE");
                    dropsql = dropsql.replaceAll("TO", "FROM");
                    sql.append(dropsql);
                } else {
                    sql.append(MetadataSqlGenerator.getDrop(statement, database));
                }
                outSql = LbUtils.processSchema(sql.toString(), statement.getOwnerName());
            } else if (!statement.getObjectType().equals("DB_LINK")) {
                if (statement.getReplaceIfExists().booleanValue()) {
                    action = action.replace("CREATE", "CREATE OR REPLACE");
                }
                action = MetadataSqlGenerator.metadata_cleanup(statement, action, LbUtils.getContext());
                sql.append(action);
                outSql = LbUtils.processSchema(sql.toString(), statement.getOwnerName());
            } else {
                outSql = null;
            }
            if (outSql == null || "null".equals(outSql)) {
                return new Sql[]{new UnparsedSql("-- object is the same nothing to do", new DatabaseObject[0])};
            }
            return new Sql[]{new UnparsedSql(outSql, new DatabaseObject[0])};
        }
        catch (Exception e) {
            LbUtils.log(e);
            return null;
        }
    }

    public static Sql[] getDropSqlSxml(AbstractOracleStatement statement, Database database) throws Exception {
        String sourceXml = null;
        String destXml = null;
        String outSql = null;
        Connection conn = ((JdbcConnection)database.getConnection()).getUnderlyingConnection();
        StringBuilder sql = new StringBuilder();
        try {
            String oType = statement.getObjectType();
            if ("MATERIALIZED_VIEW_LOG".equals(oType)) {
                String create = DbmsMetaUtils.getDdlFromSxml(conn, statement.getSource(), statement.getObjectType());
                String drop = create.replace("CREATE", "DROP");
                int loc = LiquibaseStringUtils.nthOccurrence(drop, '\"', 4);
                outSql = drop = drop.substring(0, loc + 1);
            } else {
                destXml = DbmsMetaUtils.getObjectFromDb(((JdbcConnection)database.getConnection()).getUnderlyingConnection(), statement.getObjectType(), statement.getObjectName());
                String logSxml = QueryUtils.getXmlFromActionsLog(conn, statement, database);
                if (logSxml == null || logSxml.trim().isEmpty()) {
                    sql.append(MetadataSqlGenerator.getDrop(statement, database));
                } else {
                    sourceXml = logSxml;
                    sql.append(DbmsMetaUtils.getAlterDdl(conn, destXml, sourceXml, statement.getObjectType()));
                }
                outSql = MetadataSqlGenerator.metadata_cleanup(statement, sql.toString(), LbUtils.getContext());
                outSql = LbUtils.processSchema(outSql, statement.getOwnerName());
            }
            if (outSql == null || "null".equals(outSql)) {
                return new Sql[]{new UnparsedSql("-- object is the same nothing to do", new DatabaseObject[0])};
            }
            return new Sql[]{new UnparsedSql(outSql, new DatabaseObject[0])};
        }
        catch (Exception e) {
            LbUtils.log(e);
            return null;
        }
    }

    private static String metadata_cleanup(AbstractOracleStatement stmt, String sql, ScriptRunnerContext ctx) {
        String fixed = sql;
        if (stmt.getObjectType().equals("TABLE")) {
            fixed = fixed.replaceAll(",\\s+\\);", ");\n");
            fixed = fixed.replaceAll("COMPRESS Y ENABLE", "COMPRESS ENABLE");
        }
        if (stmt.getObjectType().equals("DB_LINK")) {
            fixed = fixed.replace("VALUES ':1'", "\"<PASSWORD>\"");
        }
        boolean no_edition = false;
        Version ver = VersionTracker.getDbVersion((ConnectionIdentifier)DefaultConnectionIdentifier.createIdentifier((Connection)ctx.getCurrentConnection()));
        if (ver.compareTo(new Version("13")) < 0) {
            no_edition = true;
        }
        if (no_edition) {
            fixed = fixed.replace("EDITIONABLE ", "");
        }
        return fixed;
    }
}

