/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.util;

import java.sql.Clob;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import liquibase.exception.DatabaseException;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.raptor.liquibase.generator.SchemaGeneratorUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;
import oracle.jdbc.OraclePreparedStatement;

public class DbmsMetaUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAlterDdl(Connection conn, String source, String dest, String type) throws SQLException {
        String query = QueryUtils.getXMLQueries().getQuery("alterDdl", conn).getSql();
        Clob v_return = null;
        OraclePreparedStatement pstatement = null;
        ResultSet rs = null;
        try {
            pstatement = (OraclePreparedStatement)conn.prepareStatement(query);
            pstatement.setStringForClob(1, source);
            pstatement.setStringForClob(2, dest);
            pstatement.setString(3, type);
            try {
                rs = pstatement.executeQuery();
            }
            catch (SQLException e) {
                String string = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (pstatement != null) {
                    try {
                        pstatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                return string;
            }
            while (rs != null && rs.next()) {
                v_return = rs.getClob(1);
            }
            String string = v_return.getSubString(1L, (int)v_return.length());
            return string;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (pstatement != null) {
                try {
                    pstatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDdlFromSxml(Connection conn, String sxml, String type) throws SQLException {
        if (VersionTracker.checkVersion((ConnectionIdentifier)DefaultConnectionIdentifier.createIdentifier((Connection)conn), (Version)new Version("12.99.99"), (Version)new Version("0.0.0"))) {
            return DbmsMetaUtils.getDdlFromSxml11(conn, sxml, type);
        }
        String query = QueryUtils.getXMLQueries().getQuery("sxmlToDdlConvertFunction", conn).getSql();
        Clob holder = null;
        OraclePreparedStatement pstatement = null;
        ResultSet rs = null;
        try {
            pstatement = (OraclePreparedStatement)conn.prepareStatement(query);
            pstatement.setStringForClob(1, sxml.trim());
            pstatement.setString(2, type);
            pstatement.setInt(3, "ON".equals(LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("CONSTRAINTS")) ? 0 : 1);
            pstatement.setInt(4, "ON".equals(LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("REF_CONSTRAINTS")) ? 0 : 1);
            pstatement.setInt(5, "ON".equals(LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("OID")) ? 0 : 1);
            pstatement.setInt(6, "ON".equals(LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("STORAGE")) ? 0 : 1);
            pstatement.setInt(7, "ON".equals(LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("SEGMENT_ATTRIBUTES")) ? 0 : 1);
            pstatement.setInt(8, "ON".equals(LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("TABLESPACE")) ? 0 : 1);
            pstatement.setInt(9, "ON".equals(LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("PARTITIONING")) ? 0 : 1);
            String COLLATION = (String)LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("COLLATION_CLAUSE");
            pstatement.setString(10, COLLATION == null ? "NEVER" : COLLATION);
            try {
                rs = pstatement.executeQuery();
            }
            catch (SQLException e) {
                String string = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (pstatement != null) {
                    try {
                        pstatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                return string;
            }
            while (rs != null && rs.next()) {
                holder = rs.getClob(1);
            }
            if (holder == null || holder.length() == 0L) {
                String string = DbmsMetaUtils.getDdlFromSxmlOld(conn, sxml, type);
                return string;
            }
            String string = holder.getSubString(1L, (int)holder.length());
            return string;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (pstatement != null) {
                try {
                    pstatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static String getDdlFromSxml11(Connection conn, String sourceSxml, String oType) throws SQLException {
        boolean drop = false;
        StringBuilder sb = new StringBuilder();
        Statement stmt = null;
        try {
            if (!SchemaGeneratorUtils.doesCapturePackageExist(conn)) {
                SchemaGeneratorUtils.createCaptureObjects(conn);
                drop = true;
            }
            String sxmltoDdlQuery = "{? = call SQLCL_LB_CAPTURE.sxmlToDDL11(?, ?)}";
            Clob myClob = conn.createClob();
            myClob.setString(1L, sourceSxml);
            stmt = conn.prepareCall(sxmltoDdlQuery);
            stmt.registerOutParameter(1, JDBCType.CLOB);
            stmt.setClob(2, myClob);
            stmt.setString(3, oType);
            stmt.execute();
            Clob clob = stmt.getClob(1);
            if (clob != null) {
                sb.append(clob.getSubString(1L, (int)clob.length()));
            }
            if (drop) {
                SchemaGeneratorUtils.dropCaptureObjects(conn);
            }
            String string = sb.toString();
            return string;
        }
        catch (NoSuchMethodError e) {
            throw new SQLException(e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDdlFromSxmlOld(Connection conn, String sxml, String type) throws SQLException {
        String query = QueryUtils.getXMLQueries().getQuery("sxmlToDdlConvertProcedure", conn).getSql();
        Clob v_return = null;
        OraclePreparedStatement pstatement = null;
        ResultSet rs = null;
        try {
            pstatement = (OraclePreparedStatement)conn.prepareStatement(query);
            pstatement.setStringForClob(1, sxml);
            pstatement.setString(2, type);
            try {
                rs = pstatement.executeQuery();
            }
            catch (SQLException e) {
                LbUtils.log(e);
                String string = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (pstatement != null) {
                    try {
                        pstatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                return string;
            }
            while (rs != null && rs.next()) {
                v_return = rs.getClob(1);
            }
            String string = v_return.getSubString(1L, (int)v_return.length());
            return string;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (pstatement != null) {
                try {
                    pstatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static String getDDL(Connection conn, String oType, String oName) throws DatabaseException {
        PreparedStatement pstatement = null;
        ResultSet rs = null;
        String dropJob = null;
        Object result = null;
        try {
            String queryddl;
            if ("PUBLIC_SYNONYM".equals(oType)) {
                queryddl = QueryUtils.getXMLQueries().getQuery("queryddlPublic", conn).getSql();
                pstatement = conn.prepareStatement(queryddl);
                oType = "SYNONYM";
                pstatement.setString(3, "PUBLIC");
            } else if ("JOB".equals(oType)) {
                queryddl = QueryUtils.getXMLQueries().getQuery("queryddlJob", conn).getSql();
                pstatement = conn.prepareStatement(queryddl);
                oType = "PROCOBJ";
                dropJob = "declare \n  jobs number;\nbegin\nselect count(1) into jobs from all_scheduler_jobs where owner = user and job_name = '" + oName + "';\nif jobs > 0 then\n    dbms_scheduler.drop_job(job_name => '" + oName + "');\nend if;\n";
            } else if ("PUBLIC_DB_LINK".equals(oType)) {
                queryddl = QueryUtils.getXMLQueries().getQuery("queryddlPublic", conn).getSql();
                pstatement = conn.prepareStatement(queryddl);
                oType = "DB_LINK";
                pstatement.setString(3, "PUBLIC");
            } else {
                queryddl = QueryUtils.getXMLQueries().getQuery("queryddl", conn).getSql();
                pstatement = conn.prepareStatement(queryddl);
            }
            pstatement.setString(1, oType);
            pstatement.setString(2, oName);
            try {
                rs = pstatement.executeQuery();
            }
            catch (SQLException e) {
                return null;
            }
            while (rs != null && rs.next()) {
                result = rs.getString(1);
            }
        }
        catch (Exception e) {
            if ("JOB".equalsIgnoreCase(oType)) {
                String trimmed = ((String)result).trim().substring(6);
                String full = dropJob + trimmed;
                result = full;
            }
            return LiquibaseStringUtils.ltrim((String)result);
        }
        return result;
    }

    public static String getObjectFromDb(Connection conn, String oType, String oName) throws DatabaseException {
        String trimmed;
        String objectType = oType.toUpperCase();
        String objectName = oName;
        Statement pstatement = null;
        ResultSet rs = null;
        Object result = null;
        String dropJob = null;
        try {
            String queryddl;
            if (DbmsMetaUtils.isSxmlType(objectType)) {
                String querysxml = QueryUtils.getXMLQueries().getQuery("querysxml", conn).getSql();
                pstatement = conn.prepareStatement(querysxml);
            } else if ("PUBLIC_SYNONYM".equals(objectType)) {
                queryddl = QueryUtils.getXMLQueries().getQuery("queryddlPublic", conn).getSql();
                pstatement = conn.prepareStatement(queryddl);
                objectType = "SYNONYM";
                pstatement.setString(3, "PUBLIC");
            } else if ("JOB".equals(objectType)) {
                queryddl = QueryUtils.getXMLQueries().getQuery("queryddlJob", conn).getSql();
                pstatement = conn.prepareStatement(queryddl);
                objectType = "PROCOBJ";
                dropJob = "declare \n  jobs number;\nbegin\nselect count(1) into jobs from all_scheduler_jobs where owner = user and job_name = '" + oName + "';\nif jobs > 0 then\n    dbms_scheduler.drop_job(job_name => '" + oName + "');\nend if;\n";
            } else if ("PUBLIC_DB_LINK".equals(objectType)) {
                queryddl = QueryUtils.getXMLQueries().getQuery("queryddlPublic", conn).getSql();
                pstatement = conn.prepareStatement(queryddl);
                objectType = "DB_LINK";
                pstatement.setString(3, "PUBLIC");
            } else {
                queryddl = QueryUtils.getXMLQueries().getQuery("queryddl", conn).getSql();
                pstatement = conn.prepareStatement(queryddl);
            }
            pstatement.setString(1, objectType);
            pstatement.setString(2, objectName);
            try {
                rs = pstatement.executeQuery();
            }
            catch (SQLException e) {
                String string = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (pstatement != null) {
                    try {
                        pstatement.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                return string;
            }
            while (rs != null && rs.next()) {
                result = rs.getString(1);
            }
            if (DbmsMetaUtils.isSxmlType(oType.toUpperCase())) {
                String e = result;
                return e;
            }
            if ("JOB".equalsIgnoreCase(oType)) {
                trimmed = ((String)result).trim().substring(6);
                String full = dropJob + trimmed;
                result = full;
            }
            trimmed = LiquibaseStringUtils.ltrim((String)result);
        }
        catch (Exception e) {
            LbUtils.log(e);
            if (e instanceof DatabaseException) {
                throw (DatabaseException)((Object)e);
            }
            throw new DatabaseException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (pstatement != null) {
                try {
                    pstatement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return trimmed;
    }

    public static boolean isSxmlType(String name) {
        try {
            SXML_OBJECT_TYPES.valueOf(name);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static enum SXML_OBJECT_TYPES {
        AQ_QUEUE,
        AQ_QUEUE_TABLE,
        AQ_TRANSFORM,
        ASSOCIATION,
        AUDIT,
        AUDIT_OBJ,
        CLUSTER,
        CONTEXT,
        DEFAULT_ROLE,
        FGA_POLICY,
        INDEX,
        LIBRARY,
        MATERIALIZED_VIEW,
        MATERIALIZED_VIEW_LOG,
        OPERATOR,
        PROFILE,
        PROXY,
        REFRESH_GROUP,
        RESOURCE_COST,
        RLS_CONTEXT,
        RLS_GROUP,
        RLS_POLICY,
        RMGR_CONSUMER_GROUP,
        RMGR_INTITIAL_CONSUMER_GROUP,
        RMGR_PLAN,
        RMGR_PLAN_DIRECTIVE,
        ROLE,
        ROLLBACK_SEGMENT,
        SEQUENCE,
        TABLE,
        TABLESPACE,
        TRUSTED_DB_LINK,
        TYPE,
        USER,
        VIEW,
        XMLSCHEMA,
        XS_USER,
        XS_ROLE,
        XS_ROLESET,
        XS_ROLE_GRANT,
        XS_SECURITY_CLASS,
        XS_DATA_SECURITY,
        XS_ACL,
        XS_ACL_PARAM,
        XS_NAMESPACE;

    }
}

