/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.find;

import java.util.List;
import oracle.javatools.editor.find.Find;
import oracle.javatools.editor.find.FindCriteria;

public final class FindResult {
    private final List<Find> finds;
    private final Find find;
    private int changeId;
    private final FindCriteria criteria;

    FindResult(List<Find> finds, Find find, int changeId, FindCriteria criteria) {
        this.finds = finds;
        this.find = find;
        this.changeId = changeId;
        this.criteria = criteria;
        criteria.used();
        assert (changeId > -1);
    }

    void dispose() {
        for (Find f : this.finds) {
            f.dispose();
        }
        if (this.find != null) {
            this.find.dispose();
        }
    }

    public List<Find> getFinds() {
        return this.finds;
    }

    public Find getFind() {
        return this.find;
    }

    public int getChangeId() {
        return this.changeId;
    }

    FindCriteria getFindCriteria() {
        return this.criteria;
    }

    public String toString() {
        return this.finds == null ? "no finds" : "" + this.finds.size() + " finds, next: " + (this.find == null ? "null" : Integer.valueOf(this.find.getStartOffset()));
    }
}

