/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.profiles.attribute.xacml;

import java.util.ArrayList;
import java.util.List;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.saml2.core.Attribute;
import oracle.security.xmlsec.saml2.util.SAML2URI;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XACMLAttribute
extends Attribute {
    public XACMLAttribute(Element element) throws DOMException {
        super(element);
    }

    public XACMLAttribute(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public XACMLAttribute(Document owner) throws DOMException {
        super(owner);
        this.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
    }

    public void setXacmlDataType(String dataTypeURI) {
        String prefix = XMLElement.getDefaultNSPrefix((String)"urn:oasis:names:tc:SAML:2.0:profiles:attribute:XACML");
        if (prefix == null || prefix.length() < 1) {
            prefix = "xacmlprof";
        }
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, "urn:oasis:names:tc:SAML:2.0:profiles:attribute:XACML");
        this.setAttributeNS("urn:oasis:names:tc:SAML:2.0:profiles:attribute:XACML", prefix + ":DataType", dataTypeURI);
    }

    public String getXacmlDataType() {
        String dataTypeURI = this.getAttributeNS("urn:oasis:names:tc:SAML:2.0:profiles:attribute:XACML", "DataType");
        if (dataTypeURI != null && dataTypeURI.length() > 0) {
            return dataTypeURI;
        }
        return null;
    }

    public void addAttributeValue(String[] attributeValues) {
        this.addAttributeValues(attributeValues);
    }

    public void addAttributeValue(byte[] attributeValue) {
        Text node = this.getOwnerDocument().createTextNode(Utils.toBase64((byte[])attributeValue));
        this.addAttributeValue(node, SAML2URI.encoding_xsitype_Base64Binary);
    }

    public List getAttributeValueBytes() {
        List avList = SAML2Utils.getChildren(this, "urn:oasis:names:tc:SAML:2.0:assertion", "AttributeValue");
        if (avList != null) {
            ArrayList<byte[]> byteList = new ArrayList<byte[]>(avList.size());
            int len = avList.size();
            for (int i = 0; i < len; ++i) {
                Element av = (Element)avList.get(i);
                QName avType = XACMLAttribute.getXsiType(av);
                if (!SAML2URI.encoding_xsitype_Base64Binary.equals((Object)avType)) continue;
                byteList.add(Utils.fromBase64((String)XMLUtils.collectText((Node)av)));
            }
            if (byteList.size() > 0) {
                return byteList;
            }
        }
        return null;
    }

    @Override
    public String getAttributeProfileID() {
        return "urn:oasis:names:tc:SAML:2.0:profiles:attribute:XACML";
    }
}

