/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.IssuerAndSerialNo;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSRecipientInfo;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class CMSKeyTransRecipientInfo
extends CMSRecipientInfo {
    private IssuerAndSerialNo iasn;
    private AlgorithmIdentifier keyEncryptionAlgID;
    private byte[] encryptedKey;
    private String encryptedKeyAlgo = null;
    private byte[] spki = null;
    private boolean useSPKI64 = false;
    private ASN1Integer version = null;
    private ASN1Sequence contents = null;

    public CMSKeyTransRecipientInfo() {
    }

    public CMSKeyTransRecipientInfo(SecretKey contentEncryptionKey, PublicKey keyEncryptionKey, IssuerAndSerialNo iasn, AlgorithmIdentifier keyEncryptionAlgID) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        this.iasn = iasn;
        this.keyEncryptionAlgID = keyEncryptionAlgID;
        this.version = new ASN1Integer(0L);
        String AlgoName = CMSUtils.getAlgoName(keyEncryptionAlgID);
        Cipher cipher = null;
        cipher = keyEncryptionAlgID.equals((Object)CMS.aes128_cbc) || keyEncryptionAlgID.equals((Object)CMS.aes192_cbc) || keyEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? Cipher.getInstance("AES/CBC/PKCS5Padding") : Cipher.getInstance(AlgoName);
        this.encryptedKeyAlgo = contentEncryptionKey.getAlgorithm();
        byte[] key = contentEncryptionKey.getEncoded();
        try {
            if (AlgoName.indexOf("CBC") != -1) {
                byte[] iv = null;
                iv = keyEncryptionAlgID.equals((Object)CMS.aes128_cbc) || keyEncryptionAlgID.equals((Object)CMS.aes192_cbc) || keyEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? CMSUtils.generateRandomBytes(16) : CMSUtils.generateRandomBytes(8);
                cipher.init(1, (Key)keyEncryptionKey, new IvParameterSpec(iv));
                this.keyEncryptionAlgID = new CBCAlgorithmIdentifier(keyEncryptionAlgID.getOID(), iv);
                cipher.update(key);
                this.encryptedKey = cipher.doFinal();
            } else if (AlgoName.indexOf("RSA") != -1) {
                cipher.init(3, keyEncryptionKey);
                this.encryptedKey = cipher.wrap(contentEncryptionKey);
            } else {
                cipher.init(1, keyEncryptionKey);
                cipher.update(key);
                this.encryptedKey = cipher.doFinal();
            }
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new InvalidKeyException("Invalid AlgoParameter - IV");
        }
    }

    public CMSKeyTransRecipientInfo(InputStream is) throws IOException {
        this.inputRecipientInfo(is);
    }

    public CMSKeyTransRecipientInfo(SecretKey contentEncryptionKey, PublicKey keyEncryptionKey, byte[] spki, AlgorithmIdentifier keyEncryptionAlgID) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        this.spki = spki;
        this.keyEncryptionAlgID = keyEncryptionAlgID;
        this.version = new ASN1Integer(2L);
        String algoName = CMSUtils.getAlgoName(keyEncryptionAlgID);
        this.encryptedKeyAlgo = contentEncryptionKey.getAlgorithm();
        Cipher cipher = null;
        cipher = keyEncryptionAlgID.equals((Object)CMS.aes128_cbc) || keyEncryptionAlgID.equals((Object)CMS.aes192_cbc) || keyEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? Cipher.getInstance("AES/CBC/PKCS5Padding") : Cipher.getInstance(algoName);
        try {
            if (algoName.indexOf("CBC") != -1) {
                byte[] iv = null;
                iv = keyEncryptionAlgID.equals((Object)CMS.aes128_cbc) || keyEncryptionAlgID.equals((Object)CMS.aes192_cbc) || keyEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? CMSUtils.generateRandomBytes(16) : CMSUtils.generateRandomBytes(8);
                cipher.init(1, (Key)keyEncryptionKey, new IvParameterSpec(iv));
                this.keyEncryptionAlgID = new CBCAlgorithmIdentifier(keyEncryptionAlgID.getOID(), iv);
                cipher.update(contentEncryptionKey.getEncoded());
                this.encryptedKey = cipher.doFinal();
            } else if (algoName.indexOf("RSA") != -1) {
                cipher.init(3, keyEncryptionKey);
                this.encryptedKey = cipher.wrap(contentEncryptionKey);
            } else {
                cipher.init(1, keyEncryptionKey);
                cipher.update(contentEncryptionKey.getEncoded());
                this.encryptedKey = cipher.doFinal();
            }
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new InvalidKeyException("Invalid AlgoParameter - IV");
        }
    }

    public CMSKeyTransRecipientInfo(byte[] hmacKey, String hmacKeyAlgo, PublicKey keyEncryptionKey, IssuerAndSerialNo iasn, AlgorithmIdentifier keyEncryptionAlgID) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        this.iasn = iasn;
        this.keyEncryptionAlgID = keyEncryptionAlgID;
        this.version = new ASN1Integer(0L);
        String algoName = CMSUtils.getAlgoName(keyEncryptionAlgID);
        Cipher cipher = null;
        cipher = keyEncryptionAlgID.equals((Object)CMS.aes128_cbc) || keyEncryptionAlgID.equals((Object)CMS.aes192_cbc) || keyEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? Cipher.getInstance("AES/CBC/PKCS5Padding") : Cipher.getInstance(algoName);
        try {
            if (algoName.indexOf("CBC") != -1) {
                byte[] iv = null;
                iv = keyEncryptionAlgID.equals((Object)CMS.aes128_cbc) || keyEncryptionAlgID.equals((Object)CMS.aes192_cbc) || keyEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? CMSUtils.generateRandomBytes(16) : CMSUtils.generateRandomBytes(8);
                cipher.init(1, (Key)keyEncryptionKey, new IvParameterSpec(iv));
                this.keyEncryptionAlgID = new CBCAlgorithmIdentifier(keyEncryptionAlgID.getOID(), iv);
                cipher.update(hmacKey);
                this.encryptedKey = cipher.doFinal();
            } else if (algoName.indexOf("RSA") != -1) {
                cipher.init(3, keyEncryptionKey);
                SecretKeySpec hKey = new SecretKeySpec(hmacKey, hmacKeyAlgo);
                this.encryptedKey = cipher.wrap(hKey);
            } else {
                cipher.init(1, keyEncryptionKey);
                cipher.update(hmacKey);
                this.encryptedKey = cipher.doFinal();
            }
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new InvalidKeyException("Invalid AlgoParameter - IV");
        }
        this.encryptedKeyAlgo = hmacKeyAlgo;
    }

    public CMSKeyTransRecipientInfo(byte[] hmacKey, String hmacKeyAlgo, PublicKey keyEncryptionKey, byte[] spki, AlgorithmIdentifier keyEncryptionAlgID) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        this.spki = spki;
        this.keyEncryptionAlgID = keyEncryptionAlgID;
        this.version = new ASN1Integer(2L);
        String algoName = CMSUtils.getAlgoName(keyEncryptionAlgID);
        Cipher cipher = null;
        cipher = keyEncryptionAlgID.equals((Object)CMS.aes128_cbc) || keyEncryptionAlgID.equals((Object)CMS.aes192_cbc) || keyEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? Cipher.getInstance("AES/CBC/PKCS5Padding") : Cipher.getInstance(algoName);
        this.encryptedKeyAlgo = hmacKeyAlgo;
        try {
            if (algoName.indexOf("CBC") != -1) {
                byte[] iv = null;
                iv = keyEncryptionAlgID.equals((Object)CMS.aes128_cbc) || keyEncryptionAlgID.equals((Object)CMS.aes192_cbc) || keyEncryptionAlgID.equals((Object)CMS.aes256_cbc) ? CMSUtils.generateRandomBytes(16) : CMSUtils.generateRandomBytes(8);
                cipher.init(1, (Key)keyEncryptionKey, new IvParameterSpec(iv));
                this.keyEncryptionAlgID = new CBCAlgorithmIdentifier(keyEncryptionAlgID.getOID(), iv);
                cipher.update(hmacKey);
                this.encryptedKey = cipher.doFinal();
            } else if (algoName.indexOf("RSA") != -1) {
                cipher.init(3, keyEncryptionKey);
                SecretKeySpec hKey = new SecretKeySpec(hmacKey, hmacKeyAlgo);
                this.encryptedKey = cipher.wrap(hKey);
            } else {
                cipher.init(1, keyEncryptionKey);
                cipher.update(hmacKey);
                this.encryptedKey = cipher.doFinal();
            }
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new InvalidKeyException("Invalid AlgoParameter - IV");
        }
    }

    public int hashCode() {
        try {
            UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
            this.output((OutputStream)bos);
            return new String(bos.toByteArray()).hashCode();
        }
        catch (IOException ex) {
            throw new StreamableOutputException(ex.toString());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CMSKeyTransRecipientInfo)) {
            return false;
        }
        return this.hashCode() == ((CMSKeyTransRecipientInfo)obj).hashCode();
    }

    public IssuerAndSerialNo getIASN() {
        return this.iasn;
    }

    public BigInteger getSerialNo() {
        return this.iasn.getSerialNo();
    }

    public X500Name getIssuer() {
        return this.iasn.getIssuer();
    }

    public AlgorithmIdentifier getKeyEncryptionAlgID() {
        return this.keyEncryptionAlgID;
    }

    public byte[] getEncryptedKey() {
        return this.encryptedKey;
    }

    public byte[] getSPKI() {
        return this.spki;
    }

    public boolean useSPKI64() {
        return this.spki.length == 64;
    }

    public String getKeyAlgo() {
        return this.encryptedKeyAlgo;
    }

    public byte[] getContentEncryptionKey(PrivateKey keyDecryptionKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String algoName = CMSUtils.getAlgoName(this.keyEncryptionAlgID);
        Cipher cipher = Cipher.getInstance(algoName);
        try {
            byte[] decryptedbytes = null;
            if (this.keyEncryptionAlgID instanceof CBCAlgorithmIdentifier) {
                cipher.init(2, (Key)keyDecryptionKey, new IvParameterSpec(((CBCAlgorithmIdentifier)this.keyEncryptionAlgID).getIV()));
                decryptedbytes = cipher.doFinal(this.encryptedKey);
            } else {
                cipher.init(4, keyDecryptionKey);
                SecretKey Key2 = (SecretKey)cipher.unwrap(this.encryptedKey, this.encryptedKeyAlgo, 3);
                decryptedbytes = Key2.getEncoded();
            }
            return decryptedbytes;
        }
        catch (InvalidAlgorithmParameterException ed) {
            throw new InvalidKeyException("Invalid Algorithm Parameters _ IV");
        }
    }

    public byte[] getContentEncryptionKey(PrivateKey keyDecryptionKey, String contentEncryptionAlgo) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String algoName = CMSUtils.getAlgoName(this.keyEncryptionAlgID);
        Cipher cipher = Cipher.getInstance(algoName);
        try {
            byte[] decryptedbytes = null;
            if (this.keyEncryptionAlgID instanceof CBCAlgorithmIdentifier) {
                cipher.init(2, (Key)keyDecryptionKey, new IvParameterSpec(((CBCAlgorithmIdentifier)this.keyEncryptionAlgID).getIV()));
                decryptedbytes = cipher.doFinal(this.encryptedKey);
            } else {
                cipher.init(4, keyDecryptionKey);
                String dummyAlgo = "DES";
                SecretKey Key2 = (SecretKey)cipher.unwrap(this.encryptedKey, dummyAlgo, 3);
                decryptedbytes = Key2.getEncoded();
            }
            return decryptedbytes;
        }
        catch (InvalidAlgorithmParameterException ed) {
            throw new InvalidKeyException("Invalid Algorithm Parameters _ IV");
        }
    }

    public byte[] getContentAuthenticationKey(PrivateKey keyDecryptionKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        String algoName = CMSUtils.getAlgoName(this.keyEncryptionAlgID);
        Cipher cipher = Cipher.getInstance(algoName);
        byte[] key = null;
        try {
            if (this.keyEncryptionAlgID instanceof CBCAlgorithmIdentifier) {
                cipher.init(2, (Key)keyDecryptionKey, new IvParameterSpec(((CBCAlgorithmIdentifier)this.keyEncryptionAlgID).getIV()));
                cipher.update(this.encryptedKey);
                key = cipher.doFinal();
            } else {
                cipher.init(4, keyDecryptionKey);
                String dummyAlgo = "DES";
                SecretKey Key2 = (SecretKey)cipher.unwrap(this.encryptedKey, dummyAlgo, 3);
                key = Key2.getEncoded();
            }
            return key;
        }
        catch (InvalidAlgorithmParameterException ed) {
            throw new NoSuchAlgorithmException("Invalid Algorithm Parameters - IV");
        }
    }

    public BigInteger getVersionNumber() {
        return this.version.getValue();
    }

    @Override
    public ASN1Integer getVersion() {
        return this.version;
    }

    @Override
    protected void inputRecipientInfo(InputStream is) throws IOException {
        ASN1SequenceInputStream si = new ASN1SequenceInputStream(is);
        this.version = new ASN1Integer((InputStream)si);
        if (!this.version.equals(0) && !this.version.equals(2)) {
            throw new VersionException("Expected Version 0 or 2 But got " + this.version.getValue());
        }
        if (si.getCurrentTag() == 0) {
            if (!this.version.equals(2)) {
                throw new VersionException("Expected Version 2 with SPKI but got " + this.version.getValue());
            }
            si.setCurrentTag(4);
            this.spki = new ASN1OctetString((InputStream)si).getValue();
            this.iasn = null;
        } else {
            if (!this.version.equals(0)) {
                throw new VersionException("Expected Version 0 with IASN but got " + this.version.getValue());
            }
            this.iasn = new IssuerAndSerialNo((InputStream)si);
            this.spki = null;
        }
        this.keyEncryptionAlgID = new AlgorithmIdentifier((InputStream)si);
        this.encryptedKey = new ASN1OctetString((InputStream)si).getValue();
        si.terminate();
        this.update();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private void update() {
        this.contents = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence seq = new ASN1Sequence();
            if (this.spki != null) {
                seq.addElement((ASN1Object)new ASN1Integer(2L));
                seq.addElement(ASN1Utils.addImplicitTag((ASN1Object)new ASN1OctetString(this.spki), (int)0));
            } else {
                seq.addElement((ASN1Object)new ASN1Integer(0L));
                seq.addElement((ASN1Object)this.iasn);
            }
            seq.addElement((ASN1Object)this.keyEncryptionAlgID);
            seq.addElement((ASN1Object)new ASN1OctetString(this.encryptedKey));
            this.contents = seq;
        }
        return this.contents;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("KeyTransRecipientInfo\n");
        sb.append("Version: " + this.version.intValue() + "\n");
        if (this.spki == null) {
            sb.append("RecipientIdentifier: " + this.iasn.toString() + "\n");
        } else {
            sb.append("RecipientIdentifier: " + Utils.toHexString((byte[])this.spki) + "\n");
        }
        sb.append("Encryption AlgID: " + this.keyEncryptionAlgID + "\n");
        return sb.toString();
    }
}

