/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.hypergraph.edgeconnector;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.hypergraph.IlvHyperEdge;
import ilog.views.hypergraph.IlvHyperEdgeEnd;
import ilog.views.hypergraph.edgeconnector.IlvHyperEdgePinConnector;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.util.collections.IlvCollections;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class IlvHyperGrapherPin
implements Serializable,
IlvPersistentObject {
    private Object a;
    private IlvHyperEdgePinConnector b;
    private float c;
    private float d;
    private float e;
    private float f;
    private float g;
    private int h;
    private int i;
    private Color j;
    private Color k;
    private static final int l = 1;
    private static final int m = 2;
    private static final int n = 4;
    private static final int o = 8;

    public IlvHyperGrapherPin(IlvPoint ilvPoint, IlvPoint ilvPoint2, float f, int n) {
        this.h = 0;
        this.g = f;
        this.i = n;
        this.c = ilvPoint.x;
        this.d = ilvPoint.y;
        this.e = ilvPoint2.x;
        this.f = ilvPoint2.y;
        this.j = Color.blue;
        this.k = Color.red;
        this.setVisible(true);
        this.setMovable(true);
        this.setAllowMultiConnection(true);
        this.setSelected(false);
    }

    public IlvHyperGrapherPin(IlvHyperEdgePinConnector ilvHyperEdgePinConnector, IlvPoint ilvPoint, IlvPoint ilvPoint2, float f, int n) {
        this(ilvPoint, ilvPoint2, f, n);
        if (ilvHyperEdgePinConnector == null) {
            throw new IllegalArgumentException("connector cannot be null");
        }
        ilvHyperEdgePinConnector.addPin(this, true);
    }

    public IlvHyperGrapherPin(IlvInputStream ilvInputStream) throws IlvReadFileException {
        this.h = ilvInputStream.readInt("flags");
        this.c = ilvInputStream.readFloat("rx");
        this.d = ilvInputStream.readFloat("ry");
        this.e = ilvInputStream.readFloat("ax");
        this.f = ilvInputStream.readFloat("ay");
        this.g = ilvInputStream.readFloat("size");
        this.i = ilvInputStream.readInt("direction");
        try {
            this.j = ilvInputStream.readColor("color");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.j = Color.blue;
        }
        try {
            this.k = ilvInputStream.readColor("selectedColor");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.k = Color.red;
        }
        this.setSelected(false);
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        ilvOutputStream.write("flags", this.h);
        ilvOutputStream.write("rx", this.c);
        ilvOutputStream.write("ry", this.d);
        ilvOutputStream.write("ax", this.e);
        ilvOutputStream.write("ay", this.f);
        ilvOutputStream.write("size", this.g);
        ilvOutputStream.write("direction", this.i);
        if (!this.j.equals(Color.blue)) {
            ilvOutputStream.write("color", this.j);
        }
        if (!this.k.equals(Color.red)) {
            ilvOutputStream.write("selectedColor", this.k);
        }
    }

    public IlvHyperGrapherPin copy() {
        IlvPoint ilvPoint = new IlvPoint(this.c, this.d);
        IlvPoint ilvPoint2 = new IlvPoint(this.e, this.f);
        IlvHyperGrapherPin ilvHyperGrapherPin = new IlvHyperGrapherPin(ilvPoint, ilvPoint2, this.g, this.i);
        ilvHyperGrapherPin.h = this.h;
        ilvHyperGrapherPin.setSelected(false);
        return ilvHyperGrapherPin;
    }

    public Iterator getConnectedEnds() {
        if (this.a == null) {
            return IlvCollections.emptyIterator();
        }
        if (this.a instanceof IlvHyperEdgeEnd) {
            return IlvCollections.oneElementIterator((Object)this.a);
        }
        ArrayList arrayList = (ArrayList)this.a;
        return IlvCollections.unmodifiableIterator(arrayList.iterator());
    }

    public boolean isConnected(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        if (this.a == null) {
            return false;
        }
        if (this.a instanceof IlvHyperEdgeEnd) {
            return this.a == ilvHyperEdgeEnd;
        }
        ArrayList arrayList = (ArrayList)this.a;
        return arrayList.contains(ilvHyperEdgeEnd);
    }

    public boolean allow(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        if (this.isAllowMultiConnection()) {
            return true;
        }
        return this.a == null;
    }

    void a(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        if (this.isAllowMultiConnection()) {
            if (this.a == null) {
                this.a = new ArrayList();
            }
            ((ArrayList)this.a).add(ilvHyperEdgeEnd);
        } else {
            this.a = ilvHyperEdgeEnd;
        }
    }

    void b(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        if (this.a == null) {
            return;
        }
        if (this.isAllowMultiConnection()) {
            ArrayList arrayList = (ArrayList)this.a;
            arrayList.remove(ilvHyperEdgeEnd);
            if (arrayList.size() == 0) {
                this.a = null;
            }
        } else {
            this.a = null;
        }
    }

    void a() {
        this.a = null;
    }

    void a(IlvTransformer ilvTransformer) {
        if (this.a == null) {
            return;
        }
        if (this.getNode() == null) {
            return;
        }
        Iterator iterator = this.getConnectedEnds();
        while (iterator.hasNext()) {
            IlvHyperEdgeEnd ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
            this.b.adjust(ilvHyperEdgeEnd);
        }
    }

    final IlvPoint a(IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvTransformer ilvTransformer) {
        IlvGraphic ilvGraphic = ilvHyperEdgeEnd.getNode();
        IlvHyperEdge ilvHyperEdge = ilvHyperEdgeEnd.getHyperEdge();
        if (ilvGraphic == null || ilvHyperEdge == null) {
            return null;
        }
        int n = this.b();
        IlvRect ilvRect = this.boundingBox(ilvTransformer);
        switch (n) {
            case 1: {
                return new IlvPoint(ilvRect.x, ilvRect.y + 0.5f * ilvRect.height);
            }
            case 2: {
                return new IlvPoint(ilvRect.x + ilvRect.width, ilvRect.y + 0.5f * ilvRect.height);
            }
            case 4: {
                return new IlvPoint(ilvRect.x + 0.5f * ilvRect.width, ilvRect.y);
            }
            case 8: {
                return new IlvPoint(ilvRect.x + 0.5f * ilvRect.width, ilvRect.y + ilvRect.height);
            }
            case 16: {
                return new IlvPoint(ilvRect.x + 0.5f * ilvRect.width, ilvRect.y + 0.5f * ilvRect.height);
            }
        }
        return null;
    }

    private int b() {
        int n = this.getDirection();
        if (n == 0) {
            double d = (double)this.c - 0.5;
            double d2 = (double)this.d - 0.5;
            if (d * d > d2 * d2) {
                if (d > 0.0) {
                    return 2;
                }
                return 1;
            }
            if (d2 > 0.0) {
                return 8;
            }
            return 4;
        }
        return n;
    }

    public IlvPoint getPosition(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = this.getNodeBoundingBox(ilvTransformer);
        IlvPoint ilvPoint = new IlvPoint(this.e, this.f);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.deltaApply(ilvPoint);
        }
        ilvPoint.x += ilvRect.x + this.c * ilvRect.width;
        ilvPoint.y += ilvRect.y + this.d * ilvRect.height;
        return ilvPoint;
    }

    public void setPosition(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        if (this.getNode() == null) {
            throw new RuntimeException("pin not inside connector, or connector not attached to a node");
        }
        IlvRect ilvRect = this.getNodeBoundingBox(ilvTransformer);
        IlvPoint ilvPoint2 = new IlvPoint(this.e, this.f);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.deltaApply(ilvPoint2);
        }
        this.c = (ilvPoint.x - ilvRect.x - ilvPoint2.x) / ilvRect.width;
        this.d = (ilvPoint.y - ilvRect.y - ilvPoint2.y) / ilvRect.height;
        this.a(ilvTransformer);
        this.getHyperEdgeConnector().clearBoundingBoxCache();
    }

    public void setAbsoluteOffset(float f, float f2) {
        this.e = f;
        this.f = f2;
        this.a((IlvTransformer)null);
        if (this.getHyperEdgeConnector() != null) {
            this.getHyperEdgeConnector().clearBoundingBoxCache();
        }
    }

    public IlvPoint getAbsoluteOffset() {
        return new IlvPoint(this.e, this.f);
    }

    public void setProportionalOffset(float f, float f2) {
        this.c = f;
        this.d = f2;
        this.a((IlvTransformer)null);
        if (this.getHyperEdgeConnector() != null) {
            this.getHyperEdgeConnector().clearBoundingBoxCache();
        }
    }

    public IlvPoint getProportionalOffset() {
        return new IlvPoint(this.c, this.d);
    }

    protected boolean connectionZoomable() {
        return this.zoomable();
    }

    protected boolean zoomable() {
        IlvGraphic ilvGraphic = this.getNode();
        if (ilvGraphic != null) {
            return ilvGraphic.zoomable() && this.getHyperEdgeConnector().a();
        }
        return false;
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isSelected()) {
            graphics.setColor(this.getSelectedColor());
        } else {
            graphics.setColor(this.getColor());
        }
        float f = this.getSize();
        IlvPoint ilvPoint = this.getPosition(ilvTransformer);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.inverse(ilvPoint);
        }
        IlvRect ilvRect = new IlvRect(ilvPoint.x - f, ilvPoint.y - f, 2.0f * f, 2.0f * f);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.applyFloor(ilvRect);
        }
        this.draw(graphics, ilvRect);
    }

    protected void draw(Graphics graphics, IlvRect ilvRect) {
        graphics.fillRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width + 1, (int)ilvRect.height + 1);
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        float f = this.getSize();
        IlvPoint ilvPoint = this.getPosition(ilvTransformer);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.inverse(ilvPoint);
        }
        IlvRect ilvRect = new IlvRect(ilvPoint.x - f, ilvPoint.y - f, 2.0f * f, 2.0f * f);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.apply(ilvRect);
        }
        return ilvRect;
    }

    public IlvRect getNodeBoundingBox(IlvTransformer ilvTransformer) {
        IlvGraphic ilvGraphic = this.getNode();
        if (ilvGraphic == null) {
            return new IlvRect();
        }
        boolean bl = this.getHyperEdgeConnector().a();
        if (bl && ilvGraphic.zoomable()) {
            IlvRect ilvRect = ilvGraphic.boundingBox(null);
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.apply(ilvRect);
            }
            return ilvRect;
        }
        return ilvGraphic.boundingBox(ilvTransformer);
    }

    public final IlvGraphic getNode() {
        return this.b != null ? this.b.getOwner() : null;
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (!this.isVisible()) {
            return false;
        }
        IlvRect ilvRect = this.boundingBox(ilvTransformer);
        return ilvRect.inside(ilvPoint2.x, ilvPoint2.y);
    }

    public Color getColor() {
        return this.j;
    }

    public void setColor(Color color) {
        this.j = color == null ? Color.blue : color;
    }

    public Color getSelectedColor() {
        return this.k;
    }

    public void setSelectedColor(Color color) {
        this.k = color == null ? Color.red : color;
    }

    public void setSelected(boolean bl) {
        this.h = bl ? (this.h |= 1) : (this.h &= 0xFFFFFFFE);
    }

    public boolean isSelected() {
        return (this.h & 1) != 0;
    }

    public void setVisible(boolean bl) {
        this.h = bl ? (this.h |= 2) : (this.h &= 0xFFFFFFFD);
    }

    public boolean isVisible() {
        return (this.h & 2) != 0;
    }

    public void setMovable(boolean bl) {
        this.h = bl ? (this.h |= 8) : (this.h &= 0xFFFFFFF7);
    }

    public boolean isMovable() {
        return (this.h & 8) != 0;
    }

    public float getSize() {
        return this.g;
    }

    public void setDirection(int n) {
        this.i = n;
    }

    public int getDirection() {
        return this.i;
    }

    final void a(IlvHyperEdgePinConnector ilvHyperEdgePinConnector) {
        this.b = ilvHyperEdgePinConnector;
    }

    public final IlvHyperEdgePinConnector getHyperEdgeConnector() {
        return this.b;
    }

    public void setAllowMultiConnection(boolean bl) {
        if (bl == this.isAllowMultiConnection()) {
            return;
        }
        if (this.a != null) {
            throw new RuntimeException("You must disconnect all ends from this pin before changing the option AllowMultiConnection");
        }
        this.h = bl ? (this.h |= 4) : (this.h &= 0xFFFFFFFB);
    }

    public boolean isAllowMultiConnection() {
        return (this.h & 4) != 0;
    }
}

