/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.views;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.controls.ITabCloseListner;
import oracle.dbtools.raptor.controls.RaptorDnD;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.navigator.db.DatabaseConnection;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.utils.ConnectionDetails;
import oracle.dbtools.raptor.utils.ConnectionDisconnectListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.MapViewer;
import oracle.dbtools.spatial.mapviewer.components.MapViewerHelper;
import oracle.dbtools.spatial.persistence.QueryHistoryManager;
import oracle.dbtools.spatial.views.SpatialCustomTabbedPanel;
import oracle.dbtools.spatial.views.SpatialViewController;
import oracle.dbtools.spatial.views.tables.QueryObject;
import oracle.dbtools.spatial.views.tables.SpatialListReorderableTableWithTitleBar;
import oracle.dbtools.spatial.views.tables.SpatialReorderableTableModel;
import oracle.dbtools.spatial.views.tables.SpatialTabPanel;
import oracle.ide.Ide;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.util.dnd.TransferableTreeNode;
import oracle.ideimpl.explorer.dnd.MultiTransferable;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;

public class SpatialPanel
extends JPanel {
    private final int INITIAL_PANEL_POSITION = 600;
    static final long serialVersionUID = 1L;
    private static final String TAB_NAME = SpatialArb.getString("TAB_NAME");
    private boolean _init = false;
    private Integer _nameSuffix = 1;
    private ArrayList<ITabCloseListner> closeListeners = new ArrayList();
    private ArrayList<SpatialListReorderableTableWithTitleBar> reorderableTables = new ArrayList();
    private ArrayList<MapViewer> mapViewers = new ArrayList();
    private ArrayList<Integer> panelPositions = new ArrayList();
    private SpatialCustomTabbedPanel _innerTabbedPane = new SpatialCustomTabbedPanel();
    private Toolbar _toolbar;
    private JSplitPane middleSplitPanel;
    private int lastTabIndex;
    private Connections connections;
    private DropTargetListener dropTargetListener;
    private DropTarget dropTarget;
    protected String objectName;
    private QueryHistoryManager historyManager;
    private String[] raptorTaskCnx;
    private String[] raptorTaskTId;
    private HashMap tabCnxHashMap;
    private HashMap<String, SpatialListReorderableTableWithTitleBar> reorderableTablesMap;
    private HashMap<String, MapViewer> mapViewerHashMap;
    private HashMap<String, Integer> dividerLocationsMap;
    private ArrayList<String> failedCons;
    private String objName;
    private SpatialListReorderableTableWithTitleBar targetTab;
    private QueryObject queryObj;
    private HashMap<String, InsertObjectTask> insertDraggedObjectTasksMap;
    private String targetTabTask;
    Component leftPanelComp;
    Component rightPanelComp;
    int targetPanel;
    final transient ITabCloseListner closeListener = new ITabCloseListner(){

        public void tabClosed() {
            DefaultListModel defaultListModel = SpatialPanel.this._innerTabbedPane.getTabModel();
            ArrayList<SpatialListReorderableTableWithTitleBar> arrayList = new ArrayList<SpatialListReorderableTableWithTitleBar>();
            boolean[] blArray = new boolean[SpatialPanel.this.reorderableTables.size()];
            int n = 0;
            for (SpatialListReorderableTableWithTitleBar spatialListReorderableTableWithTitleBar : SpatialPanel.this.reorderableTables) {
                boolean string = false;
                blArray[n] = true;
                for (int insertObjectTask = defaultListModel.size() - 1; insertObjectTask >= 0; --insertObjectTask) {
                    Object e = defaultListModel.getElementAt(insertObjectTask);
                    if (!(e instanceof DefaultCustomTabPage) || ((DefaultCustomTabPage)e).getUserObject() != spatialListReorderableTableWithTitleBar.getTabPanel()) continue;
                    string = true;
                    blArray[n] = false;
                    break;
                }
                if (!string) {
                    arrayList.add(spatialListReorderableTableWithTitleBar);
                }
                ++n;
            }
            for (SpatialListReorderableTableWithTitleBar<Object> spatialListReorderableTableWithTitleBar : arrayList) {
                String string = spatialListReorderableTableWithTitleBar.getModel().getIdentifier().toString();
                InsertObjectTask insertObjectTask = SpatialPanel.this.insertDraggedObjectTasksMap.get(string);
                if (insertObjectTask != null) {
                    insertObjectTask.getDescriptor().setCancelled(true);
                }
                spatialListReorderableTableWithTitleBar.getModel().eraseTabHistory(string);
                SpatialPanel.this.reorderableTables.remove(spatialListReorderableTableWithTitleBar);
                SpatialPanel.this.tabCnxHashMap.remove(spatialListReorderableTableWithTitleBar.getModel().getIdentifier().toString());
            }
            if (SpatialPanel.this.reorderableTables.isEmpty()) {
                SpatialPanel.this.setPanels(new JPanel(new GridBagLayout()), new JPanel(new GridBagLayout()));
                SpatialPanel.this.middleSplitPanel.setDividerSize(0);
                SpatialPanel.this.tabCnxHashMap.clear();
                SpatialPanel.this.mapViewers.clear();
                SpatialPanel.this.panelPositions.clear();
            } else {
                for (int i = 0; i < blArray.length; ++i) {
                    if (!blArray[i]) continue;
                    SpatialPanel.this.mapViewers.remove(i);
                    SpatialPanel.this.panelPositions.remove(i);
                }
            }
        }
    };

    public SpatialPanel() {
        super(new GridBagLayout());
        this.tabCnxHashMap = new HashMap();
    }

    public void initialize() {
        if (!this._init) {
            this.middleSplitPanel = new JSplitPane();
            this.middleSplitPanel.setLeftComponent(new JPanel());
            this.middleSplitPanel.setRightComponent(new JPanel());
            this.reorderableTablesMap = new HashMap();
            this.mapViewerHashMap = new HashMap();
            this.dividerLocationsMap = new HashMap();
            this.insertDraggedObjectTasksMap = new HashMap();
            UIUtils.addIdeKeyBindings((JComponent)this, (int)1, (String)"oracle/dbtools/spatial/accelerators.xml");
            this.lastTabIndex = 0;
            this._init = true;
            this.closeListeners.add(this.closeListener);
            this._toolbar = new Toolbar();
            SpatialViewController.getInstance().installToolbar(this.getToolbar());
            this.add((Component)this._toolbar, new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(this._innerTabbedPane.getTabs(), new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.middleSplitPanel, new GridBagConstraints(0, 2, 5, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.dropTargetListener = new MapViewerDropTargetListener();
            this.dropTarget = new DropTarget(this, 1, this.dropTargetListener, true);
            this.connections = Connections.getInstance();
            this.connections.addConnectionDisconnectListener(new ConnectionDisconnectListener(){

                public void checkDisconnect(ConnectionDetails connectionDetails) {
                }

                public void connectionDisconnected(ConnectionDetails connectionDetails) {
                    SpatialViewController.getInstance().toggleToolbar();
                    for (SpatialListReorderableTableWithTitleBar spatialListReorderableTableWithTitleBar : SpatialPanel.this.reorderableTables) {
                        if (!spatialListReorderableTableWithTitleBar.getCombobox().getCurrentConnectionName().equals(connectionDetails.getQualifiedConnectionName())) continue;
                        spatialListReorderableTableWithTitleBar.disconnect();
                    }
                }
            });
            this.historyManager = new QueryHistoryManager();
            this._innerTabbedPane.addChangeListener(new TabChangeListener());
            this.failedCons = new ArrayList();
            this.restoreWithRaptorTask();
        }
    }

    private void restoreWithRaptorTask() {
        RaptorTask<Object> raptorTask = new RaptorTask<Object>("Restoring spatial session", true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Object doWork() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialPanel.this.restoreSessionTabs();
                    }
                });
                return null;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialViewController.getInstance().toggleToolbar();
                    }
                });
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialViewController.getInstance().toggleToolbar();
                    }
                });
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialViewController.getInstance().toggleToolbar();
                        SpatialPanel.this.setAllTabsCloseable(true);
                    }
                });
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    private void restoreSessionTabs() {
        String[] stringArray = this.historyManager.getPreviousSession();
        if (stringArray == null || stringArray.length == 0) {
            this.addTab();
            this.setTabCloseable(0, false);
        } else {
            int n = (int)Math.floor(stringArray.length / 2);
            this.raptorTaskCnx = new String[n];
            this.raptorTaskTId = new String[n];
            for (int i = 0; i < n; ++i) {
                String string;
                int n2 = i * 2;
                int n3 = n2 + 1;
                String string2 = stringArray[n2];
                this.raptorTaskCnx[i] = string = stringArray[n3];
                this.raptorTaskTId[i] = string2;
                this.addTab(string2, string);
                try {
                    if (MapViewerHelper.isConnectionValid(Connections.getInstance().getConnection(string))) continue;
                    this.failedCons.add(string);
                    continue;
                }
                catch (DBException dBException) {
                    this.failedCons.add(string);
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
                }
            }
        }
        if (this.failedCons.size() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)SpatialArb.getString("OneOrMoreConnectionsFailed"), (String)SpatialArb.getString("FailedRestoreSessionTitle"), null);
                }
            });
        }
    }

    private void addTab(String string, String string2) {
        Object object = TAB_NAME;
        object = (String)object + " " + this._nameSuffix.toString();
        this._nameSuffix = this._nameSuffix + 1;
        SpatialReorderableTableModel spatialReorderableTableModel = new SpatialReorderableTableModel(UUID.fromString(string));
        MapViewer mapViewer = new MapViewer(spatialReorderableTableModel);
        SpatialListReorderableTableWithTitleBar<QueryObject> spatialListReorderableTableWithTitleBar = new SpatialListReorderableTableWithTitleBar<QueryObject>(spatialReorderableTableModel, mapViewer, (String)object);
        this.reorderableTables.add(spatialListReorderableTableWithTitleBar);
        this.reorderableTablesMap.put(spatialListReorderableTableWithTitleBar.getModel().getIdentifier().toString(), spatialListReorderableTableWithTitleBar);
        this._innerTabbedPane.addTab(null, (String)object, spatialListReorderableTableWithTitleBar.getTabPanel(), this.closeListeners);
        this.setSelectedIndex(this._innerTabbedPane.getTabModel().getSize() - 1);
        this.mapViewers.add(mapViewer);
        this.tabCnxHashMap.put(string, mapViewer);
        JPanel jPanel = mapViewer.getRenderingPanel();
        this.setPanels(jPanel, this._innerTabbedPane.getContent());
        this.lastTabIndex = this._innerTabbedPane.getTabModel().getSize() - 1;
        this.dividerLocationsMap.put(spatialListReorderableTableWithTitleBar.getModel().getIdentifier().toString(), this.middleSplitPanel.getDividerLocation());
        SpatialViewController.getInstance().lockUI();
        this.setTabCloseable(this.lastTabIndex, false);
        spatialListReorderableTableWithTitleBar.setTabPageConnection(string2);
    }

    private void setTabCloseable(int n, boolean bl) {
        Object e;
        DefaultListModel defaultListModel = this._innerTabbedPane.getTabbedPanelListModel();
        if (defaultListModel != null && (e = defaultListModel.getElementAt(n)) instanceof DefaultCustomTabPage) {
            ((DefaultCustomTabPage)e).setCloseable(bl);
        }
    }

    public void setAllTabsCloseable(boolean bl) {
        DefaultListModel defaultListModel = this._innerTabbedPane.getTabbedPanelListModel();
        if (defaultListModel != null) {
            for (int i = 0; i < defaultListModel.getSize(); ++i) {
                Object e = defaultListModel.getElementAt(i);
                if (!(e instanceof DefaultCustomTabPage)) continue;
                if (i == 0) {
                    ((DefaultCustomTabPage)e).setCloseable(false);
                    continue;
                }
                ((DefaultCustomTabPage)e).setCloseable(bl);
            }
        }
    }

    public void addTab() {
        Object object = TAB_NAME;
        object = (String)object + " " + this._nameSuffix.toString();
        this._nameSuffix = this._nameSuffix + 1;
        SpatialReorderableTableModel spatialReorderableTableModel = new SpatialReorderableTableModel();
        MapViewer mapViewer = new MapViewer(spatialReorderableTableModel);
        SpatialListReorderableTableWithTitleBar<QueryObject> spatialListReorderableTableWithTitleBar = new SpatialListReorderableTableWithTitleBar<QueryObject>(spatialReorderableTableModel, mapViewer, (String)object);
        this.reorderableTables.add(spatialListReorderableTableWithTitleBar);
        this.reorderableTablesMap.put(spatialListReorderableTableWithTitleBar.getModel().getIdentifier().toString(), spatialListReorderableTableWithTitleBar);
        this._innerTabbedPane.addTab(null, (String)object, spatialListReorderableTableWithTitleBar.getTabPanel(), this.closeListeners);
        this.setSelectedIndex(this._innerTabbedPane.getTabModel().getSize() - 1);
        this.mapViewers.add(mapViewer);
        this.tabCnxHashMap.put(spatialReorderableTableModel.getIdentifier().toString(), mapViewer);
        JPanel jPanel = mapViewer.getRenderingPanel();
        this.setPanels(jPanel, this._innerTabbedPane.getContent());
        this.lastTabIndex = this._innerTabbedPane.getTabModel().getSize() - 1;
        this.dividerLocationsMap.put(spatialListReorderableTableWithTitleBar.getModel().getIdentifier().toString(), this.middleSplitPanel.getDividerLocation());
        SpatialViewController.getInstance().toggleToolbar();
    }

    public Toolbar getToolbar() {
        return this._toolbar;
    }

    private void setPanels(Component component, Component component2) {
        this.leftPanelComp = component;
        this.rightPanelComp = component2;
        this.middleSplitPanel.setRightComponent(this.rightPanelComp);
        this.middleSplitPanel.setLeftComponent(this.leftPanelComp);
        this.setupLeftPanel();
    }

    private void setupLeftPanel() {
        this.middleSplitPanel.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.middleSplitPanel.setDividerLocation(600);
        this.middleSplitPanel.setDividerSize(3);
        this.middleSplitPanel.setContinuousLayout(true);
        this.panelPositions.add(600);
    }

    private void restorePanelAt(int n) {
        this.targetPanel = n;
        this.middleSplitPanel.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.middleSplitPanel.setDividerSize(3);
        this.middleSplitPanel.setContinuousLayout(true);
        if (this.panelPositions.size() > 0 && this.panelPositions.get(this.targetPanel) != null) {
            this.middleSplitPanel.setDividerLocation(this.panelPositions.get(this.targetPanel));
        }
    }

    public SpatialReorderableTableModel getSelectedModel() {
        return this.getModel(this._innerTabbedPane.getSelectedIndex());
    }

    public JPanel getSelectedRenderingPanel() {
        JPanel jPanel = this.getImgPanel(this._innerTabbedPane.getSelectedIndex());
        return jPanel;
    }

    private JPanel getImgPanel(int n) {
        JPanel jPanel = null;
        if (n >= 0) {
            jPanel = this.mapViewers.get(n).getRenderingPanel();
        }
        return jPanel;
    }

    private MapViewer getMapViewer(int n) {
        MapViewer mapViewer = null;
        if (n >= 0) {
            mapViewer = this.mapViewers.get(n);
        }
        return mapViewer;
    }

    public MapViewer getSelectedMapViewer() {
        return this.getMapViewer(this._innerTabbedPane.getSelectedIndex());
    }

    private SpatialReorderableTableModel getModel(int n) {
        DefaultCustomTabPage defaultCustomTabPage;
        SpatialTabPanel spatialTabPanel;
        if (n >= 0 && (spatialTabPanel = (SpatialTabPanel)(defaultCustomTabPage = (DefaultCustomTabPage)this._innerTabbedPane.getTabModel().get(n)).getUserObject()) != null) {
            ReorderableTableWithTitleBar reorderableTableWithTitleBar = spatialTabPanel.getReorderableTableWithTitleBar();
            SpatialListReorderableTableWithTitleBar<?> spatialListReorderableTableWithTitleBar = this.getTabPage(reorderableTableWithTitleBar);
            return spatialListReorderableTableWithTitleBar.getModel();
        }
        return null;
    }

    public SpatialListReorderableTableWithTitleBar<?> getTabPage(ReorderableTableWithTitleBar reorderableTableWithTitleBar) {
        for (SpatialListReorderableTableWithTitleBar spatialListReorderableTableWithTitleBar : this.reorderableTables) {
            ReorderableTableWithTitleBar reorderableTableWithTitleBar2 = spatialListReorderableTableWithTitleBar.getReorderableTableWithTitleBar();
            if (reorderableTableWithTitleBar2 != reorderableTableWithTitleBar) continue;
            return spatialListReorderableTableWithTitleBar;
        }
        return null;
    }

    public SpatialListReorderableTableWithTitleBar<?> getTabPageByTabId(String string) {
        for (SpatialListReorderableTableWithTitleBar spatialListReorderableTableWithTitleBar : this.reorderableTables) {
            if (!spatialListReorderableTableWithTitleBar.getModel().getIdentifier().toString().equals(string)) continue;
            return spatialListReorderableTableWithTitleBar;
        }
        return null;
    }

    public SpatialListReorderableTableWithTitleBar<?> getSelectedTabPage() {
        int n = this._innerTabbedPane.getSelectedIndex();
        if (n >= 0) {
            return this.getTabPage(n);
        }
        return null;
    }

    private SpatialListReorderableTableWithTitleBar<?> getTabPage(int n) {
        DefaultCustomTabPage defaultCustomTabPage;
        SpatialTabPanel spatialTabPanel;
        ReorderableTableWithTitleBar reorderableTableWithTitleBar;
        if (n >= 0 && (reorderableTableWithTitleBar = (spatialTabPanel = (SpatialTabPanel)(defaultCustomTabPage = (DefaultCustomTabPage)this._innerTabbedPane.getTabModel().get(n)).getUserObject()).getReorderableTableWithTitleBar()) != null) {
            return this.getTabPage(reorderableTableWithTitleBar);
        }
        return null;
    }

    public String getSelecetedTabPageName() {
        return this._innerTabbedPane.getSelectedPageLabel();
    }

    public void setSelectedTabPagName(String string) {
        SpatialListReorderableTableWithTitleBar<?> spatialListReorderableTableWithTitleBar = this.getSelectedTabPage();
        if (spatialListReorderableTableWithTitleBar != null) {
            this._innerTabbedPane.renameSelectedPage(string);
        }
    }

    public ArrayList<SpatialListReorderableTableWithTitleBar> getTabPages() {
        return this.reorderableTables;
    }

    public ArrayList<String> getTabPageNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SpatialListReorderableTableWithTitleBar spatialListReorderableTableWithTitleBar : this.reorderableTables) {
            arrayList.add(spatialListReorderableTableWithTitleBar.getTabLabel());
        }
        return arrayList;
    }

    public ArrayList<SpatialReorderableTableModel> getTableModels() {
        ArrayList<SpatialReorderableTableModel> arrayList = new ArrayList<SpatialReorderableTableModel>();
        for (SpatialListReorderableTableWithTitleBar spatialListReorderableTableWithTitleBar : this.reorderableTables) {
            arrayList.add(spatialListReorderableTableWithTitleBar.getModel());
        }
        return arrayList;
    }

    private void setSelectedIndex(int n) {
        this._innerTabbedPane.setSelectedIndex(n);
    }

    public MapViewer getMapViewerByTabId(String string) {
        return (MapViewer)this.tabCnxHashMap.get(string);
    }

    private QueryObject buildQueryObject(String string) {
        QueryObject queryObject = null;
        String string2 = this.objName;
        String string3 = "SELECT * FROM " + this.objName;
        String string4 = "";
        SpatialListReorderableTableWithTitleBar<?> spatialListReorderableTableWithTitleBar = this.getTabPageByTabId(string);
        if (string2.length() > 0 && spatialListReorderableTableWithTitleBar != null) {
            String[] stringArray = new String[]{};
            try {
                Connection connection = Connections.getInstance().getConnection(spatialListReorderableTableWithTitleBar.getCombobox().getCurrentConnectionName());
                Vector<Integer[]> vector = MapViewerHelper.getQuerySRIDS(string3, connection);
                boolean bl = MapViewerHelper.isValidSpatialQuery(string3, connection);
                int n = spatialListReorderableTableWithTitleBar.getModel().getTableSRID();
                boolean bl2 = MapViewerHelper.areQuerySRIDsValid(n, vector);
                if (bl2 && bl) {
                    queryObject = new QueryObject(string2, string3, string4, Color.black, Color.black, Color.red, 8, 0, Color.black, 1, Color.gray, Color.yellow, stringArray, connection);
                    queryObject.setConnectionSourceName(spatialListReorderableTableWithTitleBar.getCurrentConnectionName());
                    UUID uUID = spatialListReorderableTableWithTitleBar.getModel().getIdentifier();
                    queryObject.setTabIdentifier(uUID.toString());
                    queryObject.setNewlyCreated();
                    queryObject.setPreselected(true);
                } else if (!bl2) {
                    throw new Exception(SpatialArb.getString("NonMatchingSRIDException"));
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, outOfMemoryError.getStackTrace()[0].toString(), outOfMemoryError);
            }
            catch (DBException dBException) {
                MessageDialog.critical((Component)Ide.getMainWindow(), (Object)dBException.getMessage(), (String)"", null);
                return queryObject;
            }
            catch (Exception exception) {
                MessageDialog.critical((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)"", null);
                return queryObject;
            }
        }
        return queryObject;
    }

    private void insertDraggedQo(QueryObject queryObject) {
        SpatialListReorderableTableWithTitleBar<?> spatialListReorderableTableWithTitleBar = this.getTabPageByTabId(queryObject.getTabIdentifier());
        if (queryObject != null && spatialListReorderableTableWithTitleBar != null) {
            spatialListReorderableTableWithTitleBar.setConnectionAndInsertQuery(queryObject, queryObject.getConnectionSourceName());
        }
    }

    private void insertDraggedObjectTask() {
        InsertObjectTask insertObjectTask = new InsertObjectTask("Inserting dragged object " + this.targetTab.getModel().getIdentifier().toString(), true, IRaptorTaskRunMode.IDE_STATUSBAR, this.targetTab.getModel().getIdentifier().toString());
        this.insertDraggedObjectTasksMap.put(this.targetTab.getModel().getIdentifier().toString(), insertObjectTask);
        insertObjectTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                SpatialPanel.this.insertDraggedObjectTasksMap.remove(SpatialPanel.this.targetTab.getModel().getIdentifier().toString());
                SpatialViewController.getInstance().toggleToolbar();
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                SpatialPanel.this.insertDraggedObjectTasksMap.remove(SpatialPanel.this.targetTab.getModel().getIdentifier().toString());
                SpatialViewController.getInstance().toggleToolbar();
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialPanel.this.insertDraggedObjectTasksMap.remove(SpatialPanel.this.targetTab.getModel().getIdentifier().toString());
                        SpatialPanel.this.insertDraggedQo(SpatialPanel.this.queryObj);
                        SpatialViewController.getInstance().toggleToolbar();
                    }
                });
            }
        });
        RaptorTaskManager.getInstance().addTask(insertObjectTask);
    }

    class InsertObjectTask<Object>
    extends RaptorTask<Object> {
        private String tabId;

        private InsertObjectTask(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode, String string2) {
            super(string, bl, iRaptorTaskRunMode);
            this.tabId = string2;
        }

        protected Object doWork() throws TaskException {
            SpatialPanel.this.queryObj = SpatialPanel.this.buildQueryObject(this.tabId);
            return null;
        }
    }

    class MapViewerDropTargetListener
    implements DropTargetListener {
        private String currentCnxName;
        private ObjectNode objNode;
        private String type;
        private DatabaseConnection draggedConn;

        MapViewerDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.acceptDrag(1);
            Transferable transferable = dropTargetDragEvent.getTransferable();
            try {
                List list = RaptorDnD.getTransferableNodes((Transferable[])new Transferable[]{transferable});
                for (int i = 0; i < list.size(); ++i) {
                    DefaultMutableTreeNode defaultMutableTreeNode = list.get(i) instanceof MultiTransferable ? (DefaultMutableTreeNode)((MultiTransferable)list.get(i)).getTransferData(TransferableTreeNode.TREE_NODE_FLAVOR) : (DefaultMutableTreeNode)list.get(i);
                    Object object = defaultMutableTreeNode.getUserObject();
                    if (object instanceof DatabaseConnection) {
                        if (!Connections.getInstance().isOracle(((DatabaseConnection)object).getConnectionName())) {
                            this.draggedConn = (DatabaseConnection)object;
                            this.type = "CNX";
                            dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                        } else {
                            dropTargetDragEvent.rejectDrag();
                        }
                        break;
                    }
                    if (!(object instanceof ObjectNode)) continue;
                    this.objNode = (ObjectNode)object;
                    SpatialPanel.this.objName = this.objNode.getObjectName();
                    this.type = this.objNode.getObjectType();
                    try {
                        if (!Connections.getInstance().isOracle(Connections.getInstance().getConnection(this.objNode.getConnectionName()))) {
                            dropTargetDragEvent.rejectDrag();
                            break;
                        }
                        if (this.type == null && !this.type.equals("TABLE") && !this.type.equals("VIEW")) {
                            dropTargetDragEvent.rejectDrag();
                            break;
                        }
                        dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
                        continue;
                    }
                    catch (DBException dBException) {
                        dropTargetDragEvent.rejectDrag();
                    }
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, unsupportedFlavorException.getStackTrace()[0].toString(), unsupportedFlavorException);
                dropTargetDragEvent.rejectDrag();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                dropTargetDragEvent.rejectDrag();
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                dropTargetDragEvent.rejectDrag();
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        @Override
        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        @Override
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            this.currentCnxName = SpatialPanel.this.getSelectedTabPage().getCurrentConnectionName();
            if (this.draggedConn == null) {
                if (this.currentCnxName == null || this.currentCnxName.isEmpty() || !this.objNode.getConnectionName().equals(this.currentCnxName)) {
                    SpatialPanel.this.getSelectedTabPage().setTabPageConnection(this.objNode.getConnectionName());
                } else {
                    SpatialPanel.this.targetTab = SpatialPanel.this.getSelectedTabPage();
                    SpatialViewController.getInstance().lockUI();
                    SpatialPanel.this.insertDraggedObjectTask();
                }
            } else if (this.draggedConn.getQualifiedConnectionName() != null && !this.draggedConn.getQualifiedConnectionName().isEmpty()) {
                SpatialPanel.this.getSelectedTabPage().setTabPageConnection(this.draggedConn.getQualifiedConnectionName());
                this.draggedConn = null;
            }
        }
    }

    class TabChangeListener
    implements ChangeListener {
        TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SpatialViewController.getInstance().setModelEnable(!SpatialPanel.this.getSelectedModel().getRowList().isEmpty());
            if (SpatialPanel.this.panelPositions.size() > SpatialPanel.this.lastTabIndex) {
                SpatialPanel.this.panelPositions.set(SpatialPanel.this.lastTabIndex, SpatialPanel.this.middleSplitPanel.getDividerLocation());
            }
            if (SpatialPanel.this._innerTabbedPane.getSelectedIndex() < SpatialPanel.this.mapViewers.size()) {
                SpatialPanel.this.middleSplitPanel.setLeftComponent(SpatialPanel.this.mapViewers.get(SpatialPanel.this._innerTabbedPane.getSelectedIndex()).getRenderingPanel());
                SpatialPanel.this.restorePanelAt(SpatialPanel.this._innerTabbedPane.getSelectedIndex());
                SpatialPanel.this.lastTabIndex = SpatialPanel.this._innerTabbedPane.getSelectedIndex();
                SpatialViewController.getInstance().toggleToolbar();
            }
            if (SpatialPanel.this._innerTabbedPane.getTabbedPanelListModel().getSize() == 1) {
                SpatialPanel.this.setTabCloseable(0, false);
            } else {
                SpatialPanel.this.setTabCloseable(0, true);
            }
        }
    }
}

