/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.ThreadsPanelSettings;
import oracle.jdevimpl.runner.debug.WindowSettingsColumnManager;

final class ThreadsPanelSettingsPanel
implements ActionListener {
    private JCheckBox[] showColumnCheckBoxes;
    private JPanel chooseColumnsPanel;
    private Map<String, boolean[]> showColumnsMap = new HashMap<String, boolean[]>();
    private transient ThreadsPanelSettings settings;
    private String currentVM;

    public ThreadsPanelSettingsPanel() {
        this.showColumnCheckBoxes = new JCheckBox[5];
        for (int i = 0; i < 5; ++i) {
            this.showColumnCheckBoxes[i] = new JCheckBox();
            this.showColumnCheckBoxes[i].addActionListener(this);
        }
        this.chooseColumnsPanel = new JPanel(new GridLayout(0, 2, 0, 0));
    }

    JPanel makeChooseColumnsPanel(String vmName, Insets borderInsets) {
        this.currentVM = vmName;
        TitledBorder border = BorderFactory.createTitledBorder(RunMgrArb.getString(91));
        this.chooseColumnsPanel.setBorder(border);
        if (borderInsets != null) {
            Insets temp = border.getBorderInsets(this.chooseColumnsPanel);
            borderInsets.top = temp.top;
            borderInsets.left = temp.left;
            borderInsets.bottom = temp.bottom;
            borderInsets.right = temp.right;
        }
        boolean[] columnsVisible = this.showColumnsMap.get(vmName);
        this.chooseColumnsPanel.removeAll();
        List<String> columnNames = this.settings.getColumnNamesInPreferences(vmName);
        for (int i = 0; i < columnNames.size(); ++i) {
            if (columnNames.get(i) == null) continue;
            if (i >= this.showColumnCheckBoxes.length) break;
            ResourceUtils.resButton((AbstractButton)this.showColumnCheckBoxes[i], (String)columnNames.get(i));
            this.showColumnCheckBoxes[i].setSelected(columnsVisible[i]);
            this.chooseColumnsPanel.add(this.showColumnCheckBoxes[i]);
        }
        this.showColumnCheckBoxes[0].setEnabled(false);
        return this.chooseColumnsPanel;
    }

    void onEntry(ThreadsPanelSettings threadsPanelSettings) {
        this.settings = threadsPanelSettings;
        HashStructure hash = this.settings.getHash();
        this.chooseColumnsPanel.removeAll();
        this.showColumnsMap.clear();
        List<String> vmNames = WindowSettingsColumnManager.getVMNames(hash);
        if (vmNames.size() > 0) {
            for (String vmName : vmNames) {
                boolean[] visibilities = new boolean[5];
                for (int j = 0; j < 5; ++j) {
                    visibilities[j] = this.settings.getColumnVisible(vmName, j);
                }
                this.showColumnsMap.put(vmName, visibilities);
            }
            for (int i = 0; i < 5; ++i) {
                this.showColumnCheckBoxes[i].addActionListener(this);
            }
        }
    }

    void onExit(ThreadsPanelSettings threadsPanelSettings) throws TraversalException {
        HashStructure hash = threadsPanelSettings.getHash();
        for (String vmName : this.showColumnsMap.keySet()) {
            boolean[] columnVisibilities = this.showColumnsMap.get(vmName);
            for (int i = 0; i < columnVisibilities.length; ++i) {
                this.settings.setColumnVisible(vmName, i, columnVisibilities[i]);
            }
        }
        for (int i = 0; i < 5; ++i) {
            this.showColumnCheckBoxes[i].removeActionListener(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.showColumnCheckBoxes.length; ++i) {
            if (e.getSource() != this.showColumnCheckBoxes[i]) continue;
            boolean[] visibilities = this.showColumnsMap.get(this.currentVM);
            visibilities[i] = this.showColumnCheckBoxes[i].isSelected();
            break;
        }
    }
}

