/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner.debug;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.tree.TreePath;
import oracle.jdevimpl.debugger.support.DataExpiredException;
import oracle.jdevimpl.debugger.support.DebugDataCompositeInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;
import oracle.jdevimpl.debugger.support.DebugHeapInfo;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.debugger.support.HasStoppedCount;
import oracle.jdevimpl.runner.debug.DataItem;
import oracle.jdevimpl.runner.debug.DataItemAfterEvaluationCallback;
import oracle.jdevimpl.runner.debug.DataTreeTableModel;
import oracle.jdevimpl.runner.debug.DebuggingProcess;
import oracle.jdevimpl.runner.debug.EvaluatorDataItem;
import oracle.jdevimpl.runner.debug.Expression;
import oracle.jdevimpl.runner.debug.HeapController;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.MonitorDataItem;

public class VersionedDataItem
extends DataItem {
    private Change change = Change.UNCHANGED;
    private long itemUpdatedStoppedCount;
    private long childrenUpdatedStoppedCount;
    private int childrenUpdatedStackDepth;
    private String previousValue;
    private String currentValue;
    private TreeMap<String, VersionedDataItem> vChildren;
    private DataItem item;
    private EvaluatorDataItem evaluatorDataItem;
    private MonitorDataItem monitorDataItem;
    private Object heapDataItem;
    private Object info;
    private DebugVirtualMachine vm;
    private VersionedDataItem parent = null;
    private String cachedVDIAddress;
    private final DataTreeTableModel model;
    DataItemAfterEvaluationCallback callback = new DataItemAfterEvaluationCallback(){

        @Override
        public void afterEvaluation(DataItem item, long stopcount) {
            long debugJDIStoppedCount;
            if (VersionedDataItem.this.vm instanceof HasStoppedCount && (debugJDIStoppedCount = ((HasStoppedCount)((Object)VersionedDataItem.this.vm)).getStoppedCount()) != stopcount && DataItem.TRACE_BACKGROUND_LOADS) {
                JDebugger.logger.trace("VDI.afterEvaluation callback passed a stale stopcount -- probably need to trigger new load!");
            }
            VersionedDataItem.this.getValue();
            if (VersionedDataItem.this.currentValue == null && VersionedDataItem.this.previousValue != null) {
                if (DataItem.TRACE_BACKGROUND_LOADS) {
                    JDebugger.logger.trace("VDI: afterEvaluation callback " + VersionedDataItem.this.getDisplayName() + " was '" + VersionedDataItem.this.previousValue + "' now null");
                }
                if (stopcount != VersionedDataItem.this.itemUpdatedStoppedCount) {
                    VersionedDataItem.this.change = Change.CHANGED;
                    VersionedDataItem.this.itemUpdatedStoppedCount = stopcount;
                }
                return;
            }
            if (VersionedDataItem.this.currentValue != null && VersionedDataItem.this.currentValue.equals(DataItem.LOADING_IN_BACKGROUND)) {
                return;
            }
            if (DataItem.TRACE_BACKGROUND_LOADS) {
                JDebugger.logger.trace("VDI: afterEvaluation callback " + VersionedDataItem.this.getDisplayName() + " was '" + VersionedDataItem.this.previousValue + "' now '" + VersionedDataItem.this.currentValue + "'");
            }
            if (VersionedDataItem.this.currentValue != null && !VersionedDataItem.this.currentValue.equals(VersionedDataItem.this.previousValue)) {
                if (stopcount != VersionedDataItem.this.itemUpdatedStoppedCount) {
                    VersionedDataItem.this.change = Change.CHANGED;
                    VersionedDataItem.this.itemUpdatedStoppedCount = stopcount;
                }
            } else if (stopcount != VersionedDataItem.this.itemUpdatedStoppedCount) {
                VersionedDataItem.this.change = Change.UNCHANGED;
                VersionedDataItem.this.itemUpdatedStoppedCount = stopcount;
            }
        }
    };

    public VersionedDataItem(DataItem item, DataTreeTableModel model, DebugVirtualMachine vm, long stopCount) {
        super(item.dataPanel, item.info);
        this.model = model;
        this.vm = vm;
        this.previousValue = "";
        this.item = item;
        this.info = item.getInfo();
        this.data = item.data;
        if (LOAD_VALUES_IN_BACKGROUND && model.shouldLoadValueLazily(item)) {
            if (DataItem.TRACE_BACKGROUND_LOADS) {
                JDebugger.logger.trace("VDI.<init> sets CV to placeholder and starts bg load with no callback");
            }
            this.currentValue = DataItem.LOADING_IN_BACKGROUND;
            model.loadValueInBackground(item, 1, null);
        } else {
            this.currentValue = item.getValue();
        }
        this.change = Change.ADDED;
        this.itemUpdatedStoppedCount = stopCount;
        this.childrenUpdatedStoppedCount = -1L;
        if (vm != null) {
            DebugStackFrameInfo currentStackFrame = vm.getCurrentStackFrame();
            int n = this.childrenUpdatedStackDepth = currentStackFrame != null ? currentStackFrame.getFrameNumber() : -1;
        }
        if (item instanceof EvaluatorDataItem) {
            this.setEvaluatorDataItem((EvaluatorDataItem)item);
        } else if (this.info instanceof EvaluatorDataItem) {
            this.setEvaluatorDataItem((EvaluatorDataItem)this.info);
        } else if (item instanceof MonitorDataItem) {
            this.setMonitorDataItem((MonitorDataItem)item);
        } else if (this.info instanceof MonitorDataItem) {
            this.setMonitorDataItem((MonitorDataItem)this.info);
        } else if (item.getClass().getSimpleName().startsWith("Heap") && item.getClass().getSimpleName().endsWith("DataItem")) {
            this.setHeapDataItem(item);
            this.cachedVDIAddress = item.getAddress();
            HeapController.heapLogger.trace("VDI constructor caching address " + this.cachedVDIAddress + " for " + item);
        }
    }

    @Override
    DataItemAfterEvaluationCallback getDataItemAfterEvaluationCallback() {
        return this.callback;
    }

    public void updateVDI(DataItem item, long stopCount) {
        if (!item.getDisplayName().equals(this.getDisplayName())) {
            super.setDisplayName(item.getDisplayName());
        }
        if (!DataItem.LOADING_IN_BACKGROUND.equals(this.currentValue)) {
            this.previousValue = this.currentValue;
        }
        this.info = item.getInfo();
        this.item = item;
        if (item instanceof EvaluatorDataItem) {
            this.setEvaluatorDataItem((EvaluatorDataItem)item);
        } else if (item instanceof MonitorDataItem) {
            this.setMonitorDataItem((MonitorDataItem)item);
        } else if (this.info instanceof MonitorDataItem) {
            this.setMonitorDataItem((MonitorDataItem)this.info);
        } else if (item.getClass().getSimpleName().startsWith("Heap") && item.getClass().getSimpleName().endsWith("DataItem")) {
            this.setHeapDataItem(item);
            this.cachedVDIAddress = item.getAddress();
            if (this.info instanceof DebugHeapInfo && ((DebugHeapInfo)this.info).getHeapAddresses().length != this.countChildNodes()) {
                HeapController.heapLogger.trace("VDI.updateVDI expiring " + this + " due to change in size of child array");
                this.expire();
            }
        }
        if (LOAD_VALUES_IN_BACKGROUND && this.model.shouldLoadValueLazily(item)) {
            this.currentValue = DataItem.LOADING_IN_BACKGROUND;
            if (DataItem.TRACE_BACKGROUND_LOADS) {
                JDebugger.logger.trace("VDI.updateVDI triggering background load of " + item.getDisplayName() + " with callback");
            }
            this.model.loadValueInBackground(item, 1, this.callback);
        } else {
            this.currentValue = item.getValue();
            this.callback.afterEvaluation(item, stopCount);
        }
    }

    public void setEvaluatorDataItem(EvaluatorDataItem edi) {
        this.evaluatorDataItem = edi;
        if (edi == null) {
            return;
        }
        DebugDataInfo info = edi.getDataInfo();
        if (info == null) {
            return;
        }
        try {
            this.currentValue = info instanceof DebugDataCompositeInfo ? ((DebugDataCompositeInfo)info).getCourtesyValue() : (info instanceof DebugDataObjectInfo ? ((DebugDataObjectInfo)info).getCourtesyValue() : info.getValue());
        }
        catch (Exception ex) {
            this.currentValue = "";
        }
    }

    public EvaluatorDataItem getEvaluatorDataItem() {
        return this.evaluatorDataItem;
    }

    public void setMonitorDataItem(MonitorDataItem mdi) {
        this.monitorDataItem = mdi;
    }

    public MonitorDataItem getMonitorDataItem() {
        return this.monitorDataItem;
    }

    public void setHeapDataItem(Object hdi) {
        this.heapDataItem = hdi;
    }

    public Object getHeapDataItem() {
        return this.heapDataItem;
    }

    public Change getChange() {
        return this.change;
    }

    void setNew() {
        this.change = Change.NEW;
    }

    public long getStateChangeStopCount() {
        return this.itemUpdatedStoppedCount;
    }

    public void setParent(VersionedDataItem parent) {
        this.parent = parent;
    }

    public void expire() {
        this.itemUpdatedStoppedCount = -1L;
        this.childrenUpdatedStoppedCount = -1L;
        this.childrenUpdatedStackDepth = -1;
        VersionedDataItem vParent = this.parent;
        while (vParent != null) {
            vParent.expire();
            vParent = vParent.parent;
        }
    }

    @Override
    public Object getInfo() {
        return this.info;
    }

    public void setInfo(Object info) {
        this.info = info;
        if (info instanceof EvaluatorDataItem) {
            this.setEvaluatorDataItem((EvaluatorDataItem)this.item);
        }
        if (info instanceof MonitorDataItem) {
            this.setMonitorDataItem((MonitorDataItem)this.item);
        }
    }

    public String getPreviousValue() {
        return this.previousValue;
    }

    @Override
    public String getValue() {
        if (this.currentValue == DataItem.LOADING_IN_BACKGROUND) {
            if (this.model.hasPendingLoad(this.item)) {
                if (DataItem.TRACE_BACKGROUND_LOADS) {
                    JDebugger.logger.trace("VersionedDataItem.getValue() for " + this.getDisplayName() + " has placeholder, load still in progress, keeping placeholder");
                }
            } else {
                try {
                    if (this.vm.isStopped()) {
                        this.currentValue = this.item.getValue();
                    } else {
                        JDebugger.logger.trace("Not updating value for " + this.item.getDisplayName() + " as VM resumed when callback invoked");
                    }
                }
                catch (DataExpiredException e) {
                    JDebugger.logger.trace("Not updating value for " + this.item.getDisplayName() + " due to DataExpiredException in callback invoked");
                }
            }
        }
        return this.currentValue;
    }

    @Override
    protected Object getValueOfColumn(int column) {
        if (column == 1) {
            return this.getValue();
        }
        return this.item.getValueOfColumn(column);
    }

    @Override
    int numberOfCachedChildren() {
        return this.vChildren == null ? 0 : this.vChildren.size();
    }

    @Override
    DataItem[] getChildNodes(boolean skipExpandedCheck) {
        DebugStackFrameInfo stackFrameInfo;
        int currentStackFrame;
        boolean stopCountChangedSinceLastUpdate = false;
        boolean stackDepthChangedSinceLastUpdate = false;
        boolean haveStoppedCount = this.vm instanceof HasStoppedCount;
        DebugThreadInfo currentThread = this.vm.getCurrentThread();
        DebuggingProcess dp = JDebugger.getInstance().getActiveDebuggingProcess();
        if (dp == null) {
            return new DataItem[0];
        }
        long debuggeeStoppedCount = -1L;
        if (haveStoppedCount) {
            debuggeeStoppedCount = ((HasStoppedCount)((Object)this.vm)).getStoppedCount();
        }
        int n = currentStackFrame = (stackFrameInfo = this.vm.getCurrentStackFrame()) != null ? stackFrameInfo.getFrameNumber() : -1;
        if (currentThread != null) {
            if (debuggeeStoppedCount != this.childrenUpdatedStoppedCount) {
                if (debuggeeStoppedCount == this.itemUpdatedStoppedCount) {
                    stopCountChangedSinceLastUpdate = true;
                } else {
                    TreeMap<String, VersionedDataItem> currentChildren = this.vChildren;
                    if (currentChildren != null) {
                        return currentChildren.values().toArray(new DataItem[currentChildren.size()]);
                    }
                    JDebugger.logger.trace("VDI.getChildNodes(): children have been nulled, will re-acquire");
                }
            } else if (currentStackFrame != this.childrenUpdatedStackDepth) {
                stackDepthChangedSinceLastUpdate = true;
            }
        }
        if (this.vChildren == null) {
            DataItem[] items = this.item.getChildNodes(false);
            this.vChildren = new TreeMap(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1.matches("\\[\\d+\\]") && o2.matches("\\[\\d+\\]")) {
                        int start = o1.indexOf(91);
                        int end = o1.indexOf(93);
                        int value1 = Integer.parseInt(o1.substring(start + 1, end));
                        start = o2.indexOf(91);
                        end = o2.indexOf(93);
                        int value2 = Integer.parseInt(o2.substring(start + 1, end));
                        return value1 - value2;
                    }
                    return o1.compareTo(o2);
                }
            });
            for (int i = 0; i < items.length; ++i) {
                VersionedDataItem vdi = new VersionedDataItem(items[i], this.model, this.vm, debuggeeStoppedCount);
                vdi.setNew();
                vdi.setParent(this);
                if (items[i] instanceof EvaluatorDataItem) {
                    vdi.setEvaluatorDataItem((EvaluatorDataItem)items[i]);
                }
                this.vChildren.put(items[i].getDisplayName(), vdi);
            }
            this.childrenUpdatedStoppedCount = debuggeeStoppedCount;
            this.childrenUpdatedStackDepth = currentStackFrame;
        } else {
            long start = System.currentTimeMillis();
            if (!haveStoppedCount || stopCountChangedSinceLastUpdate || stackDepthChangedSinceLastUpdate) {
                if (DataItem.TRACE_BACKGROUND_LOADS) {
                    JDebugger.logger.trace("VDI.getChildNodes updating child nodes due to stop count or stack depth change");
                }
                HashSet<String> removedVChildren = new HashSet<String>(this.vChildren.keySet());
                DataItem[] items = this.item.getChildNodes(skipExpandedCheck);
                for (DataItem item : items) {
                    VersionedDataItem vItem = this.vChildren.get(item.getDisplayName());
                    if (vItem != null) {
                        vItem.updateVDI(item, debuggeeStoppedCount);
                        removedVChildren.remove(item.getDisplayName());
                    } else {
                        vItem = new VersionedDataItem(item, this.model, this.vm, debuggeeStoppedCount);
                        if (item instanceof EvaluatorDataItem) {
                            vItem.setEvaluatorDataItem((EvaluatorDataItem)item);
                        }
                    }
                    this.vChildren.put(item.getDisplayName(), vItem);
                }
                for (String key : removedVChildren) {
                    this.vChildren.remove(key);
                }
                this.childrenUpdatedStoppedCount = debuggeeStoppedCount;
                this.childrenUpdatedStackDepth = currentStackFrame;
            }
        }
        return this.vChildren.values().toArray(new DataItem[this.vChildren.size()]);
    }

    @Override
    public Iterator<DataItem> getLazyChildren() {
        TreeMap<String, VersionedDataItem> currentChildren = this.vChildren;
        if (currentChildren != null) {
            ArrayList<DataItem> childList = new ArrayList<DataItem>(currentChildren.size());
            for (DataItem dataItem : currentChildren.values()) {
                childList.add(dataItem);
            }
            return childList.iterator();
        }
        return Arrays.asList(new DataItem[0]).iterator();
    }

    @Override
    String getToolTip(int column, TreePath treePath) {
        String tooltip = super.getToolTip(column, treePath);
        if (column == 1 && this.getValue() != null && !this.getValue().equals(this.previousValue)) {
            tooltip = "<html>" + tooltip + "<br/>Previous value: " + this.previousValue + "</html>";
        }
        return tooltip;
    }

    public boolean equals(Object other) {
        if (other instanceof DataItem) {
            try {
                return ((DataItem)other).getID().equals(this.getID());
            }
            catch (DataExpiredException e) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.item == null) {
            return 17;
        }
        return this.item.hashCode();
    }

    @Override
    public boolean canAdjustRange() {
        return this.item.canAdjustRange();
    }

    @Override
    boolean canAdjustObjectPreferences() {
        return this.item.canAdjustObjectPreferences();
    }

    @Override
    boolean isEmpty() {
        return this.item.isEmpty();
    }

    @Override
    public void adjustRange(TreePath treePath) {
        if (this.item.canAdjustRange() && treePath != null) {
            this.vChildren = null;
        }
        this.item.adjustRange(treePath);
    }

    @Override
    public boolean adjustRange(TreePath treePath, int start, int count) {
        if (this.item.canAdjustRange() && treePath != null) {
            this.vChildren = null;
        }
        return this.item.adjustRange(treePath, start, count);
    }

    @Override
    public int getRangeStart() {
        return this.item.getRangeStart();
    }

    @Override
    public int getRangeCount() {
        return this.item.getRangeCount();
    }

    @Override
    boolean shouldShowArrayNavigationButtons() {
        return this.item.shouldShowArrayNavigationButtons();
    }

    @Override
    boolean canAdjustRangePrevious() {
        return this.item.canAdjustRangePrevious();
    }

    @Override
    boolean canAdjustRangeNext(boolean optimizeBySkippingScan) {
        return this.item.canAdjustRangeNext(optimizeBySkippingScan);
    }

    @Override
    boolean canAdjustRangeFirst() {
        return this.item.canAdjustRangePrevious();
    }

    @Override
    boolean canAdjustRangeLast(boolean optimize) {
        return this.item.canAdjustRangeNext(optimize);
    }

    @Override
    void adjustRangeFirst(TreePath treePath) {
        if (this.item.canAdjustRange() && treePath != null) {
            this.vChildren = null;
        }
        this.item.adjustRangeFirst(treePath);
    }

    @Override
    void adjustRangeLast(TreePath treePath) {
        if (this.item.canAdjustRange() && treePath != null) {
            this.vChildren = null;
        }
        this.item.adjustRangeLast(treePath);
    }

    @Override
    void adjustRangePrevious(TreePath treePath) {
        if (this.item.canAdjustRange() && treePath != null) {
            this.vChildren = null;
        }
        this.item.adjustRangePrevious(treePath);
    }

    @Override
    void adjustRangeNext(TreePath treePath) {
        if (this.item.canAdjustRange() && treePath != null) {
            this.vChildren = null;
        }
        this.item.adjustRangeNext(treePath);
    }

    @Override
    void modifyInfo(Object info, String displayNameOverride, String expressionPartOverride, TreePath treePath) {
        this.vChildren = null;
        this.info = info;
        this.item.modifyInfo(info, displayNameOverride, expressionPartOverride, treePath);
    }

    @Override
    void clearDataForItem() {
        this.item.clearDataForItem();
    }

    @Override
    void clearCacheForColumn(int column) {
        if (this.item != null) {
            this.item.clearCacheForColumn(column);
        }
    }

    @Override
    public DebugDataInfo getDataInfo() {
        return this.item.data;
    }

    @Override
    protected boolean isUnrelated() {
        return this.item.isUnrelated();
    }

    @Override
    public String getShortLabel() {
        return this.item.getDisplayName();
    }

    @Override
    public Object getData() {
        return this.item;
    }

    @Override
    public boolean mayHaveChildren() {
        return this.item.mayHaveChildren();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.item.getTransferDataFlavors();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.item.isDataFlavorSupported(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        return this.item.getTransferData(flavor);
    }

    @Override
    String getExpressionPart() {
        return this.item.getExpressionPart();
    }

    @Override
    public String getDisplayName() {
        return this.item.getDisplayName();
    }

    @Override
    public void setDisplayName(String displayName) {
        this.item.setDisplayName(displayName);
    }

    @Override
    public String getActualType() {
        return this.item.getActualType(false, false);
    }

    @Override
    String getActualType(boolean ignoreCached, boolean showPackage) {
        return this.item.getActualType(ignoreCached, showPackage);
    }

    @Override
    public String getFullyQualifiedActualType() {
        return this.item.getFullyQualifiedActualType();
    }

    @Override
    public String getDeclaredType() {
        return this.item.getDeclaredType();
    }

    @Override
    public String getFullyQualifiedDeclaredType() {
        return this.item.getFullyQualifiedDeclaredType();
    }

    @Override
    String getValue(boolean useCached, boolean getExtendedValue) {
        return this.item.getValue(useCached, getExtendedValue, true);
    }

    @Override
    String getValue(boolean useCached, boolean getExtendedValue, boolean addQuotes) {
        return this.item.getValue(useCached, getExtendedValue, addQuotes);
    }

    @Override
    String getValueExpressionUsed() {
        return this.item.getValueExpressionUsed();
    }

    @Override
    public String getHexValue() {
        return this.item.getHexValue();
    }

    @Override
    public String getAddress() {
        try {
            String address;
            this.cachedVDIAddress = address = this.item.getAddress();
            return address;
        }
        catch (DataExpiredException dee) {
            HeapController.heapLogger.trace("VDI.getAddress returning cached " + this.cachedVDIAddress + " for " + this.item + " due to DataExpiredException");
            return this.cachedVDIAddress;
        }
    }

    @Override
    public String getID() {
        return this.item.getID();
    }

    @Override
    public String getInstanceCount() {
        return this.item.getInstanceCount();
    }

    @Override
    public void setInstanceCount(long count) {
        this.item.setInstanceCount(count);
    }

    @Override
    int countChildNodes() {
        return this.getChildNodes(false).length;
    }

    @Override
    public DataItem getField(String name) {
        return this.item.getField(name);
    }

    @Override
    public List<DataItem> getFields() {
        return this.item.getFields();
    }

    @Override
    public List<DataItem> getDeclaredFields() {
        return this.item.getDeclaredFields();
    }

    @Override
    void clearChildren(TreePath treePath) {
        this.vChildren = null;
        this.item.clearChildren(treePath);
    }

    @Override
    public boolean canViewWhole() {
        return this.item.canViewWhole();
    }

    @Override
    public void viewWhole() {
        this.item.viewWhole();
    }

    @Override
    int canUseToStringForValue() {
        return this.item.canUseToStringForValue();
    }

    @Override
    void toggleUseToString() {
        this.item.toggleUseToString();
    }

    @Override
    public String canViewAnnotations() {
        return this.item.canViewAnnotations();
    }

    @Override
    public void viewAnnotations(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        this.item.viewAnnotations(debuggingProcess, vm, thread, frame);
    }

    @Override
    public boolean canViewAnnotationsForClass() {
        return this.item.canViewAnnotationsForClass();
    }

    @Override
    public void viewAnnotationsForClass(DebuggingProcess debuggingProcess, DebugVirtualMachine vm, DebugThreadInfo thread, DebugStackFrameInfo frame) {
        this.item.viewAnnotationsForClass(debuggingProcess, vm, thread, frame);
    }

    @Override
    public boolean canToggleValue() {
        return this.item.canToggleValue();
    }

    @Override
    public void toggleValue() {
        this.expire();
        this.item.toggleValue();
    }

    @Override
    public boolean canModifyValue() {
        return this.item.canModifyValue();
    }

    @Override
    public void modifyValue(DebugVirtualMachine vm) {
        this.expire();
        this.item.modifyValue(vm);
    }

    @Override
    DataFlavor[] canDrag(TreePath treePath) {
        return this.item.canDrag(treePath);
    }

    @Override
    boolean canDiagram(TreePath treePath) {
        return this.item.canDiagram(treePath);
    }

    @Override
    public boolean canWatchAndInspect(TreePath treePath) {
        return this.item.canWatchAndInspect(treePath);
    }

    @Override
    protected boolean prepareExpression(Object[] path, int i, Expression expression) {
        return this.item.prepareExpression(path, i, expression);
    }

    @Override
    void watch(TreePath treePath) {
        this.item.watch(treePath);
    }

    @Override
    public void watch(TreePath treePath, String displayName) {
        this.item.watch(treePath, displayName);
    }

    @Override
    void inspect(TreePath treePath) {
        this.item.inspect(treePath, null);
    }

    @Override
    public void inspect(TreePath treePath, String displayName) {
        this.item.inspect(treePath, displayName);
    }

    @Override
    public boolean canWatchInspectClassLoader() {
        return this.item.canWatchInspectClassLoader();
    }

    @Override
    public void watchClassLoader(DebuggingProcess debuggingProcess) {
        this.item.watchClassLoader(debuggingProcess);
    }

    @Override
    public void inspectClassLoader(DebuggingProcess debuggingProcess) {
        this.item.inspectClassLoader(debuggingProcess);
    }

    @Override
    public String canShowSource(int cmdId) {
        return this.item.canShowSource(cmdId);
    }

    @Override
    public void showSource(int cmdId, DebuggingProcess debuggingProcess) {
        this.item.showSource(cmdId, debuggingProcess);
    }

    @Override
    long getAddressOfObject() {
        return this.item.getAddressOfObject();
    }

    @Override
    protected boolean shouldSkipField(DebugFieldInfo field) {
        return this.item.shouldSkipField(field);
    }

    @Override
    public void setIsExpanded(boolean value) {
        this.item.setIsExpanded(value);
    }

    @Override
    boolean isExpanded() {
        return this.item.isExpanded();
    }

    @Override
    boolean canGuaranteeFastEvaluation() {
        return this.item.canGuaranteeFastEvaluation();
    }

    static enum Change {
        NEW,
        ADDED,
        REMOVED,
        CHANGED,
        UNCHANGED;

    }
}

