/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.util.ImmInsets;

public class StandardGridKeyHandler
implements GridKeyHandler {
    private boolean _tabAsArrow;
    private static StandardGridKeyHandler _sManager;
    private static StandardGridKeyHandler _sTabManager;

    protected StandardGridKeyHandler() {
        this(false);
    }

    protected StandardGridKeyHandler(boolean treatTabAsArrow) {
        this._tabAsArrow = treatTabAsArrow;
    }

    public static GridKeyHandler getGridKeyHandler() {
        if (_sManager == null) {
            _sManager = new StandardGridKeyHandler();
        }
        return _sManager;
    }

    public static GridKeyHandler getGridKeyTabHandler() {
        if (_sTabManager == null) {
            _sTabManager = new StandardGridKeyHandler(true);
        }
        return _sTabManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleKeyEvent(Grid grid, KeyEvent keyEvent) {
        if (keyEvent.isAltDown()) {
            return;
        }
        GridSelectionManager selection = grid.getGridSelectionManager();
        Cell focusCell = grid.getFocusCell();
        Cell newFocusCell = null;
        Cell anchorCell = grid.getAnchorCell();
        boolean toggleCell = false;
        boolean control = keyEvent.isControlDown();
        boolean shift = keyEvent.isShiftDown();
        int id = keyEvent.getID();
        boolean shouldScroll = true;
        if (id == 401) {
            switch (keyEvent.getKeyCode()) {
                case 10: {
                    newFocusCell = this.enter(grid, focusCell, keyEvent, shift);
                    break;
                }
                case 40: {
                    newFocusCell = this.down(grid, focusCell, keyEvent);
                    break;
                }
                case 38: {
                    newFocusCell = this.up(grid, focusCell, keyEvent);
                    break;
                }
                case 9: {
                    if (shift) {
                        newFocusCell = this.left(grid, focusCell, keyEvent);
                        break;
                    }
                    newFocusCell = this.right(grid, focusCell, keyEvent);
                    break;
                }
                case 37: {
                    newFocusCell = this.left(grid, focusCell, keyEvent);
                    break;
                }
                case 39: {
                    newFocusCell = this.right(grid, focusCell, keyEvent);
                    break;
                }
                case 35: {
                    newFocusCell = this.end(grid, focusCell, keyEvent);
                    break;
                }
                case 36: {
                    newFocusCell = this.home(grid, focusCell, keyEvent);
                    break;
                }
                case 34: {
                    newFocusCell = this.pageDown(grid, focusCell, keyEvent);
                    grid.setFirstRowOnScreen(newFocusCell.row);
                    keyEvent.consume();
                    shouldScroll = false;
                    break;
                }
                case 33: {
                    newFocusCell = this.pageUp(grid, focusCell, keyEvent);
                    grid.setLastRowOnScreen(newFocusCell.row);
                    keyEvent.consume();
                    shouldScroll = false;
                    break;
                }
                case 32: {
                    if (!keyEvent.isControlDown()) break;
                    toggleCell = true;
                    newFocusCell = focusCell;
                }
            }
        }
        if (!toggleCell && (newFocusCell == null || focusCell != null && newFocusCell.column == focusCell.column && newFocusCell.row == focusCell.row)) {
            return;
        }
        keyEvent.consume();
        grid.freezeRepaints();
        try {
            if (toggleCell) {
                TwoDSelection newsel = new TwoDSelection(null, null, newFocusCell);
                if (selection.getSelection().containsCell(newFocusCell)) {
                    selection.removeSelection(newsel);
                } else {
                    selection.addSelection(newsel);
                }
                grid.setAnchorCell(newFocusCell.column, newFocusCell.row);
            } else if (shift && anchorCell != null) {
                TwoDSelection newsel = grid.getModelRangeSelection(newFocusCell.column, newFocusCell.row, anchorCell.column, anchorCell.row);
                if (control) {
                    selection.addSelection(newsel);
                } else {
                    selection.setSelection(newsel, newFocusCell);
                }
            } else if (!control) {
                TwoDSelection newsel = new TwoDSelection(null, null, newFocusCell);
                selection.setSelection(newsel, newFocusCell);
                grid.setAnchorCell(newFocusCell.column, newFocusCell.row);
            }
            grid.requestFocus(newFocusCell.column, newFocusCell.row, keyEvent);
        }
        catch (PropertyVetoException propertyVetoException) {
        }
        finally {
            grid.unfreezeRepaints();
        }
        if (shouldScroll) {
            grid.scrollCellIntoView(newFocusCell.column, newFocusCell.row);
        }
    }

    protected Cell enter(Grid grid, Cell focusCell, KeyEvent e, boolean shiftDown) {
        grid.commitCellEdit();
        if (shiftDown) {
            return this.up(grid, focusCell, e);
        }
        return this.down(grid, focusCell, e);
    }

    protected Cell left(Grid grid, Cell focusCell, KeyEvent e) {
        int focusColumn;
        int focusRow;
        e.consume();
        if (focusCell == null) {
            focusRow = grid.getNextVisibleRow(-1);
            focusColumn = grid.getNextVisibleColumn(-1);
        } else {
            focusRow = focusCell.row;
            focusColumn = grid.getPreviousVisibleColumn(focusCell.column);
        }
        if (focusColumn == -1) {
            return focusCell;
        }
        return new Cell(focusColumn, focusRow);
    }

    protected Cell right(Grid grid, Cell focusCell, KeyEvent e) {
        int focusColumn;
        int focusRow;
        e.consume();
        if (focusCell == null) {
            focusRow = grid.getNextVisibleRow(-1);
            focusColumn = grid.getNextVisibleColumn(-1);
        } else {
            focusRow = focusCell.row;
            focusColumn = grid.getNextVisibleColumn(focusCell.column);
        }
        if (focusColumn == -1) {
            return focusCell;
        }
        return new Cell(focusColumn, focusRow);
    }

    protected Cell up(Grid grid, Cell focusCell, KeyEvent e) {
        int focusColumn;
        int focusRow;
        e.consume();
        if (focusCell == null) {
            focusRow = grid.getNextVisibleRow(-1);
            focusColumn = grid.getNextVisibleColumn(-1);
        } else {
            focusRow = grid.getPreviousVisibleRow(focusCell.row);
            focusColumn = focusCell.column;
        }
        if (focusRow == -1) {
            return focusCell;
        }
        return new Cell(focusColumn, focusRow);
    }

    protected Cell down(Grid grid, Cell focusCell, KeyEvent e) {
        int focusColumn;
        int focusRow;
        e.consume();
        if (focusCell == null) {
            focusRow = grid.getNextVisibleRow(-1);
            focusColumn = grid.getNextVisibleColumn(-1);
        } else {
            focusRow = grid.getNextVisibleRow(focusCell.row);
            focusColumn = focusCell.column;
        }
        if (focusRow == -1) {
            return focusCell;
        }
        return new Cell(focusColumn, focusRow);
    }

    protected Cell pageUp(Grid grid, Cell focusCell, KeyEvent e) {
        int temp;
        int oldLastRow;
        int focusColumn;
        int focusRow;
        e.consume();
        if (focusCell == null) {
            focusRow = grid.getNextVisibleRow(-1);
            focusColumn = grid.getNextVisibleColumn(-1);
        } else {
            focusRow = focusCell.row;
            focusColumn = focusCell.column;
        }
        if (focusRow <= 0) {
            return focusCell;
        }
        if (-grid.getCanvasOriginY() == 0) {
            return new Cell(focusColumn, grid.getNextVisibleRow(-1));
        }
        int newCanvasY = -grid.getCanvasOriginY() - grid.getInnerHeight();
        focusRow = grid.getRowAt(-grid.getCanvasOriginY() - 1);
        boolean adjustFocusRow = false;
        if (newCanvasY < 0 && grid.getRowPosition(focusRow = grid.getRowAt(grid.getInnerHeight() - 1)) + grid.getRowHeight(focusRow) > grid.getInnerHeight()) {
            adjustFocusRow = true;
        }
        if (!adjustFocusRow && (oldLastRow = grid.getRowAt(-grid.getCanvasOriginY() + grid.getInnerHeight() - 1)) == focusRow) {
            adjustFocusRow = true;
        }
        if (adjustFocusRow && (temp = grid.getPreviousVisibleRow(focusRow)) != -1) {
            focusRow = temp;
        }
        return new Cell(focusColumn, focusRow);
    }

    protected Cell pageDown(Grid grid, Cell focusCell, KeyEvent e) {
        int temp;
        int oldFirstRow;
        int focusColumn;
        int focusRow;
        e.consume();
        if (focusCell == null) {
            focusRow = grid.getNextVisibleRow(-1);
            focusColumn = grid.getNextVisibleColumn(-1);
        } else {
            focusRow = focusCell.row;
            focusColumn = focusCell.column;
        }
        if (focusRow < 0 || focusRow == grid.getRowCount() - 1) {
            return focusCell;
        }
        int delta = grid.getInnerHeight();
        int newCanvasY = -grid.getCanvasOriginY() + delta;
        focusRow = grid.getRowAt(newCanvasY);
        boolean adjustFocusRow = false;
        if (-grid.getCanvasOriginY() + grid.getInnerHeight() + delta > grid.getCanvasHeight()) {
            ImmInsets insets = grid.getBorderInsets();
            delta = grid.getCanvasHeight() - insets.top - insets.bottom - (-grid.getCanvasOriginY() + grid.getInnerHeight());
            if (delta == 0) {
                return new Cell(focusColumn, grid.getPreviousVisibleRow(grid.getRowCount()));
            }
            newCanvasY = -grid.getCanvasOriginY() + delta;
            focusRow = grid.getRowAt(newCanvasY);
            if (grid.getRowPosition(focusRow) < newCanvasY) {
                adjustFocusRow = true;
            }
        }
        if (!adjustFocusRow && (oldFirstRow = grid.getRowAt(-grid.getCanvasOriginY())) == focusRow) {
            adjustFocusRow = true;
        }
        if (adjustFocusRow && (temp = grid.getNextVisibleRow(focusRow)) != -1) {
            focusRow = temp;
        }
        return new Cell(focusColumn, focusRow);
    }

    protected Cell home(Grid grid, Cell focusCell, KeyEvent e) {
        e.consume();
        int rindex = grid.getNextVisibleRow(-1);
        if (focusCell == null || focusCell.row == rindex) {
            return focusCell;
        }
        return new Cell(focusCell.column, rindex);
    }

    protected Cell end(Grid grid, Cell focusCell, KeyEvent e) {
        e.consume();
        int rows = grid.getRowCount();
        int rindex = grid.getPreviousVisibleRow(rows);
        if (focusCell == null || focusCell.row == rindex) {
            return focusCell;
        }
        return new Cell(focusCell.column, rindex);
    }

    boolean __isTabAsAroow() {
        return this._tabAsArrow;
    }
}

