/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.worker;

import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.bali.ewt.event.PropertyChanger;
import oracle.bali.ewt.model.ObjectModel;
import oracle.bali.ewt.worker.CanceledException;
import oracle.bali.ewt.worker.InvocationContext;
import oracle.bali.ewt.worker.Worker;
import oracle.bali.ewt.worker.WorkerQueue;
import oracle.bali.ewt.worker.WorkerStatusListener;
import oracle.bali.ewt.worker.WorkerUtils;
import oracle.bali.share.collection.CompoundEnumeration;
import oracle.bali.share.collection.SingleItemEnumeration;
import oracle.bali.share.event.ListenerManager;
import oracle.bali.share.util.BooleanUtils;

public abstract class AbstractWorkerQueue
implements WorkerQueue {
    private static final int _STATE_QUEUED = 0;
    private static final int _STATE_RUNNING = 1;
    private static final int _STATE_COMPLETED = 2;
    private static final int _DEBUG_OUTPUT_NONE = 0;
    private static final int _DEBUG_OUTPUT_FAILURES = 1;
    private static final int _DEBUG_OUTPUT_VERBOSE = 2;
    private static final int _DEBUG_OUTPUT_LEVEL = 0;
    ListenerManager __statusListeners;
    private PropertyChanger _propertyChanger;
    private int _queueRefCount = 0;

    protected AbstractWorkerQueue() {
    }

    @Override
    public abstract boolean isInWorkerQueueThread();

    @Override
    public final InvocationContext invokeLater(Worker queuedWorker, Dictionary parameters, WorkerStatusListener listener) {
        return this._queueWorker(queuedWorker, parameters, false, listener);
    }

    @Override
    public final InvocationContext invokeAndWait(Worker waitingWorker, Dictionary parameters, WorkerStatusListener listener) {
        return this._queueWorker(waitingWorker, parameters, true, listener);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertyChanger == null) {
            this._propertyChanger = new PropertyChanger(this);
        }
        this._propertyChanger.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this._propertyChanger.removePropertyChangeListener(listener);
    }

    @Override
    public synchronized void addWorkerStatusListener(WorkerStatusListener listener) {
        if (this.__statusListeners == null) {
            this.__statusListeners = new ListenerManager();
        }
        this.__statusListeners.addListener((EventListener)listener);
    }

    @Override
    public synchronized void removeWorkerStatusListener(WorkerStatusListener listener) {
        this.__statusListeners.removeListener((EventListener)listener);
    }

    @Override
    public final boolean isBusy() {
        return this._queueRefCount > 0;
    }

    protected abstract void invokeLater(Runnable var1);

    protected abstract void invokeAndWait(Runnable var1) throws InterruptedException, Throwable;

    static InvocationContext __runWorkerImmediately(Worker runnableWorker, Dictionary parameters, WorkerStatusListener listener) {
        WorkerContext tempContext = new WorkerContext(runnableWorker, parameters, listener, false, null);
        SingleItemEnumeration singleListener = null;
        if (listener != null) {
            listener.workerPrepared(tempContext);
            singleListener = new SingleItemEnumeration((Object)listener);
        }
        AbstractWorkerQueue._runWorker(tempContext, singleListener, null);
        return tempContext;
    }

    private static void _runWorker(InvocationContext invokeContext, Enumeration listeners, Throwable failureCause) {
        WorkerStatusListener currListener;
        Vector<WorkerStatusListener> listenersStore = null;
        if (listeners != null) {
            listenersStore = new Vector<WorkerStatusListener>(7);
            while (listeners.hasMoreElements()) {
                currListener = (WorkerStatusListener)listeners.nextElement();
                listenersStore.addElement(currListener);
            }
        }
        if (failureCause == null) {
            try {
                Worker runnableWorker = invokeContext.getWorker();
                if (!runnableWorker.isEnabled()) {
                    throw new IllegalStateException("Attempt to run disabled Worker:" + runnableWorker);
                }
                if (listenersStore != null) {
                    listeners = listenersStore.elements();
                    while (listeners.hasMoreElements()) {
                        currListener = (WorkerStatusListener)listeners.nextElement();
                        currListener.workerPrerun(invokeContext);
                    }
                }
                Object result = runnableWorker.run(invokeContext);
                invokeContext.putValue(InvocationContext.RESULT, result);
                if (listenersStore != null) {
                    listeners = listenersStore.elements();
                    while (listeners.hasMoreElements()) {
                        currListener = (WorkerStatusListener)listeners.nextElement();
                        currListener.workerSucceeded(invokeContext);
                    }
                }
            }
            catch (Throwable e) {
                failureCause = e;
            }
        }
        if (failureCause != null) {
            if (failureCause instanceof CanceledException) {
                AbstractWorkerQueue._setCanceled(invokeContext, true);
            }
            invokeContext.putValue(InvocationContext.FAILURE_CAUSE, failureCause);
            AbstractWorkerQueue._printWorkerFailure(invokeContext.getWorker(), failureCause);
            if (listenersStore != null) {
                listeners = listenersStore.elements();
                while (listeners.hasMoreElements()) {
                    currListener = (WorkerStatusListener)listeners.nextElement();
                    currListener.workerFailed(invokeContext);
                }
            }
        }
    }

    private InvocationContext _queueWorker(Worker runnableWorker, Dictionary parameters, boolean wait, WorkerStatusListener statusListener) {
        Enumeration listeners;
        WorkerContext invokeContext = new WorkerContext(runnableWorker, parameters, statusListener, wait, this);
        this._workerQueued(runnableWorker);
        if (this.__statusListeners != null && (listeners = this.__statusListeners.getListeners()) != null) {
            while (listeners.hasMoreElements()) {
                WorkerStatusListener currListener = (WorkerStatusListener)listeners.nextElement();
                currListener.workerPrepared(invokeContext);
            }
        }
        if (statusListener != null) {
            statusListener.workerPrepared(invokeContext);
        }
        if (wait) {
            try {
                this.invokeAndWait(invokeContext);
            }
            catch (Throwable e) {
                Enumeration listeners2;
                AbstractWorkerQueue._printWorkerFailure(runnableWorker, e);
                invokeContext.putValue(WorkerContext.FAILURE_CAUSE, e);
                if (this.__statusListeners != null && (listeners2 = this.__statusListeners.getListeners()) != null) {
                    while (listeners2.hasMoreElements()) {
                        WorkerStatusListener currListener = (WorkerStatusListener)listeners2.nextElement();
                        currListener.workerFailed(invokeContext);
                    }
                }
                if (statusListener != null) {
                    statusListener.workerFailed(invokeContext);
                }
                this.__workerCompleted(runnableWorker);
            }
        } else {
            this.invokeLater(invokeContext);
        }
        return invokeContext;
    }

    private void _workerQueued(Worker worker) {
        if (this._queueRefCount == 0 && this._propertyChanger != null) {
            this._propertyChanger.firePropertyChange("Busy", true);
        }
        ++this._queueRefCount;
    }

    void __workerCompleted(Worker worker) {
        --this._queueRefCount;
        if (this._queueRefCount == 0 && this._propertyChanger != null) {
            this._propertyChanger.firePropertyChange("Busy", false);
        }
    }

    private static void _debugPrint(String output, int debugLevel) {
        if (debugLevel <= 0) {
            System.out.println(output);
        }
    }

    private static void _printWorkerFailure(Worker worker, Throwable e) {
        int debugLevel;
        int n = debugLevel = e instanceof CanceledException ? 2 : 1;
        if (debugLevel <= 0) {
            System.err.println(worker.getValue(Worker.WORKER_COMMAND) + " failed with exception:" + e);
            e.printStackTrace(System.err);
        }
    }

    private static void _setCanceled(InvocationContext context, boolean isCanceled) {
        context.putValue(InvocationContext.CANCELED, BooleanUtils.getBoolean((boolean)isCanceled));
    }

    private static class WorkerContext
    implements Runnable,
    InvocationContext {
        private Worker _worker;
        private WorkerStatusListener _listener;
        private boolean _blocks;
        private boolean _cancelRequested;
        private int _runningState = 0;
        private Dictionary _parameters;
        private AbstractWorkerQueue _queue;

        public WorkerContext(Worker runnableWorker, Dictionary parameters, WorkerStatusListener listener, boolean blocks, AbstractWorkerQueue queue) {
            if (runnableWorker == null) {
                throw new IllegalArgumentException();
            }
            if (parameters == null) {
                throw new IllegalArgumentException();
            }
            this._worker = runnableWorker;
            this._parameters = parameters;
            this._listener = listener;
            this._blocks = blocks;
            this._queue = queue;
            if (WorkerUtils.getQueueLocationsSaved()) {
                this.putValue(InvocationContext.QUEUE_LOCATION, new Throwable());
            }
            AbstractWorkerQueue._setCanceled(this, false);
        }

        @Override
        public Worker getWorker() {
            return this._worker;
        }

        @Override
        public WorkerQueue getWorkerQueue() {
            return this._queue;
        }

        @Override
        public void putValue(Object key, Object value) {
            if (value == null) {
                value = WorkerUtils.PARAMETER_NULL;
            } else if (value == UNDEFINED) {
                value = null;
            }
            this._parameters.put(key, value);
        }

        private Object _getValue(Object key) {
            InvocationContext parentContext;
            Object value = this._parameters.get(key);
            if (value == null) {
                value = UNDEFINED;
            }
            if (value == WorkerUtils.PARAMETER_NULL) {
                value = null;
            } else if (value instanceof ObjectModel) {
                value = ((ObjectModel)value).getObject();
            }
            if (value == UNDEFINED) {
                value = this._worker.getDefaultParameterValue(key);
            }
            if (value == UNDEFINED && !PARENT_CONTEXT.equals(key) && (parentContext = (InvocationContext)this.getValue(PARENT_CONTEXT, null)) != null) {
                value = parentContext.getValue(key, UNDEFINED);
            }
            return value;
        }

        @Override
        public Object getValue(Object key, Object defaultValue) {
            Object result = this._getValue(key);
            if (UNDEFINED == result) {
                return defaultValue;
            }
            return result;
        }

        @Override
        public synchronized boolean cancel() {
            this._cancelRequested = true;
            return this._runningState == 0;
        }

        @Override
        public boolean isCancelRequested() {
            return this._cancelRequested;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object failureCaouse = null;
            WorkerContext workerContext = this;
            synchronized (workerContext) {
                if (this._cancelRequested) {
                    this._runningState = 2;
                }
            }
            this._runMaybeBlocked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _runMaybeBlocked() {
            if (this._blocks) {
                WorkerContext workerContext = this;
                synchronized (workerContext) {
                    this._run();
                    this.notify();
                }
            } else {
                this._run();
            }
        }

        private void _run() {
            CanceledException failureCause = null;
            if (this._runningState == 2) {
                failureCause = new CanceledException(this._worker);
            } else {
                this._runningState = 1;
            }
            Enumeration listeners = null;
            if (this._queue.__statusListeners != null) {
                listeners = this._queue.__statusListeners.getListeners();
            }
            if (this._listener != null) {
                SingleItemEnumeration singleEnum = new SingleItemEnumeration((Object)this._listener);
                listeners = listeners != null ? new CompoundEnumeration(listeners, (Enumeration)singleEnum) : singleEnum;
            }
            AbstractWorkerQueue._runWorker(this, listeners, failureCause);
            this._runningState = 2;
            this._queue.__workerCompleted(this._worker);
        }
    }
}

