/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.SoftBevelBorder;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.palette.Invokable;
import oracle.ide.palette.PaletteEvent;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteTransferable;
import oracle.ideimpl.palette.PaletteController;
import oracle.ideimpl.palette.PaletteItemImpl;
import oracle.javatools.util.PlatformUtils;

public class PaletteItemUI
extends JButton
implements MouseListener,
ActionListener,
KeyListener,
DragSourceListener,
DragGestureListener,
Observer {
    private final PaletteController _controller = PaletteController.getInstance();
    private PaletteItemImpl _item;
    private Icon _icon;
    private String _itemLabel;
    private Border _defaultBorder;
    private Color _defaultBackground;
    private Color _defaultForeground;
    private String _type;
    private DragSource _dragSource;
    private boolean _selected = false;
    boolean ignoreMouseReleased = false;
    private Object _droppedObject = null;
    private static final boolean macosxDisableDnD = PlatformUtils.isMac() && !PlatformUtils.isAtLeastMacTiger();

    public PaletteItemUI(PaletteItemImpl item) {
        this._item = item;
        if (this._item.getItem() != null) {
            this._type = this._item.getItem().getType();
        }
        this._item.attach(this);
        this._icon = item.getIcon();
        this._itemLabel = item.getShortLabel();
        this.setContentAreaFilled(false);
        this._decorate();
        if (this._icon != null) {
            this.setIcon(this._icon);
            if (this.getAccessibleContext().getAccessibleIcon()[0] != null && this._itemLabel != null) {
                this.getAccessibleContext().getAccessibleIcon()[0].setAccessibleIconDescription(this._itemLabel);
                this.getAccessibleContext().setAccessibleName(this._itemLabel);
                this.getAccessibleContext().setAccessibleDescription(this._itemLabel);
            }
        }
        this._defaultBackground = this.getBackground();
        this._defaultForeground = this.getForeground();
        this._defaultBorder = BorderFactory.createLineBorder(this._defaultBackground, 3);
        this.setBorder(this._defaultBorder);
        this.setRequestFocusEnabled(false);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JViewport viewport;
                Rectangle visRect;
                PaletteItemUI.this.setBorder(new SoftBevelBorder(0));
                Component comp = (Component)e.getSource();
                Rectangle compRect = comp.getBounds();
                Container parObj = comp.getParent();
                Container gparObj = ((Component)parObj).getParent();
                if (gparObj instanceof JViewport && !(visRect = (viewport = (JViewport)gparObj).getViewRect()).contains(compRect)) {
                    viewport.setViewPosition(new Point(compRect.x, compRect.y));
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                PaletteItemUI.this.setBorder(PaletteItemUI.this._defaultBorder);
            }
        });
        this._dragSource = new DragSource();
        this._dragSource.createDefaultDragGestureRecognizer(this, 1, this);
    }

    public void detach() {
        this._item.detach(this);
    }

    public PaletteItemImpl getItem() {
        return this._item;
    }

    public PaletteItem getPaletteItem() {
        return this._item;
    }

    public void setItem(PaletteItemImpl item) {
        this._item = item;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getItem().isPointer()) {
            this.hideAll();
            this._controller.getPalette().setActiveItem(this._item);
            if (this._controller.getStickyMode()) {
                this._controller.setStickyMode(false);
            }
            this._controller.fireItemPressed();
        }
    }

    protected void handleItem() {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor != null && editor.getContext() != null && editor.getContext().getNode() != null && editor.getContext().getNode().isReadOnly() && !this.getItem().isPointer()) {
            return;
        }
        this._controller.getPalette().setActiveItem(this._item);
        this._controller.fireItemPressed();
        if (this.getItem().isPointer()) {
            if (this._controller.getStickyMode()) {
                this._controller.setStickyMode(false);
            }
        } else {
            try {
                this.invoke();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            boolean isWeb = this.isWebBased();
            if (isWeb) {
                this._controller.reset();
            }
        }
    }

    private void invoke() throws Exception {
        Invokable invoke = (Invokable)Class.forName("oracle.jdevimpl.palette.PaletteProxy").newInstance();
        invoke.invoke(this._controller.getPaletteWindow().getContext(), new String[0]);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if ((e.isShiftDown() || e.getClickCount() == 2) && !this.isWebBased()) {
            this._controller.setStickyMode(true);
            if (!this.getItem().isPointer()) {
                this.showStickyMode();
            }
        } else if (!e.isPopupTrigger() && !this.ignoreMouseReleased) {
            this.handleItem();
            this._controller.setStickyMode(false);
        } else {
            this._tryPopup(e);
            this.showAsUnselected();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.getModifiers() == 16) {
            return;
        }
        if (!this.isSelected() && e.getClickCount() == 0) {
            this.setBorder(new SoftBevelBorder(0));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.getModifiers() == 16) {
            return;
        }
        if (!this.isSelected()) {
            this.setBackground(this._defaultBackground);
            this.setForeground(this._defaultForeground);
            this.setBorder(this._defaultBorder);
            this.showEnabled();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.hideAll();
        this.showSelectedMode();
        this._controller.getPalette().setActiveItem(this._item);
        this.ignoreMouseReleased = e.isPopupTrigger();
        this._tryPopup(e);
    }

    private void _tryPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this._setActivePage();
            this._controller.getPaletteUI().setActivePaletteItemUI(this);
            this._controller.getPalette().setActiveItem(this._item);
            this._controller.tryPopup(e);
        }
    }

    private void showEnabled() {
        Enumeration<AbstractButton> elemEnum = this._controller.getPaletteUI().getButtonGroup().getElements();
        while (elemEnum.hasMoreElements()) {
            PaletteItemUI b = (PaletteItemUI)elemEnum.nextElement();
            if (!b.isSelected()) continue;
        }
    }

    public void hideAll() {
        ArrayList getResetButton = this._controller.getPaletteUI().getActiveIconPanel().getIconList();
        for (PaletteItemUI b : getResetButton) {
            b.showAsUnselected();
        }
    }

    public void showLabel(boolean showLabel) {
        if (showLabel) {
            this.setText(this._itemLabel);
        } else {
            this.setText("");
        }
        this.getAccessibleContext().setAccessibleDescription(this._itemLabel);
    }

    public boolean isWebBased() {
        if (this._type != null) {
            return this._type.equals("jsptag") || this._type.equals("XsqlTag") || this._type.equals("html") || this._type.equals("jsp");
        }
        return false;
    }

    private final void _decorate() {
        this.setVerticalTextPosition(0);
        this.setHorizontalAlignment(2);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.setToolTipText(this._getToolText());
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        int x = (int)this.getAlignmentX();
        int y = (int)this.getAlignmentY();
        return new Point(x, y + 50);
    }

    private String _getToolText() {
        String toolTip = "";
        toolTip = this._item != null && this._item.getItem() != null && this._item.getItem().getType().equals("jsptag") && this._item.getItem().getInfo() != null ? this._item.getItem().getInfo() + ":" + this._itemLabel : (this._item != null && this._item.getItem() != null && this._item.getItem().getType().equals("html") ? this._item.getItem().getInfo() : (this._item != null && this._item.getItem() != null && this._item.getItem().getType().equals("JavaBean") ? this._item.getItem().getLongLabel() : (this._item != null && this._item.getItem() != null ? this._item.getItem().getLongLabel() : this._itemLabel)));
        return toolTip;
    }

    private final void _setActivePage() {
        String activePageName = (String)this._controller.getPaletteUI().getPageComboBox().getSelectedItem();
        this._controller.getPalette().setActivePage(this._controller.getPalette().getPalettePage(activePageName));
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.setSelected(true);
            this.handleItem();
            this.setBorder(this._defaultBorder);
            this._controller.getPaletteWindow().fireDefaultCreate(new PaletteEvent(this._controller.getPalette(), "CREATE_DEFAULT"));
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void showSelectedMode() {
        this.setSelected(true);
        this.setBorder(new SoftBevelBorder(1));
        this._controller.getPaletteUI().requestFocus();
    }

    public void showStickyMode() {
        this.hideAll();
        this.setSelected(true);
        this.setBorder(new SoftBevelBorder(1));
        this.setBackground(new Color(213, 218, 222));
        this._controller.getPalette().setActiveItem(this._item);
        this._controller.fireItemPressed();
    }

    public void showAsUnselected() {
        this.setSelected(false);
        this.setBorder(this._defaultBorder);
        this.setBackground(this._defaultBackground);
        this._controller.fireItemUnPressed();
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
        this._controller.getPaletteUI().setActivePaletteItemUI(this);
        this._controller.getPalette().setActiveItem(this._item);
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
        if (event.getDropSuccess()) {
            Context context = this._controller.getPaletteWindow().getContext();
            Element[] elems = new Element[]{this._item};
            context.setSelection(elems);
            if (this._item.getPaletteInvokable() != null) {
                this._item.getPaletteInvokable().configure(context);
            }
            if (this._droppedObject != null && this._droppedObject instanceof PaletteTransferable) {
                ((PaletteTransferable)this._droppedObject).postConfigure(context);
            }
        } else {
            this.ignoreMouseReleased = true;
        }
        this._controller.reset();
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        PaletteItemImpl impl;
        Transferable trans;
        if (!this._controller.getPalette().getActivePage().getDraggable() || this.getItem().isPointer() || macosxDisableDnD) {
            return;
        }
        boolean rightClick = false;
        InputEvent triggerEvent = dge.getTriggerEvent();
        if (4 == triggerEvent.getModifiers() || 8 == triggerEvent.getModifiers()) {
            rightClick = true;
        }
        if ((trans = (impl = this._item).getTrans(rightClick, triggerEvent)) != null) {
            this._droppedObject = trans;
            this._dragSource.startDrag(dge, null, trans, this);
        } else {
            this._droppedObject = null;
            this._dragSource.startDrag(dge, null, this._item, this);
        }
    }

    @Override
    public void setSelected(boolean selected) {
        this._selected = selected;
    }

    @Override
    public boolean isSelected() {
        return this._selected;
    }

    public void update(Object observed, UpdateMessage change) {
        PaletteItemImpl item = (PaletteItemImpl)observed;
        this.setVisible(item.canShow());
        this.repaint();
    }
}

