/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import oracle.ide.db.execute.DBRequestProcessor;
import oracle.ide.db.execute.DBRequestProcessorFactory;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.model.Element;
import oracle.ideimpl.db.explorer.ErrorSupport;
import oracle.ideimpl.db.explorer.model.DBObjectFolderFactory;
import oracle.ideimpl.db.explorer.model.PlSqlErrorElement;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.plsql.PlSqlSourceObject;
import oracle.javatools.db.plsql.PlSqlUtil;
import oracle.javatools.db.plsql.parser.PlSqlParser;

class DBErrorSupport
extends ErrorSupport.ErrorProvider {
    DBErrorSupport() {
    }

    @Override
    public void update(DBObjectNode dBObjectNode, final Element element) {
        BaseDBObjectTextNode baseDBObjectTextNode;
        SourceObject sourceObject;
        if (dBObjectNode instanceof BaseDBObjectTextNode && (sourceObject = (baseDBObjectTextNode = (BaseDBObjectTextNode)dBObjectNode).getDBObjectFromBuffer()) instanceof PlSqlSourceObject) {
            final DBObjectProvider dBObjectProvider = baseDBObjectTextNode.getProvider();
            DBRequestProcessor dBRequestProcessor = DBRequestProcessorFactory.getProcessor((DBObjectNode)baseDBObjectTextNode);
            String string = this.getClass().getSimpleName();
            DBRequestProcessor dBRequestProcessor2 = dBRequestProcessor;
            Objects.requireNonNull(dBRequestProcessor2);
            dBRequestProcessor.schedule(string, new DBRequestProcessor.DBRunnable(dBRequestProcessor2, dBObjectProvider, element.getShortLabel()){
                {
                    DBRequestProcessor dBRequestProcessor2 = dBRequestProcessor;
                    Objects.requireNonNull(dBRequestProcessor2);
                    super(dBRequestProcessor2, dBObjectProvider3, string);
                }

                protected void doWork() throws DBException {
                    PlSqlParser plSqlParser = PlSqlUtil.findOrCreateParser((PlSqlSourceObject)((PlSqlSourceObject)sourceObject), (DBObjectProvider)dBObjectProvider);
                    if (plSqlParser != null) {
                        ArrayList<PlSqlErrorElement> arrayList = null;
                        List list = plSqlParser.getIssues();
                        for (PlSqlParser.Issue issue : list) {
                            if (arrayList == null) {
                                arrayList = new ArrayList<PlSqlErrorElement>();
                            }
                            arrayList.add(new PlSqlErrorElement(dBObjectProvider, issue));
                        }
                        DBObjectFolderFactory.setErrors(element, arrayList);
                    }
                }
            }, 1500);
        }
    }
}

