/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.fcp.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.fcp.GlobalSearchDockable;
import oracle.dbtools.crest.fcp.SearchDockable;
import oracle.dbtools.crest.fcp.preferences.AbstractPP;
import oracle.dbtools.crest.fcp.preferences.SearchPreferences;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.search.SearchProfile;
import oracle.dbtools.crest.swingui.search.SearchProfilePropertiesDialog;
import oracle.dbtools.crest.swingui.search.SearchProfilesPersistence;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.Messages;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.panels.TraversableContext;

public class SearchPP
extends AbstractPP {
    private int cgCounter = 0;
    private JPanel pnMain;
    private JRadioButton rbSearchOnEnter;
    private JRadioButton rbSearchOnTyping;
    private JIntegerField txtSearchStartsStart;
    private List<SearchProfile> profilesList;
    private JTable profilesTable;
    private ProfilesTableModel profilesTableModel;
    private JButton btnRemove;
    private JButton btnProperties;
    private SearchProfilesPersistence persistence;
    private SearchProfile currentSearchProfile;
    private DefaultComboBoxModel cmbActiveModel;
    private JComboBox cmbActive;
    private ActiveCBItemListener activeCBItemListener;

    public SearchPP() {
        this.setHelpID("SEARCH_PANEL");
        this.pnMain = new JPanel(new GridBagLayout());
        this.add(this.pnMain, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel pnSimpleSearch = new JPanel(new GridBagLayout());
        pnSimpleSearch.setBorder(BorderFactory.createTitledBorder(Messages.getString("OptionsDialog.SimpleSearchOptions")));
        ButtonGroup searchTypeTypeGroup = new ButtonGroup();
        this.rbSearchOnEnter = new JRadioButton(Messages.getString("OptionsDialog.PressEnterToSearch"));
        this.rbSearchOnEnter.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SearchPP.this.txtSearchStartsStart.setEnabled(false);
                }
            }
        });
        this.rbSearchOnTyping = new JRadioButton(Messages.getString("OptionsDialog.SearchAsYouType"));
        this.rbSearchOnTyping.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    SearchPP.this.txtSearchStartsStart.setEnabled(true);
                }
            }
        });
        searchTypeTypeGroup.add(this.rbSearchOnEnter);
        searchTypeTypeGroup.add(this.rbSearchOnTyping);
        JPanel jp = new JPanel(new FlowLayout(0));
        JLabel label1 = new JLabel(Messages.getString("OptionsDialog.After"));
        label1.setBorder(new EmptyBorder(0, 20, 0, 0));
        this.txtSearchStartsStart = new JIntegerField(3, 2);
        this.txtSearchStartsStart.setText("3");
        this.addItem(jp, label1, 0, 0, 1, 1, 17, 0, 0);
        this.addItem(jp, this.txtSearchStartsStart, 1, 0, 1, 1, 17, 0, 0);
        this.addItem(pnSimpleSearch, this.rbSearchOnEnter, 0, 0, 1, 1, 17, 0, 100);
        this.addItem(pnSimpleSearch, new JLabel(""), 1, 0, 1, 1, 17, 1, 100);
        this.addItem(pnSimpleSearch, this.rbSearchOnTyping, 0, 1, 1, 1, 17, 0, 100);
        this.addItem(pnSimpleSearch, jp, 0, 2, 1, 1, 17, 1, 1);
        this.pnMain.add((Component)pnSimpleSearch, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.persistence = new SearchProfilesPersistence(this.getApplicationView());
        this.getApplicationView().loadSearchProfiles();
        this.initSearchProfiles();
    }

    private void initSearchProfiles() {
        JPanel pnSearchProfiles = new JPanel(new GridBagLayout());
        pnSearchProfiles.setBorder(BorderFactory.createTitledBorder(Messages.getString("SearchPP.SearchProfiles")));
        JButton btnAdd = new JButton(GUIConfiguration.getInstance().getIcon("ADD_ICON", 16));
        btnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        btnAdd.setEnabled(true);
        btnAdd.addActionListener(new AddAction());
        btnAdd.setMnemonic(65);
        btnAdd.setToolTipText(Messages.getString("SearchPP.Add"));
        JButton btnAddDirectory = new JButton(GUIConfiguration.getInstance().getIcon("DIRECTORIES_ICON", 16));
        btnAddDirectory.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        btnAddDirectory.setEnabled(true);
        btnAddDirectory.addActionListener(new AddDirectoryAction());
        btnAddDirectory.setMnemonic(68);
        btnAddDirectory.setToolTipText(Messages.getString("SearchPP.AddDirectory"));
        this.btnRemove = new JButton(GUIConfiguration.getInstance().getIcon("REMOVE_ICON", 16));
        this.btnRemove.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnRemove.setEnabled(false);
        this.btnRemove.addActionListener(new RemoveAction());
        this.btnRemove.setMnemonic(82);
        this.btnRemove.setToolTipText(Messages.getString("SearchPP.Remove"));
        this.btnProperties = new JButton(GUIConfiguration.getInstance().getIcon("PROPERTIES_ICON", 16));
        this.btnProperties.setPreferredSize(MessageDialogs.BUTTON_SIZE_SMALL);
        this.btnProperties.setEnabled(false);
        this.btnProperties.addActionListener(new ShowPropertiesAction());
        this.btnProperties.setMnemonic(83);
        this.btnProperties.setToolTipText(Messages.getString("SearchPP.Properties"));
        JLabel lblActive = new JLabel(Messages.getString("SearchPP.Active"));
        lblActive.setPreferredSize(new Dimension(60, 23));
        this.cmbActiveModel = new DefaultComboBoxModel();
        this.cmbActive = new JComboBox(this.cmbActiveModel);
        this.cmbActive.setRenderer(new ComboBoxRenderer());
        this.cmbActive.setPreferredSize(new Dimension(120, 23));
        this.cmbActive.setMinimumSize(new Dimension(120, 23));
        this.cmbActive.setMaximumSize(new Dimension(120, 23));
        this.cmbActive.requestFocus();
        this.activeCBItemListener = new ActiveCBItemListener();
        this.reloadActiveSearchProfileComboBox();
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(btnAdd);
        toolBar.add(btnAddDirectory);
        toolBar.add(this.btnRemove);
        toolBar.add(this.btnProperties);
        toolBar.addSeparator();
        toolBar.add(lblActive);
        toolBar.add(this.cmbActive);
        toolBar.add(Box.createHorizontalGlue());
        this.cmbActive.updateUI();
        this.profilesList = new ArrayList<SearchProfile>();
        this.profilesTableModel = new ProfilesTableModel();
        this.profilesTable = new JTable(this.profilesTableModel);
        this.profilesTable.setSelectionMode(0);
        this.profilesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SearchPP.this.profilesTable.getSelectedRow() == -1) {
                    SearchPP.this.btnRemove.setEnabled(false);
                    SearchPP.this.btnProperties.setEnabled(false);
                } else {
                    SearchPP.this.currentSearchProfile = SearchPP.this.profilesList.get(SearchPP.this.profilesTable.convertRowIndexToModel(SearchPP.this.profilesTable.getSelectedRow()));
                    SearchPP.this.btnRemove.setEnabled(true);
                    SearchPP.this.btnProperties.setEnabled(true);
                }
            }
        });
        this.profilesTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SearchProfilePropertiesDialog d = new SearchProfilePropertiesDialog(SearchPP.this.getApplicationView(), SearchPP.this.currentSearchProfile, SearchPP.this.persistence, SearchPP.this);
                    d.showDialog();
                }
            }
        });
        TableColumn col2 = this.profilesTable.getColumnModel().getColumn(2);
        col2.setCellRenderer(new ContentRenderer());
        JTableHeader header = this.profilesTable.getTableHeader();
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        JScrollPane sp = new JScrollPane(this.profilesTable);
        sp.setPreferredSize(new Dimension(300, 200));
        sp.setMinimumSize(new Dimension(300, 200));
        pnSearchProfiles.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, -1));
        pnSearchProfiles.add((Component)sp, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, -1));
        this.pnMain.add((Component)pnSearchProfiles, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void onEntry(TraversableContext tc) {
        this.rbSearchOnEnter.setSelected(!settings.isSearchAsUType());
        this.rbSearchOnTyping.setSelected(settings.isSearchAsUType());
        this.txtSearchStartsStart.setText(Integer.toString(settings.getSearchAsUTypeStart()));
        this.profilesList.clear();
        Iterator<SearchProfile> it = this.getApplicationView().getSearchProfiles().iterator();
        while (it.hasNext()) {
            this.profilesList.add(it.next());
        }
        this.profilesTable.updateUI();
    }

    public void onExit(TraversableContext tc) {
        SearchPreferences sp = this.getSearchPreferences(tc);
        settings.setSearchAsUType(this.rbSearchOnTyping.isSelected());
        settings.setSearchAsUTypeStart(Integer.parseInt(this.txtSearchStartsStart.getText()));
        sp.setSearchAsUType(this.rbSearchOnTyping.isSelected());
        sp.setSearchAsUTypeStart(Integer.parseInt(this.txtSearchStartsStart.getText()));
        List l = settings.getSearchProfilesPaths();
        l.clear();
        for (SearchProfile sProf : this.profilesList) {
            String path = sProf.getFilePath();
            if (l.contains(path)) continue;
            l.add(path);
        }
        sp.setSearchProfilesPaths(settings.getSearchProfilesPaths());
    }

    private SearchPreferences getSearchPreferences(TraversableContext tc) {
        return SearchPreferences.getInstance(tc.getPropertyStorage());
    }

    private String generateName() {
        String name = "SearchProfile";
        int newNumber = 0;
        int lastNumber = this.profilesList.size();
        if (lastNumber != 0) {
            newNumber = this.cgCounter = lastNumber + 1;
        } else {
            ++this.cgCounter;
            newNumber = this.cgCounter;
        }
        String nName = name.concat("_").concat(Integer.toString(newNumber));
        while (this.nameExistsInModel(nName)) {
            newNumber = ++this.cgCounter;
            nName = name.concat("_").concat(Integer.toString(newNumber));
        }
        return nName;
    }

    private boolean nameExistsInModel(String name) {
        for (int i = 0; i < this.profilesList.size(); ++i) {
            SearchProfile sp = this.profilesList.get(i);
            if (!sp.getFileName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void updateTable() {
        if (!this.profilesList.contains(this.currentSearchProfile)) {
            this.profilesList.add(this.currentSearchProfile);
        }
        this.profilesTable.updateUI();
    }

    public void reloadActiveSearchProfileComboBox() {
        this.cmbActive.removeItemListener(this.activeCBItemListener);
        this.cmbActiveModel.removeAllElements();
        this.cmbActiveModel.addElement(" ");
        this.cmbActive.setSelectedItem(" ");
        for (SearchProfile sp : this.getApplicationView().getSearchProfiles()) {
            this.cmbActiveModel.addElement(sp);
            if (!sp.isActive()) continue;
            this.cmbActive.setSelectedItem(sp);
        }
        this.cmbActive.addItemListener(this.activeCBItemListener);
    }

    public void reloadSearchDockablePanels() {
        DockStation dockStation = DockStation.getDockStation();
        Dockable dockable = dockStation.getDockable(GlobalSearchDockable.VIEW_ID);
        if (dockable instanceof GlobalSearchDockable) {
            GlobalSearchDockable globalSearchDockable = (GlobalSearchDockable)dockable;
            globalSearchDockable.get_gui().reloadSearchProfiles();
        }
        for (Design design : this.getApplicationView().getDesigns()) {
            for (RelationalDesign rd : design.getRelationalDesigns()) {
                for (SearchDockable sd : rd.getAllSearchDockables()) {
                    sd.get_gui().reloadSearchProfiles();
                }
            }
            for (MultidimensionalDesign md : design.getMultidimensionalDesigns()) {
                for (SearchDockable sd : md.getAllSearchDockables()) {
                    sd.get_gui().reloadSearchProfiles();
                }
            }
            LogicalDesign ld = design.getLogicalDesign();
            for (SearchDockable sd : ld.getAllSearchDockables()) {
                sd.get_gui().reloadSearchProfiles();
            }
            DataTypesDesign dtd = design.getDataTypesDesign();
            for (SearchDockable sd : dtd.getAllSearchDockables()) {
                sd.get_gui().reloadSearchProfiles();
            }
            ProcessModel pmd = design.getProcessModel();
            for (SearchDockable sd : pmd.getAllSearchDockables()) {
                sd.get_gui().reloadSearchProfiles();
            }
        }
    }

    class ContentRenderer
    extends DefaultTableCellRenderer {
        ContentRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            SearchProfile sp = SearchPP.this.profilesList.get(table.convertRowIndexToModel(row));
            this.setToolTipText(new File(sp.getFilePath() + "/" + sp.getFileName() + ".sposdm").getAbsolutePath());
            return this;
        }
    }

    private class ActiveCBItemListener
    implements ItemListener {
        private ActiveCBItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 2) {
                if (event.getItem() instanceof SearchProfile) {
                    SearchProfile sp = (SearchProfile)event.getItem();
                    sp.setActive(false);
                    SearchPP.this.persistence.save(sp, false);
                }
            } else if (event.getStateChange() == 1) {
                if (event.getItem() instanceof SearchProfile) {
                    SearchProfile sp = (SearchProfile)event.getItem();
                    sp.setActive(true);
                    SearchPP.this.persistence.save(sp, false);
                }
                ReportUtils.reloadSearchProfilesMap(SearchPP.this.getApplicationView());
                SearchPP.this.reloadSearchDockablePanels();
            }
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        ComboBoxRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null) {
                if (value instanceof SearchProfile) {
                    SearchProfile sp = (SearchProfile)value;
                    if (sp != null) {
                        this.setText(sp.getFileName());
                    }
                } else {
                    this.setText(" ");
                }
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }

    private class ShowPropertiesAction
    implements ActionListener {
        private ShowPropertiesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchPP.this.currentSearchProfile = SearchPP.this.profilesList.get(SearchPP.this.profilesTable.convertRowIndexToModel(SearchPP.this.profilesTable.getSelectedRow()));
            SearchProfilePropertiesDialog d = new SearchProfilePropertiesDialog(SearchPP.this.getApplicationView(), SearchPP.this.currentSearchProfile, SearchPP.this.persistence, SearchPP.this);
            d.showDialog();
        }
    }

    private class RemoveAction
    implements ActionListener {
        private RemoveAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchProfile sp = SearchPP.this.profilesList.get(SearchPP.this.profilesTable.convertRowIndexToModel(SearchPP.this.profilesTable.getSelectedRow()));
            int result = JOptionPane.showConfirmDialog((Component)((Object)SearchPP.this), MessageFormat.format(Messages.getString("SearchPP.AreUSure"), sp.getFileName() + ".sposdm"), Messages.getString("SearchPP.SelectOption"), 0);
            if (result == 0) {
                SearchPP.this.getApplicationView().getSearchProfiles().remove(sp);
                SearchPP.this.profilesList.remove(sp);
                SearchPP.this.profilesTable.updateUI();
                SearchPP.this.reloadActiveSearchProfileComboBox();
                SearchPP.this.reloadSearchDockablePanels();
            }
        }
    }

    private class AddDirectoryAction
    implements ActionListener {
        private AddDirectoryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file;
            URLFileChooser fileChooser = new URLFileChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(1);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("SearchPP.SelectDisrectory"));
            if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                SearchPP.this.persistence.load(SearchPP.this.getApplicationView(), new File(fileChooser.getSelectedURL().getFile()).getAbsolutePath());
                SearchPP.this.profilesList.clear();
                SearchPP.this.profilesList.addAll(SearchPP.this.getApplicationView().getSearchProfiles());
                SearchPP.this.profilesTable.updateUI();
                SearchPP.this.reloadActiveSearchProfileComboBox();
                SearchPP.this.reloadSearchDockablePanels();
            }
        }
    }

    private class AddAction
    implements ActionListener {
        private AddAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchPP.this.currentSearchProfile = new SearchProfile(SearchPP.this.getApplicationView(), SearchPP.this.generateName(), "", "", false);
            SearchProfilePropertiesDialog d = new SearchProfilePropertiesDialog(SearchPP.this.getApplicationView(), SearchPP.this.currentSearchProfile, SearchPP.this.persistence, SearchPP.this);
            d.showDialog();
            SearchPP.this.profilesTable.updateUI();
            SearchPP.this.profilesTable.getSelectionModel().setSelectionInterval(SearchPP.this.profilesTable.getRowCount() - 1, SearchPP.this.profilesTable.getRowCount() - 1);
        }
    }

    class ProfilesTableModel
    extends DefaultTableModel {
        final String[] COL_NAMES = new String[]{Messages.getString("SearchPP.Name"), Messages.getString("SearchPP.Description"), Messages.getString("SearchPP.FileName")};

        ProfilesTableModel() {
        }

        @Override
        public int getRowCount() {
            return SearchPP.this.profilesList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.COL_NAMES[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            SearchProfile sp = SearchPP.this.profilesList.get(rowIndex);
            if (columnIndex == 0) {
                return sp.getFileName();
            }
            if (columnIndex == 1) {
                return sp.getDescription();
            }
            if (columnIndex == 2) {
                return new File(sp.getFilePath() + "/" + sp.getFileName() + ".sposdm").getAbsolutePath();
            }
            return "";
        }
    }
}

