/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.ddl.sqlserver.v2k5;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.ddl.sqlserver.SHAddDataTypeSqlServer;
import oracle.dbtools.crest.model.datatype.NotStandartDataTypeNames;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.LogicalDatatypeFactory;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.DistinctTypeSet;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.SchemaSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UsedUserDefinedDatav2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.UserDefinedTypeSqlServerv2k5;
import oracle.dbtools.crest.util.logging.Logger;

public class SHAddDataTypeSqlServerv2k5
extends SHAddDataTypeSqlServer {
    private static final String ZERO = "0";
    private static final Logger LOGGER = new Logger(SHAddDataTypeSqlServerv2k5.class);
    private UsedUserDefinedDatav2k5 type;
    private UserDefinedTypeSqlServerv2k5 userDT;
    private LogicalDatatypeFactory factoryLogical;

    public SHAddDataTypeSqlServerv2k5(Design design, LogicalDatatypeFactory factoryLogical) {
        super(design, factoryLogical);
        this.factoryLogical = factoryLogical;
    }

    public SHAddDataTypeSqlServerv2k5(Design design) {
        super(design);
        this.factoryLogical = new LogicalDatatypeFactory();
    }

    @Override
    public void handle(String line) {
        String statement = SHAddDataTypeSqlServerv2k5.clearCR(line);
        if (Token.startsWithString(statement, "create type ") && !Token.hasToken(statement, "EXTERNAL")) {
            try {
                this.addDataType(statement);
                this.importLog.incrementImportedStatements();
            }
            catch (Exception e) {
                LOGGER.error("Parsing " + statement + " for SQL Server failed!", e);
                this.importLog.addFailedStatement(SHAddDataTypeSqlServerv2k5.FormatCR(line, "\n"));
            }
        } else {
            this.nextHandler(line);
        }
    }

    @Override
    public void addDataType(String statement) {
        RDBMSSite site = this.design.getSelectedRDBMSSite();
        StorageDesignSqlServerv2k5 storageDesign = (StorageDesignSqlServerv2k5)this.design.getStorageDesign(site);
        if (storageDesign != null) {
            this.type = (UsedUserDefinedDatav2k5)storageDesign.getUsedUserDefinedDataSet().createUsedUserDefinedData();
            if (this.type != null) {
                this.design.getRelationalDesign().stampModelObjectDDL(this.type);
                String typeName = Token.getTokenAfter(statement, "TYPE");
                String owner = Token.getValBeforeCharacter(typeName, '.');
                SchemaSqlServerv2k5 schema = null;
                if (!owner.equals("")) {
                    typeName = Token.getValAfterCharacter(typeName, '.');
                    schema = (SchemaSqlServerv2k5)storageDesign.getSchemaSet().getByName(owner);
                }
                String fromString = Token.getStringAfter(statement, "FROM");
                if (!typeName.equals("")) {
                    this.type.setName(typeName);
                    this.type.setSchema(schema);
                    this.type.setDatabase(this.getCurrentDB());
                    this.userDT = (UserDefinedTypeSqlServerv2k5)storageDesign.getUserDefinedTypeSet().createType();
                    this.userDT.setName(typeName);
                    this.design.getRelationalDesign().stampModelObjectDDL(this.userDT);
                    this.type.setUserDefinedType(this.userDT);
                    if (Token.hasString(fromString, "NOT NULL")) {
                        fromString = Token.getStringBefore(fromString, "NOT NULL");
                        this.userDT.setNullType("NOT NULL");
                    }
                    if (Token.hasToken(fromString, "NULL")) {
                        fromString = Token.getStringBefore(fromString, "NULL");
                        this.userDT.setNullType("NULL");
                    }
                    Iterator domains = storageDesign.getDesign().getDomainSet().iterator();
                    DesignObject dom = null;
                    while (domains.hasNext()) {
                        Domain domain = (Domain)domains.next();
                        if (!domain.getDataType().toString().equalsIgnoreCase(fromString) || !this.compareDataTypes(domain, fromString)) continue;
                        dom = domain;
                        break;
                    }
                    if (dom != null) {
                        this.userDT.setDomain(dom.getName());
                        NotStandartDataTypeNames.addNotStandartDataType(dom.getName());
                        NotStandartDataTypeNames.addNotStandartSynonym(dom.getName(), fromString);
                    } else {
                        this.createDistinctType(typeName, fromString);
                        this.userDT.setUsedUserDataType(typeName);
                        NotStandartDataTypeNames.addNotStandartDataType(typeName);
                        NotStandartDataTypeNames.addNotStandartSynonym(typeName, fromString);
                    }
                }
            }
        }
    }

    private void createDistinctType(String typeName, String buildinType) {
        Map elements;
        String datatype;
        String typeForCheck = buildinType;
        int bracketPosition = typeForCheck.indexOf(40);
        if (bracketPosition > -1) {
            typeForCheck = typeForCheck.substring(0, bracketPosition).trim();
        }
        if (this.checkBuildinDatatype(typeForCheck) && (datatype = (String)(elements = this.parseBuildinDatatype(buildinType)).get("datatype")) != null) {
            String nameLogDT = MappingDatatypeNameLogicalDataType.getNameLogicalDatatype(datatype);
            LogicalDatatype logicalDT = null;
            logicalDT = this.factoryLogical.searchLogicalDatatype(this.design, nameLogDT);
            DistinctTypeSet typeSet = this.design.getDesign().getDataTypesDesign().getDistinctTypeSet();
            DistinctType newType = typeSet.createDistinctType(null);
            newType.setName(typeName);
            this.design.getRelationalDesign().stampModelObjectDDL(newType);
            if (logicalDT != null) {
                newType.setLogicalDataType(logicalDT);
            } else {
                LogicalDatatype newLogicDT = this.design.getDesign().getLogicalDatatypeSet().createLogicalDatatype(null);
                this.design.getRelationalDesign().stampModelObjectDDL(newLogicDT);
                newType.setLogicalDataType(newLogicDT);
            }
            newType.setFilePath(this.design.getDesign().getFileName());
        }
    }

    private boolean checkBuildinDatatype(String buildinType) {
        String[] names = StandardDatatypeNames.getAllPossibleDatatypes("SQL Server 2005");
        for (int number = 0; number < names.length; ++number) {
            if (!names[number].equalsIgnoreCase(buildinType)) continue;
            return true;
        }
        return false;
    }

    private Map parseBuildinDatatype(String buildinType) {
        String datatype;
        HashMap<String, String> mapElementsColumn = new HashMap<String, String>();
        String beforeBracket = buildinType;
        int bracketPosition = buildinType.indexOf(40);
        if (bracketPosition > -1) {
            beforeBracket = buildinType.substring(0, bracketPosition).trim();
        }
        if ((datatype = StandardDatatypeNames.getUsedDatatypeName(beforeBracket)) != null) {
            String params = Token.cutTokenFromFront(buildinType, beforeBracket);
            mapElementsColumn.put("datatype", datatype);
            if (!params.equalsIgnoreCase("")) {
                boolean hasBrackets = Token.hasCloseAndOpenBrackets(params);
                if (hasBrackets) {
                    hasBrackets = Token.getValBeforeBrackets(params).trim().equalsIgnoreCase("");
                }
                if (hasBrackets) {
                    String parameters = Token.getValBetweenBrackets(params, 1);
                    int positionKomma = parameters.indexOf(",");
                    if (positionKomma != -1) {
                        mapElementsColumn.put("size", ZERO);
                        mapElementsColumn.put("precision", parameters.substring(0, positionKomma).trim());
                        mapElementsColumn.put("scale", parameters.substring(positionKomma + 1).trim());
                    } else if (datatype.equals("DECIMAL")) {
                        mapElementsColumn.put("size", ZERO);
                        mapElementsColumn.put("scale", ZERO);
                        mapElementsColumn.put("precision", parameters.trim());
                    } else if (datatype.equalsIgnoreCase("NUMERIC")) {
                        if (positionKomma != -1) {
                            mapElementsColumn.put("size", ZERO);
                            mapElementsColumn.put("precision", parameters.substring(0, positionKomma).trim());
                            mapElementsColumn.put("scale", parameters.substring(positionKomma + 1).trim());
                        } else {
                            mapElementsColumn.put("size", ZERO);
                            mapElementsColumn.put("precision", parameters.trim());
                            mapElementsColumn.put("scale", ZERO);
                        }
                    } else {
                        mapElementsColumn.put("scale", ZERO);
                        mapElementsColumn.put("precision", ZERO);
                        mapElementsColumn.put("size", parameters.trim());
                    }
                }
            }
        } else {
            LOGGER.error("datatype " + buildinType + " is unknown!");
            this.importLog.addError("Datatype " + buildinType + " is unknown");
        }
        return mapElementsColumn;
    }

    private boolean compareDataTypes(Domain domain, String datatype) {
        String domainType;
        if (datatype.equalsIgnoreCase("INT")) {
            datatype = "INTEGER";
        }
        if (Token.hasCloseAndOpenBrackets(domainType = domain.getDataType().toString()) && Token.hasCloseAndOpenBrackets(datatype)) {
            String domainTypeParams = domainType.substring(domainType.indexOf(40)).trim();
            String domainMain = domainType.substring(0, domainType.indexOf(40)).trim();
            String stringTypeParams = domainType.substring(datatype.indexOf(40)).trim();
            String stringMain = domainType.substring(0, datatype.indexOf(40)).trim();
            return domainTypeParams.equalsIgnoreCase(stringTypeParams) && domainMain.equalsIgnoreCase(stringMain);
        }
        return domainType.equalsIgnoreCase(datatype);
    }
}

