/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DimensionOraclev10g;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class MOHDimensionOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "DIMENSION";
    private static final Logger LOGGER = new Logger(MOHDimensionOracle.class);
    protected boolean dbaUser;
    PreparedStatement levKey_statement = null;
    PreparedStatement attr_statement = null;
    PreparedStatement hier_statement = null;
    PreparedStatement child_statement = null;
    PreparedStatement jkey_statement = null;
    PreparedStatement lev_statement = null;

    public MOHDimensionOracle(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHDimensionOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        TimeLog.log("Dimensions begin");
        this.levKey_statement = null;
        this.attr_statement = null;
        this.hier_statement = null;
        this.child_statement = null;
        this.jkey_statement = null;
        this.lev_statement = null;
        for (int i = 0; i < selectedObjects.size(); ++i) {
            UserOracle user;
            DBObject dbo = (DBObject)selectedObjects.get(i);
            if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
            String name = dbo.getName();
            String username = dbo.getSchema();
            StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
            DimensionOracle dim = storage.getDimensionSet().createDimension();
            dim.setName(name);
            if (!name.equals(name.toUpperCase())) {
                dim.setNameHasQuotes(true);
            }
            if ((user = (UserOracle)storage.getUserSet().getByName(username)) == null) {
                user = storage.getUserSet().createUser();
                user.setName(username);
                this.stampModelObject((ModelObject)user, "", username);
            }
            dim.setUser(user);
            this.initLevels(sqlConnection, dim, user);
            this.initHierarchies(sqlConnection, dim, user);
            this.stampModelObject(dim, dbo);
            importLog.incrementImportedStatements();
            this.addToHandledObjects(dbo);
        }
        if (this.lev_statement != null) {
            this.lev_statement.close();
        }
        if (this.levKey_statement != null) {
            this.levKey_statement.close();
        }
        if (this.attr_statement != null) {
            this.attr_statement.close();
        }
        if (this.hier_statement != null) {
            this.hier_statement.close();
        }
        if (this.child_statement != null) {
            this.child_statement.close();
        }
        if (this.jkey_statement != null) {
            this.jkey_statement.close();
        }
        TimeLog.log("Dimensions end");
    }

    private void initHierarchies(Connection sqlConnection, DimensionOracle dim, UserOracle user) throws Exception {
        if (this.hier_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("HIERARCHY_NAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_dim_hierarchies" : "all_dim_hierarchies").append(' ');
            buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("DIMENSION_NAME").append('=').append('?');
            String sql = buffer.toString();
            this.hier_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.hier_statement.setString(1, user.getName());
            this.hier_statement.setString(2, dim.getName());
            rs = this.hier_statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHDimensionOracle.initHierarchies():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
                HierarchyOracle hier = storage.getHierarchySet().createHierarchy();
                hier.setName(name);
                if (!name.equals(name.toUpperCase())) {
                    hier.setNameHasQuotes(true);
                }
                hier.setDimension(dim);
                this.stampModelObject((ModelObject)hier, user.getName(), dim.getName() + "." + name);
                this.initChildOfLevels(sqlConnection, dim, hier, user);
            }
            rs.close();
        }
    }

    private void initChildOfLevels(Connection sqlConnection, DimensionOracle dim, HierarchyOracle hier, UserOracle user) throws Exception {
        if (this.child_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("CHILD_LEVEL_NAME").append(',');
            buffer.append("JOIN_KEY_ID").append(',');
            buffer.append("PARENT_LEVEL_NAME").append(' ');
            buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_dim_child_of" : "all_dim_child_of").append(' ');
            buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("DIMENSION_NAME").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("HIERARCHY_NAME").append('=').append('?').append(' ');
            buffer.append("ORDER BY").append(' ').append("POSITION");
            String sql = buffer.toString();
            this.child_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.child_statement.setString(1, user.getName());
            this.child_statement.setString(2, dim.getName());
            this.child_statement.setString(3, hier.getName());
            rs = this.child_statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHDimensionOracle.initChildOfLevels():", e);
        }
        if (rs != null) {
            LevelOracle parentLevel;
            String parent = null;
            while (rs.next()) {
                TableProxyOracle childTable;
                String child = rs.getString(1);
                int joinId = rs.getInt(2);
                parent = rs.getString(3);
                LevelOracle level = dim.getLevelByName(child);
                if (level != null) {
                    hier.setLevels(level.getObjectID());
                }
                if (joinId == 0 || level == null || (childTable = (TableProxyOracle)level.getLevelTable()) == null) continue;
                this.initJoinKey(sqlConnection, dim, hier, user, childTable);
            }
            if (parent != null && (parentLevel = dim.getLevelByName(parent)) != null) {
                hier.setLevels(parentLevel.getObjectID());
            }
            rs.close();
        }
    }

    private void initJoinKey(Connection sqlConnection, DimensionOracle dim, HierarchyOracle hier, UserOracle user, TableProxyOracle childTable) throws Exception {
        if (this.jkey_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("LEVEL_NAME").append(',');
            buffer.append("CHILD_JOIN_COLUMN").append(' ');
            buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_dim_join_key" : "all_dim_join_key").append(' ');
            buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("DIMENSION_NAME").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("HIERARCHY_NAME").append('=').append('?').append(' ');
            buffer.append("ORDER BY").append(' ').append("LEVEL_NAME").append(',').append("KEY_POSITION");
            String sql = buffer.toString();
            this.jkey_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.jkey_statement.setString(1, user.getName());
            this.jkey_statement.setString(2, dim.getName());
            this.jkey_statement.setString(3, hier.getName());
            rs = this.jkey_statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHDimensionOracle.initJoinKey():", e);
        }
        if (rs != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            while (rs.next()) {
                String parentLevelName = rs.getString(1);
                String colName = rs.getString(2);
                ColumnProxyOracle col = (ColumnProxyOracle)childTable.getColumnProxyByName(colName);
                if (col == null) continue;
                Object columns = (String)map.get(parentLevelName);
                columns = columns == null ? col.getLongName() : (String)columns + ", " + col.getLongName();
                map.put(parentLevelName, columns);
            }
            rs.close();
            for (Map.Entry e : map.entrySet()) {
                StringBuffer join = new StringBuffer("JOIN KEY (");
                join.append((String)e.getValue());
                join.append(") REFERENCES ");
                join.append((String)e.getKey());
                hier.setJoins(join.toString());
            }
        }
    }

    private void initLevels(Connection sqlConnection, DimensionOracle dim, UserOracle user) throws Exception {
        if (this.lev_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("LEVEL_NAME").append(',');
            buffer.append("DETAILOBJ_OWNER").append(',');
            buffer.append("DETAILOBJ_NAME").append(' ');
            buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_dim_levels" : "all_dim_levels").append(' ');
            buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("DIMENSION_NAME").append('=').append('?');
            String sql = buffer.toString();
            this.lev_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.lev_statement.setString(1, user.getName());
            this.lev_statement.setString(2, dim.getName());
            rs = this.lev_statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHDimensionOracle.initLevels():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String name = rs.getString(1);
                String tableUser = rs.getString(2);
                String tableName = rs.getString(3);
                StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
                LevelOracle level = storage.getLevelSet().createLevel();
                level.setName(name);
                if (!name.equals(name.toUpperCase())) {
                    level.setNameHasQuotes(true);
                }
                level.setDimension(dim);
                this.stampModelObject((ModelObject)level, user.getName(), dim.getName() + "." + name);
                TableProxyOracle table = ((TableProxySetOracle)storage.getTableProxySet()).getByLongName(tableName, tableUser);
                if (table != null) {
                    level.setLevelTable(table);
                    this.initLevelKeys(sqlConnection, level, dim, table);
                    this.initAttributes(sqlConnection, level, dim, table);
                    continue;
                }
                LOGGER.error("Dimension " + dim.getName() + " Level " + name + " has no Table assigned");
            }
            rs.close();
        }
    }

    private void initAttributes(Connection sqlConnection, LevelOracle level, DimensionOracle dim, TableProxyOracle table) throws Exception {
        boolean oracle10gUpwards = dim instanceof DimensionOraclev10g;
        if (this.attr_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            if (oracle10gUpwards) {
                buffer.append("ATTRIBUTE_NAME").append(',');
            }
            buffer.append("COLUMN_NAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_dim_attributes" : "all_dim_attributes").append(' ');
            buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("DIMENSION_NAME").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("LEVEL_NAME").append('=').append('?');
            String sql = buffer.toString();
            this.attr_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.attr_statement.setString(1, dim.getUser().getName());
            this.attr_statement.setString(2, dim.getName());
            this.attr_statement.setString(3, level.getName());
            rs = this.attr_statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHDimensionOracle.initAttributes():", e);
        }
        StorageDesignOracle storage = level.getStorageDesignOracle();
        DimensionAttributeOracle attr = storage.getDimensionAttributeSet().createDimensionAttribute();
        attr.setLevel(level);
        if (rs != null) {
            while (rs.next()) {
                ColumnProxyOracle col;
                if (oracle10gUpwards) {
                    String attrName = rs.getString("ATTRIBUTE_NAME");
                    attr.setName(attrName);
                    if (!attrName.equals(attrName.toUpperCase())) {
                        attr.setNameHasQuotes(true);
                    }
                }
                if ((col = (ColumnProxyOracle)table.getColumnProxyByName(rs.getString("COLUMN_NAME"))) == null) continue;
                attr.setColumns(col.getObjectID());
            }
            rs.close();
        }
    }

    private void initLevelKeys(Connection sqlConnection, LevelOracle level, DimensionOracle dim, TableProxyOracle table) throws Exception {
        if (this.levKey_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("b.").append("COLUMN_NAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_dim_levels" : "all_dim_levels").append(' ').append("a").append(',');
            buffer.append(this.dbaUser ? "dba_dim_level_key" : "all_dim_level_key").append(' ').append("b").append(' ');
            buffer.append("WHERE").append(' ').append("a.").append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("a.").append("DIMENSION_NAME").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("a.").append("LEVEL_NAME").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("a.").append("OWNER").append('=').append("b.").append("OWNER").append(' ');
            buffer.append("AND").append(' ').append("a.").append("DIMENSION_NAME").append('=').append("b.").append("DIMENSION_NAME").append(' ');
            buffer.append("AND").append(' ').append("a.").append("LEVEL_NAME").append('=').append("b.").append("LEVEL_NAME").append(' ');
            buffer.append("ORDER BY").append(' ').append("b.").append("KEY_POSITION");
            String sql = buffer.toString();
            this.levKey_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.levKey_statement.setString(1, dim.getUser().getName());
            this.levKey_statement.setString(2, dim.getName());
            this.levKey_statement.setString(3, level.getName());
            rs = this.levKey_statement.executeQuery();
        }
        catch (Exception e) {
            LOGGER.error("MOHDimensionOracle.initLevelKeys():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                ColumnProxyOracle col = (ColumnProxyOracle)table.getColumnProxyByName(rs.getString(1));
                if (col == null) continue;
                level.setColumns(col.getObjectID());
            }
            rs.close();
        }
    }

    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        TimeLog.log("Extract Dimensions begin");
        Statement statement = null;
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dboNext : schemas) {
            if (!dboNext.isSelected()) continue;
            String schemaName = dboNext.getName();
            if (statement == null) {
                String filterCondition = this.getFilterConditionOracle("DIMENSION_NAME");
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ').append("DIMENSION_NAME").append(' ');
                buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_dimensions" : "all_dimensions").append(' ');
                buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
                if (filterCondition != null) {
                    buffer.append("AND").append(' ').append(filterCondition).append(' ');
                }
                String sql = buffer.toString();
                statement = sqlConnection.prepareStatement(sql);
            }
            ResultSet rs = null;
            try {
                statement.setString(1, dboNext.getName());
                rs = statement.executeQuery();
            }
            catch (Exception e) {
                LOGGER.error("MOHDimensionOracle.extract():", e);
            }
            if (rs == null) continue;
            while (rs.next()) {
                String dimName = rs.getString(1);
                DBObject dboDim = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), dimName, OBJECT_TYPE, schemaName);
                list.add(dboDim);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        TimeLog.log("Extract Dimensions end");
        return list;
    }
}

