/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.logical;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.logical.Arc;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.logical.Relation;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.logical.TVEntity;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODORelation
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "RELATION";
    private Map relations = new TreeMap();
    private Map arcMap = new TreeMap();
    private static final Logger LOGGER = new Logger(ODORelation.class);
    PreparedStatement id_statement;
    PreparedStatement com_statement;

    public ODORelation(ODExtractionHandler odExtractionHandler, ApplicationView view) {
        super(odExtractionHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        this.relations.clear();
        this.arcMap.clear();
        Statement statement = null;
        this.id_statement = null;
        this.com_statement = null;
        for (ODObject odObject : selectedObjects) {
            if (!"ENTITY".equalsIgnoreCase(odObject.getType())) continue;
            String eivid = odObject.ivid;
            if (statement == null) {
                String query = "SELECT l.NAME left_name, r.NAME right_name,l.ID left_id, l.FROM_ENTITY_REFERENCE,l.arc_reference, l.TO_ENTITY_REFERENCE,nvl(l.MAXIMUM_CARDINALITY,999) left_max_card,l.MINIMUM_CARDINALITY left_min_card,l.OTHER_RELATIONSHIP_END_REF right_id,nvl(r.MAXIMUM_CARDINALITY,999) right_max_card,r.MINIMUM_CARDINALITY right_min_card,l.IVID,l.arc_number,r.arc_reference as r_arc_reference,l.transfer as l_transfer,r.transfer as r_transfer  from CI_RELATIONSHIP_ENDS l, CI_RELATIONSHIP_ENDS r  where l.parent_ivid = ?  and l.OTHER_RELATIONSHIP_END_REF = r.id";
                statement = sqlConnection.prepareStatement(query);
            }
            ResultSet rs = null;
            try {
                statement.setString(1, eivid);
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODORelation.generate():", e);
            }
            if (rs == null) continue;
            while (rs.next()) {
                List<DummyRelation> list;
                DummyRelation dummyRelation;
                String leftRelID = rs.getString("left_id");
                String rightRelID = rs.getString("right_id");
                String leftEntityID = rs.getString("FROM_ENTITY_REFERENCE");
                String arcid = rs.getString("arc_reference");
                String rightEntityID = rs.getString("TO_ENTITY_REFERENCE");
                int leftCardinality = rs.getInt("left_max_card");
                int rightCardinality = rs.getInt("right_max_card");
                int leftIsOptional = rs.getInt("left_min_card");
                int rightIsOptional = rs.getInt("right_min_card");
                String leftName = rs.getString("left_name");
                String rightName = rs.getString("right_name");
                String rarcid = rs.getString("r_arc_reference");
                String l_transfer = rs.getString("l_transfer");
                String r_transfer = rs.getString("r_transfer");
                String arcEntityID = null;
                if (arcid != null) {
                    arcEntityID = leftEntityID;
                } else if (rarcid != null) {
                    arcEntityID = rightEntityID;
                    arcid = rarcid;
                }
                if (!this.relationExists(leftRelID, rightRelID)) {
                    dummyRelation = new DummyRelation(leftRelID, rightRelID, leftEntityID, rightEntityID);
                    dummyRelation.setLeftCardinality(rightCardinality == 1 ? "1" : "*");
                    dummyRelation.setRightCardinality(leftCardinality == 1 ? "1" : "*");
                    dummyRelation.setLeftIsOptional(leftIsOptional == 0);
                    dummyRelation.setRightIsOptional(rightIsOptional == 0);
                    dummyRelation.setLeftName(leftName);
                    dummyRelation.setRightName(rightName);
                    dummyRelation.arcEntityID = arcEntityID;
                    dummyRelation.leftTransferable = l_transfer;
                    dummyRelation.rightTransferable = r_transfer;
                    this.initIdentifying(sqlConnection, dummyRelation);
                    this.setRelationNotesAndComments(sqlConnection, dummyRelation, eivid);
                    this.relations.put(dummyRelation.getID(), dummyRelation);
                    if (arcid == null || "".equalsIgnoreCase(arcid)) continue;
                    list = (List)this.arcMap.get(arcid);
                    if (list == null) {
                        list = new ArrayList();
                    }
                    list.add(dummyRelation);
                    this.arcMap.put(arcid, list);
                    continue;
                }
                if (arcid == null || "".equalsIgnoreCase(arcid)) continue;
                dummyRelation = (DummyRelation)this.relations.get(leftRelID + "@" + rightRelID);
                if (dummyRelation == null) {
                    dummyRelation = (DummyRelation)this.relations.get(rightRelID + "@" + leftRelID);
                }
                if (dummyRelation == null) continue;
                list = (ArrayList<DummyRelation>)this.arcMap.get(arcid);
                if (list == null) {
                    list = new ArrayList<DummyRelation>();
                }
                list.add(dummyRelation);
                this.arcMap.put(arcid, list);
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.id_statement != null) {
            this.id_statement.close();
        }
        if (this.com_statement != null) {
            this.com_statement.close();
        }
        this.createRelations();
        this.createArcs();
        this.propagateFKAttributes(sqlConnection);
    }

    private void initIdentifying(Connection sqlConnection, DummyRelation dm) throws Exception {
        if (this.id_statement == null) {
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT u.unique_identifier_reference, \n");
            sql.append("  u.relationship_end_reference \n");
            sql.append("FROM ci_unique_identifier_entries u \n");
            sql.append("WHERE u.attribute_or_relation       = 'R' \n");
            sql.append("  and u.relationship_end_reference IN ( ? , ? )");
            String query = sql.toString();
            this.id_statement = sqlConnection.prepareStatement(query);
        }
        ResultSet rs = null;
        try {
            this.id_statement.setString(1, dm.getLeftRelationID());
            this.id_statement.setString(2, dm.getRightRelationID());
            rs = this.id_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODORelation.initIdentifying():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String id = rs.getString(1);
                DesignObject obj = this.getDesign().getDesignObject(id);
                if (!(obj instanceof KeyObject) || !((KeyObject)obj).isPK()) continue;
                dm.setIdentifying(true);
                dm.pk = (KeyObject)obj;
            }
            rs.close();
        }
    }

    private void propagateFKAttributes(Connection sqlConnection) throws Exception {
        boolean flag = true;
        while (flag) {
            flag = false;
            Object[] keys = this.getExtractionHandler().getRelationsToKeys().keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                DummyRelation dm = this.getDummyRelation((String)keys[i]);
                if (dm == null) continue;
                Relation relation = (Relation)this.getExtractionHandler().getImportedObject(dm.getID());
                CandidateKey candidateKey = (CandidateKey)this.getExtractionHandler().getRelationsToKeys().get(keys[i]);
                if (relation == null || candidateKey == null) continue;
                Entity entity = (Entity)candidateKey.getContainerObject();
                ContainedObject[] attributes = entity.getAllElementsGeneratedBy(relation);
                for (int j = 0; j < attributes.length; ++j) {
                    if (attributes[j].getContainer() == null || candidateKey.contains(attributes[j]) || attributes[j].getContainer() != candidateKey.getContainerWithKeyObject()) continue;
                    try {
                        candidateKey.add(attributes[j]);
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error("error adding attribute! \n", e);
                    }
                }
            }
        }
    }

    private void createRelations() {
        Object[] keys = this.relations.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            DummyRelation dm = (DummyRelation)this.relations.get(keys[i]);
            Entity leftEntity = (Entity)this.getExtractionHandler().getImportedObject(dm.getLeftEntityID());
            Entity rightEntity = (Entity)this.getExtractionHandler().getImportedObject(dm.getRightEntityID());
            if (leftEntity == null || rightEntity == null) continue;
            String id = dm.getLeftRelationID() + "_" + dm.getRightRelationID();
            DesignObject obj = this.getDesign().getDesignObject(id);
            Relation relation = null;
            if (obj != null) {
                relation = (Relation)obj;
            }
            if (relation == null) {
                relation = this.getDesign().getLogicalDesign().createRelation();
                if (obj == null) {
                    relation.setObjectID(id);
                }
            }
            relation.setFireCardinalityChange(false);
            relation.setSourceEntity(leftEntity);
            relation.setTargetEntity(rightEntity);
            Entity dom = null;
            if (dm.isIdentifying() && "1".equals(dm.getLeftCardinality()) && "1".equals(dm.getRightCardinality()) && dm.pk != null) {
                dom = relation.getTargetEntity().getPK() == dm.pk ? relation.getSourceEntity() : relation.getTargetEntity();
            }
            relation.setSourceTV((TVEntity)leftEntity.getTopView());
            relation.setTargetTV((TVEntity)rightEntity.getTopView());
            relation.setCardinality(0, dm.getLeftCardinality());
            relation.setCardinality(1, dm.getRightCardinality());
            relation.setOptionalSource(dm.leftIsOptional());
            relation.setOptionalTarget(dm.rightIsOptional());
            relation.setNameOnSource(dm.getLeftName());
            relation.setNameOnTarget(dm.getRightName());
            if (dom != null) {
                relation.setDominantRole(dom);
            }
            relation.setIdentifying(dm.isIdentifying());
            if ("N".equalsIgnoreCase(dm.rightTransferable)) {
                relation.setTargetTransferable(false);
            }
            if ("N".equalsIgnoreCase(dm.leftTransferable)) {
                relation.setSourceTransferable(false);
            }
            relation.setFireCardinalityChange(true);
            relation.setTargetCardinality(relation.getTargetCardinality());
            relation.setComment(dm.getComments());
            relation.setNotes(dm.getNotes());
            relation.addToAllDPVs();
            ((TVRelation)relation.getTopView()).addConnection();
            ((TVRelation)relation.getTopView()).resetEdgeParams();
            this.getExtractionHandler().addToImportedObjects(dm.getID(), relation);
            dm.setRelation(relation);
        }
    }

    private void createArcs() {
        Object[] keys = this.arcMap.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String arcid = (String)keys[i];
            List list = (List)this.arcMap.get(arcid);
            if (list == null || list.size() <= 1) continue;
            Entity ent = null;
            ArrayList<DesignObject> rels = new ArrayList<DesignObject>();
            for (DummyRelation dm : list) {
                if (dm.getRelation() == null) continue;
                rels.add(dm.getRelation());
                if (ent != null) continue;
                ent = (Entity)this.getDesign().getDesignObject(dm.arcEntityID);
            }
            if (rels.size() <= 1) continue;
            Relation rel = (Relation)rels.get(0);
            rels.add(0, ent);
            Arc arc = this.getDesign().getLogicalDesign().createArc(rels.toArray());
            arc.setObjectID(arcid);
        }
    }

    private DummyRelation getDummyRelation(String id) {
        Object[] keys = this.relations.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            DummyRelation dm = (DummyRelation)this.relations.get(keys[i]);
            if (dm == null || !dm.getLeftRelationID().equalsIgnoreCase(id) && !dm.getRightRelationID().equalsIgnoreCase(id)) continue;
            return dm;
        }
        return null;
    }

    private boolean relationExists(String id1, String id2) {
        return this.relations.containsKey(id1 + "@" + id2) || this.relations.containsKey(id2 + "@" + id1);
    }

    protected void setRelationNotesAndComments(Connection sqlConnection, DummyRelation dm, String ivid) throws Exception {
        if (this.com_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("txt_type").append(',');
            buffer.append("txt_text").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append("rm_text_lines").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("TXT_REF").append(' ').append("IN").append(' ').append('(');
            buffer.append(" ? ").append(',').append(" ? ").append(')').append(' ');
            buffer.append(" and parent_ivid").append('=').append(" ? ");
            buffer.append(" and txt_type in ('CDIDSC','CDINOT')");
            buffer.append(" order by txt_type, txt_seq");
            this.com_statement = sqlConnection.prepareStatement(buffer.toString());
        }
        ResultSet rs = null;
        try {
            this.com_statement.setString(1, dm.getLeftRelationID());
            this.com_statement.setString(2, dm.getRightRelationID());
            this.com_statement.setString(3, ivid);
            rs = this.com_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODORelation.setRelationNotesAndComments():", e);
        }
        if (rs != null) {
            while (rs.next()) {
                String text;
                String txtType = rs.getString("txt_type");
                String txtText = rs.getString("txt_text");
                if ("CDIDSC".equalsIgnoreCase(txtType)) {
                    text = dm.getComments();
                    if (text == null || "".equalsIgnoreCase(text)) {
                        dm.setComments(txtText);
                        continue;
                    }
                    dm.setComments(text + txtText);
                    continue;
                }
                if (!"CDINOT".equalsIgnoreCase(txtType)) continue;
                text = dm.getNotes();
                if (text == null || "".equalsIgnoreCase(text)) {
                    dm.setNotes(txtText);
                    continue;
                }
                dm.setNotes(text + txtText);
            }
            rs.close();
        }
    }

    private class DummyRelation {
        private String leftEntityID;
        private String arcEntityID;
        private String rightEntityID;
        private String leftRelationID;
        private String rightRelationID;
        private String leftCardinality;
        private String rightCardinality;
        private boolean leftIsOptional;
        private boolean rightIsOptional;
        private String leftName;
        private String leftTransferable;
        private String rightTransferable;
        private String rightName;
        private String comments;
        private String notes;
        private boolean identifying = false;
        private Relation relation;
        public KeyObject pk;

        public DummyRelation(String leftRelationID, String rightRelationID, String leftEntityID, String rightEntityID) {
            this.leftRelationID = leftRelationID;
            this.rightRelationID = rightRelationID;
            this.leftEntityID = leftEntityID;
            this.rightEntityID = rightEntityID;
        }

        public String getLeftCardinality() {
            return this.leftCardinality;
        }

        public void setLeftCardinality(String leftCardinality) {
            this.leftCardinality = leftCardinality;
        }

        public boolean leftIsOptional() {
            return this.leftIsOptional;
        }

        public void setLeftIsOptional(boolean leftIsOptional) {
            this.leftIsOptional = leftIsOptional;
        }

        public String getLeftRelationID() {
            return this.leftRelationID;
        }

        public String getRightRelationID() {
            return this.rightRelationID;
        }

        public String getRightCardinality() {
            return this.rightCardinality;
        }

        public void setRightCardinality(String rightCardinality) {
            this.rightCardinality = rightCardinality;
        }

        public boolean rightIsOptional() {
            return this.rightIsOptional;
        }

        public void setRightIsOptional(boolean rightIsOptional) {
            this.rightIsOptional = rightIsOptional;
        }

        public String getLeftEntityID() {
            return this.leftEntityID;
        }

        public String getRightEntityID() {
            return this.rightEntityID;
        }

        public String getLeftName() {
            return this.leftName;
        }

        public void setLeftName(String leftName) {
            this.leftName = leftName;
        }

        public String getRightName() {
            return this.rightName;
        }

        public void setRightName(String rightName) {
            this.rightName = rightName;
        }

        public String getID() {
            return this.leftRelationID + "@" + this.rightRelationID;
        }

        public String getComments() {
            return this.comments;
        }

        public void setComments(String comments) {
            this.comments = comments;
        }

        public String getNotes() {
            return this.notes;
        }

        public void setNotes(String notes) {
            this.notes = notes;
        }

        public boolean isIdentifying() {
            return this.identifying;
        }

        public void setIdentifying(boolean identifying) {
            this.identifying = identifying;
        }

        public Relation getRelation() {
            return this.relation;
        }

        public void setRelation(Relation relation) {
            this.relation = relation;
        }
    }
}

