/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.oracledesigner.relational;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.imports.oracledesigner.AbstractObjectHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODExtractionHandler;
import oracle.dbtools.crest.imports.oracledesigner.ODObject;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.relational.DPVRelationalSubView;
import oracle.dbtools.crest.swingui.relational.TVTable;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public class ODRelationalDiagram
extends AbstractObjectHandler {
    public static final String OBJECT_TYPE = "DIAGRAM";
    private static final Logger LOGGER = new Logger(ODRelationalDiagram.class);
    PreparedStatement t_statement;

    public ODRelationalDiagram(ODExtractionHandler odExtractionHandler, ApplicationView view) {
        super(odExtractionHandler, view);
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        Iterator it = this.getExtractionHandler().getSelectedAppSystems().iterator();
        Statement statement = null;
        this.t_statement = null;
        while (it.hasNext()) {
            String query;
            ODObject odNext = (ODObject)it.next();
            ODExtractionHandler.Branch branch = odNext.branch;
            if (branch == null) {
                if (statement == null) {
                    query = "SELECT d.NAME, d.ID,d.ivid from ci_diagrams d,sdd_folder_members b , i$sdd_wa_context cc where d.ID = b.member_object and b.folder_reference = ?  and b.PARENT_IVID = ? and cc.workarea_irid = ? and d.ivid = cc.object_ivid and cc.wastebasket ='N'  and DIAGRAM_TYPE = 'DSD' and exists (select 1 from CI_DIAGRAM_ELEMENT_USAGES u where u.DIAGRAM_REFERENCE = d.id and u.ELEMENT_TYPE_FOR in ('SNP','TBL','VW') and rownum<2) order by name";
                    statement = sqlConnection.prepareStatement(query);
                }
                statement.setString(1, odNext.getIrid());
                statement.setString(2, odNext.ivid);
                statement.setString(3, odNext.wa_irid);
            } else {
                if (statement == null) {
                    query = "SELECT d.NAME, d.ID,d.ivid from ci_diagrams d,sdd_folder_members b , i$sdd_wa_context cc where d.ID = b.member_object and b.folder_reference = ?  and b.PARENT_IVID = ? and cc.workarea_irid = ? and d.ivid = cc.object_ivid and cc.wastebasket ='N'  and DIAGRAM_TYPE = 'DSD' and exists (select 1 from CI_DIAGRAM_ELEMENT_USAGES u where u.DIAGRAM_REFERENCE = d.id and u.ELEMENT_TYPE_FOR in ('SNP','TBL','VW') and rownum<2) ";
                    StringBuffer buffer = new StringBuffer(query);
                    statement = sqlConnection.prepareStatement(buffer.toString());
                }
                statement.setString(1, odNext.getIrid());
                statement.setString(2, odNext.ivid);
                statement.setString(3, odNext.wa_irid);
            }
            ResultSet rs = null;
            try {
                rs = statement.executeQuery();
            }
            catch (SQLException e) {
                LOGGER.error("ODRelationalDiagram.extract(): " + e.getMessage());
            }
            if (rs == null) continue;
            while (rs.next()) {
                String diagramName = rs.getString("NAME");
                String diagramID = rs.getString("ID");
                String ivid = rs.getString("ivid");
                DesignPartView dpv = this.getDesign().getRelationalDesign().getSubViewByID(diagramID);
                if (dpv == null) {
                    dpv = this.getDesign().getRelationalDesign().createDesignPartSubView();
                    dpv.setDPVId(diagramID);
                }
                dpv.setName(diagramName);
                dpv.setMustBeVisible(false);
                if (!this.addTableToDiagram(sqlConnection, dpv, diagramID, ivid)) {
                    this.getDesign().getRelationalDesign().deleteSubview(dpv);
                    continue;
                }
                this.setNotesAndComments(sqlConnection, dpv.getPlaceHolder(), diagramID, odNext.ivid);
                ((DPVRelationalSubView)dpv).rearrangeNewDiagram();
            }
            rs.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (this.t_statement != null) {
            this.t_statement.close();
        }
    }

    private boolean addTableToDiagram(Connection sqlConnection, DesignPartView dpv, String diagramID, String ivid) throws Exception {
        boolean result = false;
        if (this.t_statement == null) {
            String query = "SELECT CIELEMENT_REFERENCE id, d.ELEMENT_TYPE_FOR from CI_DIAGRAM_ELEMENT_USAGES d where DIAGRAM_REFERENCE = ?  and ELEMENT_TYPE_FOR in ('SNP','TBL','VW') and d.PARENT_IVID = ? ";
            this.t_statement = sqlConnection.prepareStatement(query);
        }
        ResultSet rs = null;
        try {
            this.t_statement.setString(1, diagramID);
            this.t_statement.setString(2, ivid);
            rs = this.t_statement.executeQuery();
        }
        catch (SQLException e) {
            LOGGER.error("ODRelationalDiagram.addTableToDiagram(): " + e.getMessage());
        }
        if (rs != null) {
            while (rs.next()) {
                ContainerView tv;
                FKContainer table;
                String objectID = rs.getString("ID");
                String elementType = rs.getString("ELEMENT_TYPE_FOR");
                if ("TBL".equalsIgnoreCase(elementType)) {
                    table = (Table)this.getExtractionHandler().getImportedObject(objectID);
                    if (table == null) continue;
                    result = true;
                    tv = (ContainerView)dpv.createTopViewFor(table);
                    ((TVTable)tv).addTVFKRelations();
                    tv.addTVTypeSubstitutions();
                    continue;
                }
                if (!"VW".equalsIgnoreCase(elementType) || (table = (TableView)this.getExtractionHandler().getImportedObject(objectID)) == null) continue;
                result = true;
                tv = (ContainerView)dpv.createTopViewFor(table);
                tv.addTVTypeSubstitutions();
            }
            rs.close();
        }
        return result;
    }
}

