/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RHKeySynonym;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.logical.CandidateKey;
import oracle.dbtools.crest.model.design.logical.Entity;

public class RHCandidateKey
extends RowHandler {
    public static final String OBJECT_TYPE = "ENT_KEY";

    public RHCandidateKey(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List commentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, commentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createCandidateKey(line);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createCandidateKey(VarFileLine line) {
        Entity entity = (Entity)this.getCreatedObject(this.getField(line, "candidatekey_entity_id"));
        if (entity != null) {
            CandidateKey key = entity.createCandidateKey();
            key.setName(this.getField(line, "candidatekey_name"));
            if (this.getField(line, "Candidatekey_pk").equalsIgnoreCase("Y")) {
                key.makeValidPKIfNotEmpty();
                key.makePK();
            }
            this.setCreatorChanger(key, line);
            key.setComment(this.getComment(line));
            key.setNotes(this.getNotes(line, "note_key_id"));
            key.setSynonym(this.getSynonym(line));
            this.addCreatedObject(this.getField(line, "general_id"), key);
            this.removeSelectedLine(line);
        }
    }

    private String getComment(VarFileLine line) {
        String comment = null;
        String textID = this.getField(line, "CANDIDATEKEY_TEXT_ID");
        if (!"0".equalsIgnoreCase(textID)) {
            VarFileLine commentLine = this.getCommentLine(textID, "ANLTEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "TEXT_COMMENT_2");
                this.removeSelectedLine(commentLine);
            }
        } else {
            comment = "";
        }
        return comment;
    }

    private String getSynonym(VarFileLine line) {
        StringBuffer synonym = new StringBuffer("");
        String id = this.getField(line, "general_id");
        for (VarFileLine selectedLine : this.getSpecificRowHandler(RHKeySynonym.class).getOwnLines()) {
            VarFileLine synonymLine;
            String synID;
            String lineID = this.getField(selectedLine, "general_id");
            if (!id.equalsIgnoreCase(lineID) || "0".equalsIgnoreCase(synID = this.getField(selectedLine, "SYNONYM_ID")) || (synonymLine = this.getCommentLine(synID, "SYNONYM_OBJECT")) == null) continue;
            if (synonym.length() > 0) {
                synonym.append(',');
            }
            synonym.append(this.getField(synonymLine, "SYNONYM_OBJ_NAME"));
        }
        return synonym.toString();
    }
}

