/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.var;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.imports.var.Fields;
import oracle.dbtools.crest.imports.var.RowHandler;
import oracle.dbtools.crest.imports.var.VarFileLine;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.db2.AbstractStorageDesignDB2;
import oracle.dbtools.crest.model.design.storage.db2.BufferPoolDB2;
import oracle.dbtools.crest.model.design.storage.db2.IndexProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.Owner;
import oracle.dbtools.crest.model.design.storage.db2.StorageGroupDB2;
import oracle.dbtools.crest.model.design.storage.db2.StorageTemplateDB2;
import oracle.dbtools.crest.model.design.storage.db2.TableProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.VCatDB2;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.util.logging.Logger;

public class RHIndex
extends RowHandler {
    public static final String OBJECT_TYPE = "INDEX";
    private boolean columnNotExist = false;
    private Hashtable mapColumnSortType;
    private Index index;
    private static final Logger LOGGER = new Logger(RHIndex.class);

    public RHIndex(Design design, Fields constants, List allSelectedLines, Map allCreatedObjects, List allForeignKeyLines, List allPrimaryKeyLines, Map allReferences, List allColumnLines, List allCommentLines) {
        super(design, constants, allSelectedLines, allCreatedObjects, allForeignKeyLines, allPrimaryKeyLines, allReferences, allColumnLines, allCommentLines);
    }

    @Override
    public void read(VarFileLine line) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.addSelectedLine(line);
        } else {
            this.nextRead(line);
        }
    }

    @Override
    public List getAllTypes() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(OBJECT_TYPE);
        return list;
    }

    @Override
    public void handle(VarFileLine line, boolean hasMapping) {
        if (line.getType().equalsIgnoreCase(OBJECT_TYPE)) {
            this.createIndex(line, hasMapping);
        } else {
            this.nextHandler(line, hasMapping);
        }
    }

    private void createIndex(VarFileLine line, boolean hasMapping) {
        this.columnNotExist = false;
        this.mapColumnSortType = new Hashtable();
        StorageGroupDB2 storageGroup = (StorageGroupDB2)this.getCreatedObject(this.getField(line, "STORAGEGROUP"));
        VCatDB2 vcat = (VCatDB2)this.getCreatedObject(this.getField(line, "VCAT"));
        Table table = (Table)this.getCreatedObject(this.getField(line, "index_table_id"));
        List columns = this.getColumnFromSelected(this.getField(line, "coljct5"));
        boolean intgrIndex = false;
        if (table != null && !this.columnNotExist) {
            if (!hasMapping) {
                this.index = null;
                String pkKey = null;
                String indexKey = this.getField(line, "coljct5").trim();
                for (VarFileLine selectedLine : this.getAllPrimaryKeyLines()) {
                    String key = this.getField(selectedLine, "primarykey_coljct5").trim();
                    if (!indexKey.equalsIgnoreCase(key)) continue;
                    pkKey = this.getField(selectedLine, "general_id").trim();
                    break;
                }
                this.index = (Index)this.getAllCreatedObjects().get(pkKey);
                String indexName = this.getField(line, "index_name");
                if (this.index == null || !indexName.equalsIgnoreCase(this.index.getName())) {
                    this.index = table.createIndex();
                    for (Column column : columns) {
                        String sortType = (String)this.mapColumnSortType.get(column);
                        this.index.add(column);
                        if (!"1".equalsIgnoreCase(sortType)) continue;
                        this.index.setColumnSortOrder(column, "DESC");
                    }
                    this.index.setName(indexName);
                }
                this.fillElements(line, this.index, table, storageGroup, vcat, true);
                this.addCreatedObject(this.getField(line, "general_id"), this.index);
                this.removeSelectedLine(line);
            } else {
                String idIndex = this.getField(line, "general_id");
                this.index = (Index)this.getAllCreatedObjects().get(idIndex);
                if (this.index != null) {
                    if (table.getKeyObject(this.index.getObjectID()) == null) {
                        this.index = table.createIndex();
                        Iterator it = columns.iterator();
                        while (it.hasNext()) {
                            try {
                                Column column = (Column)it.next();
                                String sortType = (String)this.mapColumnSortType.get(column);
                                this.index.add(column);
                                if (!"1".equalsIgnoreCase(sortType)) continue;
                                this.index.setColumnSortOrder(column, "DESC");
                            }
                            catch (Exception e) {
                                StringBuffer message = new StringBuffer("1 error adding columns in RHIndex.createIndex() ");
                                message.append(line.getLine());
                                LOGGER.error(message.toString(), e);
                                this.importLog.addError("Error adding column to index " + this.index.toString());
                            }
                        }
                    }
                } else {
                    this.index = table.createIndex();
                    Iterator itColumns = columns.iterator();
                    while (itColumns.hasNext()) {
                        try {
                            Column column = (Column)itColumns.next();
                            String sortType = (String)this.mapColumnSortType.get(column);
                            this.index.add(column);
                            if (!"1".equalsIgnoreCase(sortType)) continue;
                            this.index.setColumnSortOrder(column, "DESC");
                        }
                        catch (Exception e) {
                            StringBuffer message = new StringBuffer("2 error adding columns in RHIndex.createIndex() ");
                            message.append(line.getLine());
                            LOGGER.error(message.toString(), e);
                            this.importLog.addError("Error adding column to index " + this.index.toString());
                        }
                    }
                    this.fillElements(line, this.index, table, storageGroup, vcat, intgrIndex);
                    this.addCreatedObject(this.getField(line, "general_id"), this.index);
                    this.removeSelectedLine(line);
                }
            }
        }
    }

    private List getColumnFromSelected(String indexId) {
        TreeMap<Integer, Column> map = new TreeMap<Integer, Column>();
        Integer col_pos = new Integer(3);
        ArrayList<ContainedObject> columns = new ArrayList<ContainedObject>();
        for (VarFileLine selectedLine : this.getAllSelectedLines()) {
            if (!selectedLine.getType().equalsIgnoreCase("COLJCT") || !this.getField(selectedLine, "COLJCT_5_KEY").equalsIgnoreCase(indexId)) continue;
            Column selectColumn = (Column)this.getCreatedObject(this.getField(selectedLine, "COLJCT_COLUMN_KEY"));
            String sortType = this.getField(selectedLine, "COLJCT_5_SORT_TYPE");
            String pos = this.getField(selectedLine.getLine(), col_pos);
            int position = Integer.parseInt(pos);
            if (selectColumn != null) {
                map.put(new Integer(position), selectColumn);
                this.mapColumnSortType.put(selectColumn, sortType);
                continue;
            }
            this.columnNotExist = true;
        }
        for (Integer key : map.keySet()) {
            ContainedObject col = (ContainedObject)map.get(key);
            if (col == null) continue;
            columns.add(col);
        }
        return columns;
    }

    protected int getPosition(String columnID) {
        List columnList = this.getAllColumnLines();
        for (VarFileLine line : columnList) {
            String idColumn = this.getField(line, "general_id");
            if (!idColumn.equals(columnID)) continue;
            try {
                int pos = Integer.parseInt(this.getField(line, "COLUMN_ORDNUM"));
                return pos;
            }
            catch (NumberFormatException e) {
                StringBuffer message = new StringBuffer("wrong Format in RHIndex.getPosition : ");
                message.append(line.getLine());
                LOGGER.error(message.toString(), e);
                this.importLog.addError("Wrong column position format near " + line);
            }
        }
        return 0;
    }

    private void fillClustered(VarFileLine line, IndexProxyDB2 indexProxy) {
        try {
            int clustered = Integer.parseInt(this.getField(line, "CLUSTERED"));
            switch (clustered) {
                case 0: {
                    indexProxy.setClustered(false);
                    break;
                }
                case 1: {
                    indexProxy.setClustered(true);
                    break;
                }
                default: {
                    indexProxy.setClustered(false);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHIndex.fillClustered : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL CLUSTER format near " + line);
        }
    }

    private void fillClusterType(VarFileLine line, IndexProxyDB2 indexProxy) {
        try {
            String cluster = this.getField(line, "CLUSTERED").trim();
            if (cluster.equals("1")) {
                List indexPartKeys = this.getPartIndexKeys(this.getField(line, "general_id"));
                if (indexPartKeys.size() > 0) {
                    indexProxy.setClusterType(IndexProxyDB2.CLUSTER_TYPES[2]);
                } else {
                    indexProxy.setClusterType(IndexProxyDB2.CLUSTER_TYPES[1]);
                }
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHIndex.fillClusterType : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong CLUSTER TYPE format near " + line);
        }
    }

    private List getPartIndexKeys(String indKey) {
        ArrayList<String> keyList = new ArrayList<String>();
        String partKey = null;
        for (VarFileLine selectedLine : this.getAllSelectedLines()) {
            if (!selectedLine.getType().equalsIgnoreCase("PARTITION_BOUNDARY")) continue;
            partKey = this.getField(selectedLine, "PARTITION_BOUNDARY_PARTID");
            Iterator partIT = this.getAllSelectedLines().iterator();
            String indexKey = null;
            while (partIT.hasNext()) {
                VarFileLine selectedLine2 = (VarFileLine)partIT.next();
                if (!selectedLine2.getType().equalsIgnoreCase("PARTITIONS") || !this.getField(selectedLine2, "general_id").equalsIgnoreCase(partKey) || !indKey.equalsIgnoreCase(indexKey = this.getField(selectedLine2, "TABLESPACE_PART_INDEX_KEY"))) continue;
                keyList.add(partKey);
            }
        }
        return keyList;
    }

    private void fillClusteredRatio(VarFileLine line, IndexProxyDB2 indexProxy) {
        try {
            int clusteredRatio = Integer.parseInt(this.getField(line, "CLUSTEREDRATIO"));
            if (clusteredRatio > 0) {
                indexProxy.setClusterRatio(clusteredRatio);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHIndex.fillClusterdRatio : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong CLUSTER RATIO format near " + line);
        }
    }

    private void fillCloseRule(VarFileLine line, IndexProxyDB2 indexProxy) {
        try {
            int closeRule = Integer.parseInt(this.getField(line, "CLOSERULE"));
            if (closeRule == 0) {
                indexProxy.setClose(false);
            } else if (closeRule == 1) {
                indexProxy.setClose(true);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHIndex.fillCloseRule : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL CLOSE RULE format near " + line);
        }
    }

    private void fillEraseRule(VarFileLine line, IndexProxyDB2 indexProxy) {
        try {
            int eraseRule = Integer.parseInt(this.getField(line, "ERASERULE"));
            if (eraseRule == 0) {
                indexProxy.getStorageTemplate().setSgErase(false);
            } else if (eraseRule == 1) {
                indexProxy.getStorageTemplate().setSgErase(true);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHIndex.fillEraseRule : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL ERASE RULE format near " + line);
        }
    }

    private void fillFreepage(VarFileLine line, IndexProxyDB2 indexProxy) {
        try {
            int freepage = Integer.parseInt(this.getField(line, "FREEPAGE"));
            if (freepage >= 0) {
                indexProxy.getStorageTemplate().setFreePage(freepage);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHIndex.fillFreepage : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL FREE PAGE format near " + line);
        }
    }

    private void fillInterval(VarFileLine line, IndexProxyDB2 indexProxy) {
        try {
            int interval = Integer.parseInt(this.getField(line, "INTERVAL"));
            if (interval > 0) {
                indexProxy.setMaintenanceInterval(interval);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHIndex.fillInterval : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL INTERVAL format near " + line);
        }
    }

    private void fillPctfree(VarFileLine line, IndexProxyDB2 indexProxy) {
        try {
            int pctFree = Integer.parseInt(this.getField(line, "PCTFREE"));
            if (pctFree >= 0) {
                indexProxy.getStorageTemplate().setPctFree(pctFree);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHIndex.fillPctfree : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL PCT FREE format near " + line);
        }
    }

    private void fillPriqty(VarFileLine line, IndexProxyDB2 indexProxy) {
        try {
            int priqty = Integer.parseInt(this.getField(line, "PRIQTY"));
            if (priqty > -1) {
                indexProxy.getStorageTemplate().setSgPriqty(priqty);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHIndex.fillPriqty : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL PRIQTY format near " + line);
        }
    }

    private void fillSecqty(VarFileLine line, IndexProxyDB2 indexProxy) {
        try {
            int secqty = Integer.parseInt(this.getField(line, "SECQTY"));
            if (secqty > -1) {
                indexProxy.getStorageTemplate().setSgSeqty(secqty);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHIndex.fillSecqty : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL SECQTY format near " + line);
        }
    }

    private void fillSpaceAlloc(VarFileLine line, IndexProxyDB2 indexProxy) {
        try {
            int spaceAlloc = Integer.parseInt(this.getField(line, "SPACE_ALLOC"));
            if (spaceAlloc >= 0) {
                indexProxy.setSpaceAllocationInterval(spaceAlloc);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHIndex.fillSpaceAlloc : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL SPACE ALLOC format near " + line);
        }
    }

    private void fillPieceSize(VarFileLine line, IndexProxyDB2 indexProxy) {
        try {
            String spaceAlloc = this.getField(line, "PIECESIZE");
            if (Integer.parseInt(spaceAlloc) > 0) {
                indexProxy.setPieceSize(spaceAlloc + " K");
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHIndex.fillPieceSize : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL PIECE SIZE format near " + line);
        }
    }

    private void fillGBCache(VarFileLine line, IndexProxyDB2 indexProxy) {
        try {
            int gbCache = Integer.parseInt(this.getField(line, "BG_CACHE"));
            if (gbCache == 1) {
                indexProxy.getStorageTemplate().setGbCache(StorageTemplateDB2.GBCACHE[1]);
            } else if (gbCache == 2) {
                indexProxy.getStorageTemplate().setGbCache(StorageTemplateDB2.GBCACHE[2]);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHIndex.fillGBCache : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL GB CACHE format near " + line);
        }
    }

    private void fillDefer(VarFileLine line, IndexProxyDB2 indexProxy) {
        try {
            int defer = Integer.parseInt(this.getField(line, "DEFER"));
            if (defer == 0) {
                indexProxy.setDefer(false);
            } else if (defer == 1) {
                indexProxy.setDefer(true);
            }
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHIndex.fillDefer : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL DEFER format near " + line);
        }
    }

    private void fillUnique(IndexProxyDB2 indexproxy, Index index, VarFileLine line) {
        String unique = null;
        String constraint = null;
        int testCool = (Integer)this.getFieldConstants().get("IS_COOL");
        if (testCool == 1000) {
            String columnSetKey = this.getField(line, "COLUMNSET_KEY").trim();
            List allLines = this.getAllSelectedLines();
            for (VarFileLine selectedLine : allLines) {
                if (!selectedLine.getType().equalsIgnoreCase("COLUMN_SET") || !columnSetKey.equalsIgnoreCase(this.getField(selectedLine, "general_id"))) continue;
                unique = this.getField(selectedLine, "COLUMNSET_COLSET_UNIQUE").trim();
                if (unique.equals("1")) {
                    index.setIndexState("Unique Plain Index");
                    continue;
                }
                if (!unique.equals("2")) continue;
                index.setIndexState("Unique Plain Index");
                indexproxy.setWhereNotNull(true);
            }
        } else {
            String where = this.getField(line, "cool_where_not_null").trim();
            unique = this.getField(line, "cool_unique").trim();
            constraint = this.getField(line, "constraint").trim();
            if (unique.equals("1")) {
                if (constraint.equals("1")) {
                    index.setIndexState("Unique Plain Index");
                } else {
                    index.setIndexState("Unique Plain Index");
                }
            }
            if (where.equals("1")) {
                indexproxy.setWhereNotNull(true);
            }
        }
    }

    private void fillBufferpool(VarFileLine line, IndexProxyDB2 indexProxy) {
        String bufferpoolKey = this.getField(line, "BUFFERPOOL");
        BufferPoolDB2 bufferpool = (BufferPoolDB2)this.getCreatedObject(bufferpoolKey);
        if (bufferpool != null) {
            indexProxy.setBufferPool(bufferpool);
        }
    }

    private void fillCommentOn(VarFileLine line, IndexProxyDB2 indexProxy) {
        String commentKey = this.getField(line, "TEXT");
        for (VarFileLine selectedLine : this.getAllSelectedLines()) {
            if (!selectedLine.getType().equalsIgnoreCase("TEXT") || !this.getField(selectedLine, "general_id").equalsIgnoreCase(commentKey)) continue;
            String comment = this.getField(selectedLine, "text_comment");
            indexProxy.setCommentInRDBMS(comment);
        }
    }

    private void fillOwner(VarFileLine line, IndexProxyDB2 indexProxy, Table table) {
        int testCool = (Integer)this.getFieldConstants().get("IS_COOL");
        if (testCool == 1000) {
            String ownerName = this.getField(line, "CREATE_BY");
            Owner owner = (Owner)this.getAllCreatedObjects().get(ownerName);
            if (owner == null) {
                owner = (Owner)((AbstractStorageDesignDB2)indexProxy.getStorageDesign()).getOwnerSet().createElement(null);
                owner.setName(ownerName);
                this.addCreatedObject(ownerName, owner);
            }
            indexProxy.setOwner(owner);
        } else {
            TableProxyDB2 tableProxy = (TableProxyDB2)indexProxy.getStorageDesign().getTableProxySet().getProxy(table.getObjectID());
            indexProxy.setOwner(tableProxy.getOwner());
        }
    }

    private void fillUpdateRate(VarFileLine line, IndexProxyDB2 indexProxy) {
        try {
            float updateRate = Float.parseFloat(this.getField(line, "UPDATE_RATE"));
            indexProxy.setUpdateRatePercent(updateRate *= 100.0f);
        }
        catch (NumberFormatException e) {
            StringBuffer message = new StringBuffer("wrong Format in RHIndex.fillUpdateRate : ");
            message.append(line.getLine());
            LOGGER.error(message.toString(), e);
            this.importLog.addWarning("Wrong FILL UPDATE RATE format near " + line);
        }
    }

    protected void fillElements(VarFileLine line, Index index, Table table, StorageGroupDB2 storageGroup, VCatDB2 vcat, boolean integrIndex) {
        index.setComment(this.getComment(line));
        this.setCreatorChanger(index, line);
        RDBMSSite site = this.getDesign().getSelectedRDBMSSite();
        StorageDesignDB2v70 storageDesign = (StorageDesignDB2v70)this.getDesign().getStorageDesign(site);
        IndexProxyDB2 indexProxy = (IndexProxyDB2)storageDesign.getIndexProxySet().getProxy(index.getObjectID());
        if (indexProxy != null) {
            indexProxy.setAllowIntegrityIndexNR(false);
            if (integrIndex) {
                indexProxy.setName(this.getField(line, "index_name"));
            }
            indexProxy.setNoIntegrity(true);
            StorageTemplateDB2 st = storageDesign.getStorageTemplateSet().createStorageTemplate();
            indexProxy.setStorageTemplate(st);
            if (storageGroup != null) {
                indexProxy.getStorageTemplate().setStorageGroup(storageGroup);
            } else if (vcat != null) {
                indexProxy.getStorageTemplate().setVCat(vcat);
            }
            this.fillOwner(line, indexProxy, table);
            if (!index.isPK() && !index.isUnique()) {
                this.fillUnique(indexProxy, index, line);
            }
            this.fillClustered(line, indexProxy);
            this.fillClusterType(line, indexProxy);
            this.fillClusteredRatio(line, indexProxy);
            indexProxy.setCreatedBy(this.getField(line, "CREATE_BY"));
            this.fillCloseRule(line, indexProxy);
            this.fillEraseRule(line, indexProxy);
            this.fillFreepage(line, indexProxy);
            this.fillInterval(line, indexProxy);
            this.fillPctfree(line, indexProxy);
            this.fillPriqty(line, indexProxy);
            this.fillSecqty(line, indexProxy);
            this.fillSpaceAlloc(line, indexProxy);
            this.fillPieceSize(line, indexProxy);
            this.fillDefer(line, indexProxy);
            this.fillGBCache(line, indexProxy);
            this.fillBufferpool(line, indexProxy);
            this.fillUpdateRate(line, indexProxy);
            this.fillCommentOn(line, indexProxy);
            StorageTemplateDB2 realst = storageDesign.getStorageTemplateSet().removeIfExistEqual(indexProxy.getStorageTemplate());
            if (realst != indexProxy.getStorageTemplate()) {
                indexProxy.setStorageTemplate(realst);
            }
        }
    }

    private String getComment(VarFileLine line) {
        String comment = null;
        if (!this.getField(line, "INDEX_TEXT_ID").equalsIgnoreCase("0")) {
            VarFileLine commentLine = this.getCommentLine(this.getField(line, "INDEX_TEXT_ID"), "TEXT");
            if (commentLine != null) {
                comment = this.getField(commentLine, "text_comment");
            }
        } else {
            comment = "";
        }
        return comment;
    }
}

