/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBDropTableConstraint;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.swingui.compare.ddl.CDDLFileMaker;

public class CSSBAlterTableConstraint
extends AbstractCSSBOracle {
    private CSSBDropTableConstraint dropConstraint;
    protected StorageDesignOracle storageDesign;

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection obj = (CompareObjectSelection)object;
        CompareObjectSelection tobj = obj.getCorrespondentNode();
        TableLevelConstraint sourceConstraint = (TableLevelConstraint)obj.getObject();
        Table sourceTable = sourceConstraint.getTable();
        if (sourceTable != null) {
            Design design = sourceTable.getDesign();
            RDBMSSite site = sourceTable.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOracle)design.getStorageDesign(site, sourceTable);
            if (obj.canBeCreate()) {
                this.appendAddConstraint(oldbuffer, obj, sourceTable, prettyPrint);
            } else {
                this.appendModifyConstraint(oldbuffer, obj, tobj, sourceTable, prettyPrint);
            }
        }
    }

    private void appendModifyConstraint(StringBuffer oldbuffer, CompareObjectSelection obj, CompareObjectSelection tobj, Table sourceTable, boolean prettyPrint) {
        TableProxyOracle tableProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(sourceTable.getObjectID());
        Map propMap = this.getPropertiesMap(obj);
        if (tableProxy != null && !propMap.isEmpty()) {
            TableLevelConstraint sourceConstraint = (TableLevelConstraint)obj.getObject();
            TableCheckConstraintOracle checkConstraint = tableProxy.getTableConstraint(sourceConstraint);
            if (sourceConstraint.isGenerateInDDL()) {
                String formattedCName;
                if (this.dropConstraint == null) {
                    this.dropConstraint = new CSSBDropTableConstraint();
                }
                this.dropConstraint.doAppend(oldbuffer, obj, prettyPrint);
                String cname = formattedCName = CSSBAlterTableConstraint.getFormattedSelectedName(obj, this.storageDesign);
                if (formattedCName.startsWith("\"")) {
                    cname = formattedCName.substring(1, formattedCName.length() - 1);
                }
                String rule = tobj.getChoosedPropertyValue(PropertiesComparator.RULE);
                StringBuffer buffer = new StringBuffer();
                this.appendBeforeAlterScript(oldbuffer, prettyPrint, sourceTable);
                CSSBAlterTableConstraint.appendStringWithSpace(buffer, "ALTER");
                CSSBAlterTableConstraint.appendStringWithSpace(buffer, "TABLE");
                CSSBAlterTableConstraint.appendStringWithSpace(buffer, this.getTableName(tobj));
                CSSBAlterTableConstraint.appendStringWithSpace(buffer, "ADD");
                if (!"".equals(cname) && !cname.toUpperCase().startsWith("SYS_")) {
                    CSSBAlterTableConstraint.appendStringWithSpace(buffer, "CONSTRAINT");
                    CSSBAlterTableConstraint.appendStringWithSpace(buffer, formattedCName);
                }
                String advancedComment = buffer.toString();
                CSSBAlterTableConstraint.appendNewLine(buffer, prettyPrint, 1);
                CSSBAlterTableConstraint.appendStringWithSpace(buffer, "CHECK");
                CSSBAlterTableConstraint.appendString(buffer, '(');
                CSSBAlterTableConstraint.appendString(buffer, rule);
                CSSBAlterTableConstraint.appendString(buffer, ')');
                this.appendTableConstraintState(buffer, checkConstraint, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBAlterTableConstraint.appendNewLine(buffer, prettyPrint, 0);
                CSSBAlterTableConstraint.appendLineFinisher(buffer, prettyPrint);
                CSSBAlterTableConstraint.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CDDLFileMaker.incrementAlterTable();
                this.appendAfterAlterScript(oldbuffer, prettyPrint, sourceTable);
            }
        }
    }

    @Override
    public Map getPropertiesMap(CompareObjectSelection obj) {
        TreeMap<String, String> propMap = new TreeMap<String, String>();
        for (EngPropertyHolder ph : obj.getPropertiesComparator().getPropertiesList()) {
            if (!ph.isSelected() || !ph.isModified() || !ph.isDDLHolder() || ph.isExcluded() || ph.isFiltered()) continue;
            if (ph.getName().equals(PropertiesComparator.NAME)) {
                propMap.put(PropertiesComparator.NAME, ph.getLeftValue());
                continue;
            }
            if (!ph.getName().equals(PropertiesComparator.RULE)) continue;
            propMap.put(PropertiesComparator.RULE, ph.getLeftValue());
        }
        return propMap;
    }

    private void appendAddConstraint(StringBuffer oldbuffer, CompareObjectSelection sourceConstraint, Table table, boolean prettyPrint) {
        TableProxyOracle tableProxy;
        TableLevelConstraint tableConstraint = (TableLevelConstraint)sourceConstraint.getObject();
        String rule = tableConstraint.getRule();
        if (!"".equals(rule) && tableConstraint.isGenerateInDDL() && (tableProxy = (TableProxyOracle)this.storageDesign.getTableProxySet().getProxy(table.getObjectID())) != null) {
            TableCheckConstraintOracle checkConstraint = tableProxy.getTableConstraint(tableConstraint);
            StringBuffer buffer = new StringBuffer();
            this.appendBeforeAlterScript(oldbuffer, prettyPrint, table);
            CSSBAlterTableConstraint.appendStringWithSpace(buffer, "ALTER");
            CSSBAlterTableConstraint.appendStringWithSpace(buffer, "TABLE");
            CSSBAlterTableConstraint.appendStringWithSpace(buffer, this.getTableName(sourceConstraint));
            CSSBAlterTableConstraint.appendStringWithSpace(buffer, "ADD");
            String cname = checkConstraint.getName().toUpperCase();
            if (!("".equals(cname) || cname.startsWith("SYS_") || cname.startsWith("NULL SET GENERATED_"))) {
                CSSBAlterTableConstraint.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBAlterTableConstraint.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(checkConstraint));
            }
            String advancedComment = buffer.toString();
            CSSBAlterTableConstraint.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterTableConstraint.appendStringWithSpace(buffer, "CHECK");
            CSSBAlterTableConstraint.appendString(buffer, '(');
            CSSBAlterTableConstraint.appendString(buffer, rule);
            CSSBAlterTableConstraint.appendString(buffer, ')');
            this.appendTableConstraintState(buffer, checkConstraint, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBAlterTableConstraint.appendNewLine(buffer, prettyPrint, 0);
            CSSBAlterTableConstraint.appendLineFinisher(buffer, prettyPrint);
            CSSBAlterTableConstraint.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CDDLFileMaker.incrementAlterTable();
            this.appendAfterAlterScript(oldbuffer, prettyPrint, table);
        }
    }

    private void appendTableConstraintState(StringBuffer buffer, TableCheckConstraintOracle constraint, boolean prettyPrint) {
        if (!"NO".equalsIgnoreCase(constraint.getDeferrable())) {
            CSSBAlterTableConstraint.appendNewLine(buffer, prettyPrint, 2);
            CSSBAlterTableConstraint.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(constraint.getInitially())) {
                CSSBAlterTableConstraint.appendStringWithSpace(buffer, "INITIALLY");
                CSSBAlterTableConstraint.appendStringWithSpace(buffer, "DEFERRED");
            } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBAlterTableConstraint.appendStringWithSpace(buffer, "INITIALLY");
                CSSBAlterTableConstraint.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBAlterTableConstraint.appendNewLine(buffer, prettyPrint, 2);
            CSSBAlterTableConstraint.appendStringWithSpace(buffer, "NOT");
            CSSBAlterTableConstraint.appendStringWithSpace(buffer, "DEFERRABLE");
        }
        if (this.storageDesign.getAppView().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBAlterTableConstraint.appendNewLine(buffer, prettyPrint, 2);
            if ("YES".equalsIgnoreCase(constraint.getEnable())) {
                CSSBAlterTableConstraint.appendStringWithSpace(buffer, "ENABLE");
            } else {
                CSSBAlterTableConstraint.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(constraint.getValidate())) {
                CSSBAlterTableConstraint.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                CSSBAlterTableConstraint.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if ("NO".equalsIgnoreCase(constraint.getEnable())) {
                CSSBAlterTableConstraint.appendNewLine(buffer, prettyPrint, 2);
                CSSBAlterTableConstraint.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(constraint.getValidate())) {
                    CSSBAlterTableConstraint.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if ("NO".equalsIgnoreCase(constraint.getValidate())) {
                CSSBAlterTableConstraint.appendNewLine(buffer, prettyPrint, 2);
                CSSBAlterTableConstraint.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
        if (constraint.getExceptionsTable() != null) {
            CSSBAlterTableConstraint.appendNewLine(buffer, prettyPrint, 2);
            CSSBAlterTableConstraint.appendStringWithSpace(buffer, "EXCEPTIONS");
            CSSBAlterTableConstraint.appendStringWithSpace(buffer, "INTO");
            CSSBAlterTableConstraint.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(constraint.getExceptionsTable()));
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof TableLevelConstraint;
    }

    protected String getTableName(CompareObjectSelection constraint) {
        CompareObjectSelection table = constraint.getTableNode();
        if (table != null) {
            return CSSBAlterTableConstraint.getFormattedTableName(table, this.storageDesign);
        }
        return "";
    }
}

