/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ClusterOracle;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.oracle.ClusterColumnPropertyDialogOracle;

public abstract class ClusterColumnOracle
extends AbstractStorageObjectOracle {
    private static final String[] DATA_TYPES = new String[]{"UNKNOWN", "BINARY_DOUBLE", "BINARY_FLOAT", "CHAR", "DATE", "DEC", "DECIMAL", "DOUBLE PRECISION", "FLOAT", "INT", "INTEGER", "INTERVAL DAY TO SECOND", "INTERVAL YEAR TO MONTH", "NCHAR", "NUMBER", "NUMERIC", "NVARCHAR2", "RAW", "REAL", "ROWID", "SMALLINT", "TIMESTAMP", "TIMESTAMP WITH TIME ZONE", "TIMESTAMP WITH LOCAL TIME ZONE", "UROWID", "VARCHAR", "VARCHAR2"};
    private static List dataTypesList = Arrays.asList(DATA_TYPES);
    private static Set dataTypesSet = null;
    private ClusterOracle cluster = null;
    private String dataType = DATA_TYPES[0];
    private String lengthPrecision = "";
    private int scale = 0;
    private int position = 1;
    public static final String TYPE_NAME = "ClColumn";
    public static final String OLD_TYPE_NAME = "ClusterColumn";

    @Override
    public String getIDPrefix() {
        return "CC";
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getOldObjectTypeName() {
        return OLD_TYPE_NAME;
    }

    public ClusterOracle getCluster() {
        return this.cluster;
    }

    public void setCluster(ClusterOracle cluster) {
        this.cluster = cluster;
        this.setPAC_Element(cluster);
        this.fireDataFieldChange();
    }

    public static String[] getDataTypesChoices() {
        return DATA_TYPES;
    }

    protected boolean checkDataType(String value) {
        if (dataTypesSet == null) {
            dataTypesSet = new HashSet();
            dataTypesSet.addAll(Arrays.asList(ClusterColumnOracle.getDataTypesChoices()));
        }
        return dataTypesSet.contains(value);
    }

    public void setDataType(String value) {
        if (!this.dataType.equals(value) && this.checkDataType(value)) {
            this.dataType = value;
            if (!this.isLengthPrecAllowed(this.dataType)) {
                this.lengthPrecision = "";
            }
            if (!this.isScaleAllowed(this.dataType)) {
                this.scale = 0;
            }
            this.fireDataFieldChange();
        }
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getLengthPrecision() {
        return this.lengthPrecision;
    }

    public void setLengthPrecision(String lengthPrecision) {
        this.lengthPrecision = lengthPrecision;
        this.fireDataFieldChange();
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public boolean isLengthPrecAllowed(String datatype) {
        return datatype.contains("CHAR") || datatype.equals("RAW") || datatype.equals("UROWID") || datatype.startsWith("DEC") || datatype.equals("FLOAT") || datatype.startsWith("NUM") || datatype.startsWith("TIMESTAMP") || datatype.startsWith("INTERVAL");
    }

    public boolean isScaleAllowed(String datatype) {
        return datatype.startsWith("DEC") || datatype.startsWith("NUM") || datatype.equals("INTERVAL DAY TO SECOND");
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public static List getDataTypesValues() {
        return dataTypesList;
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            ClusterColumnPropertyDialogOracle dialog = new ClusterColumnPropertyDialogOracle(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public Icon getIcon() {
        return GUIConfiguration.getInstance().getIcon("COLUMN_ICON", 16);
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }
}

