/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.udb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.Constants;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.storage.IndexProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.OwnerUDB;
import oracle.dbtools.crest.model.design.storage.udb.SchemaUDB;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.swingui.editor.storage.udb.IndexPropertyDialogUDB;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class IndexProxyUDB
extends IndexProxy
implements Constants,
PropertiesPropagator {
    private SchemaUDB schema = null;
    private OwnerUDB owner = null;
    private String includeColumns = "";
    private ColumnSet columnListSet = null;
    private boolean cluster = false;
    private int percentageFree = 10;
    private int level2PercentageFree = 10;
    private int minimumPercentageUsed = 0;
    private boolean reverseScan = false;
    public static final String[] PAGE_SPLIT_STATES = new String[]{"", "SYMMETRIC", "HIGH", "LOW"};
    private String pageSplit = "";
    private String users = "";
    private UserSet userSet = null;
    private String userGroups = "";
    private UserSet userGroupSet = null;
    public static final String YES = "YES";
    public static final String NO = "NO";
    public static final String[] YES_NO_STATES = new String[]{"YES", "NO"};
    private static Set yesNoSet = null;
    private List propertyWrapperList = null;

    public IndexProxyUDB(Index index, StorageDesign storageDesign) {
        super(index, storageDesign);
    }

    public IndexProxyUDB(Design design, String id, String longName, StorageDesign storageDesign) {
        super(design, id, longName, storageDesign);
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        super.changed(object, event);
        if (event.isType(ObjectChangeEvent.KEY_CHANGED_TO_PK)) {
            this.setIsNullInstance(true);
        } else if (event.isType(ObjectChangeEvent.KEY_CHANGED_NO_PK)) {
            if (!this.isUniqueConstraint()) {
                this.setIsNullInstance(false);
            }
        } else if (event.isType(ObjectChangeEvent.ADD_FK)) {
            this.getStorageDesign().getIndexProxySet().remove(this);
            ((StorageDesignUDB)this.getStorageDesign()).getFKProxySet().add(object);
        } else if (event.isType(ObjectChangeEvent.KEY_CHANGED_TO_UNIQUE)) {
            this.setIsNullInstance(true);
        } else if (event.isType(ObjectChangeEvent.KEY_CHANGED_NO_UNIQUE) && !this.isUniqueConstraint()) {
            this.setIsNullInstance(false);
        }
        this.fireChangeNoDirty(event);
    }

    private void addColumn(String column) {
        String columnName = column.substring(column.lastIndexOf(46) + 1, column.length());
        if (!this.getColumnSet().contains(columnName)) {
            this.getColumnSet().add(columnName);
        }
    }

    protected void recreateColumnListSet(String columns) {
        this.getColumnSet().clear();
        StringTokenizer st = new StringTokenizer(columns, ",");
        while (st.hasMoreTokens()) {
            this.getColumnSet().add(st.nextToken().trim());
        }
    }

    public String getColumnList() {
        return this.includeColumns;
    }

    public void setColumnList(String column) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnListSet(column);
        } else {
            this.addColumn(column);
        }
        this.includeColumns = this.getColumnSet().toString();
        this.fireDataFieldChange();
    }

    public void setPercentageFree(int percentageFree) {
        this.percentageFree = percentageFree;
    }

    public int getPercentageFree() {
        return this.percentageFree;
    }

    public void setLevel2PercentageFree(int percentageFree) {
        this.level2PercentageFree = percentageFree;
    }

    public int getLevel2PercentageFree() {
        return this.level2PercentageFree;
    }

    public void setMinimumPercentageUsed(int minimumPercentageUsed) {
        this.minimumPercentageUsed = minimumPercentageUsed;
    }

    public int getMinimumPercentageUsed() {
        return this.minimumPercentageUsed;
    }

    public void setReverseScanSupport(boolean reverseScan) {
        this.reverseScan = reverseScan;
    }

    public boolean getReverseScanSupport() {
        return this.reverseScan;
    }

    public void setPageSplit(String pageSplit) {
        for (int i = 0; i < PAGE_SPLIT_STATES.length; ++i) {
            if (!pageSplit.equalsIgnoreCase(PAGE_SPLIT_STATES[i])) continue;
            this.pageSplit = pageSplit;
            break;
        }
    }

    public String getPageSplit() {
        return this.pageSplit;
    }

    public void setUnique(boolean unique) {
        this.getIndex().setUnique(unique);
    }

    public SchemaUDB getSchema() {
        return this.schema;
    }

    public void setSchema(SchemaUDB schema) {
        this.schema = schema;
        this.fireDataFieldChange();
    }

    public OwnerUDB getOwner() {
        return this.owner;
    }

    public void setOwner(OwnerUDB owner) {
        if (owner != null) {
            this.owner = owner;
            this.fireChange(ObjectChangeEvent.NAME_CHANGED);
        }
    }

    public boolean getCluster() {
        return this.cluster;
    }

    public void setCluster(boolean cluster) {
        this.cluster = cluster;
    }

    @Override
    public boolean isUnique() {
        return this.getIndex().getIndexState().equalsIgnoreCase("Unique Plain Index");
    }

    public boolean isUniqueConstraint() {
        return this.getIndex().getIndexState().equalsIgnoreCase("Unique Constraint");
    }

    @Override
    public String getLongName() {
        if (this.getSchema() != null) {
            return new StringBuffer(this.getSchema().getLongName()).append('.').append(this.getName()).toString();
        }
        Index index = (Index)this.getObject();
        SchemaObject so = index.getSchemaObject();
        if (so != null) {
            StorageObject user = ((StorageDesignUDB)this.getStorageDesign()).getSchemaSet().getBySchemaObject(so);
            if (user != null) {
                return new StringBuffer(user.getLongName()).append('.').append(this.getName()).toString();
            }
            if (!this.getStorageDesign().isOpen()) {
                return new StringBuffer(so.getLongName()).append('.').append(this.getName()).toString();
            }
        }
        return super.getLongName();
    }

    public ColumnSet getColumnSet() {
        if (this.columnListSet == null) {
            this.columnListSet = new ColumnSet();
        }
        return this.columnListSet;
    }

    public void clear() {
        this.getColumnSet().removeAllElements();
        this.includeColumns = "";
    }

    private void addUser(String user) {
        if (!this.getUserSet().contains(user)) {
            this.getUserSet().add(user);
        }
    }

    protected void recreateUserSet(String users) {
        this.getUserSet().clear();
        StringTokenizer st = new StringTokenizer(users, ",");
        while (st.hasMoreTokens()) {
            this.getUserSet().add(st.nextToken().trim());
        }
    }

    public void setUsers(String users) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUserSet(users);
        } else {
            this.addUser(users);
        }
        this.users = this.getUserSet().toString();
        this.fireDataFieldChange();
    }

    public String getUsers() {
        return this.users;
    }

    public UserSet getUserSet() {
        if (this.userSet == null) {
            this.userSet = new UserSet();
        }
        return this.userSet;
    }

    private void addUserGroup(String group) {
        if (!this.getUserGroupSet().contains(group)) {
            this.getUserGroupSet().add(group);
        }
    }

    protected void recreateUserGroupSet(String groups) {
        this.getUserGroupSet().clear();
        StringTokenizer st = new StringTokenizer(groups, ",");
        while (st.hasMoreTokens()) {
            this.getUserGroupSet().add(st.nextToken().trim());
        }
    }

    public void setGroups(String groups) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateUserGroupSet(groups);
        } else {
            this.addUserGroup(groups);
        }
        this.userGroups = this.getUserGroupSet().toString();
        this.fireDataFieldChange();
    }

    public String getGroups() {
        return this.userGroups;
    }

    public UserSet getUserGroupSet() {
        if (this.userGroupSet == null) {
            this.userGroupSet = new UserSet();
        }
        return this.userGroupSet;
    }

    public void clearUsers() {
        this.getUserSet().removeAllElements();
        this.users = "";
        this.getUserGroupSet().removeAllElements();
        this.userGroups = "";
    }

    public static String[] getYesNoChoices() {
        return YES_NO_STATES;
    }

    protected boolean checkYesNo(String value) {
        if (yesNoSet == null) {
            yesNoSet = new HashSet();
            yesNoSet.addAll(Arrays.asList(IndexProxyUDB.getYesNoChoices()));
        }
        return yesNoSet.contains(value);
    }

    @Override
    public void showPropertyDialog() {
        if (!this.isDialogVisible()) {
            IndexPropertyDialogUDB dialog = new IndexPropertyDialogUDB(this.getDesign().getAppView(), this.getStorageDesign(), this);
            dialog.show();
        }
    }

    @Override
    public List getPropertyWrapperList() {
        if (this.propertyWrapperList == null) {
            this.propertyWrapperList = new ArrayList();
            this.propertyWrapperList.add(new PropertyWrapper("Schema", this, "getSchema", "setSchema", SchemaUDB.class));
            this.propertyWrapperList.add(new PropertyWrapper("Cluster", this, "getCluster", "setCluster", Boolean.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("PCTFREE", this, "getPercentageFree", "setPercentageFree", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Min % Used", this, "getMinimumPercentageUsed", "setMinimumPercentageUsed", Integer.TYPE));
            this.propertyWrapperList.add(new PropertyWrapper("Reverse Scan", this, "getReverseScanSupport", "setReverseScanSupport", Boolean.TYPE));
        }
        return this.propertyWrapperList;
    }

    @Override
    public String getName() {
        if (this.isNameChanged()) {
            return super.getName();
        }
        Index index = (Index)this.getObject();
        String name = index.getName();
        if (index.isFK() && index.getFKAssociation() != null) {
            name = index.getFKAssociation().getName();
        }
        name = this.applyNameSubstitution(name);
        return name;
    }

    @Override
    public String getStorageName() {
        return "";
    }

    public class UserSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }

    public class ColumnSet
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(", ");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

