/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractXMLReader;
import oracle.dbtools.crest.model.persistence.xml.RXMLDomain;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLDomainFile
extends AbstractXMLReader {
    private RXMLDomain delegate;
    private boolean isSystem;

    public RXMLDomainFile(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
        this.delegate = new RXMLDomain(persistenceMgr);
    }

    @Override
    public String getRelativePath(Object object) {
        this.isSystem = object instanceof String && "defaultdomains".equalsIgnoreCase(String.valueOf(object));
        return this.getRelativePath();
    }

    @Override
    public String getRelativePath() {
        if (!this.isSystem) {
            StringBuffer buffer = new StringBuffer();
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/').append(this.getConfiguration().get("domainPath"));
            return buffer.toString();
        }
        return this.getConfiguration().get("typesPath");
    }

    @Override
    protected void handleNoFile(Design design) {
        design.getDomainSet().removeAll();
    }

    @Override
    public Object recreateObject(Document doc, Design design, boolean hasDomainFileLock) {
        Element root = doc.getDocumentElement();
        String tagname = root.getTagName();
        if (tagname.equals("domain")) {
            NodeList domains = doc.getDocumentElement().getElementsByTagName("object");
            int length = domains.getLength();
            Element domainElm = null;
            for (int i = 0; i < length; ++i) {
                domainElm = (Element)domains.item(i);
                if (!"Domain".equals(domainElm.getAttribute("type"))) continue;
                this.delegate.recreateObject(domainElm, design, hasDomainFileLock);
            }
        } else {
            String fname = root.getAttribute("fileName");
            if (fname != null && !"".equals(fname)) {
                this.getPersistenceManager().getAppView().getXMLTransformationManager().loadDomains(design, fname, doc);
            }
        }
        return design.getDomainSet();
    }

    public static void checkAndSetIDGenerator(Design design) {
        Iterator it = design.getDomainSet().iterator();
        long max = 0L;
        long temp = 0L;
        while (it.hasNext()) {
            ModelIDObject mo = (ModelIDObject)it.next();
            String id = mo.getObjectID();
            if (id.indexOf(64) <= -1 || (temp = DesignPart.getCounter(id)) <= max) continue;
            max = temp;
        }
        long startCounter = design.getAppView().getIDGenerator().getStartCounter();
        long lastIndex = design.getAppView().getIDGenerator().getLastIDIndex();
        if (max > lastIndex) {
            design.getAppView().getIDGenerator().setCounter(max - startCounter + 1L);
        }
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }
}

