/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.datatypes;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.datatypes.DTConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLDistinctType
extends AbstractWXMLDesignObject
implements DTConstants {
    private DistinctType distinctType = null;

    public WXMLDistinctType(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof DistinctType;
        if (result) {
            this.distinctType = (DistinctType)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.distinctType != null) {
            String designName = this.distinctType.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("datatypes").append('/');
        }
        buffer.append(this.getConfiguration().get("distincttypePath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof DistinctType) {
            DistinctType distinctType = (DistinctType)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("LogicalType", String.valueOf(distinctType.getLogicalDataType() != null ? StringUtilities.encodeAttributeValue(distinctType.getLogicalDataType().getObjectID()) : "null"));
            map.put("size", distinctType.getSize());
            map.put("Scale", String.valueOf(distinctType.getScale()));
            map.put("Precision", String.valueOf(distinctType.getPrecision()));
            this.appendProperties(objectInfoNode, "attributes", map);
        }
    }
}

