/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.SQLAccessToAW;
import oracle.dbtools.crest.model.design.multidimensional.SQLAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLSQLAccessToAW
extends AbstractRXMLDesignObject
implements MDConstants {
    private Cube cube;
    private Slice slice;
    private boolean hasOutPosition = true;
    private TreeMap posMap = new TreeMap();

    public RXMLSQLAccessToAW(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getMultidimensionalDesign().getSQLAccessToAWSet().createSQLAccessToAW(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        SQLAttribute sqla;
        int i;
        this.hasOutPosition = true;
        this.slice = null;
        this.cube = null;
        SQLAccessToAW sqlAW = (SQLAccessToAW)super.recreateObject(objInfo, design, tryReadWriteLocking);
        this.posMap.clear();
        Map map = this.getProperties(objInfo, "attributes");
        sqlAW.setDescription((String)map.get("description"));
        sqlAW.setAWName((String)map.get("aw_name"));
        sqlAW.setGenerateGIDs(Boolean.valueOf((String)map.get("aw_include_gids")));
        sqlAW.setUseObjectType(Boolean.valueOf((String)map.get("aw_use_object_types")));
        sqlAW.setUseModelClause(Boolean.valueOf((String)map.get("aw_use_model_clause")));
        sqlAW.setUseRowToCellColumn(Boolean.valueOf((String)map.get("aw_include_row2cell")));
        sqlAW.setObjectADTName((String)map.get("aw_object_type_name"));
        sqlAW.setTableADTName((String)map.get("aw_table_type_name"));
        String cube_id = (String)map.get("cube_id");
        if (cube_id != null) {
            this.cube = (Cube)sqlAW.getMultidimensionalDesign().getCubeSet().getObjectByID(cube_id);
            if (this.cube != null) {
                this.cube.getSQLDefinitions().add(sqlAW);
                sqlAW.setCube(this.cube);
            }
        } else {
            String slice_id = (String)map.get("slice_id");
            this.slice = (Slice)sqlAW.getMultidimensionalDesign().getSliceSet().getObjectByID(slice_id);
            if (this.slice != null) {
                this.slice.getSQLDefinitions().add(sqlAW);
                sqlAW.setSlice(this.slice);
            }
        }
        if (this.slice != null) {
            this.handleMeasureWrappers(objInfo, sqlAW, this.slice);
        } else {
            map = this.getProperties(objInfo, "measures");
            Object[] measures = map.keySet().toArray();
            for (i = 0; i < measures.length; ++i) {
                String aID = (String)map.get(measures[i]);
                Measure measure = (Measure)this.cube.getMultidimensionalDesign().getMeasureSet().getObjectByID(aID);
                if (measure == null) continue;
                sqlAW.getMeasures().add(measure);
            }
        }
        this.addOutAttributes(objInfo, sqlAW);
        this.handleSQLDimensions(objInfo, sqlAW);
        if (this.hasOutPosition) {
            sqlAW.getOutSQLAttributes().clear();
            for (Integer pos : this.posMap.keySet()) {
                sqla = (SQLAttribute)this.posMap.get(pos);
                sqlAW.getOutSQLAttributes().add(sqla);
            }
        } else {
            List list = sqlAW.getOutSQLAttributes();
            for (i = 0; i < list.size(); ++i) {
                sqla = (SQLAttribute)list.get(i);
                sqla.setOutPosition(i);
            }
        }
        return sqlAW;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            String dfDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(dfDesName).append('/');
        }
        buffer.append(this.getConfiguration().get("sqltoawPath"));
        return buffer.toString();
    }

    private void handleMeasureWrappers(Element objInfo, SQLAccessToAW sqlAW, Slice slice) {
        Element wrlist = RXMLSQLAccessToAW.getFirstChildByTagName(objInfo, "measure_wrappers");
        if (wrlist != null) {
            NodeList funcList = wrlist.getElementsByTagName("measure_wrapper");
            int length = funcList.getLength();
            for (int j = 0; j < length; ++j) {
                String func_id;
                Element param = (Element)funcList.item(j);
                String id = param.getAttribute("measure_id");
                Slice.MeasureWrapper mw = slice.getMeasureWrapper(id, func_id = param.getAttribute("aggr_function_id"));
                if (mw == null) continue;
                sqlAW.getMeasureWrappers().add(mw);
            }
        }
    }

    private void addHierarchies(Element dimElem, SQLAccessToAW.SQLDimension sqld, SQLAccessToAW sqlAW) {
        Element sqla_list = RXMLSQLAccessToAW.getFirstChildByTagName(dimElem, "aw_hierarchies");
        List hlist = sqld.getSelectedSQLHierarhies();
        if (sqla_list != null) {
            NodeList hierList = sqla_list.getElementsByTagName("aw_hierarchy");
            int length = hierList.getLength();
            for (int i = 0; i < length; ++i) {
                Element heirElem = (Element)hierList.item(i);
                Map map = this.getProperties(heirElem, "attributes");
                String h_id = (String)map.get("hierarchy_id");
                String rollup = (String)map.get("aw_is_rollupform");
                SQLAccessToAW sQLAccessToAW = sqlAW;
                Objects.requireNonNull(sQLAccessToAW);
                SQLAccessToAW.SQLHierarchy sqlh = sQLAccessToAW.new SQLAccessToAW.SQLHierarchy(h_id);
                if ("true".equals(rollup)) {
                    sqlh.setRollupForm(true);
                } else {
                    sqlh.setRollupForm(true);
                }
                map = this.getProperties(heirElem, "levels");
                Object[] dims = map.keySet().toArray();
                for (int j = 0; j < dims.length; ++j) {
                    String aID = (String)map.get(dims[j]);
                    Level level = (Level)sqlAW.getMultidimensionalDesign().getLevelSet().getObjectByID(aID);
                    if (level == null) continue;
                    sqlh.getSelectedLevels().add(level);
                }
                hlist.add(sqlh);
            }
        }
    }

    private void handleSQLDimensions(Element objInfo, SQLAccessToAW sqlAW) {
        Element sl_list = RXMLSQLAccessToAW.getFirstChildByTagName(objInfo, "aw_sql_dimensions");
        if (sl_list != null) {
            NodeList slList = sl_list.getElementsByTagName("aw_sqldimension");
            int length = slList.getLength();
            for (int j = 0; j < length; ++j) {
                Element dimElem = (Element)slList.item(j);
                this.addSQLDimension(dimElem, sqlAW);
            }
        }
    }

    private void addOutAttributes(Element objInfo, SQLAccessToAW sqlAW) {
        Element sqla_list = RXMLSQLAccessToAW.getFirstChildByTagName(objInfo, "aw_out_sql_attributes");
        if (sqla_list != null) {
            NodeList attrList = sqla_list.getElementsByTagName("aw_sql_attribute");
            int length = attrList.getLength();
            for (int i = 0; i < length; ++i) {
                Element attrElem = (Element)attrList.item(i);
                this.addSQLAttribute(attrElem, sqlAW);
            }
        }
    }

    private void addSQLDimension(Element dimElem, SQLAccessToAW sqlAW) {
        List sqldims = sqlAW.getSqlDimensionDefinitions();
        Map map = this.getProperties(dimElem, "aw_sqldim_attributes");
        String dim_id = (String)map.get("dimension_id");
        Dimension dim = (Dimension)sqlAW.getMultidimensionalDesign().getDimensionSet().getObjectByID(dim_id);
        if (dim != null) {
            SQLAccessToAW sQLAccessToAW = sqlAW;
            Objects.requireNonNull(sQLAccessToAW);
            SQLAccessToAW.SQLDimension sqld = sQLAccessToAW.new SQLAccessToAW.SQLDimension(dim, sqlAW);
            this.addSQLAttributes(dimElem, sqld, sqlAW);
            this.addHierarchies(dimElem, sqld, sqlAW);
            sqldims.add(sqld);
        }
    }

    private void addSQLAttributes(Element dimElem, SQLAccessToAW.SQLDimension sqld, SQLAccessToAW sqlAW) {
        Element sqla_list = RXMLSQLAccessToAW.getFirstChildByTagName(dimElem, "aw_sql_attributes");
        if (sqla_list != null) {
            NodeList attrList = sqla_list.getElementsByTagName("aw_sql_attribute");
            int length = attrList.getLength();
            for (int i = 0; i < length; ++i) {
                Element attrElem = (Element)attrList.item(i);
                this.addSQLAttribute(attrElem, sqld, sqlAW);
            }
        }
    }

    private void addSQLAttribute(Element attrElem, SQLAccessToAW.SQLDimension sqld, SQLAccessToAW sqlAW) {
        Dimension dim = sqld.getDimension();
        List selList = sqld.getAllSelectedAttributes();
        Map map = this.getProperties(attrElem, "aw_sql_attribute_props");
        String name = (String)map.get("name");
        String type = (String)map.get("type");
        String dataType = (String)map.get("datatype");
        String out_pos = (String)map.get("aw_sql_attr_out_position");
        SQLAttribute sqla = null;
        if (SQLAccessToAW.ATTR_TYPE_SHORT_DESC.equals(type)) {
            sqld.setSelectedShortDescAttr(true);
            sqla = sqld.getShortDescAttr();
        } else if (SQLAccessToAW.ATTR_TYPE_LONG_DESC.equals(type)) {
            sqld.setSelectedLongDescAttr(true);
            sqla = sqld.getLongDescAttr();
        } else if (SQLAccessToAW.ATTR_TYPE_END_DATE.equals(type)) {
            sqld.setSelectedEndDate(true);
            sqla = sqld.getEndDateAttr();
        } else if (SQLAccessToAW.ATTR_TYPE_TIME_SPAN.equals(type)) {
            sqld.setSelectedTimeSpan(true);
            sqla = sqld.getTimeSpanAttr();
        } else if (SQLAccessToAW.ATTR_TYPE_LEVEL_NAME.equals(type)) {
            sqld.setSelectedLevelNameAttr(true);
            sqla = sqld.getLevelNameAttr();
        } else if (SQLAccessToAW.ATTR_TYPE_DIMENSION_ID.equals(type)) {
            sqld.setSelectedDimensionID(true);
            sqla = sqld.getDimensionIDAttr();
        } else if (SQLAccessToAW.ATTR_TYPE_DIMENSION_GID.equals(type)) {
            sqla = sqld.getDimensionGIDAttr();
        } else if (SQLAccessToAW.ATTR_TYPE_MEASURE.equals(type)) {
            if (sqlAW.getSlice() != null) {
                String mw_id = (String)map.get("measure_wrapper");
                String func_id = (String)map.get("aggr_function_id");
                Slice.MeasureWrapper mw = sqlAW.getSlice().createMeasureWrapper(mw_id, func_id);
                if (mw != null) {
                    sqla = new SQLAttribute(mw.getMeasureAlias(), mw, sqlAW.getSlice());
                }
            } else {
                String m_id = (String)map.get("measure");
                Measure meas = (Measure)sqlAW.getMultidimensionalDesign().getMeasureSet().getObjectByID(m_id);
                if (meas != null) {
                    sqla = new SQLAttribute(meas.getName(), meas, sqlAW.getCube());
                }
            }
        } else if (SQLAccessToAW.ATTR_TYPE_LEVEL.equals(type)) {
            String l_id = (String)map.get("level_id");
            String h_id = (String)map.get("hierarchy_id");
            Level level = (Level)sqlAW.getMultidimensionalDesign().getLevelSet().getObjectByID(l_id);
            if (level != null) {
                sqla = new SQLAttribute(level.getName(), dim, h_id, level);
            }
        } else if (SQLAccessToAW.ATTR_TYPE_DESCRIPTIVE_ATTR.equals(type)) {
            String attr_id = (String)map.get("attribute");
            String attr_name = (String)map.get("scattribute_name");
            String l_id = (String)map.get("level_id");
            Level level = (Level)sqlAW.getMultidimensionalDesign().getLevelSet().getObjectByID(l_id);
            if (level != null) {
                SlowChangingAttribute sca = level.getSlowChangingAttribute(attr_id, attr_name);
                sqla = new SQLAttribute(level.getName(), dim, level, sca);
            }
        }
        if (sqla != null) {
            if (name != null) {
                sqla.setName(name);
            }
            if (dataType != null) {
                sqla.setDataType(dataType);
            }
            if (out_pos == null) {
                this.hasOutPosition = false;
            } else {
                Integer pos = Integer.valueOf(out_pos);
                sqla.setOutPosition(pos);
                this.posMap.put(pos, sqla);
            }
            selList.add(sqla);
        }
    }

    private void addSQLAttribute(Element attrElem, SQLAccessToAW sqlAW) {
        List selList = sqlAW.getOutSQLAttributes();
        Map map = this.getProperties(attrElem, "aw_sql_attribute_props");
        String name = (String)map.get("name");
        String type = (String)map.get("type");
        String dataType = (String)map.get("datatype");
        String out_pos = (String)map.get("aw_sql_attr_out_position");
        SQLAttribute sqla = null;
        if (SQLAccessToAW.ATTR_TYPE_MEASURE.equals(type)) {
            if (sqlAW.getSlice() != null) {
                String mw_id = (String)map.get("measure_wrapper");
                String func_id = (String)map.get("aggr_function_id");
                Slice.MeasureWrapper mw = sqlAW.getSlice().createMeasureWrapper(mw_id, func_id);
                if (mw != null) {
                    sqla = new SQLAttribute(mw.getMeasureAlias(), mw, sqlAW.getSlice());
                }
            } else {
                String m_id = (String)map.get("measure");
                Measure meas = (Measure)sqlAW.getMultidimensionalDesign().getMeasureSet().getObjectByID(m_id);
                if (meas != null) {
                    sqla = new SQLAttribute(meas.getName(), meas, sqlAW.getCube());
                }
            }
        }
        if (sqla != null) {
            if (name != null) {
                sqla.setName(name);
            }
            if (dataType != null) {
                sqla.setDataType(dataType);
            }
            if (out_pos == null) {
                this.hasOutPosition = false;
            } else {
                Integer pos = Integer.valueOf(out_pos);
                sqla.setOutPosition(pos);
                this.posMap.put(pos, sqla);
            }
            selList.add(sqla);
        }
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == SQLAccessToAW.class;
    }
}

