/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.Hierarchy;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLHierarchy
extends AbstractWXMLDesignObject
implements MDConstants {
    private Hierarchy hierarchy = null;

    public WXMLHierarchy(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof Hierarchy;
        if (result) {
            this.hierarchy = (Hierarchy)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.hierarchy != null) {
            String designName = this.hierarchy.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.hierarchy.getDesignPart().getObjectID())).append('/');
        }
        buffer.append(this.getConfiguration().get("hierarchyPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof Hierarchy) {
            Hierarchy hierarchy = (Hierarchy)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("description", StringUtilities.encodeAttributeValue(String.valueOf(hierarchy.getDescription())));
            map.put("default_hierarchy", String.valueOf(hierarchy.isDefaultHierarchy()));
            map.put("link_to_dimension", StringUtilities.encodeAttributeValue(hierarchy.getLinkToDimension().getObjectID()));
            this.appendProperties(objectInfoNode, "attributes", map);
            this.appendObjects(objectInfoNode, hierarchy.getLevels().toArray(), "levels");
            this.appendObjects(objectInfoNode, hierarchy.getLinks().toArray(), "links");
        }
    }
}

