/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLExternalData
extends AbstractWXMLDesignObject
implements DFConstants {
    private ExternalData extData;

    public WXMLExternalData(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof ExternalData;
        if (result) {
            this.extData = (ExternalData)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.extData != null) {
            String designName = this.extData.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("pm").append('/');
        }
        buffer.append(this.getConfiguration().get("extDataPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof ExternalData) {
            ExternalData extData = (ExternalData)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("structured", new Boolean(extData.isStructured()).toString());
            String objID = "";
            if (extData.getRecordStructure() != null) {
                objID = extData.getRecordStructure().getObjectID();
            }
            map.put("recordstructure", objID);
            objID = "";
            if (extData.getType() != null) {
                objID = extData.getType().getObjectID();
            }
            map.put("type", StringUtilities.encodeAttributeValue(objID));
            map.put("startingpos", Integer.toString(extData.getStartingPos()));
            map.put("description", extData.getDescription());
            if (extData.getMappedDesignObject() != null) {
                map.put("mappedobject", StringUtilities.encodeAttributeValue(extData.getMappedDesignObject().getObjectID()));
            } else {
                map.put("mappedobject", "");
            }
            this.appendProperties(objectInfoNode, "attributes", map);
        }
    }
}

