/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ControllerApplication;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuPath;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectedObjectAction;

public class MenuStructure {
    private MenuPath root = MenuPath.createRoot();
    private Map pathToMenu = new HashMap();
    private Map actionMenu = new HashMap();
    private JMenuBar mbar = null;
    private String[] firstMenuNames = null;
    private String helpMenuName = null;
    private Set registeredActions = new HashSet();
    private MListener menuListener = new MListener();
    private ApplicationView appView;
    private boolean enable = true;

    public MenuStructure(ApplicationView view, String[] firstMenuNames, String helpMenuName) {
        this.appView = view;
        for (int i = 0; i < firstMenuNames.length; ++i) {
            firstMenuNames[i] = this.fixName(firstMenuNames[i]);
        }
        this.firstMenuNames = firstMenuNames;
        this.helpMenuName = this.fixName(helpMenuName);
    }

    private String fixName(String name) {
        int index = name.indexOf(38);
        if (index > -1) {
            StringBuffer sb = new StringBuffer(name);
            sb.deleteCharAt(index);
            return sb.toString();
        }
        return name;
    }

    public void put(MenuPath path, JMenu menu) {
        this.pathToMenu.put(path, menu);
    }

    public JMenu get(MenuPath mpath) {
        if (!this.pathToMenu.containsKey(mpath)) {
            JMenu menu = new JMenu(mpath.getLastNodeName());
            menu.setName(mpath.getLastNodeName());
            menu.setMnemonic(mpath.getMnemonic());
            this.put(mpath, menu);
            this.hookUpJMenu(mpath);
        }
        return (JMenu)this.pathToMenu.get(mpath);
    }

    public JMenu get(String[] path) {
        MenuPath mpath = this.root.getLastNodeIn(path);
        return this.get(mpath);
    }

    public JMenu getFirst(String[] path) {
        MenuPath mpath = this.root.getFirstNodeIn(path);
        if (mpath != null) {
            return this.get(mpath);
        }
        return null;
    }

    public void remove(MDBAction action) {
        if (!this.registeredActions.contains(action)) {
            return;
        }
        JMenu rootMenu = this.get(action.getMenuPath());
        for (int i = 0; i < rootMenu.getItemCount(); ++i) {
            JMenuItem menu = rootMenu.getItem(i);
            if (menu == null || menu.getAction() == null || !menu.getAction().equals(action)) continue;
            rootMenu.remove(menu);
            this.registeredActions.remove(action);
            this.actionMenu.remove(action);
            break;
        }
    }

    public void add(MDBAction action) {
        if (this.registeredActions.contains(action)) {
            return;
        }
        if (!action.getMenuPath().equals(MDBAction.DEFAULT_MENU_PATH)) {
            if (action.isPopupMenu()) {
                JMenu menu = new JMenu(action.getName());
                JMenu rootMenu = this.get(action.getMenuPath());
                action.setMenu(menu);
                rootMenu.add(menu);
                this.actionMenu.put(action, rootMenu);
                this.registeredActions.add(action);
            } else {
                JMenu parentMenu;
                JMenuItem menu = new JMenuItem(action.getName(), (Icon)action.getValue("SmallIcon"));
                menu.setAction(action);
                menu.setMnemonic(action.getMnemonic());
                menu.setAccelerator(action.getAccelerator());
                if (action.getToolTipText() != null) {
                    menu.setToolTipText(action.getToolTipText());
                }
                JMenu rootMenu = this.get(action.getMenuPath());
                if (action.addSeparatorBefore()) {
                    rootMenu.addSeparator();
                }
                if (action.getPosition() > -1) {
                    rootMenu.add((Component)menu, action.getPosition());
                } else {
                    rootMenu.add(menu);
                }
                if (action.addSeparatorAfterInRoot() && (parentMenu = this.getFirst(action.getMenuPath())) != null) {
                    parentMenu.addSeparator();
                }
                if (action.addSeparatorAfter()) {
                    rootMenu.addSeparator();
                }
                if (action.isObjectAction()) {
                    this.showObjectMenu(true);
                    if (!rootMenu.isVisible()) {
                        rootMenu.setVisible(true);
                    }
                }
                this.actionMenu.put(action, rootMenu);
                this.registeredActions.add(action);
            }
        }
    }

    public JMenuBar getJMenuBar() {
        if (this.mbar == null) {
            this.createJMenuBar();
        }
        return this.mbar;
    }

    private JMenuBar createJMenuBar() {
        this.mbar = new JMenuBar();
        this.updateMenuItems();
        return this.mbar;
    }

    public void updateMenuItems() {
        JMenu menu;
        int i;
        HashMap<String, JMenu> nameToMenu = new HashMap<String, JMenu>();
        MenuPath[] children = this.root.getChildren();
        for (i = 0; i < children.length; ++i) {
            String name = children[i].getLastNodeName();
            menu = this.get(children[i]);
            nameToMenu.put(name, menu);
        }
        for (i = 0; i < this.firstMenuNames.length; ++i) {
            if (!nameToMenu.containsKey(this.firstMenuNames[i])) continue;
            JMenu menu2 = this.mbar.add((JMenu)nameToMenu.get(this.firstMenuNames[i]));
            menu2.addMenuListener(this.menuListener);
            nameToMenu.remove(this.firstMenuNames[i]);
        }
        JMenu helpMenu = null;
        if (this.helpMenuName != null && !this.helpMenuName.equals("")) {
            helpMenu = (JMenu)nameToMenu.get(this.helpMenuName);
            nameToMenu.remove(this.helpMenuName);
        }
        Iterator it = nameToMenu.keySet().iterator();
        while (it.hasNext()) {
            menu = this.mbar.add((JMenu)nameToMenu.get(it.next()));
            menu.addMenuListener(this.menuListener);
        }
        if (helpMenu != null) {
            menu = this.mbar.add(helpMenu);
            menu.addMenuListener(this.menuListener);
        }
    }

    public void clearObjectActions() {
        Object[] actions = this.registeredActions.toArray();
        for (int i = actions.length - 1; i >= 0; --i) {
            MDBAction action = (MDBAction)actions[i];
            if (!action.isObjectAction()) continue;
            JMenu jmenu = (JMenu)this.actionMenu.get(action);
            if (jmenu != null) {
                jmenu.setVisible(false);
            }
            this.remove(action);
        }
    }

    protected void hookUpJMenu(MenuPath mpath) {
        JMenu menu = this.get(mpath);
        MenuPath parent = mpath.getParent();
        if (!parent.isRoot()) {
            this.get(parent).add(menu);
        }
    }

    public MenuPath getRoot() {
        return this.root;
    }

    public MListener getMenuListener() {
        return this.menuListener;
    }

    public void showObjectMenu(boolean show) {
        JMenu jmenu = this.get(new String[]{AbstractController.OBJECT_CAPTION});
        if (jmenu != null) {
            jmenu.setVisible(show);
        }
    }

    public void enableActions(boolean enable) {
        try {
            this.enable = enable;
            for (MDBAction action : this.registeredActions) {
                if (!enable) {
                    action.setOldState(action.isEnabled());
                    action.setEnabled(enable);
                    continue;
                }
                action.reset();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class MListener
    implements MenuListener {
        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            ControllerApplication controller = MenuStructure.this.appView.getController();
            if (MenuStructure.this.enable) {
                controller.updateMenus();
            }
            for (MDBAction action : MenuStructure.this.registeredActions) {
                if (!(action instanceof SelectedObjectAction) || MenuStructure.this.appView.getCurrentDPV() == null) continue;
                SelectableObject selected = MenuStructure.this.appView.getCurrentDPV().getCurrentSelection();
                action.setEnabled(((SelectedObjectAction)action).canHandle(selected));
            }
        }
    }
}

