/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.CellMapper;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramModel;
import oracle.dbtools.crest.swingui.diagram.graph.Edge;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;

public class DiagramConstants {
    public static boolean NEGATIVE_ALLOWED = false;
    public static final Point dummyPoint = new Point();
    public static final Font defaultFont = UIManager.getFont("Tree.font");
    public static final float DEFAULTFONTSIZE = 12.0f;
    public static final int DEFAULTFONTSTYLE = 0;
    public static final int DEFAULTDECORATIONSIZE = 8;
    public static final int PERMILLE = 1000;
    protected static float[] dash = new float[]{8.0f, 8.0f};
    public static Stroke SELECTION_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
    public static final int ARROW_NONE = 0;
    public static final int ARROW_CLASSIC = 1;
    public static final int ARROW_TECHNICAL = 2;
    public static final int ARROW_SIMPLE = 4;
    public static final int ARROW_CIRCLE = 5;
    public static final int ARROW_LINE = 7;
    public static final int ARROW_DOUBLELINE = 8;
    public static final int ARROW_DIAMOND = 9;
    public static final int STYLE_ORTHOGONAL = 11;
    public static final int STYLE_BEZIER = 12;
    public static final int STYLE_SPLINE = 13;
    public static final int ARROW_TECHNICAL_IDENT = 14;
    public static final int ARROW_CIRCLE_IDENT = 15;
    public static final int ARROW_TRIANGLE = 16;
    public static final int ARROW_TRIANGLE_IDENT = 17;
    public static final int ARROW_LINE_CIRCLE = 18;
    public static final int ARROW_TRIANGLE_CIRCLE = 19;
    public static final int ARROW_TRIANGLE_CIRCLE_NO_FILL = 20;
    public static final int ARROW_TRIANGLE_CROSS = 21;
    public static final int ARROW_LINE_CROSS = 22;
    public static final int ARROW_LINE_CIRCLE_NO_FILL = 23;
    public static final int X_AXIS = 1;
    public static final int Y_AXIS = 2;
    public static final Edge.Routing ROUTING_SIMPLE = new DefaultEdge.DefaultRouting();
    public static final String SIZEABLEAXIS = "sizeableAxis";
    public static final String MOVEABLEAXIS = "moveableAxis";
    public static final String REPLACEATTRIBUTES = "replaceAttributes";
    public static final String REMOVEATTRIBUTES = "removeAttributes";
    public static final String REMOVEALL = "removeAll";
    public static final String ICON = "icon";
    public static final String FONT = "font";
    public static final String OPAQUE = "opaque";
    public static final String BORDER = "border";
    public static final String LINECOLOR = "linecolor";
    public static final String BORDERCOLOR = "bordercolor";
    public static final String LINEWIDTH = "linewidth";
    public static final String FOREGROUND = "foregroundColor";
    public static final String BACKGROUND = "backgroundColor";
    public static final String VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String HORIZONTAL_ALIGNMENT = "horizontalAlignment";
    public static final String VERTICAL_TEXT_POSITION = "verticalTextPosition";
    public static final String HORIZONTAL_TEXT_POSITION = "horizontalTextPosition";
    public static final String DASHPATTERN = "dashPattern";
    public static final String LINESTYLE = "lineStyle";
    public static final String LINEBEGIN = "lineBegin";
    public static final String LINEEND = "lineEnd";
    public static final String BEGINSIZE = "beginSize";
    public static final String ENDSIZE = "endsize";
    public static final String BEGINFILL = "beginFill";
    public static final String ENDFILL = "endFill";
    public static final String VALUE = "value";
    public static final String TRANSFERABLE = "transferable";
    public static final String TRANSFERABLE_SOURCE = "transferable_source";
    public static final String TRANSFERABLE_TARGET = "transferable_target";
    public static final String EDITABLE = "editable";
    public static final String MOVEABLE = "moveable";
    public static final String SIZEABLE = "sizeable";
    public static final String AUTOSIZE = "autosize";
    public static final String BENDABLE = "bendable";
    public static final String CONNECTABLE = "connectable";
    public static final String DISCONNECTABLE = "disconnectable";
    public static final String BOUNDS = "bounds";
    public static final String POINTS = "points";
    public static final String ROUTING = "routing";
    public static final String LABELPOSITION = "labelposition";
    public static final String SOURCELABELPOSITION = "sourceLabelposition";
    public static final String TARGETLABELPOSITION = "targetLabelposition";
    public static final String LABELALONGEDGE = "labelAlongEdge";
    public static final String ABSOLUTE = "absolute";
    public static final String OFFSET = "offset";
    public static final String SIZE = "size";
    public static final String BEGIN_DASHED = "beginDashed";
    public static final String END_DASHED = "endDashed";

    public static Map createAttributes(Object cell, Object key, Object value) {
        return DiagramConstants.createAttributes(new Object[]{cell}, new Object[]{key}, new Object[]{value});
    }

    public static Map createAttributes(Object[] cells, Object key, Object value) {
        return DiagramConstants.createAttributes(cells, new Object[]{key}, new Object[]{value});
    }

    public static Map createAttributes(Object[] cells, Object[] keys, Object[] values) {
        if (keys != null && values != null && keys.length != values.length) {
            throw new IllegalArgumentException(Messages.getString("DiagramConstants.KeysValuesSameLength"));
        }
        Hashtable<Object, Map> nested = new Hashtable<Object, Map>();
        for (int i = 0; i < cells.length; ++i) {
            if (cells[i] == null) continue;
            Map attributes = DiagramConstants.createMap();
            for (int j = 0; j < keys.length; ++j) {
                if (keys[j] == null || values[j] == null) continue;
                attributes.put(keys[j], values[j]);
            }
            nested.put(cells[i], attributes);
        }
        return nested;
    }

    public static Map createAttributes(Object[] elements, CellMapper cm) {
        Hashtable<Object, Map> attributes = new Hashtable<Object, Map>();
        for (int i = 0; i < elements.length; ++i) {
            CellView view = null;
            Object key = elements[i];
            if (key instanceof CellView) {
                view = (CellView)key;
                key = view.getCell();
            } else if (cm != null) {
                view = cm.getMapping(key, false);
            }
            if (view == null) continue;
            attributes.put(key, DiagramConstants.cloneMap(view.getAllAttributes()));
        }
        return attributes;
    }

    public static Map createAttributesFromModel(Object[] elements, DiagramModel model) {
        Hashtable<Object, Map> attributes = new Hashtable<Object, Map>();
        for (int i = 0; i < elements.length; ++i) {
            Map attr = model.getAttributes(elements[i]);
            if (attr == null || attr.size() <= 0) continue;
            attributes.put(elements[i], DiagramConstants.cloneMap(attr));
        }
        return attributes;
    }

    public static Point2D createPoint() {
        return new SerializablePoint2D();
    }

    public static Point2D createPoint(Point2D p) {
        if (p != null) {
            return DiagramConstants.createPoint(p.getX(), p.getY());
        }
        return null;
    }

    public static Point2D createPoint(double x, double y) {
        return new SerializablePoint2D(x, y);
    }

    public static Rectangle2D createRect() {
        return new SerializableRectangle2D();
    }

    public static Rectangle2D createRect(double x, double y, double w, double h) {
        return new SerializableRectangle2D(x, y, w, h);
    }

    public static Rectangle2D createRect(Point2D pt) {
        return DiagramConstants.createRect(pt, 0.0);
    }

    public static Rectangle2D createRect(Point2D pt, double size) {
        if (pt != null) {
            return DiagramConstants.createRect(pt.getX(), pt.getY(), size, size);
        }
        return null;
    }

    public static Rectangle2D createRect(Rectangle2D rect) {
        if (rect != null) {
            return DiagramConstants.createRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        }
        return null;
    }

    public static Rectangle2D createRect(double x, double y, double w, double h, double grow1, double grow2) {
        return DiagramConstants.createRect(x - grow1, y - grow1, w + grow1 + grow2, h + grow1 + grow2);
    }

    public static Rectangle2D createRect(Rectangle2D rect, double grow1, double grow2) {
        if (rect != null) {
            return DiagramConstants.createRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), grow1, grow2);
        }
        return null;
    }

    public static Map createMap() {
        return new Hashtable();
    }

    public static Map replaceKeys(Map keyMap, Map map) {
        Hashtable newMap = new Hashtable();
        for (Map.Entry entry : map.entrySet()) {
            Object newKey;
            if (!(entry.getValue() instanceof Map) || (newKey = keyMap.get(entry.getKey())) == null) continue;
            Map val = DiagramConstants.cloneMap((Map)entry.getValue());
            newMap.put(newKey, val);
        }
        return newMap;
    }

    public static Map cloneMap(Map map) {
        Point targetLabel;
        Point sourceLabel;
        Point label;
        List points;
        Hashtable newMap = new Hashtable(map);
        Rectangle2D bounds = DiagramConstants.getBounds(newMap);
        if (bounds != null) {
            DiagramConstants.setBounds(newMap, (Rectangle2D)bounds.clone());
        }
        if ((points = DiagramConstants.getPoints(newMap)) != null) {
            DiagramConstants.setPoints(newMap, DiagramConstants.clonePoints(points));
        }
        if ((label = DiagramConstants.getLabelPosition(newMap)) != null) {
            DiagramConstants.setLabelPosition(newMap, new Point(label));
        }
        if ((sourceLabel = DiagramConstants.getSourceLabelPosition(newMap)) != null) {
            DiagramConstants.setSourceLabelPosition(newMap, new Point(sourceLabel));
        }
        if ((targetLabel = DiagramConstants.getTargetLabelPosition(newMap)) != null) {
            DiagramConstants.setTargetLabelPosition(newMap, new Point(targetLabel));
        }
        return newMap;
    }

    public static List clonePoints(List points) {
        ArrayList newList = new ArrayList();
        for (Object point : points) {
            if (point instanceof PortView) {
                point = ((PortView)point).isAutoRoute() || ((PortView)point).getPoint() == null ? ((PortView)point).getLocation(null) : DiagramConstants.createPoint(((PortView)point).getPoint());
            } else if (point instanceof Point2D) {
                point = DiagramConstants.createPoint((Point2D)point);
            }
            newList.add(point);
        }
        return newList;
    }

    public static void translate(Collection c, double dx, double dy, AbstractDiagram diagram) {
        for (Object map : c) {
            if (!(map instanceof Map)) continue;
            DiagramConstants.translate((Map)map, dx, dy, null);
        }
    }

    public static void translate(Map map, double dx, double dy, AbstractDiagram diagram) {
        if (DiagramConstants.isMoveable(map)) {
            List points;
            Rectangle2D bounds = DiagramConstants.getBounds(map);
            if (bounds != null) {
                int moveableAxis = DiagramConstants.getMoveableAxis(map);
                if (moveableAxis == 1) {
                    dy = 0.0;
                } else if (moveableAxis == 2) {
                    dx = 0.0;
                }
                double x = bounds.getX() + dx;
                double y = bounds.getY() + dy;
                if (diagram != null && diagram.isGridEnabled()) {
                    double sgs = diagram.getGridSize();
                    x = Math.round((double)Math.round(x / sgs) * sgs);
                    y = Math.round((double)Math.round(y / sgs) * sgs);
                }
                bounds.setFrame(x, y, bounds.getWidth(), bounds.getHeight());
                if (!NEGATIVE_ALLOWED) {
                    bounds.setFrame(Math.max(0.0, bounds.getX()), Math.max(0.0, bounds.getY()), bounds.getWidth(), bounds.getHeight());
                }
            }
            if ((points = DiagramConstants.getPoints(map)) != null) {
                for (int i = 0; i < points.size(); ++i) {
                    Object obj = points.get(i);
                    if (!(obj instanceof Point2D)) continue;
                    Point2D pt = (Point2D)obj;
                    pt.setLocation(pt.getX() + dx, pt.getY() + dy);
                    if (NEGATIVE_ALLOWED) continue;
                    pt.setLocation(Math.max(0.0, pt.getX()), Math.max(0.0, pt.getY()));
                }
            }
        }
    }

    public static void scale(Map map, double sx, double sy, Point2D origin, AbstractDiagram diagram) {
        List points;
        Rectangle2D bounds = DiagramConstants.getBounds(map);
        if (bounds != null) {
            Point2D p = DiagramConstants.createPoint(bounds.getX(), bounds.getY());
            Point2D loc = (Point2D)p.clone();
            int sizeableAxis = DiagramConstants.getSizeableAxis(map);
            if (sizeableAxis == 1) {
                sy = 1.0;
            } else if (sizeableAxis == 2) {
                sx = 1.0;
            }
            p.setLocation(origin.getX() + (double)Math.round((p.getX() - origin.getX()) * sx), origin.getY() + (double)Math.round((p.getY() - origin.getY()) * sy));
            if (!p.equals(loc)) {
                DiagramConstants.translate(map, p.getX() - loc.getX(), p.getY() - loc.getY(), diagram);
            }
            double w = Math.max(1L, Math.round(bounds.getWidth() * sx));
            double h = Math.max(1L, Math.round(bounds.getHeight() * sy));
            bounds.setFrame(bounds.getX(), bounds.getY(), w, h);
        }
        if ((points = DiagramConstants.getPoints(map)) != null) {
            for (Object obj : points) {
                if (!(obj instanceof Point2D)) continue;
                Point2D loc = (Point2D)obj;
                Point2D p = (Point2D)loc.clone();
                p.setLocation(origin.getX() + (double)Math.round((p.getX() - origin.getX()) * sx), origin.getY() + (double)Math.round((p.getY() - origin.getY()) * sy));
                loc.setLocation(p);
            }
        }
    }

    public static void setFont(Map map, Font font) {
        map.put(FONT, font);
    }

    public static Font getFont(Map map) {
        Font font = (Font)map.get(FONT);
        if (font == null) {
            font = defaultFont;
        }
        return font;
    }

    public static final void setRemoveAttributes(Map map, Object[] value) {
        map.put(REMOVEATTRIBUTES, value);
    }

    public static final Object[] getRemoveAttributes(Map map) {
        return (Object[])map.get(REMOVEATTRIBUTES);
    }

    public static Map applyMap(Map change, Map target) {
        Hashtable undo = new Hashtable();
        if (change != null) {
            Object[] remove;
            if (DiagramConstants.isRemoveAll(change)) {
                undo.putAll(target);
                target.clear();
            }
            if ((remove = DiagramConstants.getRemoveAttributes(change)) != null) {
                for (int i = 0; i < remove.length; ++i) {
                    Object oldValue = target.remove(remove[i]);
                    if (oldValue == null) continue;
                    undo.put(remove[i], oldValue);
                }
            }
            HashSet removeAttributes = new HashSet();
            for (Map.Entry entry : change.entrySet()) {
                Object key = entry.getKey();
                if (key.equals(REMOVEALL) || key.equals(REMOVEATTRIBUTES)) continue;
                Object oldValue = target.put(key, entry.getValue());
                if (oldValue == null) {
                    removeAttributes.add(key);
                    continue;
                }
                undo.put(key, oldValue);
            }
            if (!removeAttributes.isEmpty()) {
                DiagramConstants.setRemoveAttributes(undo, removeAttributes.toArray());
            }
        }
        return undo;
    }

    public static final void setMoveableAxis(Map map, int axis) {
        map.put(MOVEABLEAXIS, new Integer(axis));
    }

    public static final int getMoveableAxis(Map map) {
        Integer intObj = (Integer)map.get(MOVEABLEAXIS);
        if (intObj != null) {
            return intObj;
        }
        return 0;
    }

    public static final void setSizeableAxis(Map map, int axis) {
        map.put(SIZEABLEAXIS, new Integer(axis));
    }

    public static final int getSizeableAxis(Map map) {
        Integer intObj = (Integer)map.get(SIZEABLEAXIS);
        if (intObj != null) {
            return intObj;
        }
        return 0;
    }

    public static final void setIcon(Map map, Icon value) {
        map.put(ICON, value);
    }

    public static final Icon getIcon(Map map) {
        return (Icon)map.get(ICON);
    }

    public static final void setOpaque(Map map, boolean flag) {
        map.put(OPAQUE, new Boolean(flag));
    }

    public static final boolean isOpaque(Map map) {
        Boolean bool = (Boolean)map.get(OPAQUE);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static final void setTransferable(Map map, boolean flag) {
        map.put(TRANSFERABLE, new Boolean(flag));
    }

    public static final boolean isTransferable(Map map) {
        Boolean bool = (Boolean)map.get(TRANSFERABLE);
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public static final void setTransferableSource(Map map, boolean flag) {
        map.put(TRANSFERABLE_SOURCE, new Boolean(flag));
    }

    public static final boolean isTransferableSource(Map map) {
        Boolean bool = (Boolean)map.get(TRANSFERABLE_SOURCE);
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public static final void setTransferableTarget(Map map, boolean flag) {
        map.put(TRANSFERABLE_TARGET, new Boolean(flag));
    }

    public static final boolean isTransferableTarget(Map map) {
        Boolean bool = (Boolean)map.get(TRANSFERABLE_TARGET);
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public static final void setBorder(Map map, Border value) {
        map.put(BORDER, value);
    }

    public static final Border getBorder(Map map) {
        return (Border)map.get(BORDER);
    }

    public static final void setLineColor(Map map, Color value) {
        map.put(LINECOLOR, value);
    }

    public static final Color getLineColor(Map map) {
        return (Color)map.get(LINECOLOR);
    }

    public static final void setBorderColor(Map map, Color value) {
        map.put(BORDERCOLOR, value);
    }

    public static final Color getBorderColor(Map map) {
        return (Color)map.get(BORDERCOLOR);
    }

    public static final void setLineWidth(Map map, float width) {
        map.put(LINEWIDTH, new Float(width));
    }

    public static final float getLineWidth(Map map) {
        Float floatObj = (Float)map.get(LINEWIDTH);
        if (floatObj != null) {
            return floatObj.floatValue();
        }
        return 1.0f;
    }

    public static final void setForeground(Map map, Color value) {
        map.put(FOREGROUND, value);
    }

    public static final Color getForeground(Map map) {
        return (Color)map.get(FOREGROUND);
    }

    public static final void setBackground(Map map, Color value) {
        map.put(BACKGROUND, value);
    }

    public static final Color getBackground(Map map) {
        return (Color)map.get(BACKGROUND);
    }

    public static final void setVerticalAlignment(Map map, int width) {
        map.put(VERTICAL_ALIGNMENT, new Integer(width));
    }

    public static final int getVerticalAlignment(Map map) {
        Integer intObj = (Integer)map.get(VERTICAL_ALIGNMENT);
        if (intObj != null) {
            return intObj;
        }
        return 0;
    }

    public static final void setHorizontalAlignment(Map map, int width) {
        map.put(HORIZONTAL_ALIGNMENT, new Integer(width));
    }

    public static final int getHorizontalAlignment(Map map) {
        Integer intObj = (Integer)map.get(HORIZONTAL_ALIGNMENT);
        if (intObj != null) {
            return intObj;
        }
        return 0;
    }

    public static final void setVerticalTextPosition(Map map, int width) {
        map.put(VERTICAL_TEXT_POSITION, new Integer(width));
    }

    public static final int getVerticalTextPosition(Map map) {
        Integer intObj = (Integer)map.get(VERTICAL_TEXT_POSITION);
        if (intObj != null) {
            return intObj;
        }
        return 3;
    }

    public static final void setHorizontalTextPosition(Map map, int width) {
        map.put(HORIZONTAL_TEXT_POSITION, new Integer(width));
    }

    public static final int getHorizontalTextPosition(Map map) {
        Integer intObj = (Integer)map.get(HORIZONTAL_TEXT_POSITION);
        if (intObj != null) {
            return intObj;
        }
        return 0;
    }

    public static final void setDashPattern(Map map, float[] value) {
        map.put(DASHPATTERN, value);
    }

    public static final float[] getDashPattern(Map map) {
        return (float[])map.get(DASHPATTERN);
    }

    public static final void setLineStyle(Map map, int style) {
        map.put(LINESTYLE, new Integer(style));
    }

    public static final int getLineStyle(Map map) {
        Integer intObj = (Integer)map.get(LINESTYLE);
        if (intObj != null) {
            return intObj;
        }
        return 11;
    }

    public static final void setBeginSize(Map map, int style) {
        map.put(BEGINSIZE, new Integer(style));
    }

    public static final int getBeginSize(Map map) {
        Integer intObj = (Integer)map.get(BEGINSIZE);
        if (intObj != null) {
            return intObj;
        }
        return 8;
    }

    public static final void setEndSize(Map map, int style) {
        map.put(ENDSIZE, new Integer(style));
    }

    public static final int getEndSize(Map map) {
        Integer intObj = (Integer)map.get(ENDSIZE);
        if (intObj != null) {
            return intObj;
        }
        return 8;
    }

    public static final void setLineBegin(Map map, int style) {
        map.put(LINEBEGIN, new Integer(style));
    }

    public static final int getLineBegin(Map map) {
        Integer intObj = (Integer)map.get(LINEBEGIN);
        if (intObj != null) {
            return intObj;
        }
        return 0;
    }

    public static final void setLineEnd(Map map, int style) {
        map.put(LINEEND, new Integer(style));
    }

    public static final int getLineEnd(Map map) {
        Integer intObj = (Integer)map.get(LINEEND);
        if (intObj != null) {
            return intObj;
        }
        return 0;
    }

    public static final void setValue(Map map, Object value) {
        map.put(VALUE, value);
    }

    public static final Object getValue(Map map) {
        return map.get(VALUE);
    }

    public static final void setLabelPosition(Map map, Point position) {
        map.put(LABELPOSITION, position);
    }

    public static final Point getLabelPosition(Map map) {
        return (Point)map.get(LABELPOSITION);
    }

    public static final void setSourceLabelPosition(Map map, Point position) {
        map.put(SOURCELABELPOSITION, position);
    }

    public static final Point getSourceLabelPosition(Map map) {
        return (Point)map.get(SOURCELABELPOSITION);
    }

    public static final void setTargetLabelPosition(Map map, Point position) {
        map.put(TARGETLABELPOSITION, position);
    }

    public static final Point getTargetLabelPosition(Map map) {
        return (Point)map.get(TARGETLABELPOSITION);
    }

    public static final void setLabelAlongEdge(Map map, boolean flag) {
        map.put(LABELALONGEDGE, new Boolean(flag));
    }

    public static final boolean isLabelAlongEdge(Map map) {
        Boolean bool = (Boolean)map.get(LABELALONGEDGE);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static final void setEditable(Map map, boolean flag) {
        map.put(EDITABLE, new Boolean(flag));
    }

    public static final boolean isEditable(Map map) {
        Boolean bool = (Boolean)map.get(EDITABLE);
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public static final void setMoveable(Map map, boolean flag) {
        map.put(MOVEABLE, new Boolean(flag));
    }

    public static final boolean isMoveable(Map map) {
        Boolean bool = (Boolean)map.get(MOVEABLE);
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public static final void setSizeable(Map map, boolean flag) {
        map.put(SIZEABLE, new Boolean(flag));
    }

    public static final boolean isSizeable(Map map) {
        Boolean bool = (Boolean)map.get(SIZEABLE);
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public static final void setAutoSize(Map map, boolean flag) {
        map.put(AUTOSIZE, new Boolean(flag));
    }

    public static final boolean isAutoSize(Map map) {
        Boolean bool = (Boolean)map.get(AUTOSIZE);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static final void setBendable(Map map, boolean flag) {
        map.put(BENDABLE, new Boolean(flag));
    }

    public static final boolean isBendable(Map map) {
        Boolean bool = (Boolean)map.get(BENDABLE);
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public static final void setConnectable(Map map, boolean flag) {
        map.put(CONNECTABLE, new Boolean(flag));
    }

    public static final boolean isConnectable(Map map) {
        Boolean bool = (Boolean)map.get(CONNECTABLE);
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public static final void setDisconnectable(Map map, boolean flag) {
        map.put(DISCONNECTABLE, new Boolean(flag));
    }

    public static final boolean isDisconnectable(Map map) {
        Boolean bool = (Boolean)map.get(DISCONNECTABLE);
        if (bool != null) {
            return bool;
        }
        return true;
    }

    public static final void setPoints(Map map, List list) {
        map.put(POINTS, list);
    }

    public static final List getPoints(Map map) {
        return (List)map.get(POINTS);
    }

    public static final void setRouting(Map map, Edge.Routing routing) {
        map.put(ROUTING, routing);
    }

    public static final Edge.Routing getRouting(Map map) {
        return (Edge.Routing)map.get(ROUTING);
    }

    public static final void setBounds(Map map, Rectangle2D bounds) {
        map.put(BOUNDS, bounds);
    }

    public static final Rectangle2D getBounds(Map map) {
        return (Rectangle2D)map.get(BOUNDS);
    }

    public static final void setSize(Map map, Dimension size) {
        map.put(SIZE, size);
    }

    public static final Dimension getSize(Map map) {
        return (Dimension)map.get(SIZE);
    }

    public static final void setOffset(Map map, Point2D offset) {
        map.put(OFFSET, offset);
    }

    public static final Point2D getOffset(Map map) {
        return (Point2D)map.get(OFFSET);
    }

    public static final void setBeginFill(Map map, boolean flag) {
        map.put(BEGINFILL, new Boolean(flag));
    }

    public static final boolean isBeginFill(Map map) {
        Boolean bool = (Boolean)map.get(BEGINFILL);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static final void setBeginDashed(Map map, boolean flag) {
        map.put(BEGIN_DASHED, new Boolean(flag));
    }

    public static final boolean isBeginDashed(Map map) {
        Boolean bool = (Boolean)map.get(BEGIN_DASHED);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static final void setEndDashed(Map map, boolean flag) {
        map.put(END_DASHED, new Boolean(flag));
    }

    public static final boolean isEndDashed(Map map) {
        Boolean bool = (Boolean)map.get(END_DASHED);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static final void setEndFill(Map map, boolean flag) {
        map.put(ENDFILL, new Boolean(flag));
    }

    public static final boolean isEndFill(Map map) {
        Boolean bool = (Boolean)map.get(ENDFILL);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static final void setAbsolute(Map map, boolean flag) {
        map.put(ABSOLUTE, new Boolean(flag));
    }

    public static final boolean isAbsolute(Map map) {
        Boolean bool = (Boolean)map.get(ABSOLUTE);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static final void setRemoveAll(Map map, boolean flag) {
        map.put(REMOVEALL, new Boolean(flag));
    }

    public static final boolean isRemoveAll(Map map) {
        Boolean bool = (Boolean)map.get(REMOVEALL);
        if (bool != null) {
            return bool;
        }
        return false;
    }

    public static class SerializableRectangle2D
    extends Rectangle2D.Double
    implements Serializable {
        public SerializableRectangle2D() {
        }

        public SerializableRectangle2D(double x, double y, double width, double height) {
            super(x, y, width, height);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(new Double(this.getX()));
            out.writeObject(new Double(this.getY()));
            out.writeObject(new Double(this.getWidth()));
            out.writeObject(new Double(this.getHeight()));
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            Double x = (Double)in.readObject();
            Double y = (Double)in.readObject();
            Double width = (Double)in.readObject();
            Double height = (Double)in.readObject();
            this.setFrame(x, y, width, height);
        }
    }

    public static class SerializablePoint2D
    extends Point2D.Double
    implements Serializable {
        public SerializablePoint2D() {
        }

        public SerializablePoint2D(double x, double y) {
            super(x, y);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(new Double(this.getX()));
            out.writeObject(new Double(this.getY()));
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            Double x = (Double)in.readObject();
            Double y = (Double)in.readObject();
            this.setLocation(x, y);
        }
    }
}

