/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.ImageObject;
import oracle.dbtools.crest.model.design.undo.ImageUpdateEdit;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;

public class ImageDiagramCell
extends DefaultDiagramCell {
    public static final String IMAGE_SELECT = Messages.getString("ImageObject.SelectImage");
    public static final String ORIGINAL_SIZE = Messages.getString("ImageObject.OriginalSize");
    private JPopupMenu menu;
    private ImageObject image;

    public ImageDiagramCell(ImageObject image) {
        this(image, DiagramConstants.createMap());
    }

    public ImageDiagramCell(ImageObject image, Map attributeMap) {
        this.image = image;
        this.setAttributes(attributeMap);
        DiagramConstants.setValue(this.getAttributes(), image.getName());
    }

    private void selectImage() {
        String oldFileName = this.image.getImageFileName();
        BufferedImage newPicture = this.image.getImage();
        if (newPicture != null) {
            ImageUpdateEdit edit = new ImageUpdateEdit(this.image, oldFileName, newPicture);
            edit.end();
            edit.applyUpdates();
            this.image.getDesignPart().postUndoableEdit(edit);
            this.originalSize();
        }
    }

    private void originalSize() {
        TopView topView;
        if (this.image.getPicture() != null && (topView = this.getTopView()) != null && topView.getCellView() != null) {
            Rectangle r = new Rectangle(topView.getLocation().x, topView.getLocation().y, this.image.getPicture().getWidth(), this.image.getPicture().getHeight());
            topView.getCellView().setNewBounds(r, false);
        }
    }

    @Override
    public void doubleClick() {
        this.selectImage();
    }

    @Override
    public void showPopupMenu(Point pt) {
        JPopupMenu menu = this.getPopupMenu();
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        if (this.isEditable()) {
            this.selectedObjects = this.getTopView().getDesignPartView().getSelectedObjects();
            this.menu.add(new AbstractAction(COPY){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImageDiagramCell.this.image.getAppView().clearCopiedObjects();
                    ImageDiagramCell.this.getTopView().getDesignPartView().addSelectedToCopied();
                }
            });
            if (this.selectedObjects.length > 1) {
                this.menu.add(new AbstractAction(DELETE_OBJECTS){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DefaultDiagramCell.deleteObjects(ImageDiagramCell.this.selectedObjects, ImageDiagramCell.this.getDiagram().getAppView());
                    }
                });
            } else {
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ImageDiagramCell.this.deleteImage();
                    }
                });
            }
            this.menu.addSeparator();
        }
        this.menu.add(new AbstractAction(ORIGINAL_SIZE){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageDiagramCell.this.originalSize();
            }
        });
        this.menu.addSeparator();
        this.menu.add(new AbstractAction(IMAGE_SELECT){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageDiagramCell.this.selectImage();
            }
        });
        return this.menu;
    }

    public ImageObject getImage() {
        return this.image;
    }

    public void deleteImage() {
        ImageObject imageObject = this.getImage();
        ApplicationView.log(MessageFormat.format(Messages.getString("NoteDiagramCell.DeleteImage"), imageObject.getName()));
        imageObject.getDesignPart().postImageRemoveEdit(imageObject);
        imageObject.remove();
    }

    @Override
    public void deleteSelected() {
        this.deleteImage();
    }
}

