/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.relational;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;

public class ImpliedForeignKeyEdge
extends DefaultEdge {
    private JPopupMenu menu;

    @Override
    public void showPopupMenu(Point pt) {
        JPopupMenu menu = this.getPopupMenu();
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ImpliedForeignKeyEdge.this.deleteModel();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ImpliedForeignKeyEdge.this.format();
                    }
                });
            }
        }
        return this.menu;
    }

    public void deleteModel() {
        DesignObject obj = this.getTopView().getModel();
        TVConnector connector = (TVConnector)this.getTopView();
        if (connector.remove(obj)) {
            ApplicationView.log(MessageFormat.format(Messages.getString("ImpliedForeignKeyEdge.Delete"), obj.getObjectTypeName(), obj.getName()));
        }
    }

    @Override
    public void deleteSelected() {
        this.deleteModel();
    }
}

