/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.relational;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.crest.model.design.AbstractView;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerWithKeyObject;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.FontObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.ColumnView;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.relational.ViewIndex;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerRenderer;
import oracle.dbtools.crest.swingui.editor.viewbuilder.SQLNameHelper;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class TableViewRenderer
extends ContainerRenderer {
    public static final int COLUMN_LEFT = 10;
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(150, 255, 150);
    public static final Color DEFAULT_DATATYPE_COLOR = Color.BLUE;

    public TableViewRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
        this.datatypeColor = DEFAULT_DATATYPE_COLOR;
    }

    @Override
    protected Color getBackgroundColor() {
        if (this.getTopView() == null || this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            DefaultFontAndColor dfc = this.container.getDesign().getDesignLevelSettings().getDefaultFCObject("Relational View");
            if (dfc != null) {
                return dfc.getBackgroundColor();
            }
            return super.getBackgroundColor();
        }
        return this.getTopView().getBackgroundColor();
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            DefaultFontAndColor dfc = this.container.getDesign().getDesignLevelSettings().getDefaultFCObject("Relational View");
            if (dfc != null) {
                return dfc.getForegroundColor();
            }
            return this.getForeground();
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    protected Color getElementsColor() {
        return this.getTopView().getFontObject(EditableFonts.FO_COLUMN).getColor();
    }

    @Override
    protected Font getElementsFont() {
        return this.getTopView().getFontObject(EditableFonts.FO_COLUMN).getFont();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        TopView efo = this.getTopView();
        Dimension dim = this.getSize();
        int width = dim.width;
        int height = dim.height;
        g2.setPaint(this.getBackgroundColor());
        g.fillRoundRect(0, 0, width - 1, height - 1, 40, 40);
        g.setColor(this.getBorderColor());
        g.drawRoundRect(0, 0, width - 1, height - 1, 40, 40);
        Font titleFont = efo.getFontObject(EditableFonts.FO_TITLE).getFont();
        g.setFont(titleFont);
        FontMetrics fm = g.getFontMetrics();
        int colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
        int yCursor = Math.max(colTextHeight, titleFont.getSize());
        int xCursor = (width - fm.stringWidth(this.longName)) / 2;
        if (xCursor < 20) {
            xCursor = 20;
        }
        boolean isValidSQL = ((AbstractView)this.container).isValidSQL();
        boolean isParsed = ((AbstractView)this.container).isParsed();
        boolean isIncorrectSQL = ((AbstractView)this.container).isIncorrectSQL();
        Icon icon = null;
        if (isIncorrectSQL) {
            icon = WARNING_RED_ICON;
        } else if (!isValidSQL) {
            icon = WARNING_RED_ICON;
        } else if (!isParsed) {
            icon = WARNING_YELLOW_ICON;
        }
        if (icon != null) {
            icon.paintIcon(this, g, 10, yCursor - 8);
            if (this.container.isRemoteObject()) {
                REMOTE_TABLE_ICON.paintIcon(this, g2, 26, 2);
            }
        } else if (this.container.isRemoteObject()) {
            REMOTE_TABLE_ICON.paintIcon(this, g2, 10, 2);
        }
        BasicStroke lineStroke = new BasicStroke(this.borderWidth);
        BasicStroke textStroke = new BasicStroke(1.0f);
        g2.setStroke(textStroke);
        g.setColor(efo.getFontObject(EditableFonts.FO_TITLE).getColor());
        g.setFont(efo.getFontObject(EditableFonts.FO_TITLE).getFont());
        String[] wrappedTitle = TableViewRenderer.wrapText(this.longName, TableViewRenderer.getMaxChars(this.longName, fm, width - 20 - 5));
        for (int t = 0; t < wrappedTitle.length; ++t) {
            String text = wrappedTitle[t];
            g.drawString(text, xCursor, yCursor);
            if (this.container.isDeprecated()) {
                this.strikeThrough(g2, text, xCursor, yCursor);
            }
            yCursor += colTextHeight;
        }
        yCursor -= colTextHeight;
        DesignPartView dpv = this.getDesignPartView();
        if (dpv != null && !dpv.clearDetails()) {
            boolean drawLine = true;
            if (!dpv.isShowNamesOnly() && (dpv.showAllDetails() || dpv.showElements() || dpv.showKeyElements())) {
                Iterator it;
                g2.setStroke(lineStroke);
                g.setColor(this.getBorderColor());
                g.drawLine(0, yCursor += 3 + this.borderWidth, width - 2, yCursor);
                if (this.container.isBST()) {
                    StructuredType st = this.container.getBasedOnStructuredType();
                    if (st != null) {
                        void var24_32;
                        TypeElement[] elements = this.container.getTypeSubstitution() == null ? st.toElementObjectArray(st.getAllElements()) : st.getElements();
                        String longestName = this.getLongestTypeName(elements);
                        g.setFont(this.getElementsFont());
                        fm = g.getFontMetrics();
                        colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
                        boolean bl = false;
                        while (var24_32 < elements.length) {
                            TypeElement elm = elements[var24_32];
                            g.setColor(this.getElementsColor());
                            g.setFont(this.getElementsFont());
                            g.drawString(elm.getName(), 10, yCursor += 3 + fm.getMaxAscent());
                            fm = g.getFontMetrics();
                            int anLeft = fm.stringWidth(longestName) + 20;
                            g.setColor(efo.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                            g.drawString(elm.getDataType(), anLeft, yCursor);
                            g.setColor(this.getForeground());
                            ++var24_32;
                        }
                    }
                } else {
                    g2.setStroke(textStroke);
                    boolean hasHeader = ((TableView)this.container).hasValidHeader();
                    FontObject fo = efo.getFontObject(EditableFonts.FO_COLUMN);
                    if (fo == null) {
                        fo = efo.getFontObject(EditableFonts.FO_ATTRIBUTE);
                    }
                    Font colFont = fo.getFont();
                    ContainedObject[] containedObjectArray = ((TableView)this.container).getColumns();
                    String longestName = this.getLongestNameInView(containedObjectArray, hasHeader);
                    String longestDTName = this.getLongestVDTName(containedObjectArray);
                    int nameSize = this.getMaxSize(longestName, colFont, g2);
                    int dtNameSize = this.getMaxSize(longestDTName, colFont, g2);
                    int nnPos = this.getMaxSize("KW", colFont, g2);
                    int namePos = 3 + this.getMaxSize("KWN", colFont, g2);
                    g.setFont(this.getElementsFont());
                    fm = g.getFontMetrics();
                    int cLeft = 20 + namePos + nameSize;
                    int dtLeft = 20 + namePos + nameSize;
                    if (dpv.showAllDetails() || dpv.showDatatype()) {
                        cLeft = 20 + dtLeft + dtNameSize;
                    }
                    float fontSize = Math.max(this.getElementsFont().getSize2D(), colFont.getSize2D());
                    colFont = colFont.deriveFont(fontSize);
                    colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
                    for (int i = 0; i < containedObjectArray.length; ++i) {
                        ColumnView element = (ColumnView)containedObjectArray[i];
                        if (dpv.showKeyElements() && !element.isPKElement() && !element.isFKElement() && !element.isUnique()) continue;
                        int anLeft = nnPos;
                        g.setColor(efo.getFontObject(EditableFonts.FO_NOT_NULL).getColor());
                        g.setFont(colFont);
                        g.drawString(element.getNullsAllowed() ? "" : "*", anLeft, yCursor += 3 + fm.getMaxAscent());
                        String type = " ";
                        if (element.isPKElement()) {
                            type = "P";
                            g.setColor(efo.getFontObject(EditableFonts.FO_PK).getColor());
                            g.setFont(colFont);
                            if (element.isFKElement() || this.container instanceof FKContainer && element.isPartOfUnresolvedFK((FKContainer)this.container)) {
                                type = type.concat("F");
                            }
                            g.drawString(type, 2, yCursor);
                        } else if (element.isUnique()) {
                            type = "U";
                            g.setColor(efo.getFontObject(EditableFonts.FO_UK).getColor());
                            g.setFont(colFont);
                            if (element.isFKElement(true) || this.container instanceof FKContainer && element.isPartOfUnresolvedFK((FKContainer)this.container)) {
                                type = type.concat("F");
                            }
                            g.drawString(type, 2, yCursor);
                        } else if (element.isFKElement(true) || this.container instanceof FKContainer && element.isPartOfUnresolvedFK((FKContainer)this.container)) {
                            type = "F";
                            g.setColor(efo.getFontObject(EditableFonts.FO_FK).getColor());
                            g.setFont(colFont);
                            g.drawString(type, 2, yCursor);
                        } else {
                            g.setColor(this.getElementsColor());
                            g.setFont(colFont);
                        }
                        String name = element.getPresentationName(hasHeader);
                        g.setFont(this.getElementsFont());
                        g.setColor(this.getElementsColor());
                        if (element.isDeprecated()) {
                            this.strikeThrough(g2, name, namePos, yCursor);
                        }
                        g.drawString(name, namePos, yCursor);
                        fm = g.getFontMetrics();
                        if (dpv.showAllDetails() || dpv.showDatatype()) {
                            g.setColor(efo.getFontObject(EditableFonts.FO_DATATYPE).getColor());
                            String dt = this.getDataType(element);
                            if ((dt == null || "".equals(dt)) && (dt = element.getExpression()) == null) {
                                dt = "";
                            }
                            g.drawString(dt, dtLeft, yCursor);
                        }
                        if (dpv.showComments()) {
                            g.setColor(efo.getFontObject(EditableFonts.FO_COMMENTS).getColor());
                            g.setFont(this.getElementsFont());
                            g.drawString(element.getCommentInRDBMS(), cLeft, yCursor);
                        }
                        g.setColor(this.getForegroundColor());
                        if (yCursor <= height) continue;
                        g.setColor(this.getBorderColor());
                        int right = width - 4;
                        int left = right - 8;
                        int center = right - 4;
                        int bottom = height - 4;
                        int top = bottom - 8;
                        int[] xPts = new int[]{center - 10, left - 10, right - 10};
                        int[] yPts = new int[]{bottom, top, top};
                        g.fillPolygon(xPts, yPts, 3);
                        break;
                    }
                }
                if (dpv.showAllDetails() || dpv.showKeys()) {
                    List keys = this.getKeys(((ContainerWithKeyObject)this.container).getKeys());
                    it = null;
                    if (keys.size() > 0) {
                        if (dpv.showAllDetails() || dpv.showElements()) {
                            g.setColor(this.getBorderColor());
                            g2.setStroke(lineStroke);
                            yCursor += 6;
                            for (KeyObject key : keys) {
                                if (efo.getHiddenElements().contains(key)) continue;
                                g.drawLine(0, yCursor, width - 2, yCursor);
                                break;
                            }
                        }
                        g2.setStroke(textStroke);
                        for (KeyObject key : keys) {
                            if (!key.isPK() && !key.isUnique() || efo.getHiddenElements().contains(key)) continue;
                            int n = 4;
                            if (key.isPK()) {
                                icon = PKEY_ICON;
                                n = 2;
                            } else {
                                icon = KEY_ICON;
                            }
                            g.setColor(this.getKeyColor());
                            g.setFont(this.getKeysFont());
                            fm = g.getFontMetrics();
                            yCursor += fm.getHeight();
                            int keyIconYOffset = -(icon.getIconHeight() + fm.getMaxAscent() - fm.getMaxDescent()) / 2;
                            try {
                                icon.paintIcon(this, g, n, yCursor + keyIconYOffset + 1);
                            }
                            catch (Exception longestDTName) {
                                // empty catch block
                            }
                            Object keyName = key.getName();
                            if (dpv.showAllDetails() || dpv.showKeyAndIndexColumns()) {
                                ViewIndex ind;
                                ContainedObject[] columns = key.getElements();
                                keyName = (String)keyName + " (";
                                String expr = null;
                                if (key instanceof ViewIndex && "".equals(expr = (ind = (ViewIndex)key).getIndexExpression())) {
                                    expr = null;
                                }
                                if (expr == null) {
                                    for (int j = 0; j < columns.length; ++j) {
                                        ContainedObject column = columns[j];
                                        String colName = column.getName();
                                        if (j > 0) {
                                            keyName = (String)keyName + ", ";
                                        }
                                        keyName = (String)keyName + colName;
                                    }
                                } else {
                                    keyName = (String)keyName + expr;
                                }
                                keyName = (String)keyName + ")";
                            }
                            if (key.isDeprecated()) {
                                this.strikeThrough(g2, (String)keyName, PKEY_ICON.getIconWidth() + 6, yCursor);
                            }
                            g.drawString((String)keyName, PKEY_ICON.getIconWidth() + 6, yCursor);
                            if (yCursor <= height) continue;
                            g.setColor(this.getBorderColor());
                            int right = width - 4;
                            int left = right - 8;
                            int center = right - 4;
                            int bottom = height - 4;
                            int top = bottom - 8;
                            int[] xPts = new int[]{center - 10, left - 10, right - 10};
                            int[] yPts = new int[]{bottom, top, top};
                            g.fillPolygon(xPts, yPts, 3);
                            break;
                        }
                    }
                }
                if (dpv instanceof DPVRelational && (dpv.showAllDetails() || dpv.showFKeys())) {
                    List fKeys = this.getFKeys(((ContainerWithKeyObject)this.container).getKeys());
                    it = null;
                    if (fKeys.size() > 0) {
                        if (dpv.showAllDetails() || dpv.showElements()) {
                            g.setColor(this.getBorderColor());
                            g2.setStroke(lineStroke);
                            yCursor += 6;
                            for (KeyObject key : fKeys) {
                                if (efo.getHiddenElements().contains(key)) continue;
                                g.drawLine(0, yCursor, width - 2, yCursor);
                                break;
                            }
                        }
                        g2.setStroke(textStroke);
                        for (KeyObject key : fKeys) {
                            void var24_37;
                            Object var24_35 = null;
                            if (key.isFK()) {
                                FKIndexAssociation fKIndexAssociation = key.getFKAssociation();
                            }
                            if (efo.getHiddenElements().contains(key)) continue;
                            icon = FK_ICON;
                            int LEFT = 2;
                            g.setColor(this.getKeyColor());
                            g.setFont(this.getKeysFont());
                            fm = g.getFontMetrics();
                            yCursor += fm.getHeight();
                            int keyIconYOffset = -(icon.getIconHeight() + fm.getMaxAscent() - fm.getMaxDescent()) / 2;
                            try {
                                icon.paintIcon(this, g, LEFT, yCursor + keyIconYOffset + 1);
                            }
                            catch (Exception right) {
                                // empty catch block
                            }
                            Object keyName = key.getName();
                            if (var24_37 != null) {
                                keyName = var24_37.getName();
                            }
                            if (dpv.showAllDetails() || dpv.showKeyAndIndexColumns()) {
                                ViewIndex ind;
                                ContainedObject[] columns = key.getElements();
                                keyName = (String)keyName + " (";
                                String expr = null;
                                if (key instanceof ViewIndex && "".equals(expr = (ind = (ViewIndex)key).getIndexExpression())) {
                                    expr = null;
                                }
                                if (expr == null) {
                                    for (int j = 0; j < columns.length; ++j) {
                                        ContainedObject column = columns[j];
                                        String colName = column.getName();
                                        if (j > 0) {
                                            keyName = (String)keyName + ", ";
                                        }
                                        keyName = (String)keyName + colName;
                                    }
                                } else {
                                    keyName = (String)keyName + expr;
                                }
                                keyName = (String)keyName + ")";
                            }
                            if (key.isDeprecated()) {
                                this.strikeThrough(g2, (String)keyName, PKEY_ICON.getIconWidth() + 6, yCursor);
                            }
                            g.drawString((String)keyName, PKEY_ICON.getIconWidth() + 6, yCursor);
                            if (yCursor <= height) continue;
                            g.setColor(this.getBorderColor());
                            int right = width - 4;
                            int left = right - 8;
                            int center = right - 4;
                            int bottom = height - 4;
                            int top = bottom - 8;
                            int[] xPts = new int[]{center - 10, left - 10, right - 10};
                            int[] yPts = new int[]{bottom, top, top};
                            g.fillPolygon(xPts, yPts, 3);
                            break;
                        }
                    }
                }
                if (dpv.showAllDetails()) {
                    int top;
                    int bottom;
                    int center;
                    String name;
                    List<SQLNameHelper> usedContainers;
                    if (!((TableView)this.container).isIncorrectSQL() && !((TableView)this.container).getUsedTablesAndViews().isEmpty()) {
                        usedContainers = ((TableView)this.container).getUsedTablesAndViews();
                        if (usedContainers.size() > 0) {
                            g2.setStroke(lineStroke);
                            int p = colTextHeight / 5;
                            g.setColor(this.getBorderColor());
                            g.drawLine(0, yCursor += 3 + this.borderWidth + p, width - 2, yCursor);
                            g.setFont(this.getElementsFont());
                            g.setColor(this.getElementsColor());
                            for (SQLNameHelper sQLNameHelper : usedContainers) {
                                yCursor += 3 + fm.getMaxAscent();
                                name = sQLNameHelper.getTableName();
                                g.setFont(this.getElementsFont());
                                if (sQLNameHelper.isDeprecated()) {
                                    this.strikeThrough(g2, name, 10, yCursor);
                                }
                                g.drawString(name, 10, yCursor);
                                if (yCursor <= height) continue;
                                g.setColor(this.getBorderColor());
                                int right = width - 4;
                                int left = right - 8;
                                center = right - 4;
                                bottom = height - 4;
                                top = bottom - 8;
                                int[] xPts = new int[]{center - 10, left - 10, right - 10};
                                int[] yPts = new int[]{bottom, top, top};
                                g.fillPolygon(xPts, yPts, 3);
                                break;
                            }
                        }
                    } else {
                        usedContainers = ((TableView)this.container).getUsedContainers();
                        if (usedContainers.size() > 0) {
                            g2.setStroke(lineStroke);
                            int p = colTextHeight / 5;
                            g.setColor(this.getBorderColor());
                            g.drawLine(0, yCursor += 3 + this.borderWidth + p, width - 2, yCursor);
                            g.setFont(this.getElementsFont());
                            g.setColor(this.getElementsColor());
                            for (AbstractView.ContainerHolder containerHolder : usedContainers) {
                                yCursor += 3 + fm.getMaxAscent();
                                name = containerHolder.getContainer().getName();
                                g.setFont(this.getElementsFont());
                                if (containerHolder.getContainer().isDeprecated()) {
                                    this.strikeThrough(g2, name, 10, yCursor);
                                }
                                g.drawString(name, 10, yCursor);
                                if (yCursor <= height) continue;
                                g.setColor(this.getBorderColor());
                                int right = width - 4;
                                int left = right - 8;
                                center = right - 4;
                                bottom = height - 4;
                                top = bottom - 8;
                                int[] xPts = new int[]{center - 10, left - 10, right - 10};
                                int[] yPts = new int[]{bottom, top, top};
                                g.fillPolygon(xPts, yPts, 3);
                                break;
                            }
                        }
                    }
                }
            }
            String comments = this.container.getCommentInRDBMS().trim();
            if (dpv.showComments() && !"".equalsIgnoreCase(comments)) {
                if (drawLine) {
                    g.setColor(this.getBorderColor());
                    g2.setStroke(lineStroke);
                    g.drawLine(0, yCursor += 6, width - 2, yCursor);
                }
                g.setColor(efo.getFontObject(EditableFonts.FO_COMMENTS).getColor());
                g.setFont(titleFont);
                fm = g.getFontMetrics();
                yCursor += fm.getHeight();
                String[] wrappedComments = TableViewRenderer.wrapText(comments, TableViewRenderer.getMaxChars(comments, fm, width - fm.stringWidth("WWW")));
                for (int t = 0; t < wrappedComments.length; ++t) {
                    String string = wrappedComments[t];
                    g.drawString(string, 10, yCursor);
                    yCursor += fm.getHeight();
                }
            }
        }
    }

    @Override
    protected String getLongestTypeName(TypeElement[] elements) {
        String name = "";
        for (int i = 0; i < elements.length; ++i) {
            String n = elements[i].getName();
            if (n.length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    private String getDataType(ColumnView column) {
        if (column.getReferencedColumn() != null && ("Aggregate".equalsIgnoreCase(column.getReferencedColumn().getSourceType()) || "Derived".equalsIgnoreCase(column.getReferencedColumn().getSourceType()) && column.getReferencedColumn().getFormulaDesc() != null && column.getReferencedColumn().getFormulaDesc().length() > 0)) {
            return column.getReferencedColumn().getFormulaDesc();
        }
        return column.getDataTypeString();
    }

    protected String getLongestName(ContainedObject[] elements) {
        return this.getLongestNameInView(elements, false);
    }

    protected String getLongestNameInView(ContainedObject[] elements, boolean hasHeader) {
        String name = "";
        for (int i = 0; i < elements.length; ++i) {
            String n = null;
            if (hasHeader) {
                n = ((ColumnView)elements[i]).getHeaderAlias();
            }
            if ((n == null || "".equalsIgnoreCase(n)) && ((n = ((ColumnView)elements[i]).getAlias()) == null || "".equalsIgnoreCase(n))) {
                n = ((ColumnView)elements[i]).getReferencedName();
            }
            if (n.length() <= name.length()) continue;
            name = n;
        }
        return name;
    }

    protected String getLongestVDTName(ContainedObject[] elements) {
        String name = "";
        for (int i = 0; i < elements.length; ++i) {
            ColumnView element = (ColumnView)elements[i];
            String dt = this.getDataType(element);
            if ((dt == null || "".equals(dt)) && (dt = element.getExpression()) == null) {
                dt = "";
            }
            if (dt.length() <= name.length()) continue;
            name = dt;
        }
        return name;
    }
}

